/*
 * Decompiled with CFR 0.152.
 */
package com.e4a.runtime.components.impl.android.n38;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPClientConfig;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.net.ftp.FTPReply;

public class FTP {
    private String hostName;
    private int ftpPort;
    private String userName;
    private String password;
    private FTPClient ftpClient;
    private List<FTPFile> list;
    public static final String REMOTE_PATH = "\\";
    private String currentPath = "";
    private double response;

    public FTP(String host, int port, String user, String pass) {
        this.hostName = host;
        this.ftpPort = port;
        this.userName = user;
        this.password = pass;
        this.ftpClient = new FTPClient();
        this.list = new ArrayList<FTPFile>();
    }

    public boolean openConnect() {
        try {
            boolean flag = false;
            this.ftpClient.setDataTimeout(5000);
            this.ftpClient.setConnectTimeout(5000);
            this.ftpClient.setControlEncoding("GBK");
            this.ftpClient.connect(this.hostName, this.ftpPort);
            int reply = this.ftpClient.getReplyCode();
            if (!FTPReply.isPositiveCompletion((int)reply)) {
                this.ftpClient.disconnect();
            }
            this.ftpClient.login(this.userName, this.password);
            reply = this.ftpClient.getReplyCode();
            if (!FTPReply.isPositiveCompletion((int)reply)) {
                this.ftpClient.disconnect();
            } else {
                FTPClientConfig config = new FTPClientConfig(this.ftpClient.getSystemType().split(" ")[0]);
                config.setServerLanguageCode("zh");
                this.ftpClient.configure(config);
                this.ftpClient.enterLocalPassiveMode();
                this.ftpClient.setFileType(2);
                flag = true;
            }
            return flag;
        }
        catch (IOException e) {
            return false;
        }
    }

    public void closeConnect() {
        try {
            if (this.ftpClient != null) {
                this.ftpClient.logout();
                this.ftpClient.disconnect();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public boolean isConnected() {
        if (this.ftpClient != null) {
            return this.ftpClient.isConnected();
        }
        return false;
    }

    public String printWorkingDirectory() {
        try {
            this.ftpClient.enterLocalPassiveMode();
            return this.ftpClient.printWorkingDirectory();
        }
        catch (IOException e) {
            return "";
        }
    }

    public String listFiles(String remotePath) {
        try {
            this.ftpClient.enterLocalPassiveMode();
            FTPFile[] files = this.ftpClient.listFiles(remotePath);
            String list = "";
            for (FTPFile file : files) {
                list = !list.equals("") ? list + "\n" + file.getName() + "/" + file.getSize() + "/" + file.isDirectory() : file.getName() + "/" + file.getSize() + "/" + file.isDirectory();
            }
            return list;
        }
        catch (IOException e) {
            return "";
        }
    }

    public boolean makeDirectory(String remotePath, String pathname) {
        try {
            this.ftpClient.changeWorkingDirectory(remotePath);
            return this.ftpClient.makeDirectory(pathname);
        }
        catch (IOException e) {
            return false;
        }
    }

    public boolean rename(String remotePath, String from, String to) {
        try {
            this.ftpClient.changeWorkingDirectory(remotePath);
            return this.ftpClient.rename(from, to);
        }
        catch (IOException e) {
            return false;
        }
    }

    public boolean removeDirectory(String remotePath, String pathname) {
        try {
            this.ftpClient.changeWorkingDirectory(remotePath);
            return this.ftpClient.removeDirectory(pathname);
        }
        catch (IOException e) {
            return false;
        }
    }

    public boolean deleteFile(String remotePath, String pathname) {
        try {
            this.ftpClient.changeWorkingDirectory(remotePath);
            return this.ftpClient.deleteFile(pathname);
        }
        catch (IOException e) {
            return false;
        }
    }

    public boolean download(String remotePath, String fileName, String localPath) {
        try {
            FTPFile[] ftpFiles;
            boolean flag = false;
            this.currentPath = remotePath;
            this.response = 0.0;
            this.ftpClient.changeWorkingDirectory(remotePath);
            this.ftpClient.enterLocalPassiveMode();
            for (FTPFile ftpFile : ftpFiles = this.ftpClient.listFiles()) {
                if (!ftpFile.getName().equals(fileName)) continue;
                File file = new File(localPath + "/" + fileName);
                flag = ftpFile.isDirectory() ? this.downloadMany(file) : this.downloadSingle(file, ftpFile);
            }
            return flag;
        }
        catch (IOException e) {
            return false;
        }
    }

    private boolean downloadSingle(File localFile, FTPFile ftpFile) {
        try {
            boolean flag = true;
            FileOutputStream outputStream = new FileOutputStream(localFile);
            this.response += (double)ftpFile.getSize();
            flag = this.ftpClient.retrieveFile(localFile.getName(), (OutputStream)outputStream);
            ((OutputStream)outputStream).close();
            return flag;
        }
        catch (IOException e) {
            return false;
        }
    }

    private boolean downloadMany(File localFile) {
        try {
            FTPFile[] ftpFiles;
            boolean flag = true;
            this.currentPath = !this.currentPath.equals(REMOTE_PATH) ? this.currentPath + REMOTE_PATH + localFile.getName() : this.currentPath + localFile.getName();
            localFile.mkdir();
            this.ftpClient.changeWorkingDirectory(this.currentPath);
            this.ftpClient.enterLocalPassiveMode();
            for (FTPFile ftpFile : ftpFiles = this.ftpClient.listFiles()) {
                File file = new File(localFile.getPath() + "/" + ftpFile.getName());
                flag = ftpFile.isDirectory() ? this.downloadMany(file) : this.downloadSingle(file, ftpFile);
            }
            return flag;
        }
        catch (IOException e) {
            return false;
        }
    }

    public boolean uploading(String localPath, String fileName, String remotePath) {
        try {
            boolean flag = false;
            this.currentPath = remotePath;
            this.response = 0.0;
            this.ftpClient.setFileType(2);
            this.ftpClient.enterLocalPassiveMode();
            this.ftpClient.setFileTransferMode(10);
            this.ftpClient.changeWorkingDirectory(remotePath);
            File localFile = new File(localPath + "/" + fileName);
            flag = localFile.isDirectory() ? this.uploadingMany(localFile) : this.uploadingSingle(localFile);
            return flag;
        }
        catch (IOException e) {
            return false;
        }
    }

    private boolean uploadingSingle(File localFile) {
        try {
            boolean flag = true;
            FileInputStream inputStream = new FileInputStream(localFile);
            this.response += (double)((InputStream)inputStream).available() / 1.0;
            flag = this.ftpClient.storeFile(localFile.getName(), (InputStream)inputStream);
            ((InputStream)inputStream).close();
            return flag;
        }
        catch (IOException e) {
            return false;
        }
    }

    private boolean uploadingMany(File localFile) {
        try {
            File[] files;
            boolean flag = true;
            this.currentPath = !this.currentPath.equals(REMOTE_PATH) ? this.currentPath + REMOTE_PATH + localFile.getName() : this.currentPath + localFile.getName();
            this.ftpClient.makeDirectory(this.currentPath);
            this.ftpClient.changeWorkingDirectory(this.currentPath);
            for (File file : files = localFile.listFiles()) {
                if (file.isHidden()) continue;
                flag = file.isDirectory() ? this.uploadingMany(file) : this.uploadingSingle(file);
            }
            return flag;
        }
        catch (IOException e) {
            return false;
        }
    }
}

