/*
 * Decompiled with CFR 0.152.
 */
package com.e4a.runtime.components.impl.android.n36.download;

import android.content.Context;
import android.os.Handler;
import android.os.Message;
import com.e4a.runtime.components.impl.android.n36.download.Info;
import com.e4a.runtime.components.impl.android.n36.download.InfoDao;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;

public class Downloader {
    private int done;
    private InfoDao dao;
    private int fileLen;
    private Handler handler;
    private boolean isPause;
    private boolean isCancle;

    public Downloader(Context context, Handler handler) {
        this.dao = new InfoDao(context);
        this.handler = handler;
    }

    public void download(final String path, final String savePath, final int thCount) {
        new Thread(new Runnable(){

            public void run() {
                try {
                    URL url = new URL(path);
                    HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                    conn.setConnectTimeout(10000);
                    if (conn.getResponseCode() == 200) {
                        Downloader.this.fileLen = conn.getContentLength();
                        File file = new File(savePath);
                        RandomAccessFile raf = new RandomAccessFile(file, "rws");
                        raf.setLength(Downloader.this.fileLen);
                        raf.close();
                        Message msg = new Message();
                        msg.what = 0;
                        msg.getData().putInt("fileLen", Downloader.this.fileLen);
                        Downloader.this.handler.sendMessage(msg);
                        int partLen = (Downloader.this.fileLen + thCount - 1) / thCount;
                        for (int i = 0; i < thCount; ++i) {
                            new DownloadThread(url, file, partLen, i).start();
                        }
                    } else {
                        Downloader.this.\u53d1\u9001\u4e0b\u8f7d\u5931\u8d25\u6d88\u606f();
                    }
                }
                catch (MalformedURLException e) {
                    Downloader.this.\u53d1\u9001\u4e0b\u8f7d\u5931\u8d25\u6d88\u606f();
                }
                catch (IOException e) {
                    Downloader.this.\u53d1\u9001\u4e0b\u8f7d\u5931\u8d25\u6d88\u606f();
                }
            }
        }).start();
    }

    private void \u53d1\u9001\u4e0b\u8f7d\u5931\u8d25\u6d88\u606f() {
        Message msg = new Message();
        msg.what = 2;
        msg.getData().putInt("result", 2);
        this.handler.sendMessage(msg);
    }

    public void pause() {
        this.isPause = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resume() {
        this.isPause = false;
        InfoDao infoDao = this.dao;
        synchronized (infoDao) {
            this.dao.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancle() {
        if (this.isPause) {
            this.isPause = false;
            InfoDao infoDao = this.dao;
            synchronized (infoDao) {
                this.dao.notifyAll();
            }
        }
        this.isCancle = true;
    }

    private final class DownloadThread
    extends Thread {
        private URL url;
        private File file;
        private int partLen;
        private int id;

        public DownloadThread(URL url, File file, int partLen, int id) {
            this.url = url;
            this.file = file;
            this.partLen = partLen;
            this.id = id;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Info info = Downloader.this.dao.query(this.url.toString(), this.id);
            if (info != null) {
                Downloader.this.done += info.getDone();
            } else {
                info = new Info(this.url.toString(), this.id, 0);
                Downloader.this.dao.insert(info);
            }
            int start = this.id * this.partLen + info.getDone();
            int end = (this.id + 1) * this.partLen - 1;
            try {
                int len;
                HttpURLConnection conn = (HttpURLConnection)this.url.openConnection();
                conn.setReadTimeout(10000);
                conn.setRequestProperty("Range", "bytes=" + start + "-" + end);
                RandomAccessFile raf = new RandomAccessFile(this.file, "rws");
                raf.seek(start);
                InputStream in = conn.getInputStream();
                byte[] buf = new byte[10240];
                while ((len = in.read(buf)) != -1 && !Downloader.this.isCancle) {
                    if (Downloader.this.isPause) {
                        InfoDao infoDao = Downloader.this.dao;
                        synchronized (infoDao) {
                            try {
                                Downloader.this.dao.wait();
                            }
                            catch (InterruptedException e) {
                                e.printStackTrace();
                            }
                        }
                    }
                    raf.write(buf, 0, len);
                    Downloader.this.done += len;
                    info.setDone(info.getDone() + len);
                    Downloader.this.dao.update(info);
                    Message msg = new Message();
                    msg.what = 1;
                    int[] data = new int[]{Downloader.this.fileLen, Downloader.this.done};
                    msg.getData().putIntArray("done", data);
                    Downloader.this.handler.sendMessage(msg);
                }
                in.close();
                raf.close();
                if (Downloader.this.isCancle) {
                    Downloader.this.dao.deleteAll2(info.getPath());
                    if (this.file.exists()) {
                        this.file.delete();
                    }
                } else {
                    Downloader.this.dao.deleteAll(info.getPath(), Downloader.this.fileLen);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                Message msg = new Message();
                msg.what = 2;
                msg.getData().putInt("result", 2);
                Downloader.this.handler.sendMessage(msg);
            }
        }
    }
}

