/*
 * Decompiled with CFR 0.152.
 */
package com.e4a.runtime.components.impl.android.n35.bluetooth;

import android.bluetooth.BluetoothSocket;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class ConnectedThread
extends Thread {
    private static final int RECEIVE_MSG = 7;
    private static final int SEND_MSG = 8;
    private static final int LOSE_CONNECT = 9;
    private boolean isStop;
    private BluetoothSocket socket;
    private Handler handler;
    private InputStream is;
    private OutputStream os;

    public ConnectedThread(BluetoothSocket s, Handler h) {
        this.socket = s;
        this.handler = h;
        this.isStop = false;
    }

    public void run() {
        while (!this.isStop) {
            int size = 0;
            byte[] buf = new byte[1024];
            try {
                this.is = this.socket.getInputStream();
                size = this.is.read(buf);
            }
            catch (IOException e) {
                e.printStackTrace();
                this.isStop = true;
                Message msg = new Message();
                msg.what = 9;
                this.handler.sendMessage(msg);
            }
            if (size <= 0) continue;
            byte[] buf2 = new byte[size];
            System.arraycopy(buf, 0, buf2, 0, size);
            this.sendMessageToHandler(buf2, 7);
        }
    }

    public void write(byte[] buf) {
        try {
            this.os = this.socket.getOutputStream();
            this.os.write(buf);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.sendMessageToHandler(buf, 8);
    }

    private void sendMessageToHandler(byte[] buf, int mode) {
        String[] temp = new String[]{this.socket.getRemoteDevice().getName(), this.socket.getRemoteDevice().getAddress()};
        Bundle bundle = new Bundle();
        bundle.putStringArray("address", temp);
        bundle.putByteArray("byte", buf);
        Message msg = new Message();
        msg.setData(bundle);
        msg.what = mode;
        this.handler.sendMessage(msg);
    }
}

