/*
 * Decompiled with CFR 0.152.
 */
package com.e4a.runtime.components.impl.android.n33.QQTextView;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.os.Handler;
import android.text.SpannableString;
import android.text.style.ImageSpan;
import android.util.AttributeSet;
import android.widget.TextView;
import com.e4a.runtime.components.impl.android.n33.QQTextView.GifOpenHelper;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MyTextView
extends TextView {
    private ArrayList<SpanInfo> spanInfoList = new ArrayList();
    private Handler handler;
    private String myText;

    public MyTextView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    public MyTextView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public MyTextView(Context context) {
        super(context);
    }

    private void parseText(HashMap<String, String> gifface, HashMap<String, String> staticface, String inputStr) {
        this.myText = inputStr;
        Pattern mPattern = Pattern.compile("\\[.*?\\]");
        Matcher mMatcher = mPattern.matcher(inputStr);
        while (mMatcher.find()) {
            String faceName = mMatcher.group();
            String image = null;
            image = gifface.get(faceName);
            if (image != null) {
                this.parseGif(image, mMatcher.start(), mMatcher.end());
                continue;
            }
            image = staticface.get(faceName);
            if (image == null) continue;
            this.parseBmp(image, mMatcher.start(), mMatcher.end());
        }
    }

    private void parseBmp(String image, int start, int end) {
        Bitmap bitmap = null;
        if (image.startsWith("/")) {
            bitmap = BitmapFactory.decodeFile((String)image);
        } else {
            try {
                bitmap = BitmapFactory.decodeStream((InputStream)this.getContext().getResources().getAssets().open(image));
            }
            catch (IOException ioe) {
                // empty catch block
            }
        }
        ImageSpan imageSpan = new ImageSpan(this.getContext(), bitmap);
        SpanInfo spanInfo = new SpanInfo();
        spanInfo.currentFrameIndex = 0;
        spanInfo.frameCount = 1;
        spanInfo.start = start;
        spanInfo.end = end;
        spanInfo.delay = 100;
        spanInfo.mapList.add(bitmap);
        this.spanInfoList.add(spanInfo);
    }

    private void parseGif(String image, int start, int end) {
        GifOpenHelper helper = new GifOpenHelper();
        if (image.startsWith("/")) {
            try {
                helper.read(new FileInputStream(image));
            }
            catch (IOException ioe) {}
        } else {
            try {
                helper.read(this.getContext().getResources().getAssets().open(image));
            }
            catch (IOException ioe) {
                // empty catch block
            }
        }
        SpanInfo spanInfo = new SpanInfo();
        spanInfo.currentFrameIndex = 0;
        spanInfo.frameCount = helper.getFrameCount();
        spanInfo.start = start;
        spanInfo.end = end;
        spanInfo.mapList.add(helper.getImage());
        for (int i = 1; i < helper.getFrameCount(); ++i) {
            spanInfo.mapList.add(helper.nextBitmap());
        }
        spanInfo.delay = helper.nextDelay();
        this.spanInfoList.add(spanInfo);
    }

    public void setSpanText(Handler handler, HashMap<String, String> gifface, HashMap<String, String> staticface, String text) {
        this.handler = handler;
        this.parseText(gifface, staticface, text);
        TextRunnable r = new TextRunnable();
        handler.post((Runnable)r);
    }

    public class TextRunnable
    implements Runnable {
        public void run() {
            SpannableString sb = new SpannableString((CharSequence)("" + MyTextView.this.myText));
            int gifCount = 0;
            SpanInfo info = null;
            for (int i = 0; i < MyTextView.this.spanInfoList.size(); ++i) {
                info = (SpanInfo)MyTextView.this.spanInfoList.get(i);
                if (info.mapList.size() > 1) {
                    ++gifCount;
                }
                Bitmap bitmap = info.mapList.get(info.currentFrameIndex);
                info.currentFrameIndex = (info.currentFrameIndex + 1) % info.frameCount;
                bitmap = Bitmap.createScaledBitmap((Bitmap)bitmap, (int)60, (int)60, (boolean)true);
                ImageSpan imageSpan = new ImageSpan(MyTextView.this.getContext(), bitmap);
                sb.setSpan((Object)imageSpan, info.start, info.end, 33);
            }
            MyTextView.this.setText((CharSequence)sb);
            if (gifCount != 0) {
                MyTextView.this.handler.postDelayed((Runnable)this, (long)info.delay);
            }
        }
    }

    private class SpanInfo {
        ArrayList<Bitmap> mapList = new ArrayList();
        int start = 0;
        int end = 0;
        int frameCount = 0;
        int currentFrameIndex = 0;
        int delay = 0;
    }
}

