/*
 * Decompiled with CFR 0.152.
 */
package com.e4a.runtime.components.impl.android.n26;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.widget.SeekBar;

public class VerticalSeekBar
extends SeekBar {
    private Drawable mThumb;
    private SeekBar.OnSeekBarChangeListener mOnSeekBarChangeListener;

    public VerticalSeekBar(Context context) {
        super(context);
    }

    public VerticalSeekBar(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    public VerticalSeekBar(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(h, w, oldh, oldw);
    }

    protected synchronized void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(heightMeasureSpec, widthMeasureSpec);
        this.setMeasuredDimension(this.getMeasuredHeight(), this.getMeasuredWidth());
    }

    protected void onDraw(Canvas c) {
        c.rotate(-90.0f);
        c.translate((float)(-this.getHeight()), 0.0f);
        this.onSizeChanged(this.getWidth(), this.getHeight(), 0, 0);
        super.onDraw(c);
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (!this.isEnabled()) {
            return false;
        }
        switch (event.getAction()) {
            case 0: {
                this.setPressed(true);
                this.onStartTrackingTouch();
                break;
            }
            case 2: {
                this.attemptClaimDrag();
                this.setProgress(this.getMax() - (int)((float)this.getMax() * event.getY() / (float)this.getHeight()));
                this.onProgressRefresh();
                break;
            }
            case 1: {
                int i = 0;
                i = this.getMax() - (int)((float)this.getMax() * event.getY() / (float)this.getHeight());
                this.setProgress(i);
                this.onSizeChanged(this.getWidth(), this.getHeight(), 0, 0);
                this.onStopTrackingTouch();
                this.setPressed(false);
                break;
            }
            case 3: {
                this.onStopTrackingTouch();
                this.setPressed(false);
            }
        }
        return true;
    }

    public void setOnSeekBarChangeListener(SeekBar.OnSeekBarChangeListener l) {
        this.mOnSeekBarChangeListener = l;
    }

    void onProgressRefresh() {
        if (this.mOnSeekBarChangeListener != null) {
            this.mOnSeekBarChangeListener.onProgressChanged((SeekBar)this, this.getProgress(), true);
        }
    }

    void onStartTrackingTouch() {
        if (this.mOnSeekBarChangeListener != null) {
            this.mOnSeekBarChangeListener.onStartTrackingTouch((SeekBar)this);
        }
    }

    void onStopTrackingTouch() {
        if (this.mOnSeekBarChangeListener != null) {
            this.mOnSeekBarChangeListener.onStopTrackingTouch((SeekBar)this);
        }
    }

    private void attemptClaimDrag() {
        if (this.getParent() != null) {
            this.getParent().requestDisallowInterceptTouchEvent(true);
        }
    }
}

