/*
 * Decompiled with CFR 0.152.
 */
package com.e4a.runtime.components.impl.android.n11;

import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import android.view.Display;
import android.view.WindowManager;
import com.e4a.runtime.components.ComponentContainer;
import com.e4a.runtime.components.impl.ComponentImpl;
import com.e4a.runtime.components.impl.android.n11.\u65b9\u5411\u4f20\u611f\u5668;
import com.e4a.runtime.events.EventDispatcher;
import com.e4a.runtime.\u4e0a\u4e0b\u6587\u64cd\u4f5c;
import java.util.List;

public class \u65b9\u5411\u4f20\u611f\u5668Impl
extends ComponentImpl
implements \u65b9\u5411\u4f20\u611f\u5668,
SensorEventListener {
    private final SensorManager sensors = (SensorManager)\u4e0a\u4e0b\u6587\u64cd\u4f5c.\u53d6\u5168\u5c40\u4e0a\u4e0b\u6587().getSystemService("sensor");
    private boolean enabled;
    private float yaw;
    private float pitch;
    private float roll;

    public \u65b9\u5411\u4f20\u611f\u5668Impl(ComponentContainer container) {
        super(container);
        this.sensors.registerListener((SensorEventListener)this, this.sensors.getDefaultSensor(3), 1);
    }

    public void \u65b9\u5411\u6539\u53d8(float newYaw, float newPitch, float newRoll) {
        EventDispatcher.dispatchEvent(this, "\u65b9\u5411\u6539\u53d8", Float.valueOf(newYaw), Float.valueOf(newPitch), Float.valueOf(newRoll));
    }

    public boolean \u6709\u6548() {
        List sensorList = this.sensors.getSensorList(3);
        return sensorList != null && !sensorList.isEmpty();
    }

    public boolean \u53ef\u7528() {
        return this.enabled;
    }

    public void \u53ef\u7528(boolean enable) {
        this.enabled = enable;
    }

    public float \u4fef\u4ef0\u89d2() {
        return this.pitch;
    }

    public float \u6a2a\u6eda\u89d2() {
        return this.roll;
    }

    public float \u504f\u822a\u89d2() {
        return this.yaw;
    }

    public float \u503e\u659c\u89d2() {
        return (float)Math.toDegrees(Math.atan2(this.pitch, this.roll));
    }

    public float Magnitude() {
        int MAX_VALUE = 90;
        return (float)(Math.sqrt(Math.pow(Math.min(90.0f, this.pitch), 2.0) + Math.pow(Math.min(90.0f, this.roll), 2.0)) / (90.0 * Math.sqrt(2.0)));
    }

    public void onSensorChanged(SensorEvent event) {
        if (event.sensor.getType() == 3 && this.enabled) {
            this.yaw = event.values[0];
            this.pitch = event.values[1];
            this.roll = event.values[2];
            this.\u65b9\u5411\u6539\u53d8(this.yaw, this.pitch, this.roll);
        }
    }

    public void onAccuracyChanged(Sensor sensor, int accuracy) {
    }

    public int \u53d6\u5c4f\u5e55\u65cb\u8f6c\u89d2\u5ea6() {
        Display display = ((WindowManager)\u4e0a\u4e0b\u6587\u64cd\u4f5c.\u53d6\u5168\u5c40\u4e0a\u4e0b\u6587().getSystemService("window")).getDefaultDisplay();
        switch (display.getRotation()) {
            case 0: {
                return 0;
            }
            case 1: {
                return 90;
            }
            case 2: {
                return 180;
            }
            case 3: {
                return 270;
            }
        }
        return 0;
    }
}

