/*
 * Decompiled with CFR 0.152.
 */
package com.e4a.runtime.components.impl.android.n10;

import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.location.Criteria;
import android.location.Location;
import android.location.LocationListener;
import android.location.LocationManager;
import android.os.Bundle;
import com.e4a.runtime.android.mainActivity;
import com.e4a.runtime.components.ComponentContainer;
import com.e4a.runtime.components.impl.ComponentImpl;
import com.e4a.runtime.components.impl.android.n10.\u4f4d\u7f6e\u4f20\u611f\u5668;
import com.e4a.runtime.events.EventDispatcher;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;

public class \u4f4d\u7f6e\u4f20\u611f\u5668Impl
extends ComponentImpl
implements \u4f4d\u7f6e\u4f20\u611f\u5668 {
    private Context mContext;
    private LocationManager locationManager;
    private String provider;
    private Location location = null;
    private Criteria criteria = null;
    private final LocationListener locationListener = new LocationListener(){

        public void onLocationChanged(Location location) {
            if (location != null) {
                \u4f4d\u7f6e\u4f20\u611f\u5668Impl.this.\u4f4d\u7f6e\u6539\u53d8(location.getLatitude(), location.getLongitude(), location.getAltitude(), location.getSpeed(), location.getBearing());
            }
        }

        public void onProviderDisabled(String provider) {
            \u4f4d\u7f6e\u4f20\u611f\u5668Impl.this.\u8bbe\u5907\u5173\u95ed();
        }

        public void onProviderEnabled(String provider) {
            \u4f4d\u7f6e\u4f20\u611f\u5668Impl.this.\u8bbe\u5907\u5f00\u542f();
        }

        public void onStatusChanged(String provider, int status, Bundle extras) {
            switch (status) {
                case 2: {
                    \u4f4d\u7f6e\u4f20\u611f\u5668Impl.this.\u72b6\u6001\u6539\u53d8(1);
                    break;
                }
                case 0: {
                    \u4f4d\u7f6e\u4f20\u611f\u5668Impl.this.\u72b6\u6001\u6539\u53d8(2);
                    break;
                }
                case 1: {
                    \u4f4d\u7f6e\u4f20\u611f\u5668Impl.this.\u72b6\u6001\u6539\u53d8(3);
                }
            }
        }
    };

    public \u4f4d\u7f6e\u4f20\u611f\u5668Impl(ComponentContainer container) {
        super(container);
        this.mContext = mainActivity.getContext();
        this.locationManager = (LocationManager)this.mContext.getSystemService("location");
    }

    public boolean \u8bbe\u5907\u662f\u5426\u6709\u6548() {
        if (this.locationManager == null) {
            return false;
        }
        List providers = this.locationManager.getAllProviders();
        if (providers == null) {
            return false;
        }
        return providers.contains("gps");
    }

    public boolean \u8bbe\u5907\u662f\u5426\u5df2\u5f00\u542f() {
        return this.locationManager.isProviderEnabled("gps");
    }

    public void \u6253\u5f00\u8bbe\u7f6e\u754c\u9762() {
        Intent intent = new Intent();
        intent.setAction("android.settings.LOCATION_SOURCE_SETTINGS");
        intent.setFlags(0x10000000);
        try {
            this.mContext.startActivity(intent);
        }
        catch (ActivityNotFoundException ex) {
            intent.setAction("android.settings.SETTINGS");
            try {
                this.mContext.startActivity(intent);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void \u5f00\u59cb\u76d1\u6d4b() {
        if (this.locationManager.isProviderEnabled("gps")) {
            if (this.criteria == null) {
                this.criteria = new Criteria();
                this.criteria.setAccuracy(1);
                this.criteria.setAltitudeRequired(true);
                this.criteria.setBearingRequired(true);
                this.criteria.setCostAllowed(true);
                this.criteria.setPowerRequirement(1);
            }
            this.provider = this.locationManager.getBestProvider(this.criteria, true);
            this.locationManager.requestLocationUpdates("gps", 1000L, 0.0f, this.locationListener);
            this.location = this.locationManager.getLastKnownLocation("gps");
        }
    }

    public void \u505c\u6b62\u76d1\u6d4b() {
        this.locationManager.removeUpdates(this.locationListener);
    }

    public double \u53d6\u7eac\u5ea6() {
        if (this.location != null) {
            return this.location.getLatitude();
        }
        return 0.0;
    }

    public double \u53d6\u7ecf\u5ea6() {
        if (this.location != null) {
            return this.location.getLongitude();
        }
        return 0.0;
    }

    public double \u53d6\u6d77\u62d4() {
        if (this.location != null) {
            return this.location.getAltitude();
        }
        return 0.0;
    }

    public double \u53d6\u901f\u5ea6() {
        if (this.location != null) {
            return this.location.getSpeed();
        }
        return 0.0;
    }

    public double \u53d6\u65b9\u5411() {
        if (this.location != null) {
            return this.location.getBearing();
        }
        return 0.0;
    }

    public String \u53d6\u65f6\u95f4() {
        if (this.location != null) {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH-mm-ss");
            String time = dateFormat.format(new Date(this.location.getTime()));
            return time;
        }
        return "";
    }

    public double \u53d6\u7cbe\u5ea6() {
        if (this.location != null && this.location.hasAccuracy()) {
            return this.location.getAccuracy();
        }
        return 0.0;
    }

    public void \u4f4d\u7f6e\u6539\u53d8(double latitude, double longitude, double altitude, double speed, double bearing) {
        EventDispatcher.dispatchEvent(this, "\u4f4d\u7f6e\u6539\u53d8", latitude, longitude, altitude, speed, bearing);
    }

    public void \u72b6\u6001\u6539\u53d8(int state) {
        EventDispatcher.dispatchEvent(this, "\u72b6\u6001\u6539\u53d8", state);
    }

    public void \u8bbe\u5907\u5f00\u542f() {
        EventDispatcher.dispatchEvent(this, "\u8bbe\u5907\u5f00\u542f", new Object[0]);
    }

    public void \u8bbe\u5907\u5173\u95ed() {
        EventDispatcher.dispatchEvent(this, "\u8bbe\u5907\u5173\u95ed", new Object[0]);
    }
}

