/*
 * Decompiled with CFR 0.152.
 */
package com.e4a.runtime;

import com.e4a.runtime.Log;
import com.e4a.runtime.annotations.SimpleObject;
import com.e4a.runtime.annotations.SimpleProperty;
import com.e4a.runtime.variants.IntegerVariant;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Objects {
    private static final Map<String, PropertyInitializer> PROPERTY_INITIALIZERS = new HashMap<String, PropertyInitializer>();
    private static final Map<Class<?>, List<PropertyDescriptor>> COMPONENT_MAP;

    private Objects() {
    }

    public static void initializeProperties(Object object) {
        Class<?> cls = object.getClass();
        List<PropertyDescriptor> pdl = COMPONENT_MAP.get(cls);
        if (pdl == null) {
            pdl = new ArrayList<PropertyDescriptor>();
            Objects.initializeProperties(object, cls, pdl);
            COMPONENT_MAP.put(cls, pdl);
        } else {
            for (PropertyDescriptor pd : pdl) {
                pd.runInitializer(object);
            }
        }
    }

    private static void initializeProperties(Object object, Class<?> cls, List<PropertyDescriptor> pdl) {
        Class<?> scls = cls.getSuperclass();
        if (scls != null && scls != Object.class) {
            Objects.initializeProperties(object, scls, pdl);
        }
        for (Class<?> iface : cls.getInterfaces()) {
            Objects.initializeProperties(object, iface, pdl);
        }
        SimpleObject c = cls.getAnnotation(SimpleObject.class);
        if (c != null) {
            for (Method m : cls.getDeclaredMethods()) {
                String initializer;
                SimpleProperty p = m.getAnnotation(SimpleProperty.class);
                if (p == null || (initializer = p.initializer()).length() == 0) continue;
                if (!m.getReturnType().equals(Void.TYPE)) {
                    Log.Warning("Simple Runtime Library", "ignoring initializer on property getter method: " + cls.getName() + '.' + m.getName());
                    continue;
                }
                PropertyInitializer pi = PROPERTY_INITIALIZERS.get(p.type());
                if (pi == null) {
                    Log.Warning("Simple Runtime Library", "unknown property type: " + p.type());
                    continue;
                }
                PropertyDescriptor pd = new PropertyDescriptor(pi, m, initializer);
                pd.runInitializer(object);
                pdl.add(pd);
            }
        }
    }

    private static String unquote(String s) {
        return s.substring(1, s.length() - 1);
    }

    static {
        PROPERTY_INITIALIZERS.put("simple.asset", new PropertyInitializer(){

            void initializer(Object object, Method m, String value) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
                m.invoke(object, Objects.unquote(value));
            }
        });
        PROPERTY_INITIALIZERS.put("simple.boolean", new PropertyInitializer(){

            void initializer(Object object, Method m, String value) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
                m.invoke(object, value.equals("True"));
            }
        });
        PROPERTY_INITIALIZERS.put("simple.color", new PropertyInitializer(){

            void initializer(Object object, Method m, String value) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
                m.invoke(object, Integer.valueOf(value));
            }
        });
        PROPERTY_INITIALIZERS.put("simple.double", new PropertyInitializer(){

            void initializer(Object object, Method m, String value) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
                m.invoke(object, Double.valueOf(value));
            }
        });
        PROPERTY_INITIALIZERS.put("simple.halign", new PropertyInitializer(){

            void initializer(Object object, Method m, String value) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
                m.invoke(object, Integer.valueOf(value));
            }
        });
        PROPERTY_INITIALIZERS.put("simple.integer", new PropertyInitializer(){

            void initializer(Object object, Method m, String value) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
                m.invoke(object, Integer.valueOf(value));
            }
        });
        PROPERTY_INITIALIZERS.put("simple.layout", new PropertyInitializer(){

            void initializer(Object object, Method m, String value) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
                m.invoke(object, IntegerVariant.getIntegerVariant(Integer.valueOf(value)));
            }
        });
        PROPERTY_INITIALIZERS.put("simple.long", new PropertyInitializer(){

            void initializer(Object object, Method m, String value) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
                m.invoke(object, Long.valueOf(value));
            }
        });
        PROPERTY_INITIALIZERS.put("simple.single", new PropertyInitializer(){

            void initializer(Object object, Method m, String value) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
                m.invoke(object, Float.valueOf(value));
            }
        });
        PROPERTY_INITIALIZERS.put("simple.string", new PropertyInitializer(){

            void initializer(Object object, Method m, String value) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
                m.invoke(object, Objects.unquote(value));
            }
        });
        PROPERTY_INITIALIZERS.put("simple.text", new PropertyInitializer(){

            void initializer(Object object, Method m, String value) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
                m.invoke(object, value);
            }
        });
        PROPERTY_INITIALIZERS.put("simple.justification", new PropertyInitializer(){

            void initializer(Object object, Method m, String value) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
                m.invoke(object, Integer.valueOf(value));
            }
        });
        PROPERTY_INITIALIZERS.put("simple.typeface", new PropertyInitializer(){

            void initializer(Object object, Method m, String value) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
                m.invoke(object, Integer.valueOf(value));
            }
        });
        PROPERTY_INITIALIZERS.put("simple.valign", new PropertyInitializer(){

            void initializer(Object object, Method m, String value) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
                m.invoke(object, Integer.valueOf(value));
            }
        });
        COMPONENT_MAP = new HashMap();
    }

    private static abstract class PropertyInitializer {
        private PropertyInitializer() {
        }

        void run(Object object, Method m, String value) {
            try {
                this.initializer(object, m, value);
            }
            catch (IllegalArgumentException e) {
                PropertyInitializer.reportInitializePropertiesError(m, e);
            }
            catch (IllegalAccessException e) {
            }
            catch (InvocationTargetException e) {
                PropertyInitializer.reportInitializePropertiesError(m, e);
            }
        }

        abstract void initializer(Object var1, Method var2, String var3) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException;

        private static void reportInitializePropertiesError(Method m, Exception e) {
            Log.Error("Simple Runtime Library", "Runtime exception setting property default values: " + m.getName());
            e.printStackTrace();
        }
    }

    private static class PropertyDescriptor {
        private final PropertyInitializer pi;
        private final Method m;
        private final String initializer;

        PropertyDescriptor(PropertyInitializer pi, Method m, String initializer) {
            this.pi = pi;
            this.m = m;
            this.initializer = initializer;
        }

        void runInitializer(Object object) {
            this.pi.run(object, this.m, this.initializer);
        }
    }
}

