/*
 * Decompiled with CFR 0.152.
 */
package com.e4a.runtime;

import android.app.Dialog;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.LinearGradient;
import android.graphics.Paint;
import android.graphics.RectF;
import android.graphics.Shader;
import android.graphics.SweepGradient;
import android.os.Bundle;
import android.view.Display;
import android.view.MotionEvent;
import android.view.View;
import android.widget.Button;
import android.widget.LinearLayout;

public class ColorPickerDialog
extends Dialog {
    private Context mContext;
    private String mTitle;
    private String ButtonTitle;
    private int mInitialColor;
    private OnColorChangedListener mListener;

    public ColorPickerDialog(Context context, String title, String button, OnColorChangedListener l) {
        this(context, title, button, -7829368, l);
    }

    public ColorPickerDialog(Context context, String title, String button, int initalColor, OnColorChangedListener l) {
        super(context);
        this.mContext = context;
        this.mTitle = title;
        this.ButtonTitle = button;
        this.mListener = l;
        this.mInitialColor = initalColor;
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        LinearLayout layout = new LinearLayout(this.mContext);
        layout.setOrientation(1);
        layout.setVerticalGravity(16);
        boolean isPortrait = this.\u662f\u5426\u4e3a\u7ad6\u5c4f(this.mContext);
        if (isPortrait) {
            final PortraitColorPickerView PortraitColorPicker = new PortraitColorPickerView(this.mContext, this.mListener);
            layout.addView((View)PortraitColorPicker);
            Button button = new Button(this.mContext);
            button.setText((CharSequence)this.ButtonTitle);
            button.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (ColorPickerDialog.this.mListener != null) {
                        ColorPickerDialog.this.mListener.colorChanged(PortraitColorPicker.mCenterPaint.getColor());
                        ColorPickerDialog.this.dismiss();
                    }
                }
            });
            layout.addView((View)button);
        } else {
            final LandscapeColorPickerView LandscapeColorPicker = new LandscapeColorPickerView(this.mContext, this.mListener);
            layout.addView((View)LandscapeColorPicker);
            Button button = new Button(this.mContext);
            button.setText((CharSequence)this.ButtonTitle);
            button.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (ColorPickerDialog.this.mListener != null) {
                        ColorPickerDialog.this.mListener.colorChanged(LandscapeColorPicker.mCenterPaint.getColor());
                        ColorPickerDialog.this.dismiss();
                    }
                }
            });
            layout.addView((View)button);
        }
        this.setContentView((View)layout);
        this.setTitle(this.mTitle);
    }

    private boolean \u662f\u5426\u4e3a\u7ad6\u5c4f(Context context) {
        return context.getResources().getConfiguration().orientation == 1;
    }

    private class LandscapeColorPickerView
    extends ColorPickerView {
        public LandscapeColorPickerView(Context context, OnColorChangedListener l) {
            super(context, l);
            Display display = ColorPickerDialog.this.getWindow().getWindowManager().getDefaultDisplay();
            int height = (int)((float)display.getHeight() * 0.8f) - 36;
            int width = (int)((float)display.getWidth() * 0.5f);
            this.mHeight = height;
            this.mWidth = width;
            this.setMinimumHeight(height);
            this.setMinimumWidth(width);
            SweepGradient s = new SweepGradient(0.0f, 0.0f, this.mCircleColors, null);
            this.mCirclePaint = new Paint(1);
            this.mCirclePaint.setShader((Shader)s);
            this.mCirclePaint.setStyle(Paint.Style.STROKE);
            this.mCirclePaint.setStrokeWidth(50.0f);
            this.mCircleRadius = (float)(this.mHeight / 2) * 0.7f - this.mCirclePaint.getStrokeWidth() * 0.5f;
            this.mCenterPaint = new Paint(1);
            this.mCenterPaint.setColor(ColorPickerDialog.this.mInitialColor);
            this.mCenterPaint.setStrokeWidth(5.0f);
            this.mCenterRadius = (this.mCircleRadius - this.mCirclePaint.getStrokeWidth() / 2.0f) * 0.7f;
            this.mLinePaint = new Paint(1);
            this.mLinePaint.setColor(Color.parseColor((String)"#72A1D1"));
            this.mLinePaint.setStrokeWidth(4.0f);
            this.mRectPaint = new Paint(1);
            this.mRectPaint.setStrokeWidth(5.0f);
            this.mRectLeft = this.mCircleRadius + this.mCirclePaint.getStrokeWidth() * 0.5f + this.mLinePaint.getStrokeMiter() * 0.5f + 15.0f;
            this.mRectTop = -this.mCircleRadius - this.mCirclePaint.getStrokeWidth() * 0.5f;
            this.mRectRight = this.mRectLeft + 50.0f;
            this.mRectBottom = this.mCircleRadius + this.mCirclePaint.getStrokeWidth() * 0.5f;
        }

        protected void onDraw(Canvas canvas) {
            canvas.translate((float)(this.mWidth / 2 - 50), (float)(this.mHeight / 2));
            canvas.drawCircle(0.0f, 0.0f, this.mCenterRadius, this.mCenterPaint);
            if (this.mHighlightCenter || this.mlittleLightCenter) {
                int c = this.mCenterPaint.getColor();
                this.mCenterPaint.setStyle(Paint.Style.STROKE);
                if (this.mHighlightCenter) {
                    this.mCenterPaint.setAlpha(255);
                } else if (this.mlittleLightCenter) {
                    this.mCenterPaint.setAlpha(144);
                }
                canvas.drawCircle(0.0f, 0.0f, this.mCenterRadius + this.mCenterPaint.getStrokeWidth(), this.mCenterPaint);
                this.mCenterPaint.setStyle(Paint.Style.FILL);
                this.mCenterPaint.setColor(c);
            }
            canvas.drawOval(new RectF(-this.mCircleRadius, -this.mCircleRadius, this.mCircleRadius, this.mCircleRadius), this.mCirclePaint);
            if (this.mDownInCircle) {
                this.mRectColors[1] = this.mCenterPaint.getColor();
            }
            this.mRectShader = new LinearGradient(0.0f, this.mRectTop, 0.0f, this.mRectBottom, this.mRectColors, null, Shader.TileMode.MIRROR);
            this.mRectPaint.setShader(this.mRectShader);
            canvas.drawRect(this.mRectLeft, this.mRectTop, this.mRectRight, this.mRectBottom, this.mRectPaint);
            float offset = this.mLinePaint.getStrokeWidth() / 2.0f;
            canvas.drawLine(this.mRectLeft - offset, this.mRectTop - offset * 2.0f, this.mRectLeft - offset, this.mRectBottom + offset * 2.0f, this.mLinePaint);
            canvas.drawLine(this.mRectLeft - offset * 2.0f, this.mRectTop - offset, this.mRectRight + offset * 2.0f, this.mRectTop - offset, this.mLinePaint);
            canvas.drawLine(this.mRectRight + offset, this.mRectTop - offset * 2.0f, this.mRectRight + offset, this.mRectBottom + offset * 2.0f, this.mLinePaint);
            canvas.drawLine(this.mRectLeft - offset * 2.0f, this.mRectBottom + offset, this.mRectRight + offset * 2.0f, this.mRectBottom + offset, this.mLinePaint);
            super.onDraw(canvas);
        }

        public boolean onTouchEvent(MotionEvent event) {
            float x = event.getX() - (float)(this.mWidth / 2) + 50.0f;
            float y = event.getY() - (float)(this.mHeight / 2);
            boolean inCircle = this.inColorCircle(x, y, this.mCircleRadius + this.mCirclePaint.getStrokeWidth() / 2.0f, this.mCircleRadius - this.mCirclePaint.getStrokeWidth() / 2.0f);
            boolean inCenter = this.inCenter(x, y, this.mCenterRadius);
            boolean inRect = this.inRect(x, y);
            System.out.println(x + "..." + y);
            System.out.println(this.mRectLeft + "..." + this.mRectRight + "..." + this.mRectTop + "..." + this.mRectBottom);
            switch (event.getAction()) {
                case 0: {
                    this.onActionDown(inCircle, inCenter, inRect);
                }
                case 2: {
                    this.onActionMove(x, y, inCircle, inCenter, inRect);
                    break;
                }
                case 1: {
                    this.onActionUp(inCenter);
                }
            }
            return true;
        }

        protected int interpRectColor(int[] colors, float x, float y) {
            float p;
            int c1;
            int c0;
            float referLine = this.mRectBottom;
            if (y < 0.0f) {
                c0 = colors[0];
                c1 = colors[1];
                p = (y + referLine) / referLine;
            } else {
                c0 = colors[1];
                c1 = colors[2];
                p = y / referLine;
            }
            int a = this.ave(Color.alpha((int)c0), Color.alpha((int)c1), p);
            int r = this.ave(Color.red((int)c0), Color.red((int)c1), p);
            int g = this.ave(Color.green((int)c0), Color.green((int)c1), p);
            int b = this.ave(Color.blue((int)c0), Color.blue((int)c1), p);
            return Color.argb((int)a, (int)r, (int)g, (int)b);
        }
    }

    private class PortraitColorPickerView
    extends ColorPickerView {
        public PortraitColorPickerView(Context context, OnColorChangedListener l) {
            super(context, l);
            Display display = ColorPickerDialog.this.getWindow().getWindowManager().getDefaultDisplay();
            int height = (int)((float)display.getHeight() * 0.5f) - 36;
            int width = (int)((float)display.getWidth() * 0.7f);
            this.mHeight = height;
            this.mWidth = width;
            this.setMinimumHeight(height);
            this.setMinimumWidth(width);
            SweepGradient s = new SweepGradient(0.0f, 0.0f, this.mCircleColors, null);
            this.mCirclePaint = new Paint(1);
            this.mCirclePaint.setShader((Shader)s);
            this.mCirclePaint.setStyle(Paint.Style.STROKE);
            this.mCirclePaint.setStrokeWidth(50.0f);
            this.mCircleRadius = (float)(width / 2) * 0.7f - this.mCirclePaint.getStrokeWidth() * 0.5f;
            this.mCenterPaint = new Paint(1);
            this.mCenterPaint.setColor(ColorPickerDialog.this.mInitialColor);
            this.mCenterPaint.setStrokeWidth(5.0f);
            this.mCenterRadius = (this.mCircleRadius - this.mCirclePaint.getStrokeWidth() / 2.0f) * 0.7f;
            this.mLinePaint = new Paint(1);
            this.mLinePaint.setColor(Color.parseColor((String)"#72A1D1"));
            this.mLinePaint.setStrokeWidth(4.0f);
            this.mRectPaint = new Paint(1);
            this.mRectPaint.setStrokeWidth(5.0f);
            this.mRectLeft = -this.mCircleRadius - this.mCirclePaint.getStrokeWidth() * 0.5f;
            this.mRectTop = this.mCircleRadius + this.mCirclePaint.getStrokeWidth() * 0.5f + this.mLinePaint.getStrokeMiter() * 0.5f + 15.0f;
            this.mRectRight = this.mCircleRadius + this.mCirclePaint.getStrokeWidth() * 0.5f;
            this.mRectBottom = this.mRectTop + 50.0f;
        }

        protected void onDraw(Canvas canvas) {
            canvas.translate((float)(this.mWidth / 2), (float)(this.mHeight / 2 - 50));
            canvas.drawCircle(0.0f, 0.0f, this.mCenterRadius, this.mCenterPaint);
            if (this.mHighlightCenter || this.mlittleLightCenter) {
                int c = this.mCenterPaint.getColor();
                this.mCenterPaint.setStyle(Paint.Style.STROKE);
                if (this.mHighlightCenter) {
                    this.mCenterPaint.setAlpha(255);
                } else if (this.mlittleLightCenter) {
                    this.mCenterPaint.setAlpha(144);
                }
                canvas.drawCircle(0.0f, 0.0f, this.mCenterRadius + this.mCenterPaint.getStrokeWidth(), this.mCenterPaint);
                this.mCenterPaint.setStyle(Paint.Style.FILL);
                this.mCenterPaint.setColor(c);
            }
            canvas.drawOval(new RectF(-this.mCircleRadius, -this.mCircleRadius, this.mCircleRadius, this.mCircleRadius), this.mCirclePaint);
            if (this.mDownInCircle) {
                this.mRectColors[1] = this.mCenterPaint.getColor();
            }
            this.mRectShader = new LinearGradient(this.mRectLeft, 0.0f, this.mRectRight, 0.0f, this.mRectColors, null, Shader.TileMode.MIRROR);
            this.mRectPaint.setShader(this.mRectShader);
            canvas.drawRect(this.mRectLeft, this.mRectTop, this.mRectRight, this.mRectBottom, this.mRectPaint);
            float offset = this.mLinePaint.getStrokeWidth() / 2.0f;
            canvas.drawLine(this.mRectLeft - offset, this.mRectTop - offset * 2.0f, this.mRectLeft - offset, this.mRectBottom + offset * 2.0f, this.mLinePaint);
            canvas.drawLine(this.mRectLeft - offset * 2.0f, this.mRectTop - offset, this.mRectRight + offset * 2.0f, this.mRectTop - offset, this.mLinePaint);
            canvas.drawLine(this.mRectRight + offset, this.mRectTop - offset * 2.0f, this.mRectRight + offset, this.mRectBottom + offset * 2.0f, this.mLinePaint);
            canvas.drawLine(this.mRectLeft - offset * 2.0f, this.mRectBottom + offset, this.mRectRight + offset * 2.0f, this.mRectBottom + offset, this.mLinePaint);
            super.onDraw(canvas);
        }

        public boolean onTouchEvent(MotionEvent event) {
            float x = event.getX() - (float)(this.mWidth / 2);
            float y = event.getY() - (float)(this.mHeight / 2) + 50.0f;
            boolean inCircle = this.inColorCircle(x, y, this.mCircleRadius + this.mCirclePaint.getStrokeWidth() / 2.0f, this.mCircleRadius - this.mCirclePaint.getStrokeWidth() / 2.0f);
            boolean inCenter = this.inCenter(x, y, this.mCenterRadius);
            boolean inRect = this.inRect(x, y);
            System.out.println(x + "..." + y);
            System.out.println(this.mRectLeft + "..." + this.mRectRight + "..." + this.mRectTop + "..." + this.mRectBottom);
            switch (event.getAction()) {
                case 0: {
                    this.onActionDown(inCircle, inCenter, inRect);
                }
                case 2: {
                    this.onActionMove(x, y, inCircle, inCenter, inRect);
                    break;
                }
                case 1: {
                    this.onActionUp(inCenter);
                }
            }
            return true;
        }

        protected int interpRectColor(int[] colors, float x, float y) {
            float p;
            int c1;
            int c0;
            if (x < 0.0f) {
                c0 = colors[0];
                c1 = colors[1];
                p = (x + this.mRectRight) / this.mRectRight;
            } else {
                c0 = colors[1];
                c1 = colors[2];
                p = x / this.mRectRight;
            }
            int a = this.ave(Color.alpha((int)c0), Color.alpha((int)c1), p);
            int r = this.ave(Color.red((int)c0), Color.red((int)c1), p);
            int g = this.ave(Color.green((int)c0), Color.green((int)c1), p);
            int b = this.ave(Color.blue((int)c0), Color.blue((int)c1), p);
            return Color.argb((int)a, (int)r, (int)g, (int)b);
        }
    }

    protected abstract class ColorPickerView
    extends View {
        protected OnColorChangedListener mListener;
        protected Paint mCirclePaint;
        protected Paint mCenterPaint;
        protected Paint mLinePaint;
        protected Paint mRectPaint;
        protected Shader mRectShader;
        protected float mRectLeft;
        protected float mRectTop;
        protected float mRectRight;
        protected float mRectBottom;
        protected int mHeight;
        protected int mWidth;
        protected float mCircleRadius;
        protected float mCenterRadius;
        protected boolean mDownInCircle;
        protected boolean mDownInRect;
        protected boolean mHighlightCenter;
        protected boolean mlittleLightCenter;
        protected final int[] mCircleColors;
        protected final int[] mRectColors;

        public ColorPickerView(Context context, OnColorChangedListener l) {
            super(context);
            this.mDownInCircle = true;
            this.mListener = l;
            this.mCircleColors = new int[]{-65536, -65281, -16776961, -16711681, -16711936, -256, -65536};
            this.mRectColors = new int[]{-16777216, ColorPickerDialog.this.mInitialColor, -1};
        }

        protected int ave(int s, int d, float p) {
            return s + Math.round(p * (float)(d - s));
        }

        protected boolean inColorCircle(float x, float y, float outRadius, float inRadius) {
            double outCircle = Math.PI * (double)outRadius * (double)outRadius;
            double inCircle = Math.PI * (double)inRadius * (double)inRadius;
            double fingerCircle = Math.PI * (double)(x * x + y * y);
            return fingerCircle < outCircle && fingerCircle > inCircle;
        }

        protected boolean inCenter(float x, float y, float centerRadius) {
            double fingerCircle = Math.PI * (double)(x * x + y * y);
            double centerCircle = Math.PI * (double)centerRadius * (double)centerRadius;
            return fingerCircle < centerCircle;
        }

        protected boolean inRect(float x, float y) {
            return x <= this.mRectRight && x >= this.mRectLeft && y <= this.mRectBottom && y >= this.mRectTop;
        }

        protected int interpCircleColor(int[] colors, float unit) {
            if (unit <= 0.0f) {
                return colors[0];
            }
            if (unit >= 1.0f) {
                return colors[colors.length - 1];
            }
            float p = unit * (float)(colors.length - 1);
            int i = (int)p;
            int c0 = colors[i];
            int c1 = colors[i + 1];
            int a = this.ave(Color.alpha((int)c0), Color.alpha((int)c1), p -= (float)i);
            int r = this.ave(Color.red((int)c0), Color.red((int)c1), p);
            int g = this.ave(Color.green((int)c0), Color.green((int)c1), p);
            int b = this.ave(Color.blue((int)c0), Color.blue((int)c1), p);
            return Color.argb((int)a, (int)r, (int)g, (int)b);
        }

        protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
            super.onMeasure(this.mWidth, this.mHeight);
        }

        protected void onActionDown(boolean inCircle, boolean inCenter, boolean inRect) {
            this.mDownInCircle = inCircle;
            this.mDownInRect = inRect;
            this.mHighlightCenter = inCenter;
        }

        abstract int interpRectColor(int[] var1, float var2, float var3);

        protected void onActionMove(float x, float y, boolean inCircle, boolean inCenter, boolean inRect) {
            if (this.mDownInCircle && inCircle) {
                float angle = (float)Math.atan2(y, x);
                float unit = (float)((double)angle / (Math.PI * 2));
                if (unit < 0.0f) {
                    unit += 1.0f;
                }
                this.mCenterPaint.setColor(this.interpCircleColor(this.mCircleColors, unit));
            } else if (this.mDownInRect && inRect) {
                this.mCenterPaint.setColor(this.interpRectColor(this.mRectColors, x, y));
            }
            if (this.mHighlightCenter && inCenter || this.mlittleLightCenter && inCenter) {
                this.mHighlightCenter = true;
                this.mlittleLightCenter = false;
            } else if (this.mHighlightCenter || this.mlittleLightCenter) {
                this.mHighlightCenter = false;
                this.mlittleLightCenter = true;
            } else {
                this.mHighlightCenter = false;
                this.mlittleLightCenter = false;
            }
            this.invalidate();
        }

        protected void onActionUp(boolean inCenter) {
            if (this.mHighlightCenter && inCenter && this.mListener != null) {
                this.mListener.colorChanged(this.mCenterPaint.getColor());
                ColorPickerDialog.this.dismiss();
            }
            if (this.mDownInCircle) {
                this.mDownInCircle = false;
            }
            if (this.mDownInRect) {
                this.mDownInRect = false;
            }
            if (this.mHighlightCenter) {
                this.mHighlightCenter = false;
            }
            if (this.mlittleLightCenter) {
                this.mlittleLightCenter = false;
            }
            this.invalidate();
        }
    }

    public static interface OnColorChangedListener {
        public void colorChanged(int var1);
    }
}

