/*
 * Decompiled with CFR 0.152.
 */
package com.javafx.tools.doclets.internal.toolkit.taglets;

import com.javafx.tools.doclets.internal.toolkit.taglets.BaseInlineTaglet;
import com.javafx.tools.doclets.internal.toolkit.taglets.InheritableTaglet;
import com.javafx.tools.doclets.internal.toolkit.taglets.Taglet;
import com.javafx.tools.doclets.internal.toolkit.taglets.TagletOutput;
import com.javafx.tools.doclets.internal.toolkit.taglets.TagletWriter;
import com.javafx.tools.doclets.internal.toolkit.util.DocFinder;
import com.sun.javadoc.MethodDoc;
import com.sun.javadoc.Tag;

public class InheritDocTaglet
extends BaseInlineTaglet {
    public static final String INHERIT_DOC_INLINE_TAG = "{@inheritDoc}";

    public InheritDocTaglet() {
        this.name = "inheritDoc";
    }

    public boolean inField() {
        return false;
    }

    public boolean inConstructor() {
        return false;
    }

    public boolean inOverview() {
        return false;
    }

    public boolean inPackage() {
        return false;
    }

    public boolean inType() {
        return false;
    }

    private TagletOutput retrieveInheritedDocumentation(TagletWriter writer, MethodDoc md, Tag holderTag, boolean isFirstSentence) {
        Taglet inheritableTaglet;
        TagletOutput replacement = writer.getTagletOutputInstance();
        Taglet taglet = inheritableTaglet = holderTag == null ? null : writer.configuration().tagletManager.getTaglet(holderTag.name());
        if (inheritableTaglet != null && !(inheritableTaglet instanceof InheritableTaglet)) {
            writer.configuration().message.warning(md.position(), "doclet.noInheritedDoc", md.name() + md.flatSignature());
        }
        DocFinder.Output inheritedDoc = DocFinder.search(new DocFinder.Input(md, (InheritableTaglet)inheritableTaglet, holderTag, isFirstSentence, true));
        if (!inheritedDoc.isValidInheritDocTag) {
            writer.configuration().message.warning(md.position(), "doclet.noInheritedDoc", md.name() + md.flatSignature());
        } else if (inheritedDoc.inlineTags.length > 0) {
            replacement = writer.commentTagsToOutput(inheritedDoc.holderTag, inheritedDoc.holder, inheritedDoc.inlineTags, isFirstSentence);
        }
        return replacement;
    }

    public TagletOutput getTagletOutput(Tag tag, TagletWriter tagletWriter) {
        if (!(tag.holder() instanceof MethodDoc)) {
            return tagletWriter.getOutputInstance();
        }
        return tag.name().equals("@inheritDoc") ? this.retrieveInheritedDocumentation(tagletWriter, (MethodDoc)tag.holder(), null, tagletWriter.isFirstSentence) : this.retrieveInheritedDocumentation(tagletWriter, (MethodDoc)tag.holder(), tag, tagletWriter.isFirstSentence);
    }
}

