/*
 * Decompiled with CFR 0.152.
 */
package com.javafx.tools.doclets.internal.toolkit.builders;

import com.javafx.tools.doclets.internal.toolkit.Configuration;
import com.javafx.tools.doclets.internal.toolkit.Content;
import com.javafx.tools.doclets.internal.toolkit.MethodWriter;
import com.javafx.tools.doclets.internal.toolkit.builders.AbstractMemberBuilder;
import com.javafx.tools.doclets.internal.toolkit.builders.XMLNode;
import com.javafx.tools.doclets.internal.toolkit.util.DocFinder;
import com.javafx.tools.doclets.internal.toolkit.util.VisibleMemberMap;
import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.MethodDoc;
import com.sun.javadoc.ProgramElementDoc;
import com.sun.javadoc.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodBuilder
extends AbstractMemberBuilder {
    private int currentMethodIndex;
    private ClassDoc classDoc;
    private VisibleMemberMap visibleMemberMap;
    private MethodWriter writer;
    private List<ProgramElementDoc> methods;

    private MethodBuilder(Configuration configuration) {
        super(configuration);
    }

    public static MethodBuilder getInstance(Configuration configuration, ClassDoc classDoc, MethodWriter writer) {
        MethodBuilder builder = new MethodBuilder(configuration);
        builder.classDoc = classDoc;
        builder.writer = writer;
        builder.visibleMemberMap = new VisibleMemberMap(classDoc, 4, configuration.nodeprecated);
        builder.methods = new ArrayList<ProgramElementDoc>(builder.visibleMemberMap.getLeafClassMembers(configuration));
        if (configuration.getMemberComparator() != null) {
            Collections.sort(builder.methods, configuration.getMemberComparator());
        }
        return builder;
    }

    @Override
    public String getName() {
        return "MethodDetails";
    }

    public List<ProgramElementDoc> members(ClassDoc classDoc) {
        return this.visibleMemberMap.getMembersFor(classDoc);
    }

    public VisibleMemberMap getVisibleMemberMap() {
        return this.visibleMemberMap;
    }

    @Override
    public boolean hasMembersToDocument() {
        return this.methods.size() > 0;
    }

    public void buildMethodDoc(XMLNode node, Content memberDetailsTree) {
        if (this.writer == null) {
            return;
        }
        int size = this.methods.size();
        if (size > 0) {
            Content methodDetailsTree = this.writer.getMethodDetailsTreeHeader(this.classDoc, memberDetailsTree);
            this.currentMethodIndex = 0;
            while (this.currentMethodIndex < size) {
                Content methodDocTree = this.writer.getMethodDocTreeHeader((MethodDoc)this.methods.get(this.currentMethodIndex), methodDetailsTree);
                this.buildChildren(node, methodDocTree);
                methodDetailsTree.addContent(this.writer.getMethodDoc(methodDocTree, this.currentMethodIndex == size - 1));
                ++this.currentMethodIndex;
            }
            memberDetailsTree.addContent(this.writer.getMethodDetails(methodDetailsTree));
        }
    }

    public void buildSignature(XMLNode node, Content methodDocTree) {
        methodDocTree.addContent(this.writer.getSignature((MethodDoc)this.methods.get(this.currentMethodIndex)));
    }

    public void buildDeprecationInfo(XMLNode node, Content methodDocTree) {
        this.writer.addDeprecated((MethodDoc)this.methods.get(this.currentMethodIndex), methodDocTree);
    }

    public void buildMethodComments(XMLNode node, Content methodDocTree) {
        if (!this.configuration.nocomment) {
            MethodDoc method = (MethodDoc)this.methods.get(this.currentMethodIndex);
            if (method.inlineTags().length == 0) {
                DocFinder.Output docs = DocFinder.search(new DocFinder.Input(method));
                method = docs.inlineTags != null && docs.inlineTags.length > 0 ? (MethodDoc)docs.holder : method;
            }
            this.writer.addComments((Type)method.containingClass(), method, methodDocTree);
        }
    }

    public void buildTagInfo(XMLNode node, Content methodDocTree) {
        this.writer.addTags((MethodDoc)this.methods.get(this.currentMethodIndex), methodDocTree);
    }

    public MethodWriter getWriter() {
        return this.writer;
    }
}

