/*
 * Decompiled with CFR 0.152.
 */
package com.javafx.tools.doclets.formats.html;

import com.javafx.tools.doclets.formats.html.AbstractExecutableMemberWriter;
import com.javafx.tools.doclets.formats.html.ClassWriterImpl;
import com.javafx.tools.doclets.formats.html.ConfigurationImpl;
import com.javafx.tools.doclets.formats.html.LinkInfoImpl;
import com.javafx.tools.doclets.formats.html.SubWriterHolderWriter;
import com.javafx.tools.doclets.formats.html.markup.HtmlConstants;
import com.javafx.tools.doclets.formats.html.markup.HtmlStyle;
import com.javafx.tools.doclets.formats.html.markup.HtmlTag;
import com.javafx.tools.doclets.formats.html.markup.HtmlTree;
import com.javafx.tools.doclets.formats.html.markup.RawHtml;
import com.javafx.tools.doclets.internal.toolkit.Content;
import com.javafx.tools.doclets.internal.toolkit.taglets.DeprecatedTaglet;
import com.javafx.tools.doclets.internal.toolkit.util.Util;
import com.javafx.tools.doclets.internal.toolkit.util.VisibleMemberMap;
import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.ConstructorDoc;
import com.sun.javadoc.Doc;
import com.sun.javadoc.ExecutableMemberDoc;
import com.sun.javadoc.FieldDoc;
import com.sun.javadoc.MemberDoc;
import com.sun.javadoc.MethodDoc;
import com.sun.javadoc.ProgramElementDoc;
import com.sun.javadoc.SourcePosition;
import com.sun.javadoc.Tag;
import com.sun.javadoc.Type;
import java.lang.reflect.Modifier;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMemberWriter {
    protected boolean printedSummaryHeader = false;
    protected final SubWriterHolderWriter writer;
    protected final ClassDoc classdoc;
    public final boolean nodepr;

    public AbstractMemberWriter(SubWriterHolderWriter writer, ClassDoc classdoc) {
        this.writer = writer;
        this.nodepr = this.configuration().nodeprecated;
        this.classdoc = classdoc;
    }

    public AbstractMemberWriter(SubWriterHolderWriter writer) {
        this(writer, null);
    }

    public abstract void addSummaryLabel(Content var1);

    public abstract String getTableSummary();

    public abstract String getCaption();

    public abstract String[] getSummaryTableHeader(ProgramElementDoc var1);

    public abstract void addInheritedSummaryLabel(ClassDoc var1, Content var2);

    public abstract void addSummaryAnchor(ClassDoc var1, Content var2);

    public abstract void addInheritedSummaryAnchor(ClassDoc var1, Content var2);

    protected abstract void addSummaryType(ProgramElementDoc var1, Content var2);

    protected void addSummaryLink(ClassDoc cd, ProgramElementDoc member, Content tdSummary) {
        this.addSummaryLink(3, cd, member, tdSummary);
    }

    protected abstract void addSummaryLink(int var1, ClassDoc var2, ProgramElementDoc var3, Content var4);

    protected abstract void addInheritedSummaryLink(ClassDoc var1, ProgramElementDoc var2, Content var3);

    protected abstract Content getDeprecatedLink(ProgramElementDoc var1);

    protected abstract Content getNavSummaryLink(ClassDoc var1, boolean var2);

    protected abstract void addNavDetailLink(boolean var1, Content var2);

    protected void print(String str) {
        this.writer.print(str);
        this.writer.displayLength += str.length();
    }

    protected void print(char ch) {
        this.writer.print(ch);
        ++this.writer.displayLength;
    }

    protected void strong(String str) {
        this.writer.strong(str);
        this.writer.displayLength += str.length();
    }

    protected void addName(String name, Content htmltree) {
        htmltree.addContent(name);
        this.writer.displayLength += name.length();
    }

    protected String modifierString(MemberDoc member) {
        int ms = member.modifierSpecifier();
        int no = 288;
        return Modifier.toString(ms & ~no);
    }

    protected String typeString(MemberDoc member) {
        String type = "";
        if (member instanceof MethodDoc) {
            type = ((MethodDoc)member).returnType().toString();
        } else if (member instanceof FieldDoc) {
            type = ((FieldDoc)member).type().toString();
        }
        return type;
    }

    protected void addModifiers(MemberDoc member, Content htmltree) {
        String mod = this.modifierString(member);
        if ((member.isField() || member.isMethod()) && this.writer instanceof ClassWriterImpl && ((ClassWriterImpl)this.writer).getClassDoc().isInterface()) {
            mod = Util.replaceText(mod, "public", "").trim();
        }
        if (mod.length() > 0) {
            htmltree.addContent(mod);
            htmltree.addContent(this.writer.getSpace());
        }
    }

    protected String makeSpace(int len) {
        if (len <= 0) {
            return "";
        }
        StringBuffer sb = new StringBuffer(len);
        for (int i = 0; i < len; ++i) {
            sb.append(' ');
        }
        return sb.toString();
    }

    protected void addModifierAndType(ProgramElementDoc member, Type type, Content tdSummaryType) {
        HtmlTree code = new HtmlTree(HtmlTag.CODE);
        this.addModifier(member, code);
        if (type == null) {
            if (member.isClass()) {
                code.addContent("class");
            } else {
                code.addContent("interface");
            }
            code.addContent(this.writer.getSpace());
        } else if (member instanceof ExecutableMemberDoc && ((ExecutableMemberDoc)member).typeParameters().length > 0) {
            int displayLength = ((AbstractExecutableMemberWriter)this).addTypeParameters((ExecutableMemberDoc)member, code);
            if (displayLength > 10) {
                code.addContent(new HtmlTree(HtmlTag.BR));
            }
            code.addContent(new RawHtml(this.writer.getLink(new LinkInfoImpl(17, type))));
        } else {
            code.addContent(new RawHtml(this.writer.getLink(new LinkInfoImpl(17, type))));
        }
        tdSummaryType.addContent(code);
    }

    private void printModifier(ProgramElementDoc member) {
        if (member.isProtected()) {
            this.print("protected ");
        } else if (member.isPrivate()) {
            this.print("private ");
        } else if (!member.isPublic()) {
            this.writer.printText("doclet.Package_private");
            this.print(" ");
        }
        if (member.isMethod() && ((MethodDoc)member).isAbstract()) {
            this.print("abstract ");
        }
        if (member.isStatic()) {
            this.print("static");
        }
    }

    private void addModifier(ProgramElementDoc member, Content code) {
        if (member.isProtected()) {
            code.addContent("protected ");
        } else if (member.isPrivate()) {
            code.addContent("private ");
        } else if (!member.isPublic()) {
            code.addContent(this.configuration().getText("doclet.Package_private"));
            code.addContent(" ");
        }
        if (member.isMethod() && ((MethodDoc)member).isAbstract()) {
            code.addContent("abstract ");
        }
        if (member.isStatic()) {
            code.addContent("static ");
        }
    }

    protected void addDeprecatedInfo(ProgramElementDoc member, Content contentTree) {
        String output = new DeprecatedTaglet().getTagletOutput((Doc)member, this.writer.getTagletWriterInstance(false)).toString().trim();
        if (!output.isEmpty()) {
            RawHtml deprecatedContent = new RawHtml(output);
            HtmlTree div = HtmlTree.DIV(HtmlStyle.block, deprecatedContent);
            contentTree.addContent(div);
        }
    }

    protected void addComment(ProgramElementDoc member, Content htmltree) {
        if (member.inlineTags().length > 0) {
            this.writer.addInlineComment((Doc)member, htmltree);
        }
    }

    protected String name(ProgramElementDoc member) {
        return member.name();
    }

    protected Content getHead(MemberDoc member) {
        RawHtml memberContent = new RawHtml(member.name());
        HtmlTree heading = HtmlTree.HEADING(HtmlConstants.MEMBER_HEADING, memberContent);
        return heading;
    }

    protected boolean isInherited(ProgramElementDoc ped) {
        return !ped.isPrivate() && (!ped.isPackagePrivate() || ped.containingPackage().equals(this.classdoc.containingPackage()));
    }

    protected void addDeprecatedAPI(List<Doc> deprmembers, String headingKey, String tableSummary, String[] tableHeader, Content contentTree) {
        if (deprmembers.size() > 0) {
            HtmlTree table = HtmlTree.TABLE(0, 3, 0, tableSummary, this.writer.getTableCaption(this.configuration().getText(headingKey)));
            ((Content)table).addContent(this.writer.getSummaryTableHeader(tableHeader, "col"));
            HtmlTree tbody = new HtmlTree(HtmlTag.TBODY);
            for (int i = 0; i < deprmembers.size(); ++i) {
                ProgramElementDoc member = (ProgramElementDoc)deprmembers.get(i);
                HtmlTree td = HtmlTree.TD(HtmlStyle.colOne, this.getDeprecatedLink(member));
                if (member.tags("deprecated").length > 0) {
                    this.writer.addInlineDeprecatedComment((Doc)member, member.tags("deprecated")[0], td);
                }
                HtmlTree tr = HtmlTree.TR(td);
                if (i % 2 == 0) {
                    tr.addStyle(HtmlStyle.altColor);
                } else {
                    tr.addStyle(HtmlStyle.rowColor);
                }
                ((Content)tbody).addContent(tr);
            }
            ((Content)table).addContent(tbody);
            HtmlTree li = HtmlTree.LI(HtmlStyle.blockList, table);
            HtmlTree ul = HtmlTree.UL(HtmlStyle.blockList, li);
            contentTree.addContent(ul);
        }
    }

    protected void addUseInfo(List<? extends ProgramElementDoc> mems, String heading, String tableSummary, Content contentTree) {
        if (mems == null) {
            return;
        }
        List<? extends ProgramElementDoc> members = mems;
        boolean printedUseTableHeader = false;
        if (members.size() > 0) {
            HtmlTree table = HtmlTree.TABLE(0, 3, 0, tableSummary, this.writer.getTableCaption(heading));
            HtmlTree tbody = new HtmlTree(HtmlTag.TBODY);
            Iterator<? extends ProgramElementDoc> it = members.iterator();
            int i = 0;
            while (it.hasNext()) {
                ProgramElementDoc pgmdoc = it.next();
                ClassDoc cd = pgmdoc.containingClass();
                if (!printedUseTableHeader) {
                    ((Content)table).addContent(this.writer.getSummaryTableHeader(this.getSummaryTableHeader(pgmdoc), "col"));
                    printedUseTableHeader = true;
                }
                HtmlTree tr = new HtmlTree(HtmlTag.TR);
                if (i % 2 == 0) {
                    tr.addStyle(HtmlStyle.altColor);
                } else {
                    tr.addStyle(HtmlStyle.rowColor);
                }
                HtmlTree tdFirst = new HtmlTree(HtmlTag.TD);
                tdFirst.addStyle(HtmlStyle.colFirst);
                this.writer.addSummaryType(this, pgmdoc, tdFirst);
                tr.addContent(tdFirst);
                HtmlTree tdLast = new HtmlTree(HtmlTag.TD);
                tdLast.addStyle(HtmlStyle.colLast);
                if (cd != null && !(pgmdoc instanceof ConstructorDoc) && !(pgmdoc instanceof ClassDoc)) {
                    HtmlTree name = new HtmlTree(HtmlTag.SPAN);
                    name.addStyle(HtmlStyle.strong);
                    name.addContent(cd.name() + ".");
                    tdLast.addContent(name);
                }
                this.addSummaryLink(pgmdoc instanceof ClassDoc ? 4 : 3, cd, pgmdoc, tdLast);
                this.writer.addSummaryLinkComment(this, pgmdoc, tdLast);
                tr.addContent(tdLast);
                ((Content)tbody).addContent(tr);
                ++i;
            }
            ((Content)table).addContent(tbody);
            contentTree.addContent(table);
        }
    }

    protected void addNavDetailLink(List<?> members, Content liNav) {
        this.addNavDetailLink(members.size() > 0, liNav);
    }

    protected void addNavSummaryLink(List<?> members, VisibleMemberMap visibleMemberMap, Content liNav) {
        if (members.size() > 0) {
            liNav.addContent(this.getNavSummaryLink(null, true));
            return;
        }
        for (ClassDoc icd = this.classdoc.superclass(); icd != null; icd = icd.superclass()) {
            List<ProgramElementDoc> inhmembers = visibleMemberMap.getMembersFor(icd);
            if (inhmembers.size() <= 0) continue;
            liNav.addContent(this.getNavSummaryLink(icd, true));
            return;
        }
        liNav.addContent(this.getNavSummaryLink(null, false));
    }

    protected void serialWarning(SourcePosition pos, String key, String a1, String a2) {
        if (this.configuration().serialwarn) {
            ConfigurationImpl.getInstance().getDocletSpecificMsg().warning(pos, key, a1, a2);
        }
    }

    public ProgramElementDoc[] eligibleMembers(ProgramElementDoc[] members) {
        return this.nodepr ? Util.excludeDeprecatedMembers(members) : members;
    }

    public ConfigurationImpl configuration() {
        return this.writer.configuration;
    }

    public void addMemberSummary(ClassDoc classDoc, ProgramElementDoc member, Tag[] firstSentenceTags, Content tableTree, int counter) {
        HtmlTree tdSummaryType = new HtmlTree(HtmlTag.TD);
        tdSummaryType.addStyle(HtmlStyle.colFirst);
        this.writer.addSummaryType(this, member, tdSummaryType);
        HtmlTree tdSummary = new HtmlTree(HtmlTag.TD);
        this.setSummaryColumnStyle(tdSummary);
        this.addSummaryLink(classDoc, member, tdSummary);
        this.writer.addSummaryLinkComment(this, member, firstSentenceTags, tdSummary);
        HtmlTree tr = HtmlTree.TR(tdSummaryType);
        tr.addContent(tdSummary);
        if (counter % 2 == 0) {
            tr.addStyle(HtmlStyle.altColor);
        } else {
            tr.addStyle(HtmlStyle.rowColor);
        }
        tableTree.addContent(tr);
    }

    public void setSummaryColumnStyle(HtmlTree tdTree) {
        tdTree.addStyle(HtmlStyle.colLast);
    }

    public void addInheritedMemberSummary(ClassDoc classDoc, ProgramElementDoc nestedClass, boolean isFirst, boolean isLast, Content linksTree) {
        this.writer.addInheritedMemberSummary(this, classDoc, nestedClass, isFirst, linksTree);
    }

    public Content getInheritedSummaryHeader(ClassDoc classDoc) {
        Content inheritedTree = this.writer.getMemberTreeHeader();
        this.writer.addInheritedSummaryHeader(this, classDoc, inheritedTree);
        return inheritedTree;
    }

    public Content getInheritedSummaryLinksTree() {
        return new HtmlTree(HtmlTag.CODE);
    }

    public Content getSummaryTableTree(ClassDoc classDoc) {
        return this.writer.getSummaryTableTree(this, classDoc);
    }

    public Content getMemberTree(Content memberTree) {
        return this.writer.getMemberTree(memberTree);
    }

    public Content getMemberTree(Content memberTree, boolean isLastContent) {
        if (isLastContent) {
            return HtmlTree.UL(HtmlStyle.blockListLast, memberTree);
        }
        return HtmlTree.UL(HtmlStyle.blockList, memberTree);
    }
}

