/*
 * Decompiled with CFR 0.152.
 */
package com.e4a.runtime.components.impl.android.\u5982\u610f\u53ef\u89c6\u64ad\u653e\u5668\u7c7b\u5e93;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.SurfaceTexture;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.util.Log;
import android.view.Surface;
import android.view.SurfaceHolder;
import android.view.TextureView;
import android.view.View;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityNodeInfo;
import com.e4a.runtime.components.impl.android.\u5982\u610f\u53ef\u89c6\u64ad\u653e\u5668\u7c7b\u5e93.IRenderView;
import com.e4a.runtime.components.impl.android.\u5982\u610f\u53ef\u89c6\u64ad\u653e\u5668\u7c7b\u5e93.MeasureHelper;
import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import tv.danmaku.ijk.media.player.IMediaPlayer;
import tv.danmaku.ijk.media.player.ISurfaceTextureHolder;
import tv.danmaku.ijk.media.player.ISurfaceTextureHost;

@TargetApi(value=14)
public class TextureRenderView
extends TextureView
implements IRenderView {
    private static final String TAG = "TextureRenderView";
    private MeasureHelper mMeasureHelper;
    private SurfaceCallback mSurfaceCallback;

    public TextureRenderView(Context context) {
        super(context);
        this.initView(context);
    }

    public TextureRenderView(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.initView(context);
    }

    public TextureRenderView(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
        this.initView(context);
    }

    @TargetApi(value=21)
    public TextureRenderView(Context context, AttributeSet attributeSet, int n, int n2) {
        super(context, attributeSet, n, n2);
        this.initView(context);
    }

    private void initView(Context context) {
        this.mMeasureHelper = new MeasureHelper((View)this);
        this.mSurfaceCallback = new SurfaceCallback(this);
        this.setSurfaceTextureListener(this.mSurfaceCallback);
    }

    @Override
    public View getView() {
        return this;
    }

    @Override
    public boolean shouldWaitForResize() {
        return false;
    }

    protected void onDetachedFromWindow() {
        this.mSurfaceCallback.willDetachFromWindow();
        super.onDetachedFromWindow();
        this.mSurfaceCallback.didDetachFromWindow();
    }

    @Override
    public void setVideoSize(int n, int n2) {
        if (n > 0 && n2 > 0) {
            this.mMeasureHelper.setVideoSize(n, n2);
            this.requestLayout();
        }
    }

    @Override
    public void setVideoSampleAspectRatio(int n, int n2) {
        if (n > 0 && n2 > 0) {
            this.mMeasureHelper.setVideoSampleAspectRatio(n, n2);
            this.requestLayout();
        }
    }

    @Override
    public void setVideoRotation(int n) {
        this.mMeasureHelper.setVideoRotation(n);
        this.setRotation(n);
    }

    @Override
    public void setAspectRatio(int n) {
        this.mMeasureHelper.setAspectRatio(n);
        this.requestLayout();
    }

    protected void onMeasure(int n, int n2) {
        this.mMeasureHelper.doMeasure(n, n2);
        this.setMeasuredDimension(this.mMeasureHelper.getMeasuredWidth(), this.mMeasureHelper.getMeasuredHeight());
    }

    public IRenderView.ISurfaceHolder getSurfaceHolder() {
        return new InternalSurfaceHolder(this, this.mSurfaceCallback.mSurfaceTexture, this.mSurfaceCallback);
    }

    @Override
    public void addRenderCallback(IRenderView.IRenderCallback iRenderCallback) {
        this.mSurfaceCallback.addRenderCallback(iRenderCallback);
    }

    @Override
    public void removeRenderCallback(IRenderView.IRenderCallback iRenderCallback) {
        this.mSurfaceCallback.removeRenderCallback(iRenderCallback);
    }

    public void onInitializeAccessibilityEvent(AccessibilityEvent accessibilityEvent) {
        super.onInitializeAccessibilityEvent(accessibilityEvent);
        accessibilityEvent.setClassName((CharSequence)TextureRenderView.class.getName());
    }

    public void onInitializeAccessibilityNodeInfo(AccessibilityNodeInfo accessibilityNodeInfo) {
        super.onInitializeAccessibilityNodeInfo(accessibilityNodeInfo);
        accessibilityNodeInfo.setClassName((CharSequence)TextureRenderView.class.getName());
    }

    private static final class SurfaceCallback
    implements TextureView.SurfaceTextureListener,
    ISurfaceTextureHost {
        private SurfaceTexture mSurfaceTexture;
        private boolean mIsFormatChanged;
        private int mWidth;
        private int mHeight;
        private boolean mOwnSurfaceTexture = true;
        private boolean mWillDetachFromWindow = false;
        private boolean mDidDetachFromWindow = false;
        private WeakReference<TextureRenderView> mWeakRenderView;
        private Map<IRenderView.IRenderCallback, Object> mRenderCallbackMap = new ConcurrentHashMap<IRenderView.IRenderCallback, Object>();

        public SurfaceCallback(@NonNull TextureRenderView textureRenderView) {
            this.mWeakRenderView = new WeakReference<TextureRenderView>(textureRenderView);
        }

        public void setOwnSurfaceTexture(boolean bl) {
            this.mOwnSurfaceTexture = bl;
        }

        public void addRenderCallback(@NonNull IRenderView.IRenderCallback iRenderCallback) {
            this.mRenderCallbackMap.put(iRenderCallback, iRenderCallback);
            InternalSurfaceHolder internalSurfaceHolder = null;
            if (this.mSurfaceTexture != null) {
                if (internalSurfaceHolder == null) {
                    internalSurfaceHolder = new InternalSurfaceHolder((TextureRenderView)this.mWeakRenderView.get(), this.mSurfaceTexture, this);
                }
                iRenderCallback.onSurfaceCreated(internalSurfaceHolder, this.mWidth, this.mHeight);
            }
            if (this.mIsFormatChanged) {
                if (internalSurfaceHolder == null) {
                    internalSurfaceHolder = new InternalSurfaceHolder((TextureRenderView)this.mWeakRenderView.get(), this.mSurfaceTexture, this);
                }
                iRenderCallback.onSurfaceChanged(internalSurfaceHolder, 0, this.mWidth, this.mHeight);
            }
        }

        public void removeRenderCallback(@NonNull IRenderView.IRenderCallback iRenderCallback) {
            this.mRenderCallbackMap.remove(iRenderCallback);
        }

        public void onSurfaceTextureAvailable(SurfaceTexture surfaceTexture, int n, int n2) {
            this.mSurfaceTexture = surfaceTexture;
            this.mIsFormatChanged = false;
            this.mWidth = 0;
            this.mHeight = 0;
            InternalSurfaceHolder internalSurfaceHolder = new InternalSurfaceHolder((TextureRenderView)this.mWeakRenderView.get(), surfaceTexture, this);
            for (IRenderView.IRenderCallback iRenderCallback : this.mRenderCallbackMap.keySet()) {
                iRenderCallback.onSurfaceCreated(internalSurfaceHolder, 0, 0);
            }
        }

        public void onSurfaceTextureSizeChanged(SurfaceTexture surfaceTexture, int n, int n2) {
            this.mSurfaceTexture = surfaceTexture;
            this.mIsFormatChanged = true;
            this.mWidth = n;
            this.mHeight = n2;
            InternalSurfaceHolder internalSurfaceHolder = new InternalSurfaceHolder((TextureRenderView)this.mWeakRenderView.get(), surfaceTexture, this);
            for (IRenderView.IRenderCallback iRenderCallback : this.mRenderCallbackMap.keySet()) {
                iRenderCallback.onSurfaceChanged(internalSurfaceHolder, 0, n, n2);
            }
        }

        public boolean onSurfaceTextureDestroyed(SurfaceTexture surfaceTexture) {
            this.mSurfaceTexture = surfaceTexture;
            this.mIsFormatChanged = false;
            this.mWidth = 0;
            this.mHeight = 0;
            InternalSurfaceHolder internalSurfaceHolder = new InternalSurfaceHolder((TextureRenderView)this.mWeakRenderView.get(), surfaceTexture, this);
            for (IRenderView.IRenderCallback iRenderCallback : this.mRenderCallbackMap.keySet()) {
                iRenderCallback.onSurfaceDestroyed(internalSurfaceHolder);
            }
            Log.d((String)TextureRenderView.TAG, (String)("onSurfaceTextureDestroyed: destroy: " + this.mOwnSurfaceTexture));
            return this.mOwnSurfaceTexture;
        }

        public void onSurfaceTextureUpdated(SurfaceTexture surfaceTexture) {
        }

        public void releaseSurfaceTexture(SurfaceTexture surfaceTexture) {
            if (surfaceTexture == null) {
                Log.d((String)TextureRenderView.TAG, (String)"releaseSurfaceTexture: null");
            } else if (this.mDidDetachFromWindow) {
                if (surfaceTexture != this.mSurfaceTexture) {
                    Log.d((String)TextureRenderView.TAG, (String)"releaseSurfaceTexture: didDetachFromWindow(): release different SurfaceTexture");
                    surfaceTexture.release();
                } else if (!this.mOwnSurfaceTexture) {
                    Log.d((String)TextureRenderView.TAG, (String)"releaseSurfaceTexture: didDetachFromWindow(): release detached SurfaceTexture");
                    surfaceTexture.release();
                } else {
                    Log.d((String)TextureRenderView.TAG, (String)"releaseSurfaceTexture: didDetachFromWindow(): already released by TextureView");
                }
            } else if (this.mWillDetachFromWindow) {
                if (surfaceTexture != this.mSurfaceTexture) {
                    Log.d((String)TextureRenderView.TAG, (String)"releaseSurfaceTexture: willDetachFromWindow(): release different SurfaceTexture");
                    surfaceTexture.release();
                } else if (!this.mOwnSurfaceTexture) {
                    Log.d((String)TextureRenderView.TAG, (String)"releaseSurfaceTexture: willDetachFromWindow(): re-attach SurfaceTexture to TextureView");
                    this.setOwnSurfaceTexture(true);
                } else {
                    Log.d((String)TextureRenderView.TAG, (String)"releaseSurfaceTexture: willDetachFromWindow(): will released by TextureView");
                }
            } else if (surfaceTexture != this.mSurfaceTexture) {
                Log.d((String)TextureRenderView.TAG, (String)"releaseSurfaceTexture: alive: release different SurfaceTexture");
                surfaceTexture.release();
            } else if (!this.mOwnSurfaceTexture) {
                Log.d((String)TextureRenderView.TAG, (String)"releaseSurfaceTexture: alive: re-attach SurfaceTexture to TextureView");
                this.setOwnSurfaceTexture(true);
            } else {
                Log.d((String)TextureRenderView.TAG, (String)"releaseSurfaceTexture: alive: will released by TextureView");
            }
        }

        public void willDetachFromWindow() {
            Log.d((String)TextureRenderView.TAG, (String)"willDetachFromWindow()");
            this.mWillDetachFromWindow = true;
        }

        public void didDetachFromWindow() {
            Log.d((String)TextureRenderView.TAG, (String)"didDetachFromWindow()");
            this.mDidDetachFromWindow = true;
        }
    }

    private static final class InternalSurfaceHolder
    implements IRenderView.ISurfaceHolder {
        private TextureRenderView mTextureView;
        private SurfaceTexture mSurfaceTexture;
        private ISurfaceTextureHost mSurfaceTextureHost;

        public InternalSurfaceHolder(@NonNull TextureRenderView textureRenderView, @Nullable SurfaceTexture surfaceTexture, @NonNull ISurfaceTextureHost iSurfaceTextureHost) {
            this.mTextureView = textureRenderView;
            this.mSurfaceTexture = surfaceTexture;
            this.mSurfaceTextureHost = iSurfaceTextureHost;
        }

        @Override
        @TargetApi(value=16)
        public void bindToMediaPlayer(IMediaPlayer iMediaPlayer) {
            if (iMediaPlayer == null) {
                return;
            }
            if (Build.VERSION.SDK_INT >= 16 && iMediaPlayer instanceof ISurfaceTextureHolder) {
                ISurfaceTextureHolder iSurfaceTextureHolder = (ISurfaceTextureHolder)iMediaPlayer;
                this.mTextureView.mSurfaceCallback.setOwnSurfaceTexture(false);
                SurfaceTexture surfaceTexture = iSurfaceTextureHolder.getSurfaceTexture();
                if (surfaceTexture != null) {
                    this.mTextureView.setSurfaceTexture(surfaceTexture);
                } else {
                    iSurfaceTextureHolder.setSurfaceTexture(this.mSurfaceTexture);
                    iSurfaceTextureHolder.setSurfaceTextureHost((ISurfaceTextureHost)this.mTextureView.mSurfaceCallback);
                }
            } else {
                iMediaPlayer.setSurface(this.openSurface());
            }
        }

        @Override
        @NonNull
        public IRenderView getRenderView() {
            return this.mTextureView;
        }

        @Override
        @Nullable
        public SurfaceHolder getSurfaceHolder() {
            return null;
        }

        @Override
        @Nullable
        public SurfaceTexture getSurfaceTexture() {
            return this.mSurfaceTexture;
        }

        @Override
        @Nullable
        public Surface openSurface() {
            if (this.mSurfaceTexture == null) {
                return null;
            }
            return new Surface(this.mSurfaceTexture);
        }
    }
}

