/*
 * Decompiled with CFR 0.152.
 */
package com.e4a.runtime.components.impl.android.\u5982\u610f\u53ef\u89c6\u64ad\u653e\u5668\u7c7b\u5e93;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.SurfaceTexture;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.util.Log;
import android.view.Surface;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.view.View;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityNodeInfo;
import com.e4a.runtime.components.impl.android.\u5982\u610f\u53ef\u89c6\u64ad\u653e\u5668\u7c7b\u5e93.IRenderView;
import com.e4a.runtime.components.impl.android.\u5982\u610f\u53ef\u89c6\u64ad\u653e\u5668\u7c7b\u5e93.MeasureHelper;
import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import tv.danmaku.ijk.media.player.IMediaPlayer;
import tv.danmaku.ijk.media.player.ISurfaceTextureHolder;

public class SurfaceRenderView
extends SurfaceView
implements IRenderView {
    private MeasureHelper mMeasureHelper;
    private SurfaceCallback mSurfaceCallback;

    public SurfaceRenderView(Context context) {
        super(context);
        this.initView(context);
    }

    public SurfaceRenderView(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.initView(context);
    }

    public SurfaceRenderView(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
        this.initView(context);
    }

    @TargetApi(value=21)
    public SurfaceRenderView(Context context, AttributeSet attributeSet, int n, int n2) {
        super(context, attributeSet, n, n2);
        this.initView(context);
    }

    private void initView(Context context) {
        this.mMeasureHelper = new MeasureHelper((View)this);
        this.mSurfaceCallback = new SurfaceCallback(this);
        this.getHolder().addCallback((SurfaceHolder.Callback)this.mSurfaceCallback);
        this.getHolder().setType(0);
    }

    @Override
    public View getView() {
        return this;
    }

    @Override
    public boolean shouldWaitForResize() {
        return true;
    }

    @Override
    public void setVideoSize(int n, int n2) {
        if (n > 0 && n2 > 0) {
            this.mMeasureHelper.setVideoSize(n, n2);
            this.getHolder().setFixedSize(n, n2);
            this.requestLayout();
        }
    }

    @Override
    public void setVideoSampleAspectRatio(int n, int n2) {
        if (n > 0 && n2 > 0) {
            this.mMeasureHelper.setVideoSampleAspectRatio(n, n2);
            this.requestLayout();
        }
    }

    @Override
    public void setVideoRotation(int n) {
        Log.e((String)"", (String)("SurfaceView doesn't support rotation (" + n + ")!\n"));
    }

    @Override
    public void setAspectRatio(int n) {
        this.mMeasureHelper.setAspectRatio(n);
        this.requestLayout();
    }

    protected void onMeasure(int n, int n2) {
        this.mMeasureHelper.doMeasure(n, n2);
        this.setMeasuredDimension(this.mMeasureHelper.getMeasuredWidth(), this.mMeasureHelper.getMeasuredHeight());
    }

    @Override
    public void addRenderCallback(IRenderView.IRenderCallback iRenderCallback) {
        this.mSurfaceCallback.addRenderCallback(iRenderCallback);
    }

    @Override
    public void removeRenderCallback(IRenderView.IRenderCallback iRenderCallback) {
        this.mSurfaceCallback.removeRenderCallback(iRenderCallback);
    }

    public void onInitializeAccessibilityEvent(AccessibilityEvent accessibilityEvent) {
        super.onInitializeAccessibilityEvent(accessibilityEvent);
        accessibilityEvent.setClassName((CharSequence)SurfaceRenderView.class.getName());
    }

    @TargetApi(value=14)
    public void onInitializeAccessibilityNodeInfo(AccessibilityNodeInfo accessibilityNodeInfo) {
        super.onInitializeAccessibilityNodeInfo(accessibilityNodeInfo);
        if (Build.VERSION.SDK_INT >= 14) {
            accessibilityNodeInfo.setClassName((CharSequence)SurfaceRenderView.class.getName());
        }
    }

    private static final class SurfaceCallback
    implements SurfaceHolder.Callback {
        private SurfaceHolder mSurfaceHolder;
        private boolean mIsFormatChanged;
        private int mFormat;
        private int mWidth;
        private int mHeight;
        private WeakReference<SurfaceRenderView> mWeakSurfaceView;
        private Map<IRenderView.IRenderCallback, Object> mRenderCallbackMap = new ConcurrentHashMap<IRenderView.IRenderCallback, Object>();

        public SurfaceCallback(@NonNull SurfaceRenderView surfaceRenderView) {
            this.mWeakSurfaceView = new WeakReference<SurfaceRenderView>(surfaceRenderView);
        }

        public void addRenderCallback(@NonNull IRenderView.IRenderCallback iRenderCallback) {
            this.mRenderCallbackMap.put(iRenderCallback, iRenderCallback);
            InternalSurfaceHolder internalSurfaceHolder = null;
            if (this.mSurfaceHolder != null) {
                if (internalSurfaceHolder == null) {
                    internalSurfaceHolder = new InternalSurfaceHolder((SurfaceRenderView)this.mWeakSurfaceView.get(), this.mSurfaceHolder);
                }
                iRenderCallback.onSurfaceCreated(internalSurfaceHolder, this.mWidth, this.mHeight);
            }
            if (this.mIsFormatChanged) {
                if (internalSurfaceHolder == null) {
                    internalSurfaceHolder = new InternalSurfaceHolder((SurfaceRenderView)this.mWeakSurfaceView.get(), this.mSurfaceHolder);
                }
                iRenderCallback.onSurfaceChanged(internalSurfaceHolder, this.mFormat, this.mWidth, this.mHeight);
            }
        }

        public void removeRenderCallback(@NonNull IRenderView.IRenderCallback iRenderCallback) {
            this.mRenderCallbackMap.remove(iRenderCallback);
        }

        public void surfaceCreated(SurfaceHolder surfaceHolder) {
            this.mSurfaceHolder = surfaceHolder;
            this.mIsFormatChanged = false;
            this.mFormat = 0;
            this.mWidth = 0;
            this.mHeight = 0;
            InternalSurfaceHolder internalSurfaceHolder = new InternalSurfaceHolder((SurfaceRenderView)this.mWeakSurfaceView.get(), this.mSurfaceHolder);
            for (IRenderView.IRenderCallback iRenderCallback : this.mRenderCallbackMap.keySet()) {
                iRenderCallback.onSurfaceCreated(internalSurfaceHolder, 0, 0);
            }
        }

        public void surfaceDestroyed(SurfaceHolder surfaceHolder) {
            this.mSurfaceHolder = null;
            this.mIsFormatChanged = false;
            this.mFormat = 0;
            this.mWidth = 0;
            this.mHeight = 0;
            InternalSurfaceHolder internalSurfaceHolder = new InternalSurfaceHolder((SurfaceRenderView)this.mWeakSurfaceView.get(), this.mSurfaceHolder);
            for (IRenderView.IRenderCallback iRenderCallback : this.mRenderCallbackMap.keySet()) {
                iRenderCallback.onSurfaceDestroyed(internalSurfaceHolder);
            }
        }

        public void surfaceChanged(SurfaceHolder surfaceHolder, int n, int n2, int n3) {
            this.mSurfaceHolder = surfaceHolder;
            this.mIsFormatChanged = true;
            this.mFormat = n;
            this.mWidth = n2;
            this.mHeight = n3;
            InternalSurfaceHolder internalSurfaceHolder = new InternalSurfaceHolder((SurfaceRenderView)this.mWeakSurfaceView.get(), this.mSurfaceHolder);
            for (IRenderView.IRenderCallback iRenderCallback : this.mRenderCallbackMap.keySet()) {
                iRenderCallback.onSurfaceChanged(internalSurfaceHolder, n, n2, n3);
            }
        }
    }

    private static final class InternalSurfaceHolder
    implements IRenderView.ISurfaceHolder {
        private SurfaceRenderView mSurfaceView;
        private SurfaceHolder mSurfaceHolder;

        public InternalSurfaceHolder(@NonNull SurfaceRenderView surfaceRenderView, @Nullable SurfaceHolder surfaceHolder) {
            this.mSurfaceView = surfaceRenderView;
            this.mSurfaceHolder = surfaceHolder;
        }

        @Override
        public void bindToMediaPlayer(IMediaPlayer iMediaPlayer) {
            if (iMediaPlayer != null) {
                if (Build.VERSION.SDK_INT >= 16 && iMediaPlayer instanceof ISurfaceTextureHolder) {
                    ISurfaceTextureHolder iSurfaceTextureHolder = (ISurfaceTextureHolder)iMediaPlayer;
                    iSurfaceTextureHolder.setSurfaceTexture(null);
                }
                iMediaPlayer.setDisplay(this.mSurfaceHolder);
            }
        }

        @Override
        @NonNull
        public IRenderView getRenderView() {
            return this.mSurfaceView;
        }

        @Override
        @Nullable
        public SurfaceHolder getSurfaceHolder() {
            return this.mSurfaceHolder;
        }

        @Override
        @Nullable
        public SurfaceTexture getSurfaceTexture() {
            return null;
        }

        @Override
        @Nullable
        public Surface openSurface() {
            if (this.mSurfaceHolder == null) {
                return null;
            }
            return this.mSurfaceHolder.getSurface();
        }
    }
}

