/*
 * Decompiled with CFR 0.152.
 */
package com.e4a.runtime.components.impl.android.\u5982\u610f\u53ef\u89c6\u64ad\u653e\u5668\u7c7b\u5e93;

import android.content.Context;
import android.support.annotation.NonNull;
import android.view.View;
import java.lang.ref.WeakReference;

public final class MeasureHelper {
    private WeakReference<View> mWeakView;
    private int mVideoWidth;
    private int mVideoHeight;
    private int mVideoSarNum;
    private int mVideoSarDen;
    private int mVideoRotationDegree;
    private int mMeasuredWidth;
    private int mMeasuredHeight;
    private int mCurrentAspectRatio = 0;

    public MeasureHelper(View view) {
        this.mWeakView = new WeakReference<View>(view);
    }

    public View getView() {
        if (this.mWeakView == null) {
            return null;
        }
        return (View)this.mWeakView.get();
    }

    public void setVideoSize(int n, int n2) {
        this.mVideoWidth = n;
        this.mVideoHeight = n2;
    }

    public void setVideoSampleAspectRatio(int n, int n2) {
        this.mVideoSarNum = n;
        this.mVideoSarDen = n2;
    }

    public void setVideoRotation(int n) {
        this.mVideoRotationDegree = n;
    }

    public void doMeasure(int n, int n2) {
        int n3;
        if (this.mVideoRotationDegree == 90 || this.mVideoRotationDegree == 270) {
            n3 = n;
            n = n2;
            n2 = n3;
        }
        n3 = View.getDefaultSize((int)this.mVideoWidth, (int)n);
        int n4 = View.getDefaultSize((int)this.mVideoHeight, (int)n2);
        if (this.mCurrentAspectRatio == 3) {
            n3 = n;
            n4 = n2;
        } else if (this.mVideoWidth > 0 && this.mVideoHeight > 0) {
            int n5 = View.MeasureSpec.getMode((int)n);
            int n6 = View.MeasureSpec.getSize((int)n);
            int n7 = View.MeasureSpec.getMode((int)n2);
            int n8 = View.MeasureSpec.getSize((int)n2);
            if (n5 == Integer.MIN_VALUE && n7 == Integer.MIN_VALUE) {
                float f;
                float f2 = (float)n6 / (float)n8;
                switch (this.mCurrentAspectRatio) {
                    case 4: {
                        f = 1.7777778f;
                        if (this.mVideoRotationDegree != 90 && this.mVideoRotationDegree != 270) break;
                        f = 1.0f / f;
                        break;
                    }
                    case 5: {
                        f = 1.3333334f;
                        if (this.mVideoRotationDegree != 90 && this.mVideoRotationDegree != 270) break;
                        f = 1.0f / f;
                        break;
                    }
                    default: {
                        f = (float)this.mVideoWidth / (float)this.mVideoHeight;
                        if (this.mVideoSarNum <= 0 || this.mVideoSarDen <= 0) break;
                        f = f * (float)this.mVideoSarNum / (float)this.mVideoSarDen;
                    }
                }
                boolean bl = f > f2;
                switch (this.mCurrentAspectRatio) {
                    case 0: 
                    case 4: 
                    case 5: {
                        if (bl) {
                            n3 = n6;
                            n4 = (int)((float)n3 / f);
                            break;
                        }
                        n4 = n8;
                        n3 = (int)((float)n4 * f);
                        break;
                    }
                    case 1: {
                        if (bl) {
                            n4 = n8;
                            n3 = (int)((float)n4 * f);
                            break;
                        }
                        n3 = n6;
                        n4 = (int)((float)n3 / f);
                        break;
                    }
                    default: {
                        if (bl) {
                            n3 = Math.min(this.mVideoWidth, n6);
                            n4 = (int)((float)n3 / f);
                            break;
                        }
                        n4 = Math.min(this.mVideoHeight, n8);
                        n3 = (int)((float)n4 * f);
                        break;
                    }
                }
            } else if (n5 == 0x40000000 && n7 == 0x40000000) {
                n4 = n8;
                n3 = n6;
                if (this.mVideoWidth * n4 < n3 * this.mVideoHeight) {
                    n3 = n4 * this.mVideoWidth / this.mVideoHeight;
                } else if (this.mVideoWidth * n4 > n3 * this.mVideoHeight) {
                    n4 = n3 * this.mVideoHeight / this.mVideoWidth;
                }
            } else if (n5 == 0x40000000) {
                n3 = n6;
                n4 = n3 * this.mVideoHeight / this.mVideoWidth;
                if (n7 == Integer.MIN_VALUE && n4 > n8) {
                    n4 = n8;
                }
            } else if (n7 == 0x40000000) {
                n4 = n8;
                n3 = n4 * this.mVideoWidth / this.mVideoHeight;
                if (n5 == Integer.MIN_VALUE && n3 > n6) {
                    n3 = n6;
                }
            } else {
                n3 = this.mVideoWidth;
                n4 = this.mVideoHeight;
                if (n7 == Integer.MIN_VALUE && n4 > n8) {
                    n4 = n8;
                    n3 = n4 * this.mVideoWidth / this.mVideoHeight;
                }
                if (n5 == Integer.MIN_VALUE && n3 > n6) {
                    n3 = n6;
                    n4 = n3 * this.mVideoHeight / this.mVideoWidth;
                }
            }
        }
        this.mMeasuredWidth = n3;
        this.mMeasuredHeight = n4;
    }

    public int getMeasuredWidth() {
        return this.mMeasuredWidth;
    }

    public int getMeasuredHeight() {
        return this.mMeasuredHeight;
    }

    public void setAspectRatio(int n) {
        this.mCurrentAspectRatio = n;
    }

    @NonNull
    public static String getAspectRatioText(Context context, int n) {
        String string;
        switch (n) {
            case 0: {
                string = "Aspect / Fit parent";
                break;
            }
            case 1: {
                string = "Aspect / Fill parent";
                break;
            }
            case 2: {
                string = "Aspect / Wrap conten";
                break;
            }
            case 3: {
                string = "Free / Fill parent";
                break;
            }
            case 4: {
                string = "16:9 / Fit parent";
                break;
            }
            case 5: {
                string = "4:3 / Fit parent";
                break;
            }
            default: {
                string = "NA";
            }
        }
        return string;
    }
}

