/*
 * Decompiled with CFR 0.152.
 */
package com.e4a.runtime.components.impl.android.\u5982\u610f\u53ef\u89c6\u64ad\u653e\u5668\u7c7b\u5e93;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.Resources;
import android.media.AudioManager;
import android.net.Uri;
import android.os.Build;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.Log;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.MediaController;
import com.e4a.runtime.components.impl.android.\u5982\u610f\u53ef\u89c6\u64ad\u653e\u5668\u7c7b\u5e93.IMediaController;
import com.e4a.runtime.components.impl.android.\u5982\u610f\u53ef\u89c6\u64ad\u653e\u5668\u7c7b\u5e93.IRenderView;
import com.e4a.runtime.components.impl.android.\u5982\u610f\u53ef\u89c6\u64ad\u653e\u5668\u7c7b\u5e93.SurfaceRenderView;
import com.e4a.runtime.components.impl.android.\u5982\u610f\u53ef\u89c6\u64ad\u653e\u5668\u7c7b\u5e93.TextureRenderView;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import tv.danmaku.ijk.media.player.AndroidMediaPlayer;
import tv.danmaku.ijk.media.player.IMediaPlayer;
import tv.danmaku.ijk.media.player.IjkMediaPlayer;
import tv.danmaku.ijk.media.player.TextureMediaPlayer;

public class IjkVideoView
extends FrameLayout
implements MediaController.MediaPlayerControl {
    private String TAG = "IjkVideoView";
    private Uri mUri;
    private Map<String, String> mHeaders;
    public static final int STATE_ERROR = -1;
    public static final int STATE_IDLE = 0;
    public static final int STATE_PREPARING = 1;
    public static final int STATE_PREPARED = 2;
    public static final int STATE_PLAYING = 3;
    public static final int STATE_PAUSED = 4;
    public static final int STATE_PLAYBACK_COMPLETED = 5;
    private int mCurrentState = 0;
    private int mTargetState = 0;
    private IRenderView.ISurfaceHolder mSurfaceHolder = null;
    private IMediaPlayer mMediaPlayer = null;
    private int mVideoWidth;
    private int mVideoHeight;
    private int mSurfaceWidth;
    private int mSurfaceHeight;
    private int mVideoRotationDegree;
    private IMediaController mMediaController;
    private IMediaPlayer.OnCompletionListener mOnCompletionListener;
    private IMediaPlayer.OnPreparedListener mOnPreparedListener;
    private int mCurrentBufferPercentage;
    private IMediaPlayer.OnErrorListener mOnErrorListener;
    private IMediaPlayer.OnInfoListener mOnInfoListener;
    private long mSeekWhenPrepared;
    private boolean mCanPause = true;
    private boolean mCanSeekBack;
    private boolean mCanSeekForward;
    private Context mAppContext;
    private IRenderView mRenderView;
    private int mVideoSarNum;
    private int mVideoSarDen;
    private boolean usingAndroidPlayer = false;
    private boolean usingMediaCodec = false;
    private boolean usingMediaCodecAutoRotate = false;
    private boolean usingOpenSLES = false;
    private String pixelFormat = "";
    private boolean enableBackgroundPlay = false;
    private boolean enableSurfaceView = true;
    private boolean enableTextureView = false;
    private boolean enableNoView = false;
    IMediaPlayer.OnVideoSizeChangedListener mSizeChangedListener = new IMediaPlayer.OnVideoSizeChangedListener(){

        public void onVideoSizeChanged(IMediaPlayer iMediaPlayer, int n, int n2, int n3, int n4) {
            IjkVideoView.this.mVideoWidth = iMediaPlayer.getVideoWidth();
            IjkVideoView.this.mVideoHeight = iMediaPlayer.getVideoHeight();
            IjkVideoView.this.mVideoSarNum = iMediaPlayer.getVideoSarNum();
            IjkVideoView.this.mVideoSarDen = iMediaPlayer.getVideoSarDen();
            if (IjkVideoView.this.mVideoWidth != 0 && IjkVideoView.this.mVideoHeight != 0) {
                if (IjkVideoView.this.mRenderView != null) {
                    IjkVideoView.this.mRenderView.setVideoSize(IjkVideoView.this.mVideoWidth, IjkVideoView.this.mVideoHeight);
                    IjkVideoView.this.mRenderView.setVideoSampleAspectRatio(IjkVideoView.this.mVideoSarNum, IjkVideoView.this.mVideoSarDen);
                }
                IjkVideoView.this.requestLayout();
            }
        }
    };
    IMediaPlayer.OnPreparedListener mPreparedListener = new IMediaPlayer.OnPreparedListener(){

        public void onPrepared(IMediaPlayer iMediaPlayer) {
            IjkVideoView.this.mCurrentState = 2;
            if (IjkVideoView.this.mOnPreparedListener != null) {
                IjkVideoView.this.mOnPreparedListener.onPrepared(IjkVideoView.this.mMediaPlayer);
            }
            if (IjkVideoView.this.mMediaController != null) {
                IjkVideoView.this.mMediaController.setEnabled(true);
            }
            IjkVideoView.this.mVideoWidth = iMediaPlayer.getVideoWidth();
            IjkVideoView.this.mVideoHeight = iMediaPlayer.getVideoHeight();
            long l = IjkVideoView.this.mSeekWhenPrepared;
            if (l != 0L) {
                IjkVideoView.this.seekTo((int)l);
            }
            if (IjkVideoView.this.mVideoWidth != 0 && IjkVideoView.this.mVideoHeight != 0) {
                if (IjkVideoView.this.mRenderView != null) {
                    IjkVideoView.this.mRenderView.setVideoSize(IjkVideoView.this.mVideoWidth, IjkVideoView.this.mVideoHeight);
                    IjkVideoView.this.mRenderView.setVideoSampleAspectRatio(IjkVideoView.this.mVideoSarNum, IjkVideoView.this.mVideoSarDen);
                    if (!IjkVideoView.this.mRenderView.shouldWaitForResize() || IjkVideoView.this.mSurfaceWidth == IjkVideoView.this.mVideoWidth && IjkVideoView.this.mSurfaceHeight == IjkVideoView.this.mVideoHeight) {
                        if (IjkVideoView.this.mTargetState == 3) {
                            IjkVideoView.this.start();
                            if (IjkVideoView.this.mMediaController != null) {
                                IjkVideoView.this.mMediaController.show();
                            }
                        } else if (!(IjkVideoView.this.isPlaying() || l == 0L && IjkVideoView.this.getCurrentPosition() <= 0 || IjkVideoView.this.mMediaController == null)) {
                            IjkVideoView.this.mMediaController.show(0);
                        }
                    }
                }
            } else if (IjkVideoView.this.mTargetState == 3) {
                IjkVideoView.this.start();
            }
        }
    };
    private IMediaPlayer.OnCompletionListener mCompletionListener = new IMediaPlayer.OnCompletionListener(){

        public void onCompletion(IMediaPlayer iMediaPlayer) {
            IjkVideoView.this.mCurrentState = 5;
            IjkVideoView.this.mTargetState = 5;
            if (IjkVideoView.this.mMediaController != null) {
                IjkVideoView.this.mMediaController.hide();
            }
            if (IjkVideoView.this.mOnCompletionListener != null) {
                IjkVideoView.this.mOnCompletionListener.onCompletion(IjkVideoView.this.mMediaPlayer);
            }
        }
    };
    private IMediaPlayer.OnInfoListener mInfoListener = new IMediaPlayer.OnInfoListener(){

        public boolean onInfo(IMediaPlayer iMediaPlayer, int n, int n2) {
            if (IjkVideoView.this.mOnInfoListener != null) {
                IjkVideoView.this.mOnInfoListener.onInfo(iMediaPlayer, n, n2);
            }
            switch (n) {
                case 10001: {
                    IjkVideoView.this.mVideoRotationDegree = n2;
                    Log.d((String)IjkVideoView.this.TAG, (String)("MEDIA_INFO_VIDEO_ROTATION_CHANGED: " + n2));
                    if (IjkVideoView.this.mRenderView == null) break;
                    IjkVideoView.this.mRenderView.setVideoRotation(n2);
                }
            }
            return true;
        }
    };
    private IMediaPlayer.OnErrorListener mErrorListener = new IMediaPlayer.OnErrorListener(){

        public boolean onError(IMediaPlayer iMediaPlayer, int n, int n2) {
            Log.d((String)IjkVideoView.this.TAG, (String)("Error: " + n + "," + n2));
            IjkVideoView.this.mCurrentState = -1;
            IjkVideoView.this.mTargetState = -1;
            if (IjkVideoView.this.mMediaController != null) {
                IjkVideoView.this.mMediaController.hide();
            }
            if (IjkVideoView.this.mOnErrorListener != null && IjkVideoView.this.mOnErrorListener.onError(IjkVideoView.this.mMediaPlayer, n, n2)) {
                return true;
            }
            if (IjkVideoView.this.getWindowToken() != null) {
                Resources resources = IjkVideoView.this.mAppContext.getResources();
            }
            return true;
        }
    };
    private IMediaPlayer.OnBufferingUpdateListener mBufferingUpdateListener = new IMediaPlayer.OnBufferingUpdateListener(){

        public void onBufferingUpdate(IMediaPlayer iMediaPlayer, int n) {
            IjkVideoView.this.mCurrentBufferPercentage = n;
        }
    };
    IRenderView.IRenderCallback mSHCallback = new IRenderView.IRenderCallback(){

        @Override
        public void onSurfaceChanged(@NonNull IRenderView.ISurfaceHolder iSurfaceHolder, int n, int n2, int n3) {
            boolean bl;
            if (iSurfaceHolder.getRenderView() != IjkVideoView.this.mRenderView) {
                Log.e((String)IjkVideoView.this.TAG, (String)"onSurfaceChanged: unmatched render callback\n");
                return;
            }
            IjkVideoView.this.mSurfaceWidth = n2;
            IjkVideoView.this.mSurfaceHeight = n3;
            boolean bl2 = IjkVideoView.this.mTargetState == 3;
            boolean bl3 = bl = !IjkVideoView.this.mRenderView.shouldWaitForResize() || IjkVideoView.this.mVideoWidth == n2 && IjkVideoView.this.mVideoHeight == n3;
            if (IjkVideoView.this.mMediaPlayer != null && bl2 && bl) {
                if (IjkVideoView.this.mSeekWhenPrepared != 0L) {
                    IjkVideoView.this.seekTo((int)IjkVideoView.this.mSeekWhenPrepared);
                }
                IjkVideoView.this.start();
            }
        }

        @Override
        public void onSurfaceCreated(@NonNull IRenderView.ISurfaceHolder iSurfaceHolder, int n, int n2) {
            if (iSurfaceHolder.getRenderView() != IjkVideoView.this.mRenderView) {
                Log.e((String)IjkVideoView.this.TAG, (String)"onSurfaceCreated: unmatched render callback\n");
                return;
            }
            IjkVideoView.this.mSurfaceHolder = iSurfaceHolder;
            if (IjkVideoView.this.mMediaPlayer != null) {
                IjkVideoView.this.bindSurfaceHolder(IjkVideoView.this.mMediaPlayer, iSurfaceHolder);
            } else {
                IjkVideoView.this.openVideo();
            }
        }

        @Override
        public void onSurfaceDestroyed(@NonNull IRenderView.ISurfaceHolder iSurfaceHolder) {
            if (iSurfaceHolder.getRenderView() != IjkVideoView.this.mRenderView) {
                Log.e((String)IjkVideoView.this.TAG, (String)"onSurfaceDestroyed: unmatched render callback\n");
                return;
            }
            IjkVideoView.this.mSurfaceHolder = null;
            IjkVideoView.this.releaseWithoutStop();
        }
    };
    private static final int[] s_allAspectRatio = new int[]{0, 1, 2, 3, 4, 5};
    private int mCurrentAspectRatioIndex = 0;
    private int mCurrentAspectRatio = s_allAspectRatio[this.mCurrentAspectRatioIndex];
    public static final int RENDER_NONE = 0;
    public static final int RENDER_SURFACE_VIEW = 1;
    public static final int RENDER_TEXTURE_VIEW = 2;
    private List<Integer> mAllRenders = new ArrayList<Integer>();
    private int mCurrentRenderIndex = 0;
    private int mCurrentRender = 0;

    public int getCurrentState() {
        return this.mCurrentState;
    }

    public IjkVideoView(Context context) {
        super(context);
        this.initVideoView(context);
    }

    public IjkVideoView(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.initVideoView(context);
    }

    public IjkVideoView(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
        this.initVideoView(context);
    }

    @TargetApi(value=21)
    public IjkVideoView(Context context, AttributeSet attributeSet, int n, int n2) {
        super(context, attributeSet, n, n2);
        this.initVideoView(context);
    }

    private void initVideoView(Context context) {
        this.mAppContext = context.getApplicationContext();
        this.initBackground();
        this.initRenders();
        this.mVideoWidth = 0;
        this.mVideoHeight = 0;
        this.setFocusable(true);
        this.setFocusableInTouchMode(true);
        this.requestFocus();
        this.mCurrentState = 0;
        this.mTargetState = 0;
    }

    public void setRenderView(IRenderView iRenderView) {
        View view;
        if (this.mRenderView != null) {
            if (this.mMediaPlayer != null) {
                this.mMediaPlayer.setDisplay(null);
            }
            view = this.mRenderView.getView();
            this.mRenderView.removeRenderCallback(this.mSHCallback);
            this.mRenderView = null;
            this.removeView(view);
        }
        if (iRenderView == null) {
            return;
        }
        this.mRenderView = iRenderView;
        iRenderView.setAspectRatio(this.mCurrentAspectRatio);
        if (this.mVideoWidth > 0 && this.mVideoHeight > 0) {
            iRenderView.setVideoSize(this.mVideoWidth, this.mVideoHeight);
        }
        if (this.mVideoSarNum > 0 && this.mVideoSarDen > 0) {
            iRenderView.setVideoSampleAspectRatio(this.mVideoSarNum, this.mVideoSarDen);
        }
        view = this.mRenderView.getView();
        FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(-2, -2, 17);
        view.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        this.addView(view);
        this.mRenderView.addRenderCallback(this.mSHCallback);
        this.mRenderView.setVideoRotation(this.mVideoRotationDegree);
    }

    public void setRender(int n) {
        switch (n) {
            case 0: {
                this.setRenderView(null);
                break;
            }
            case 2: {
                TextureRenderView textureRenderView = new TextureRenderView(this.getContext());
                if (this.mMediaPlayer != null) {
                    textureRenderView.getSurfaceHolder().bindToMediaPlayer(this.mMediaPlayer);
                    textureRenderView.setVideoSize(this.mMediaPlayer.getVideoWidth(), this.mMediaPlayer.getVideoHeight());
                    textureRenderView.setVideoSampleAspectRatio(this.mMediaPlayer.getVideoSarNum(), this.mMediaPlayer.getVideoSarDen());
                    textureRenderView.setAspectRatio(this.mCurrentAspectRatio);
                }
                this.setRenderView(textureRenderView);
                break;
            }
            case 1: {
                SurfaceRenderView surfaceRenderView = new SurfaceRenderView(this.getContext());
                this.setRenderView(surfaceRenderView);
                break;
            }
            default: {
                Log.e((String)this.TAG, (String)String.format(Locale.getDefault(), "invalid render %d\n", n));
            }
        }
    }

    public void setHeaders(Map<String, String> map) {
        this.mHeaders = map;
    }

    public void setVideoPath(String string) {
        this.setVideoURI(Uri.parse((String)string));
    }

    public void setVideoURI(Uri uri) {
        this.setVideoURI(uri, this.mHeaders);
    }

    private void setVideoURI(Uri uri, Map<String, String> map) {
        this.mUri = uri;
        this.mHeaders = map;
        this.mSeekWhenPrepared = 0L;
        this.openVideo();
        this.requestLayout();
        this.invalidate();
    }

    public void stopPlayback() {
        if (this.mMediaPlayer != null) {
            this.mMediaPlayer.stop();
            this.mMediaPlayer.release();
            this.mMediaPlayer = null;
            this.mCurrentState = 0;
            this.mTargetState = 0;
            AudioManager audioManager = (AudioManager)this.mAppContext.getSystemService("audio");
            audioManager.abandonAudioFocus(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void openVideo() {
        if (this.mUri == null || this.mSurfaceHolder == null) {
            return;
        }
        this.release(false);
        AudioManager audioManager = (AudioManager)this.mAppContext.getSystemService("audio");
        audioManager.requestAudioFocus(null, 3, 1);
        try {
            IjkMediaPlayer ijkMediaPlayer;
            if (this.usingAndroidPlayer) {
                this.mMediaPlayer = new AndroidMediaPlayer();
            } else {
                ijkMediaPlayer = null;
                if (this.mUri != null) {
                    ijkMediaPlayer = new IjkMediaPlayer();
                    IjkMediaPlayer.native_setLogLevel((int)3);
                    if (this.usingMediaCodec) {
                        ijkMediaPlayer.setOption(4, "mediacodec", 1L);
                        if (this.usingMediaCodecAutoRotate) {
                            ijkMediaPlayer.setOption(4, "mediacodec-auto-rotate", 1L);
                        } else {
                            ijkMediaPlayer.setOption(4, "mediacodec-auto-rotate", 0L);
                        }
                    } else {
                        ijkMediaPlayer.setOption(4, "mediacodec", 0L);
                    }
                    if (this.usingOpenSLES) {
                        ijkMediaPlayer.setOption(4, "opensles", 1L);
                    } else {
                        ijkMediaPlayer.setOption(4, "opensles", 0L);
                    }
                    if (TextUtils.isEmpty((CharSequence)this.pixelFormat)) {
                        ijkMediaPlayer.setOption(4, "overlay-format", 842225234L);
                    } else {
                        ijkMediaPlayer.setOption(4, "overlay-format", this.pixelFormat);
                    }
                    ijkMediaPlayer.setOption(4, "framedrop", 1L);
                    ijkMediaPlayer.setOption(4, "start-on-prepared", 0L);
                    ijkMediaPlayer.setOption(1, "http-detect-range-support", 0L);
                    ijkMediaPlayer.setOption(1, "timeout", 10000000L);
                    ijkMediaPlayer.setOption(1, "reconnect", 1L);
                    ijkMediaPlayer.setOption(4, "mediacodec-hevc", 1L);
                    ijkMediaPlayer.setOption(1, "safe", 0L);
                    ijkMediaPlayer.setOption(1, "protocol_whitelist", "async,cache,crypto,file,http,https,ijkhttphook,ijkinject,ijklivehook,ijklongurl,ijksegment,ijktcphook,pipe,rtp,tcp,tls,udp,ijkurlhook,data,concat,subfile,udp");
                    ijkMediaPlayer.setOption(2, "skip_loop_filter", 48L);
                }
                this.mMediaPlayer = ijkMediaPlayer;
            }
            if (this.enableBackgroundPlay) {
                this.mMediaPlayer = new TextureMediaPlayer(this.mMediaPlayer);
            }
            ijkMediaPlayer = this.getContext();
            this.mMediaPlayer.setOnPreparedListener(this.mPreparedListener);
            this.mMediaPlayer.setOnVideoSizeChangedListener(this.mSizeChangedListener);
            this.mMediaPlayer.setOnCompletionListener(this.mCompletionListener);
            this.mMediaPlayer.setOnErrorListener(this.mErrorListener);
            this.mMediaPlayer.setOnInfoListener(this.mInfoListener);
            this.mMediaPlayer.setOnBufferingUpdateListener(this.mBufferingUpdateListener);
            this.mCurrentBufferPercentage = 0;
            if (Build.VERSION.SDK_INT > 14) {
                this.mMediaPlayer.setDataSource(this.mAppContext, this.mUri, this.mHeaders);
            } else {
                this.mMediaPlayer.setDataSource(this.mUri.toString());
            }
            this.bindSurfaceHolder(this.mMediaPlayer, this.mSurfaceHolder);
            this.mMediaPlayer.setAudioStreamType(3);
            this.mMediaPlayer.setScreenOnWhilePlaying(true);
            this.mMediaPlayer.prepareAsync();
            this.mCurrentState = 1;
            this.attachMediaController();
        }
        catch (IOException iOException) {
            Log.w((String)this.TAG, (String)("Unable to open content: " + this.mUri), (Throwable)iOException);
            this.mCurrentState = -1;
            this.mTargetState = -1;
            this.mErrorListener.onError(this.mMediaPlayer, 1, 0);
            return;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Log.w((String)this.TAG, (String)("Unable to open content: " + this.mUri), (Throwable)illegalArgumentException);
            this.mCurrentState = -1;
            this.mTargetState = -1;
            this.mErrorListener.onError(this.mMediaPlayer, 1, 0);
            return;
        }
    }

    public void setMediaController(IMediaController iMediaController) {
        if (this.mMediaController != null) {
            this.mMediaController.hide();
        }
        this.mMediaController = iMediaController;
        this.attachMediaController();
    }

    private void attachMediaController() {
        if (this.mMediaPlayer != null && this.mMediaController != null) {
            this.mMediaController.setMediaPlayer(this);
            IjkVideoView ijkVideoView = this.getParent() instanceof View ? (View)this.getParent() : this;
            this.mMediaController.setAnchorView((View)ijkVideoView);
            this.mMediaController.setEnabled(this.isInPlaybackState());
        }
    }

    public void setOnPreparedListener(IMediaPlayer.OnPreparedListener onPreparedListener) {
        this.mOnPreparedListener = onPreparedListener;
    }

    public void setOnCompletionListener(IMediaPlayer.OnCompletionListener onCompletionListener) {
        this.mOnCompletionListener = onCompletionListener;
    }

    public void setOnErrorListener(IMediaPlayer.OnErrorListener onErrorListener) {
        this.mOnErrorListener = onErrorListener;
    }

    public void setOnInfoListener(IMediaPlayer.OnInfoListener onInfoListener) {
        this.mOnInfoListener = onInfoListener;
    }

    private void bindSurfaceHolder(IMediaPlayer iMediaPlayer, IRenderView.ISurfaceHolder iSurfaceHolder) {
        if (iMediaPlayer == null) {
            return;
        }
        if (iSurfaceHolder == null) {
            iMediaPlayer.setDisplay(null);
            return;
        }
        iSurfaceHolder.bindToMediaPlayer(iMediaPlayer);
    }

    public void releaseWithoutStop() {
        if (this.mMediaPlayer != null) {
            this.mMediaPlayer.setDisplay(null);
        }
    }

    public void release(boolean bl) {
        if (this.mMediaPlayer != null) {
            this.mMediaPlayer.reset();
            this.mMediaPlayer.release();
            this.mMediaPlayer = null;
            this.mCurrentState = 0;
            if (bl) {
                this.mTargetState = 0;
            }
            AudioManager audioManager = (AudioManager)this.mAppContext.getSystemService("audio");
            audioManager.abandonAudioFocus(null);
        }
    }

    public boolean onTouchEvent(MotionEvent motionEvent) {
        if (this.isInPlaybackState() && this.mMediaController != null) {
            this.toggleMediaControlsVisiblity();
        }
        return false;
    }

    public boolean onTrackballEvent(MotionEvent motionEvent) {
        if (this.isInPlaybackState() && this.mMediaController != null) {
            this.toggleMediaControlsVisiblity();
        }
        return false;
    }

    public boolean onKeyDown(int n, KeyEvent keyEvent) {
        boolean bl;
        boolean bl2 = bl = n != 4 && n != 24 && n != 25 && n != 164 && n != 82 && n != 5 && n != 6;
        if (this.isInPlaybackState() && bl && this.mMediaController != null) {
            if (n == 79 || n == 85) {
                if (this.mMediaPlayer.isPlaying()) {
                    this.pause();
                    this.mMediaController.show();
                } else {
                    this.start();
                    this.mMediaController.hide();
                }
                return true;
            }
            if (n == 126) {
                if (!this.mMediaPlayer.isPlaying()) {
                    this.start();
                    this.mMediaController.hide();
                }
                return true;
            }
            if (n == 86 || n == 127) {
                if (this.mMediaPlayer.isPlaying()) {
                    this.pause();
                    this.mMediaController.show();
                }
                return true;
            }
            this.toggleMediaControlsVisiblity();
        }
        return super.onKeyDown(n, keyEvent);
    }

    private void toggleMediaControlsVisiblity() {
        if (this.mMediaController.isShowing()) {
            this.mMediaController.hide();
        } else {
            this.mMediaController.show();
        }
    }

    public void start() {
        if (this.isInPlaybackState()) {
            this.mMediaPlayer.start();
            this.mCurrentState = 3;
        }
        this.mTargetState = 3;
    }

    public void pause() {
        if (this.isInPlaybackState() && this.mMediaPlayer.isPlaying()) {
            this.mMediaPlayer.pause();
            this.mCurrentState = 4;
        }
        this.mTargetState = 4;
    }

    public void suspend() {
        this.release(false);
    }

    public void resume() {
        this.openVideo();
    }

    public int getDuration() {
        if (this.isInPlaybackState()) {
            return (int)this.mMediaPlayer.getDuration();
        }
        return -1;
    }

    public int getCurrentPosition() {
        if (this.isInPlaybackState()) {
            return (int)this.mMediaPlayer.getCurrentPosition();
        }
        return 0;
    }

    public void seekTo(int n) {
        if (this.isInPlaybackState()) {
            this.mMediaPlayer.seekTo((long)n);
            this.mSeekWhenPrepared = 0L;
        } else {
            this.mSeekWhenPrepared = n;
        }
    }

    public boolean isPlaying() {
        return this.isInPlaybackState() && this.mMediaPlayer.isPlaying();
    }

    public int getBufferPercentage() {
        if (this.mMediaPlayer != null) {
            return this.mCurrentBufferPercentage;
        }
        return 0;
    }

    private boolean isInPlaybackState() {
        return this.mMediaPlayer != null && this.mCurrentState != -1 && this.mCurrentState != 0 && this.mCurrentState != 1;
    }

    public boolean canPause() {
        return this.mCanPause;
    }

    public boolean canSeekBackward() {
        return this.mCanSeekBack;
    }

    public boolean canSeekForward() {
        return this.mCanSeekForward;
    }

    public int getAudioSessionId() {
        return 0;
    }

    public int toggleAspectRatio() {
        ++this.mCurrentAspectRatioIndex;
        this.mCurrentAspectRatioIndex %= s_allAspectRatio.length;
        this.mCurrentAspectRatio = s_allAspectRatio[this.mCurrentAspectRatioIndex];
        if (this.mRenderView != null) {
            this.mRenderView.setAspectRatio(this.mCurrentAspectRatio);
        }
        return this.mCurrentAspectRatio;
    }

    public int toggleAspectRatio(int n) {
        this.mCurrentAspectRatio = s_allAspectRatio[n %= s_allAspectRatio.length];
        if (this.mRenderView != null) {
            this.mRenderView.setAspectRatio(this.mCurrentAspectRatio);
        }
        return this.mCurrentAspectRatio;
    }

    private void initRenders() {
        this.mAllRenders.clear();
        if (this.enableSurfaceView) {
            this.mAllRenders.add(1);
        }
        if (this.enableTextureView && Build.VERSION.SDK_INT >= 14) {
            this.mAllRenders.add(2);
        }
        if (this.enableNoView) {
            this.mAllRenders.add(0);
        }
        if (this.mAllRenders.isEmpty()) {
            this.mAllRenders.add(1);
        }
        this.mCurrentRender = this.mAllRenders.get(this.mCurrentRenderIndex);
        this.setRender(this.mCurrentRender);
    }

    public int toggleRender() {
        ++this.mCurrentRenderIndex;
        this.mCurrentRenderIndex %= this.mAllRenders.size();
        this.mCurrentRender = this.mAllRenders.get(this.mCurrentRenderIndex);
        this.setRender(this.mCurrentRender);
        return this.mCurrentRender;
    }

    private void initBackground() {
        if (this.enableBackgroundPlay) {
            // empty if block
        }
    }

    public void setAspectRatio(int n) {
        for (int i = 0; i < s_allAspectRatio.length; ++i) {
            if (s_allAspectRatio[i] != n) continue;
            this.mCurrentAspectRatioIndex = i;
            if (this.mRenderView == null) break;
            this.mRenderView.setAspectRatio(this.mCurrentAspectRatio);
            break;
        }
    }
}

