/*
 * Decompiled with CFR 0.152.
 */
package com.e4a.runtime.components.impl.android.\u65b0\u5fae\u4fe1\u652f\u4ed8\u7c7b\u5e93;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.util.Log;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import junit.framework.Assert;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolVersion;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.scheme.PlainSocketFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.tsccm.ThreadSafeClientConnManager;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpParams;
import org.apache.http.params.HttpProtocolParams;
import org.apache.http.util.EntityUtils;

public class Util {
    private static final String TAG = "SDK_Sample.Util";
    private static final int MAX_DECODE_PICTURE_SIZE = 2764800;

    public static byte[] bmpToByteArray(Bitmap bitmap, boolean bl) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        bitmap.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)byteArrayOutputStream);
        if (bl) {
            bitmap.recycle();
        }
        byte[] byArray = byteArrayOutputStream.toByteArray();
        try {
            byteArrayOutputStream.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return byArray;
    }

    public static byte[] httpGet(String string) {
        if (string == null || string.length() == 0) {
            Log.e((String)TAG, (String)"httpGet, url is null");
            return null;
        }
        HttpClient httpClient = Util.getNewHttpClient();
        HttpGet httpGet = new HttpGet(string);
        try {
            HttpResponse httpResponse = httpClient.execute((HttpUriRequest)httpGet);
            if (httpResponse.getStatusLine().getStatusCode() != 200) {
                Log.e((String)TAG, (String)("httpGet fail, status code = " + httpResponse.getStatusLine().getStatusCode()));
                return null;
            }
            return EntityUtils.toByteArray((HttpEntity)httpResponse.getEntity());
        }
        catch (Exception exception) {
            Log.e((String)TAG, (String)("httpGet exception, e = " + exception.getMessage()));
            exception.printStackTrace();
            return null;
        }
    }

    public static byte[] httpPost(String string, String string2) {
        if (string == null || string.length() == 0) {
            Log.e((String)TAG, (String)"httpPost, url is null");
            return null;
        }
        HttpClient httpClient = Util.getNewHttpClient();
        HttpPost httpPost = new HttpPost(string);
        try {
            httpPost.setEntity((HttpEntity)new StringEntity(string2));
            httpPost.setHeader("Accept", "application/json");
            httpPost.setHeader("Content-type", "application/json");
            HttpResponse httpResponse = httpClient.execute((HttpUriRequest)httpPost);
            if (httpResponse.getStatusLine().getStatusCode() != 200) {
                Log.e((String)TAG, (String)("httpGet fail, status code = " + httpResponse.getStatusLine().getStatusCode()));
                return null;
            }
            return EntityUtils.toByteArray((HttpEntity)httpResponse.getEntity());
        }
        catch (Exception exception) {
            Log.e((String)TAG, (String)("httpPost exception, e = " + exception.getMessage()));
            exception.printStackTrace();
            return null;
        }
    }

    private static HttpClient getNewHttpClient() {
        try {
            KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            keyStore.load(null, null);
            SSLSocketFactoryEx sSLSocketFactoryEx = new SSLSocketFactoryEx(keyStore);
            sSLSocketFactoryEx.setHostnameVerifier(SSLSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER);
            BasicHttpParams basicHttpParams = new BasicHttpParams();
            HttpProtocolParams.setVersion((HttpParams)basicHttpParams, (ProtocolVersion)HttpVersion.HTTP_1_1);
            HttpProtocolParams.setContentCharset((HttpParams)basicHttpParams, (String)"UTF-8");
            SchemeRegistry schemeRegistry = new SchemeRegistry();
            schemeRegistry.register(new Scheme("http", (SocketFactory)PlainSocketFactory.getSocketFactory(), 80));
            schemeRegistry.register(new Scheme("https", (SocketFactory)sSLSocketFactoryEx, 443));
            ThreadSafeClientConnManager threadSafeClientConnManager = new ThreadSafeClientConnManager((HttpParams)basicHttpParams, schemeRegistry);
            return new DefaultHttpClient((ClientConnectionManager)threadSafeClientConnManager, (HttpParams)basicHttpParams);
        }
        catch (Exception exception) {
            return new DefaultHttpClient();
        }
    }

    public static byte[] readFromFile(String string, int n, int n2) {
        if (string == null) {
            return null;
        }
        File file = new File(string);
        if (!file.exists()) {
            Log.i((String)TAG, (String)"readFromFile: file not found");
            return null;
        }
        if (n2 == -1) {
            n2 = (int)file.length();
        }
        Log.d((String)TAG, (String)("readFromFile : offset = " + n + " len = " + n2 + " offset + len = " + (n + n2)));
        if (n < 0) {
            Log.e((String)TAG, (String)("readFromFile invalid offset:" + n));
            return null;
        }
        if (n2 <= 0) {
            Log.e((String)TAG, (String)("readFromFile invalid len:" + n2));
            return null;
        }
        if (n + n2 > (int)file.length()) {
            Log.e((String)TAG, (String)("readFromFile invalid file len:" + file.length()));
            return null;
        }
        byte[] byArray = null;
        try {
            RandomAccessFile randomAccessFile = new RandomAccessFile(string, "r");
            byArray = new byte[n2];
            randomAccessFile.seek(n);
            randomAccessFile.readFully(byArray);
            randomAccessFile.close();
        }
        catch (Exception exception) {
            Log.e((String)TAG, (String)("readFromFile : errMsg = " + exception.getMessage()));
            exception.printStackTrace();
        }
        return byArray;
    }

    public static Bitmap extractThumbNail(String string, int n, int n2, boolean bl) {
        Assert.assertTrue((string != null && !string.equals("") && n > 0 && n2 > 0 ? 1 : 0) != 0);
        BitmapFactory.Options options = new BitmapFactory.Options();
        try {
            options.inJustDecodeBounds = true;
            Bitmap bitmap = BitmapFactory.decodeFile((String)string, (BitmapFactory.Options)options);
            if (bitmap != null) {
                bitmap.recycle();
                bitmap = null;
            }
            Log.d((String)TAG, (String)("extractThumbNail: round=" + n2 + "x" + n + ", crop=" + bl));
            double d = (double)options.outHeight * 1.0 / (double)n;
            double d2 = (double)options.outWidth * 1.0 / (double)n2;
            Log.d((String)TAG, (String)("extractThumbNail: extract beX = " + d2 + ", beY = " + d));
            options.inSampleSize = (int)(bl ? (d > d2 ? d2 : d) : (d < d2 ? d2 : d));
            if (options.inSampleSize <= 1) {
                options.inSampleSize = 1;
            }
            while (options.outHeight * options.outWidth / options.inSampleSize > 2764800) {
                ++options.inSampleSize;
            }
            int n3 = n;
            int n4 = n2;
            if (bl) {
                if (d > d2) {
                    n3 = (int)((double)n4 * 1.0 * (double)options.outHeight / (double)options.outWidth);
                } else {
                    n4 = (int)((double)n3 * 1.0 * (double)options.outWidth / (double)options.outHeight);
                }
            } else if (d < d2) {
                n3 = (int)((double)n4 * 1.0 * (double)options.outHeight / (double)options.outWidth);
            } else {
                n4 = (int)((double)n3 * 1.0 * (double)options.outWidth / (double)options.outHeight);
            }
            options.inJustDecodeBounds = false;
            Log.i((String)TAG, (String)("bitmap required size=" + n4 + "x" + n3 + ", orig=" + options.outWidth + "x" + options.outHeight + ", sample=" + options.inSampleSize));
            Bitmap bitmap2 = BitmapFactory.decodeFile((String)string, (BitmapFactory.Options)options);
            if (bitmap2 == null) {
                Log.e((String)TAG, (String)"bitmap decode failed");
                return null;
            }
            Log.i((String)TAG, (String)("bitmap decoded size=" + bitmap2.getWidth() + "x" + bitmap2.getHeight()));
            Bitmap bitmap3 = Bitmap.createScaledBitmap((Bitmap)bitmap2, (int)n4, (int)n3, (boolean)true);
            if (bitmap3 != null) {
                bitmap2.recycle();
                bitmap2 = bitmap3;
            }
            if (bl) {
                Bitmap bitmap4 = Bitmap.createBitmap((Bitmap)bitmap2, (int)(bitmap2.getWidth() - n2 >> 1), (int)(bitmap2.getHeight() - n >> 1), (int)n2, (int)n);
                if (bitmap4 == null) {
                    return bitmap2;
                }
                bitmap2.recycle();
                bitmap2 = bitmap4;
                Log.i((String)TAG, (String)("bitmap croped size=" + bitmap2.getWidth() + "x" + bitmap2.getHeight()));
            }
            return bitmap2;
        }
        catch (OutOfMemoryError outOfMemoryError) {
            Log.e((String)TAG, (String)("decode bitmap failed: " + outOfMemoryError.getMessage()));
            options = null;
            return null;
        }
    }

    public static String sha1(String string) {
        if (string == null || string.length() == 0) {
            return null;
        }
        char[] cArray = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA1");
            messageDigest.update(string.getBytes());
            byte[] byArray = messageDigest.digest();
            int n = byArray.length;
            char[] cArray2 = new char[n * 2];
            int n2 = 0;
            for (int i = 0; i < n; ++i) {
                byte by = byArray[i];
                cArray2[n2++] = cArray[by >>> 4 & 0xF];
                cArray2[n2++] = cArray[by & 0xF];
            }
            return new String(cArray2);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static List<String> stringsToList(String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            arrayList.add(stringArray[i]);
        }
        return arrayList;
    }

    private static class SSLSocketFactoryEx
    extends SSLSocketFactory {
        SSLContext sslContext = SSLContext.getInstance("TLS");

        public SSLSocketFactoryEx(KeyStore keyStore) throws NoSuchAlgorithmException, KeyManagementException, KeyStoreException, UnrecoverableKeyException {
            super(keyStore);
            X509TrustManager x509TrustManager = new X509TrustManager(){

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }

                @Override
                public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
                }
            };
            this.sslContext.init(null, new TrustManager[]{x509TrustManager}, null);
        }

        public Socket createSocket(Socket socket, String string, int n, boolean bl) throws IOException, UnknownHostException {
            return this.sslContext.getSocketFactory().createSocket(socket, string, n, bl);
        }

        public Socket createSocket() throws IOException {
            return this.sslContext.getSocketFactory().createSocket();
        }
    }
}

