/*
 * Decompiled with CFR 0.152.
 */
package com.e4a.runtime.components.impl.android.BLE\u84dd\u7259\u7c7b\u5e93;

import android.annotation.SuppressLint;
import android.app.Service;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothGatt;
import android.bluetooth.BluetoothGattCallback;
import android.bluetooth.BluetoothGattCharacteristic;
import android.bluetooth.BluetoothGattDescriptor;
import android.bluetooth.BluetoothGattService;
import android.bluetooth.BluetoothManager;
import android.content.Context;
import android.content.Intent;
import android.os.Binder;
import android.os.Build;
import android.os.Handler;
import android.os.IBinder;
import java.util.List;
import java.util.UUID;

@SuppressLint(value={"NewApi"})
public class BluetoothLeService
extends Service {
    private Handler handler = new Handler();
    private BluetoothManager mBluetoothManager;
    private BluetoothAdapter mBluetoothAdapter;
    private String mBluetoothDeviceAddress;
    private BluetoothGatt mBluetoothGatt;
    private int mConnectionState = 0;
    private static final int STATE_DISCONNECTED = 0;
    private static final int STATE_CONNECTING = 1;
    private static final int STATE_CONNECTED = 2;
    public static final String ACTION_GATT_CONNECTED = "com.example.bluetooth.le.ACTION_GATT_CONNECTED";
    public static final String ACTION_GATT_DISCONNECTED = "com.example.bluetooth.le.ACTION_GATT_DISCONNECTED";
    public static final String ACTION_GATT_SERVICES_DISCOVERED = "com.example.bluetooth.le.ACTION_GATT_SERVICES_DISCOVERED";
    public static final String ACTION_DATA_READ = "com.example.bluetooth.le.ACTION_DATA_READ";
    public static final String ACTION_DATA_WRITE = "com.example.bluetooth.le.ACTION_DATA_WRITE";
    public static final String ACTION_DATA_CHANGED = "com.example.bluetooth.le.ACTION_DATA_CHANGED";
    public static final String EXTRA_DATA = "com.example.bluetooth.le.EXTRA_DATA";
    public static final String EXTRA_DATA2 = "com.example.bluetooth.le.EXTRA_DATA2";
    public static final String SERVICE_UUID = "com.example.bluetooth.le.SERVICE_UUID";
    public static final String CHARA_UUID = "com.example.bluetooth.le.CHARA_UUID";
    private final BluetoothGattCallback mGattCallback = new BluetoothGattCallback(){

        public void onConnectionStateChange(BluetoothGatt bluetoothGatt, int n, int n2) {
            if (n2 == 2) {
                String string = BluetoothLeService.ACTION_GATT_CONNECTED;
                BluetoothLeService.this.mConnectionState = 2;
                BluetoothLeService.this.broadcastUpdate(string);
                BluetoothLeService.this.mBluetoothGatt.discoverServices();
            } else if (n2 == 0) {
                String string = BluetoothLeService.ACTION_GATT_DISCONNECTED;
                BluetoothLeService.this.mConnectionState = 0;
                BluetoothLeService.this.broadcastUpdate(string);
            }
        }

        public void onServicesDiscovered(BluetoothGatt bluetoothGatt, int n) {
            if (n == 0) {
                BluetoothLeService.this.broadcastUpdate(BluetoothLeService.ACTION_GATT_SERVICES_DISCOVERED);
            }
        }

        public void onCharacteristicRead(BluetoothGatt bluetoothGatt, BluetoothGattCharacteristic bluetoothGattCharacteristic, int n) {
            if (n == 0) {
                BluetoothLeService.this.broadcastUpdate(BluetoothLeService.ACTION_DATA_READ, bluetoothGattCharacteristic, 1);
            } else {
                BluetoothLeService.this.broadcastUpdate(BluetoothLeService.ACTION_DATA_READ, bluetoothGattCharacteristic, 2);
            }
        }

        public void onCharacteristicChanged(BluetoothGatt bluetoothGatt, BluetoothGattCharacteristic bluetoothGattCharacteristic) {
            BluetoothLeService.this.broadcastUpdate(BluetoothLeService.ACTION_DATA_CHANGED, bluetoothGattCharacteristic);
        }

        public void onCharacteristicWrite(BluetoothGatt bluetoothGatt, BluetoothGattCharacteristic bluetoothGattCharacteristic, int n) {
            if (n == 0) {
                BluetoothLeService.this.broadcastUpdate(BluetoothLeService.ACTION_DATA_WRITE, 1);
            } else {
                BluetoothLeService.this.broadcastUpdate(BluetoothLeService.ACTION_DATA_WRITE, 2);
            }
        }
    };
    private final IBinder mBinder = new LocalBinder();

    private void broadcastUpdate(String string) {
        Intent intent = new Intent(string);
        this.sendBroadcast(intent);
    }

    private void broadcastUpdate(String string, int n) {
        Intent intent = new Intent(string);
        intent.putExtra(EXTRA_DATA, n);
        this.sendBroadcast(intent);
    }

    private void broadcastUpdate(String string, BluetoothGattCharacteristic bluetoothGattCharacteristic) {
        Intent intent = new Intent(string);
        byte[] byArray = bluetoothGattCharacteristic.getValue();
        intent.putExtra(EXTRA_DATA, byArray);
        BluetoothGattService bluetoothGattService = bluetoothGattCharacteristic.getService();
        intent.putExtra(SERVICE_UUID, bluetoothGattService.getUuid().toString());
        intent.putExtra(CHARA_UUID, bluetoothGattCharacteristic.getUuid().toString());
        this.sendBroadcast(intent);
    }

    private void broadcastUpdate(String string, BluetoothGattCharacteristic bluetoothGattCharacteristic, int n) {
        Intent intent = new Intent(string);
        byte[] byArray = bluetoothGattCharacteristic.getValue();
        intent.putExtra(EXTRA_DATA, byArray);
        intent.putExtra(EXTRA_DATA2, n);
        BluetoothGattService bluetoothGattService = bluetoothGattCharacteristic.getService();
        intent.putExtra(SERVICE_UUID, bluetoothGattService.getUuid().toString());
        intent.putExtra(CHARA_UUID, bluetoothGattCharacteristic.getUuid().toString());
        this.sendBroadcast(intent);
    }

    public IBinder onBind(Intent intent) {
        return this.mBinder;
    }

    public boolean onUnbind(Intent intent) {
        this.close();
        return super.onUnbind(intent);
    }

    public boolean initialize() {
        if (this.mBluetoothManager == null) {
            this.mBluetoothManager = (BluetoothManager)this.getSystemService("bluetooth");
            if (this.mBluetoothManager == null) {
                return false;
            }
        }
        this.mBluetoothAdapter = this.mBluetoothManager.getAdapter();
        return this.mBluetoothAdapter != null;
    }

    public boolean connect(String string) {
        if (this.mBluetoothAdapter == null || string == null) {
            return false;
        }
        if (this.mBluetoothDeviceAddress != null && string.equals(this.mBluetoothDeviceAddress) && this.mBluetoothGatt != null) {
            if (this.mBluetoothGatt.connect()) {
                this.mConnectionState = 1;
                return true;
            }
            return false;
        }
        BluetoothDevice bluetoothDevice = this.mBluetoothAdapter.getRemoteDevice(string);
        if (bluetoothDevice == null) {
            return false;
        }
        this.mBluetoothGatt = Build.VERSION.SDK_INT >= 23 ? bluetoothDevice.connectGatt((Context)this, false, this.mGattCallback, 2) : bluetoothDevice.connectGatt((Context)this, false, this.mGattCallback);
        this.mBluetoothDeviceAddress = string;
        this.mConnectionState = 1;
        return true;
    }

    public void disconnect() {
        if (this.mBluetoothAdapter == null || this.mBluetoothGatt == null) {
            return;
        }
        this.mBluetoothGatt.disconnect();
    }

    public void close() {
        if (this.mBluetoothGatt == null) {
            return;
        }
        this.mBluetoothGatt.close();
        this.mBluetoothGatt = null;
    }

    public boolean getProperties(String string, String string2, int n) {
        if (this.mBluetoothAdapter == null || this.mBluetoothGatt == null) {
            return false;
        }
        BluetoothGattService bluetoothGattService = this.mBluetoothGatt.getService(UUID.fromString(string));
        BluetoothGattCharacteristic bluetoothGattCharacteristic = bluetoothGattService.getCharacteristic(UUID.fromString(string2));
        if (n == 1) {
            return 0 != (bluetoothGattCharacteristic.getProperties() & 2);
        }
        if (n == 2) {
            return 0 != (bluetoothGattCharacteristic.getProperties() & 8);
        }
        return 0 != (bluetoothGattCharacteristic.getProperties() & 0x10);
    }

    public void readCharacteristic(String string, String string2) {
        if (this.mBluetoothAdapter == null || this.mBluetoothGatt == null) {
            return;
        }
        BluetoothGattService bluetoothGattService = this.mBluetoothGatt.getService(UUID.fromString(string));
        BluetoothGattCharacteristic bluetoothGattCharacteristic = bluetoothGattService.getCharacteristic(UUID.fromString(string2));
        this.mBluetoothGatt.readCharacteristic(bluetoothGattCharacteristic);
    }

    public void writeCharacteristic(String string, String string2, byte[] byArray) {
        if (this.mBluetoothAdapter == null || this.mBluetoothGatt == null) {
            return;
        }
        BluetoothGattService bluetoothGattService = this.mBluetoothGatt.getService(UUID.fromString(string));
        BluetoothGattCharacteristic bluetoothGattCharacteristic = bluetoothGattService.getCharacteristic(UUID.fromString(string2));
        bluetoothGattCharacteristic.setValue(byArray);
        this.mBluetoothGatt.writeCharacteristic(bluetoothGattCharacteristic);
    }

    public void setCharacteristicNotification(String string, String string2, boolean bl) {
        if (this.mBluetoothAdapter == null || this.mBluetoothGatt == null) {
            return;
        }
        BluetoothGattService bluetoothGattService = this.mBluetoothGatt.getService(UUID.fromString(string));
        BluetoothGattCharacteristic bluetoothGattCharacteristic = bluetoothGattService.getCharacteristic(UUID.fromString(string2));
        this.mBluetoothGatt.setCharacteristicNotification(bluetoothGattCharacteristic, bl);
        List list = bluetoothGattCharacteristic.getDescriptors();
        for (BluetoothGattDescriptor bluetoothGattDescriptor : list) {
            bluetoothGattDescriptor.setValue(BluetoothGattDescriptor.ENABLE_NOTIFICATION_VALUE);
            this.mBluetoothGatt.writeDescriptor(bluetoothGattDescriptor);
        }
    }

    public void setCharacteristicNotification2(BluetoothGattCharacteristic bluetoothGattCharacteristic, boolean bl) {
        if (this.mBluetoothAdapter == null || this.mBluetoothGatt == null) {
            return;
        }
        this.mBluetoothGatt.setCharacteristicNotification(bluetoothGattCharacteristic, bl);
        List list = bluetoothGattCharacteristic.getDescriptors();
        for (BluetoothGattDescriptor bluetoothGattDescriptor : list) {
            bluetoothGattDescriptor.setValue(BluetoothGattDescriptor.ENABLE_NOTIFICATION_VALUE);
            this.mBluetoothGatt.writeDescriptor(bluetoothGattDescriptor);
        }
    }

    public List<BluetoothGattService> getSupportedGattServices() {
        if (this.mBluetoothGatt == null) {
            return null;
        }
        return this.mBluetoothGatt.getServices();
    }

    public class LocalBinder
    extends Binder {
        BluetoothLeService getService() {
            return BluetoothLeService.this;
        }
    }
}

