/*
 * Decompiled with CFR 0.152.
 */
package com.e4a.runtime.components.impl.android.BLE\u84dd\u7259\u7c7b\u5e93;

import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothGattCharacteristic;
import android.bluetooth.BluetoothGattService;
import android.bluetooth.BluetoothManager;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.ServiceConnection;
import android.os.Build;
import android.os.IBinder;
import com.e4a.runtime.android.mainActivity;
import com.e4a.runtime.collections.\u96c6\u5408;
import com.e4a.runtime.components.ComponentContainer;
import com.e4a.runtime.components.impl.ComponentImpl;
import com.e4a.runtime.components.impl.android.BLE\u84dd\u7259\u7c7b\u5e93.BLE\u84dd\u7259;
import com.e4a.runtime.components.impl.android.BLE\u84dd\u7259\u7c7b\u5e93.BluetoothLeService;
import com.e4a.runtime.events.EventDispatcher;
import com.e4a.runtime.variants.ArrayVariant;
import com.e4a.runtime.variants.Variant;
import com.e4a.runtime.\u6587\u672c\u64cd\u4f5c;
import java.util.ArrayList;
import java.util.List;

public class BLE\u84dd\u7259Impl
extends ComponentImpl
implements BLE\u84dd\u7259 {
    private BluetoothAdapter mBluetoothAdapter;
    private boolean mScanning;
    private ArrayList<BluetoothDevice> mLeDevices;
    private BluetoothLeService mBluetoothLeService;
    private boolean mConnected = false;
    private BluetoothGattCharacteristic mNotifyCharacteristic;
    private final ServiceConnection mServiceConnection = new ServiceConnection(){

        public void onServiceConnected(ComponentName componentName, IBinder iBinder) {
            BLE\u84dd\u7259Impl.this.mBluetoothLeService = ((BluetoothLeService.LocalBinder)iBinder).getService();
            BLE\u84dd\u7259Impl.this.mBluetoothLeService.initialize();
        }

        public void onServiceDisconnected(ComponentName componentName) {
            BLE\u84dd\u7259Impl.this.mBluetoothLeService = null;
        }
    };
    private final BroadcastReceiver mGattUpdateReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            String string = intent.getAction();
            if ("com.example.bluetooth.le.ACTION_GATT_CONNECTED".equals(string)) {
                BLE\u84dd\u7259Impl.this.mConnected = true;
                BLE\u84dd\u7259Impl.this.\u8fde\u63a5\u72b6\u6001\u6539\u53d8(1);
            } else if ("com.example.bluetooth.le.ACTION_GATT_DISCONNECTED".equals(string)) {
                BLE\u84dd\u7259Impl.this.mConnected = false;
                BLE\u84dd\u7259Impl.this.\u8fde\u63a5\u72b6\u6001\u6539\u53d8(2);
            } else if ("com.example.bluetooth.le.ACTION_GATT_SERVICES_DISCOVERED".equals(string)) {
                BLE\u84dd\u7259Impl.this.displayGattServices(BLE\u84dd\u7259Impl.this.mBluetoothLeService.getSupportedGattServices());
            } else if ("com.example.bluetooth.le.ACTION_DATA_READ".equals(string)) {
                String string2 = intent.getStringExtra("com.example.bluetooth.le.SERVICE_UUID");
                String string3 = intent.getStringExtra("com.example.bluetooth.le.CHARA_UUID");
                byte[] byArray = intent.getByteArrayExtra("com.example.bluetooth.le.EXTRA_DATA");
                int n = intent.getIntExtra("com.example.bluetooth.le.EXTRA_DATA2", 2);
                BLE\u84dd\u7259Impl.this.\u8bfb\u53d6\u6570\u636e\u5b8c\u6bd5(n, string2, string3, byArray);
            } else if ("com.example.bluetooth.le.ACTION_DATA_CHANGED".equals(string)) {
                String string4 = intent.getStringExtra("com.example.bluetooth.le.SERVICE_UUID");
                String string5 = intent.getStringExtra("com.example.bluetooth.le.CHARA_UUID");
                byte[] byArray = intent.getByteArrayExtra("com.example.bluetooth.le.EXTRA_DATA");
                BLE\u84dd\u7259Impl.this.\u901a\u9053\u6570\u636e\u6539\u53d8(string4, string5, byArray);
            } else if ("com.example.bluetooth.le.ACTION_DATA_WRITE".equals(string)) {
                int n = intent.getIntExtra("com.example.bluetooth.le.EXTRA_DATA", 2);
                BLE\u84dd\u7259Impl.this.\u5199\u5165\u6570\u636e\u5b8c\u6bd5(n);
            }
        }
    };
    private BluetoothAdapter.LeScanCallback mLeScanCallback = new BluetoothAdapter.LeScanCallback(){

        public void onLeScan(final BluetoothDevice bluetoothDevice, final int n, byte[] byArray) {
            final byte[] byArray2 = byArray;
            mainActivity.getContext().runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    int n4 = byArray2[25] * 256 + byArray2[26];
                    int n2 = byArray2[27] * 256 + byArray2[28];
                    if (!BLE\u84dd\u7259Impl.this.mLeDevices.contains(bluetoothDevice)) {
                        BLE\u84dd\u7259Impl.this.mLeDevices.add(bluetoothDevice);
                        int n3 = 1;
                        switch (bluetoothDevice.getBondState()) {
                            case 10: {
                                n3 = 1;
                                break;
                            }
                            case 11: {
                                n3 = 2;
                                break;
                            }
                            case 12: {
                                n3 = 3;
                            }
                        }
                        BLE\u84dd\u7259Impl.this.\u53d1\u73b0\u8bbe\u5907("" + bluetoothDevice.getName(), "" + bluetoothDevice.getAddress(), n4, n2, n3);
                    } else {
                        BLE\u84dd\u7259Impl.this.\u4fe1\u53f7\u5f3a\u5ea6\u6539\u53d8("" + bluetoothDevice.getName(), "" + bluetoothDevice.getAddress(), n);
                    }
                }
            });
        }
    };

    public BLE\u84dd\u7259Impl(ComponentContainer componentContainer) {
        super(componentContainer);
    }

    private static IntentFilter makeGattUpdateIntentFilter() {
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction("com.example.bluetooth.le.ACTION_GATT_CONNECTED");
        intentFilter.addAction("com.example.bluetooth.le.ACTION_GATT_DISCONNECTED");
        intentFilter.addAction("com.example.bluetooth.le.ACTION_GATT_SERVICES_DISCOVERED");
        intentFilter.addAction("com.example.bluetooth.le.ACTION_DATA_READ");
        intentFilter.addAction("com.example.bluetooth.le.ACTION_DATA_CHANGED");
        intentFilter.addAction("com.example.bluetooth.le.ACTION_DATA_WRITE");
        return intentFilter;
    }

    @Override
    public boolean \u521d\u59cb\u5316() {
        if (Build.VERSION.SDK_INT < 18) {
            return false;
        }
        if (!mainActivity.getContext().getPackageManager().hasSystemFeature("android.hardware.bluetooth_le")) {
            return false;
        }
        BluetoothManager bluetoothManager = (BluetoothManager)mainActivity.getContext().getSystemService("bluetooth");
        this.mBluetoothAdapter = bluetoothManager.getAdapter();
        if (this.mBluetoothAdapter == null) {
            return false;
        }
        this.mLeDevices = new ArrayList();
        this.mBluetoothAdapter.enable();
        Intent intent = new Intent((Context)mainActivity.getContext(), BluetoothLeService.class);
        mainActivity mainActivity2 = mainActivity.getContext();
        mainActivity.getContext();
        mainActivity2.bindService(intent, this.mServiceConnection, 1);
        mainActivity.getContext().registerReceiver(this.mGattUpdateReceiver, BLE\u84dd\u7259Impl.makeGattUpdateIntentFilter());
        return true;
    }

    @Override
    public void \u7f6e\u53ef\u88ab\u53d1\u73b0() {
        Intent intent = new Intent("android.bluetooth.adapter.action.REQUEST_DISCOVERABLE");
        intent.putExtra("android.bluetooth.adapter.extra.DISCOVERABLE_DURATION", 300);
        mainActivity.getContext().startActivity(intent);
    }

    @Override
    public void \u5f00\u59cb\u641c\u7d22() {
        this.scanLeDevice(true);
    }

    @Override
    public void \u505c\u6b62\u641c\u7d22() {
        this.scanLeDevice(false);
    }

    private void scanLeDevice(boolean bl) {
        if (bl) {
            this.mScanning = true;
            this.mBluetoothAdapter.startLeScan(this.mLeScanCallback);
        } else {
            this.mScanning = false;
            this.mBluetoothAdapter.stopLeScan(this.mLeScanCallback);
        }
    }

    @Override
    public void \u8fde\u63a5\u8bbe\u5907(String string) {
        if (this.mBluetoothLeService != null) {
            this.mBluetoothLeService.connect(string);
        }
    }

    @Override
    public void \u65ad\u5f00\u8fde\u63a5() {
        if (this.mBluetoothLeService != null) {
            this.mBluetoothLeService.disconnect();
        }
    }

    @Override
    public void \u91ca\u653e\u8d44\u6e90() {
        mainActivity.getContext().unregisterReceiver(this.mGattUpdateReceiver);
        mainActivity.getContext().unbindService(this.mServiceConnection);
        if (this.mBluetoothLeService != null) {
            this.mBluetoothLeService.disconnect();
            this.mBluetoothLeService.close();
        }
        this.mBluetoothLeService = null;
    }

    @Override
    public void \u8fde\u63a5\u72b6\u6001\u6539\u53d8(int n) {
        EventDispatcher.dispatchEvent((Object)this, (String)"\u8fde\u63a5\u72b6\u6001\u6539\u53d8", (Object[])new Object[]{n});
    }

    @Override
    public void \u8bfb\u53d6\u6570\u636e\u5b8c\u6bd5(int n, String string, String string2, byte[] byArray) {
        EventDispatcher.dispatchEvent((Object)this, (String)"\u8bfb\u53d6\u6570\u636e\u5b8c\u6bd5", (Object[])new Object[]{n, string, string2, byArray});
    }

    @Override
    public void \u5199\u5165\u6570\u636e\u5b8c\u6bd5(int n) {
        EventDispatcher.dispatchEvent((Object)this, (String)"\u5199\u5165\u6570\u636e\u5b8c\u6bd5", (Object[])new Object[]{n});
    }

    @Override
    public void \u901a\u9053\u6570\u636e\u6539\u53d8(String string, String string2, byte[] byArray) {
        EventDispatcher.dispatchEvent((Object)this, (String)"\u901a\u9053\u6570\u636e\u6539\u53d8", (Object[])new Object[]{string, string2, byArray});
    }

    @Override
    public void \u8bfb\u53d6\u6570\u636e(String string, String string2) {
        if (this.mBluetoothLeService != null) {
            this.mBluetoothLeService.setCharacteristicNotification(string, string2, true);
            this.mBluetoothLeService.readCharacteristic(string, string2);
        }
    }

    @Override
    public void \u5199\u5165\u6570\u636e(String string, String string2, byte[] byArray) {
        if (this.mBluetoothLeService != null) {
            this.mBluetoothLeService.writeCharacteristic(string, string2, byArray);
        }
    }

    @Override
    public void \u53d1\u73b0\u8bbe\u5907(String string, String string2, int n, int n2, int n3) {
        EventDispatcher.dispatchEvent((Object)this, (String)"\u53d1\u73b0\u8bbe\u5907", (Object[])new Object[]{string, string2, n, n2, n3});
    }

    @Override
    public void \u4fe1\u53f7\u5f3a\u5ea6\u6539\u53d8(String string, String string2, int n) {
        EventDispatcher.dispatchEvent((Object)this, (String)"\u4fe1\u53f7\u5f3a\u5ea6\u6539\u53d8", (Object[])new Object[]{string, string2, n});
    }

    private void displayGattServices(List<BluetoothGattService> list) {
        if (list == null) {
            return;
        }
        \u96c6\u5408 \u96c6\u54082 = new \u96c6\u5408();
        for (BluetoothGattService bluetoothGattService : list) {
            String string = bluetoothGattService.getUuid().toString();
            List list2 = bluetoothGattService.getCharacteristics();
            for (BluetoothGattCharacteristic bluetoothGattCharacteristic : list2) {
                string = string + "|*|" + bluetoothGattCharacteristic.getUuid().toString();
                this.mBluetoothLeService.setCharacteristicNotification2(bluetoothGattCharacteristic, true);
            }
            String[] stringArray = \u6587\u672c\u64cd\u4f5c.\u5206\u5272\u6587\u672c((String)string, (String)"|*|");
            \u96c6\u54082.\u52a0\u5165\u9879\u76ee((Variant)ArrayVariant.getArrayVariant((Object)stringArray));
        }
        this.\u53d1\u73b0\u670d\u52a1(\u96c6\u54082);
    }

    @Override
    public void \u53d1\u73b0\u670d\u52a1(\u96c6\u5408 \u96c6\u54082) {
        EventDispatcher.dispatchEvent((Object)this, (String)"\u53d1\u73b0\u670d\u52a1", (Object[])new Object[]{\u96c6\u54082});
    }

    @Override
    public boolean \u662f\u5426\u53ef\u8bfb(String string, String string2) {
        if (this.mBluetoothLeService != null) {
            return this.mBluetoothLeService.getProperties(string, string2, 1);
        }
        return false;
    }

    @Override
    public boolean \u662f\u5426\u53ef\u5199(String string, String string2) {
        if (this.mBluetoothLeService != null) {
            return this.mBluetoothLeService.getProperties(string, string2, 2);
        }
        return false;
    }

    @Override
    public boolean \u662f\u5426\u53ef\u901a\u77e5(String string, String string2) {
        if (this.mBluetoothLeService != null) {
            return this.mBluetoothLeService.getProperties(string, string2, 3);
        }
        return false;
    }
}

