/*
 * Decompiled with CFR 0.152.
 */
package com.sqlcrypt.database.sqlite;

import android.content.Context;
import android.util.Log;
import com.sqlcrypt.database.DatabaseErrorHandler;
import com.sqlcrypt.database.DefaultDatabaseErrorHandler;
import com.sqlcrypt.database.sqlite.SQLiteDatabase;
import com.sqlcrypt.database.sqlite.SQLiteException;

public abstract class SQLiteOpenHelper {
    private static final String TAG = SQLiteOpenHelper.class.getSimpleName();
    private final Context mContext;
    private final String mName;
    private final String mPasswd;
    private final SQLiteDatabase.CursorFactory mFactory;
    private final int mNewVersion;
    private SQLiteDatabase mDatabase = null;
    private boolean mIsInitializing = false;
    private final DatabaseErrorHandler mErrorHandler;

    public SQLiteOpenHelper(Context context, String name, String passwd, SQLiteDatabase.CursorFactory factory, int version) {
        this(context, name, passwd, factory, version, new DefaultDatabaseErrorHandler());
    }

    public SQLiteOpenHelper(Context context, String name, String passwd, SQLiteDatabase.CursorFactory factory, int version, DatabaseErrorHandler errorHandler) {
        if (version < 1) {
            throw new IllegalArgumentException("Version must be >= 1, was " + version);
        }
        if (errorHandler == null) {
            throw new IllegalArgumentException("DatabaseErrorHandler param value can't be null.");
        }
        this.mContext = context;
        this.mName = name;
        this.mPasswd = passwd;
        this.mFactory = factory;
        this.mNewVersion = version;
        this.mErrorHandler = errorHandler;
    }

    public String getDatabaseName() {
        return this.mName;
    }

    public synchronized SQLiteDatabase getWritableDatabase() {
        if (this.mDatabase != null) {
            if (!this.mDatabase.isOpen()) {
                this.mDatabase = null;
            } else if (!this.mDatabase.isReadOnly()) {
                return this.mDatabase;
            }
        }
        if (this.mIsInitializing) {
            throw new IllegalStateException("getWritableDatabase called recursively");
        }
        boolean success = false;
        SQLiteDatabase db = null;
        if (this.mDatabase != null) {
            this.mDatabase.lock();
        }
        try {
            this.mIsInitializing = true;
            db = this.mName == null ? SQLiteDatabase.create(null) : SQLiteDatabase.openDatabase(this.mName, this.mPasswd, this.mFactory, 0);
            int version = db.getVersion();
            if (version != this.mNewVersion) {
                db.beginTransaction();
                try {
                    if (version == 0) {
                        this.onCreate(db);
                    } else if (version > this.mNewVersion) {
                        this.onDowngrade(db, version, this.mNewVersion);
                    } else {
                        this.onUpgrade(db, version, this.mNewVersion);
                    }
                    db.setVersion(this.mNewVersion);
                    db.setTransactionSuccessful();
                }
                finally {
                    db.endTransaction();
                }
            }
            this.onOpen(db);
            success = true;
            SQLiteDatabase sQLiteDatabase = db;
            return sQLiteDatabase;
        }
        finally {
            this.mIsInitializing = false;
            if (success) {
                if (this.mDatabase != null) {
                    try {
                        this.mDatabase.close();
                    }
                    catch (Exception exception) {}
                    this.mDatabase.unlock();
                }
                this.mDatabase = db;
            } else {
                if (this.mDatabase != null) {
                    this.mDatabase.unlock();
                }
                if (db != null) {
                    db.close();
                }
            }
        }
    }

    public synchronized SQLiteDatabase getReadableDatabase() {
        if (this.mDatabase != null) {
            if (!this.mDatabase.isOpen()) {
                this.mDatabase = null;
            } else {
                return this.mDatabase;
            }
        }
        if (this.mIsInitializing) {
            throw new IllegalStateException("getReadableDatabase called recursively");
        }
        try {
            return this.getWritableDatabase();
        }
        catch (SQLiteException e) {
            if (this.mName == null) {
                throw e;
            }
            Log.e((String)TAG, (String)("Couldn't open " + this.mName + " for writing (will try read-only):"), (Throwable)e);
            SQLiteDatabase db = null;
            try {
                this.mIsInitializing = true;
                String path = this.mContext.getDatabasePath(this.mName).getPath();
                db = SQLiteDatabase.openDatabase(path, this.mPasswd, this.mFactory, 1, this.mErrorHandler);
                if (db.getVersion() != this.mNewVersion) {
                    throw new SQLiteException("Can't upgrade read-only database from version " + db.getVersion() + " to " + this.mNewVersion + ": " + path);
                }
                this.onOpen(db);
                Log.w((String)TAG, (String)("Opened " + this.mName + " in read-only mode"));
                SQLiteDatabase sQLiteDatabase = this.mDatabase = db;
                return sQLiteDatabase;
            }
            finally {
                this.mIsInitializing = false;
                if (db != null && db != this.mDatabase) {
                    db.close();
                }
            }
        }
    }

    public synchronized void close() {
        if (this.mIsInitializing) {
            throw new IllegalStateException("Closed during initialization");
        }
        if (this.mDatabase != null && this.mDatabase.isOpen()) {
            this.mDatabase.close();
            this.mDatabase = null;
        }
    }

    public abstract void onCreate(SQLiteDatabase var1);

    public abstract void onUpgrade(SQLiteDatabase var1, int var2, int var3);

    public void onDowngrade(SQLiteDatabase db, int oldVersion, int newVersion) {
        throw new SQLiteException("Can't downgrade database from version " + oldVersion + " to " + newVersion);
    }

    public void onOpen(SQLiteDatabase db) {
    }
}

