/*
 * Decompiled with CFR 0.152.
 */
package com.sqlcrypt.database.sqlite;

import android.util.Log;
import com.sqlcrypt.database.AbstractWindowedCursor;
import com.sqlcrypt.database.CursorWindow;
import com.sqlcrypt.database.sqlite.DatabaseObjectNotClosedException;
import com.sqlcrypt.database.sqlite.SQLiteCursorDriver;
import com.sqlcrypt.database.sqlite.SQLiteDatabase;
import com.sqlcrypt.database.sqlite.SQLiteDebug;
import com.sqlcrypt.database.sqlite.SQLiteQuery;
import java.util.HashMap;
import java.util.Map;

public class SQLiteCursor
extends AbstractWindowedCursor {
    static final String TAG = "SQLiteCursor";
    static final int NO_COUNT = -1;
    private final String mEditTable;
    private final String[] mColumns;
    private SQLiteQuery mQuery;
    private final SQLiteCursorDriver mDriver;
    private volatile int mCount = -1;
    private Map<String, Integer> mColumnNameMap;
    private final Throwable mStackTrace;

    @Deprecated
    public SQLiteCursor(SQLiteDatabase db, SQLiteCursorDriver driver, String editTable, SQLiteQuery query) {
        this(driver, editTable, query);
    }

    public SQLiteCursor(SQLiteCursorDriver driver, String editTable, SQLiteQuery query) {
        if (query == null) {
            throw new IllegalArgumentException("query object cannot be null");
        }
        if (query.mDatabase == null) {
            throw new IllegalArgumentException("query.mDatabase cannot be null");
        }
        this.mStackTrace = new DatabaseObjectNotClosedException().fillInStackTrace();
        this.mDriver = driver;
        this.mEditTable = editTable;
        this.mColumnNameMap = null;
        this.mQuery = query;
        query.mDatabase.lock(query.mSql);
        try {
            int columnCount = this.mQuery.columnCountLocked();
            this.mColumns = new String[columnCount];
            int i = 0;
            while (i < columnCount) {
                String columnName;
                this.mColumns[i] = columnName = this.mQuery.columnNameLocked(i);
                if ("_id".equals(columnName)) {
                    this.mRowIdColumnIndex = i;
                }
                ++i;
            }
        }
        finally {
            query.mDatabase.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SQLiteDatabase getDatabase() {
        SQLiteCursor sQLiteCursor = this;
        synchronized (sQLiteCursor) {
            return this.mQuery.mDatabase;
        }
    }

    @Override
    public boolean onMove(int oldPosition, int newPosition) {
        if (this.mWindow == null || newPosition < this.mWindow.getStartPosition() || newPosition >= this.mWindow.getStartPosition() + this.mWindow.getNumRows()) {
            this.fillWindow(newPosition);
        }
        return true;
    }

    @Override
    public int getCount() {
        if (this.mCount == -1) {
            this.fillWindow(0);
        }
        return this.mCount;
    }

    private void fillWindow(int startPos) {
        this.clearOrCreateWindow(this.getDatabase().getPath());
        this.mWindow.setStartPosition(startPos);
        int count = this.getQuery().fillWindow(this.mWindow);
        if (startPos == 0) {
            if (Log.isLoggable((String)TAG, (int)3)) {
                Log.d((String)TAG, (String)("received count(*) from native_fill_window: " + count));
            }
            this.mCount = count;
        } else if (this.mCount <= 0) {
            throw new IllegalStateException("Row count should never be zero or negative when the start position is non-zero");
        }
    }

    private synchronized SQLiteQuery getQuery() {
        return this.mQuery;
    }

    @Override
    public int getColumnIndex(String columnName) {
        Integer i;
        int periodIndex;
        if (this.mColumnNameMap == null) {
            String[] columns = this.mColumns;
            int columnCount = columns.length;
            HashMap<String, Integer> map = new HashMap<String, Integer>(columnCount, 1.0f);
            int i2 = 0;
            while (i2 < columnCount) {
                map.put(columns[i2], i2);
                ++i2;
            }
            this.mColumnNameMap = map;
        }
        if ((periodIndex = columnName.lastIndexOf(46)) != -1) {
            Exception e = new Exception();
            Log.e((String)TAG, (String)("requesting column name with table name -- " + columnName), (Throwable)e);
            columnName = columnName.substring(periodIndex + 1);
        }
        if ((i = this.mColumnNameMap.get(columnName)) != null) {
            return i;
        }
        return -1;
    }

    @Override
    public String[] getColumnNames() {
        return this.mColumns;
    }

    @Override
    public void deactivate() {
        super.deactivate();
        this.mDriver.cursorDeactivated();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        super.close();
        SQLiteCursor sQLiteCursor = this;
        synchronized (sQLiteCursor) {
            this.mQuery.close();
            this.mDriver.cursorClosed();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean requery() {
        if (this.isClosed()) {
            return false;
        }
        long timeStart = 0L;
        SQLiteCursor sQLiteCursor = this;
        synchronized (sQLiteCursor) {
            if (this.mWindow != null) {
                this.mWindow.clear();
            }
            this.mPos = -1;
            SQLiteDatabase db = null;
            try {
                db = this.mQuery.mDatabase.getDatabaseHandle(this.mQuery.mSql);
            }
            catch (IllegalStateException e) {
                Log.w((String)TAG, (String)("requery() failed " + e.getMessage()), (Throwable)e);
                return false;
            }
            if (!db.equals(this.mQuery.mDatabase)) {
                try {
                    db.lock(this.mQuery.mSql);
                }
                catch (IllegalStateException e) {
                    Log.w((String)TAG, (String)("requery() failed " + e.getMessage()), (Throwable)e);
                    return false;
                }
                try {
                    try {
                        this.mQuery.close();
                        this.mQuery = new SQLiteQuery(db, this.mQuery);
                    }
                    catch (IllegalStateException e) {
                        Log.w((String)TAG, (String)("requery() failed " + e.getMessage()), (Throwable)e);
                        db.unlock();
                        return false;
                    }
                }
                finally {
                    db.unlock();
                }
            }
            this.mDriver.cursorRequeried(this);
            this.mCount = -1;
            try {
                this.mQuery.requery();
            }
            catch (IllegalStateException e) {
                Log.w((String)TAG, (String)("requery() failed " + e.getMessage()), (Throwable)e);
                return false;
            }
        }
        boolean result = false;
        try {
            return super.requery();
        }
        catch (IllegalStateException e) {
            Log.w((String)TAG, (String)("requery() failed " + e.getMessage()), (Throwable)e);
        }
        return result;
    }

    @Override
    public void setWindow(CursorWindow window) {
        super.setWindow(window);
        this.mCount = -1;
    }

    public void setSelectionArguments(String[] selectionArgs) {
        this.mDriver.setBindArguments(selectionArgs);
    }

    @Override
    protected void finalize() {
        try {
            if (this.mWindow != null) {
                if (this.mStackTrace != null) {
                    int len = this.mQuery.mSql.length();
                    Log.w((String)TAG, (String)("Finalizing a Cursor that has not been deactivated or closed. database = " + this.mQuery.mDatabase.getPath() + ", table = " + this.mEditTable + ", query = " + this.mQuery.mSql.substring(0, len > 1000 ? 1000 : len)), (Throwable)this.mStackTrace);
                }
                this.close();
                SQLiteDebug.notifyActiveCursorFinalized();
            }
        }
        finally {
            super.finalize();
        }
    }
}

