/*
 * Decompiled with CFR 0.152.
 */
package com.sqlcrypt.database.sqlite;

import android.os.SystemClock;
import android.util.Log;
import com.sqlcrypt.database.sqlite.SQLiteDatabase;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Random;

class DatabaseConnectionPool {
    private static final String TAG = "DatabaseConnectionPool";
    private volatile int mMaxPoolSize = 4;
    private final ArrayList<PoolObj> mPool = new ArrayList(this.mMaxPoolSize);
    private final SQLiteDatabase mParentDbObj;
    private Random rand;

    DatabaseConnectionPool(SQLiteDatabase db) {
        this.mParentDbObj = db;
        if (Log.isLoggable((String)TAG, (int)3)) {
            Log.d((String)TAG, (String)("Max Pool Size: " + this.mMaxPoolSize));
        }
    }

    synchronized void close() {
        if (Log.isLoggable((String)TAG, (int)3)) {
            Log.d((String)TAG, (String)("Closing the connection pool on " + this.mParentDbObj.getPath() + this.toString()));
        }
        int i = this.mPool.size() - 1;
        while (i >= 0) {
            this.mPool.get(i).mDb.close();
            --i;
        }
        this.mPool.clear();
    }

    synchronized SQLiteDatabase get(String sql) {
        SQLiteDatabase db = null;
        PoolObj poolObj = null;
        int poolSize = this.mPool.size();
        if (Log.isLoggable((String)TAG, (int)3)) {
            assert (sql != null);
            this.doAsserts();
        }
        if (this.getFreePoolSize() == 0) {
            if (this.mMaxPoolSize == poolSize) {
                if (this.mMaxPoolSize == 1) {
                    poolObj = this.mPool.get(0);
                } else {
                    int i = 0;
                    while (i < this.mMaxPoolSize) {
                        if (this.mPool.get(i).mDb.isInStatementCache(sql)) {
                            poolObj = this.mPool.get(i);
                            break;
                        }
                        ++i;
                    }
                    if (poolObj == null) {
                        if (this.rand == null) {
                            this.rand = new Random(SystemClock.elapsedRealtime());
                        }
                        poolObj = this.mPool.get(this.rand.nextInt(this.mMaxPoolSize));
                    }
                }
                db = poolObj.mDb;
            } else {
                db = this.mParentDbObj.createPoolConnection((short)(poolSize + 1));
                poolObj = new PoolObj(db);
                this.mPool.add(poolSize, poolObj);
            }
        } else {
            int i = 0;
            while (i < poolSize) {
                if (this.mPool.get(i).isFree() && this.mPool.get(i).mDb.isInStatementCache(sql)) {
                    poolObj = this.mPool.get(i);
                    break;
                }
                ++i;
            }
            if (poolObj == null) {
                i = 0;
                while (i < poolSize) {
                    if (this.mPool.get(i).isFree()) {
                        poolObj = this.mPool.get(i);
                        break;
                    }
                    ++i;
                }
            }
            db = poolObj.mDb;
        }
        assert (poolObj != null);
        assert (poolObj.mDb == db);
        poolObj.acquire();
        if (Log.isLoggable((String)TAG, (int)3)) {
            Log.d((String)TAG, (String)("END get-connection: " + this.toString() + poolObj.toString()));
        }
        return db;
    }

    synchronized void release(SQLiteDatabase db) {
        if (Log.isLoggable((String)TAG, (int)3)) {
            assert (db.mConnectionNum > 0);
            this.doAsserts();
            assert (this.mPool.get(db.mConnectionNum - 1).mDb == db);
        }
        PoolObj poolObj = this.mPool.get(db.mConnectionNum - 1);
        if (Log.isLoggable((String)TAG, (int)3)) {
            Log.d((String)TAG, (String)("BEGIN release-conn: " + this.toString() + poolObj.toString()));
        }
        if (poolObj.isFree()) {
            throw new IllegalStateException("Releasing object already freed: " + db.mConnectionNum);
        }
        poolObj.release();
        if (Log.isLoggable((String)TAG, (int)3)) {
            Log.d((String)TAG, (String)("END release-conn: " + this.toString() + poolObj.toString()));
        }
    }

    synchronized ArrayList<SQLiteDatabase> getConnectionList() {
        ArrayList<SQLiteDatabase> list = new ArrayList<SQLiteDatabase>();
        int i = this.mPool.size() - 1;
        while (i >= 0) {
            list.add(this.mPool.get(i).mDb);
            --i;
        }
        return list;
    }

    int getFreePoolSize() {
        int count = 0;
        int i = this.mPool.size() - 1;
        while (i >= 0) {
            if (this.mPool.get(i).isFree()) {
                ++count;
            }
            --i;
        }
        return count++;
    }

    ArrayList<PoolObj> getPool() {
        return this.mPool;
    }

    public String toString() {
        StringBuilder buff = new StringBuilder();
        buff.append("db: ");
        buff.append(this.mParentDbObj.getPath());
        buff.append(", totalsize = ");
        buff.append(this.mPool.size());
        buff.append(", #free = ");
        buff.append(this.getFreePoolSize());
        buff.append(", maxpoolsize = ");
        buff.append(this.mMaxPoolSize);
        for (PoolObj p : this.mPool) {
            buff.append("\n");
            buff.append(p.toString());
        }
        return buff.toString();
    }

    private void doAsserts() {
        int i = 0;
        while (i < this.mPool.size()) {
            this.mPool.get(i).verify();
            assert (((PoolObj)this.mPool.get((int)i)).mDb.mConnectionNum == i + 1);
            ++i;
        }
    }

    synchronized void setMaxPoolSize(int size) {
        this.mMaxPoolSize = size;
    }

    synchronized int getMaxPoolSize() {
        return this.mMaxPoolSize;
    }

    boolean isDatabaseObjFree(SQLiteDatabase db) {
        return this.mPool.get(db.mConnectionNum - 1).isFree();
    }

    int getSize() {
        return this.mPool.size();
    }

    static class PoolObj {
        private final SQLiteDatabase mDb;
        private boolean mFreeBusyFlag = true;
        private static final boolean FREE = true;
        private static final boolean BUSY = false;
        private int mNumHolders = 0;
        private HashSet<Long> mHolderIds = new HashSet();

        public PoolObj(SQLiteDatabase db) {
            this.mDb = db;
        }

        private synchronized void acquire() {
            if (Log.isLoggable((String)DatabaseConnectionPool.TAG, (int)3)) {
                assert (this.isFree());
                long id = Thread.currentThread().getId();
                assert (!this.mHolderIds.contains(id));
                this.mHolderIds.add(id);
            }
            ++this.mNumHolders;
            this.mFreeBusyFlag = false;
        }

        private synchronized void release() {
            if (Log.isLoggable((String)DatabaseConnectionPool.TAG, (int)3)) {
                long id = Thread.currentThread().getId();
                assert (this.mHolderIds.size() == this.mNumHolders);
                assert (this.mHolderIds.contains(id));
                this.mHolderIds.remove(id);
            }
            --this.mNumHolders;
            if (this.mNumHolders == 0) {
                this.mFreeBusyFlag = true;
            }
        }

        private synchronized boolean isFree() {
            if (Log.isLoggable((String)DatabaseConnectionPool.TAG, (int)3)) {
                this.verify();
            }
            return this.mFreeBusyFlag;
        }

        private synchronized void verify() {
            if (this.mFreeBusyFlag ? !$assertionsDisabled && this.mNumHolders != 0 : !$assertionsDisabled && this.mNumHolders <= 0) {
                throw new AssertionError();
            }
        }

        synchronized int getNumHolders() {
            return this.mNumHolders;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String toString() {
            StringBuilder buff = new StringBuilder();
            buff.append(", conn # ");
            buff.append(this.mDb.mConnectionNum);
            buff.append(", mCountHolders = ");
            PoolObj poolObj = this;
            synchronized (poolObj) {
                buff.append(this.mNumHolders);
                buff.append(", freeBusyFlag = ");
                buff.append(this.mFreeBusyFlag);
                for (Long l : this.mHolderIds) {
                    buff.append(", id = " + l);
                }
            }
            return buff.toString();
        }
    }
}

