/*
 * Decompiled with CFR 0.152.
 */
package com.sqlcrypt.database;

import android.os.Binder;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.Process;
import android.util.Log;
import android.util.SparseIntArray;
import com.sqlcrypt.database.CharArrayBuffer;
import com.sqlcrypt.database.CloseGuard;
import com.sqlcrypt.database.CursorWindowAllocationException;
import com.sqlcrypt.database.sqlite.SQLiteClosable;

public class CursorWindow
extends SQLiteClosable
implements Parcelable {
    private static final String STATS_TAG = "CursorWindowStats";
    private static final int sCursorWindowSize = 0x200000;
    public int mWindowPtr;
    private int mStartPos;
    private final String mName;
    private final CloseGuard mCloseGuard = CloseGuard.get();
    public static final Parcelable.Creator<CursorWindow> CREATOR = new Parcelable.Creator<CursorWindow>(){

        public CursorWindow createFromParcel(Parcel source) {
            return new CursorWindow(source, null);
        }

        public CursorWindow[] newArray(int size) {
            return new CursorWindow[size];
        }
    };
    private static final SparseIntArray sWindowToPidMap = new SparseIntArray();

    private static native int nativeCreate(String var0, int var1);

    private static native int nativeCreateFromParcel(Parcel var0);

    private static native void nativeDispose(int var0);

    private static native void nativeWriteToParcel(int var0, Parcel var1);

    private static native void nativeClear(int var0);

    private static native int nativeGetNumRows(int var0);

    private static native boolean nativeSetNumColumns(int var0, int var1);

    private static native boolean nativeAllocRow(int var0);

    private static native void nativeFreeLastRow(int var0);

    private static native int nativeGetType(int var0, int var1, int var2);

    private static native byte[] nativeGetBlob(int var0, int var1, int var2);

    private static native String nativeGetString(int var0, int var1, int var2);

    private static native long nativeGetLong(int var0, int var1, int var2);

    private static native double nativeGetDouble(int var0, int var1, int var2);

    private static native void nativeCopyStringToBuffer(int var0, int var1, int var2, CharArrayBuffer var3);

    private static native boolean nativePutBlob(int var0, byte[] var1, int var2, int var3);

    private static native boolean nativePutString(int var0, String var1, int var2, int var3);

    private static native boolean nativePutLong(int var0, long var1, int var3, int var4);

    private static native boolean nativePutDouble(int var0, double var1, int var3, int var4);

    private static native boolean nativePutNull(int var0, int var1, int var2);

    private static native String nativeGetName(int var0);

    public CursorWindow(String name) {
        this.mStartPos = 0;
        this.mName = name;
        this.mWindowPtr = CursorWindow.nativeCreate(name, 0x200000);
        if (this.mWindowPtr == 0) {
            throw new CursorWindowAllocationException("Cursor window allocation of 2048 kb failed. " + this.printStats());
        }
        this.mCloseGuard.open("close");
        this.recordNewWindow(Binder.getCallingPid(), this.mWindowPtr);
    }

    @Deprecated
    public CursorWindow(boolean localWindow) {
        this((String)null);
    }

    private CursorWindow(Parcel source) {
        this.mStartPos = source.readInt();
        this.mWindowPtr = CursorWindow.nativeCreateFromParcel(source);
        if (this.mWindowPtr == 0) {
            throw new CursorWindowAllocationException("Cursor window could not be created from binder.");
        }
        this.mName = CursorWindow.nativeGetName(this.mWindowPtr);
        this.mCloseGuard.open("close");
    }

    protected void finalize() throws Throwable {
        try {
            if (this.mCloseGuard != null) {
                this.mCloseGuard.warnIfOpen();
            }
            this.dispose();
        }
        finally {
            super.finalize();
        }
    }

    private void dispose() {
        if (this.mCloseGuard != null) {
            this.mCloseGuard.close();
        }
        if (this.mWindowPtr != 0) {
            this.recordClosingOfWindow(this.mWindowPtr);
            CursorWindow.nativeDispose(this.mWindowPtr);
            this.mWindowPtr = 0;
        }
    }

    public String getName() {
        return this.mName;
    }

    public void close() {
        this.releaseReference();
    }

    public void clear() {
        this.acquireReference();
        try {
            this.mStartPos = 0;
            CursorWindow.nativeClear(this.mWindowPtr);
        }
        finally {
            this.releaseReference();
        }
    }

    public int getStartPosition() {
        return this.mStartPos;
    }

    public void setStartPosition(int pos) {
        this.mStartPos = pos;
    }

    public int getNumRows() {
        this.acquireReference();
        try {
            int n = CursorWindow.nativeGetNumRows(this.mWindowPtr);
            return n;
        }
        finally {
            this.releaseReference();
        }
    }

    public boolean setNumColumns(int columnNum) {
        this.acquireReference();
        try {
            boolean bl = CursorWindow.nativeSetNumColumns(this.mWindowPtr, columnNum);
            return bl;
        }
        finally {
            this.releaseReference();
        }
    }

    public boolean allocRow() {
        this.acquireReference();
        try {
            boolean bl = CursorWindow.nativeAllocRow(this.mWindowPtr);
            return bl;
        }
        finally {
            this.releaseReference();
        }
    }

    public void freeLastRow() {
        this.acquireReference();
        try {
            CursorWindow.nativeFreeLastRow(this.mWindowPtr);
        }
        finally {
            this.releaseReference();
        }
    }

    @Deprecated
    public boolean isNull(int row, int column) {
        return this.getType(row, column) == 0;
    }

    @Deprecated
    public boolean isBlob(int row, int column) {
        int type = this.getType(row, column);
        return type == 4 || type == 0;
    }

    @Deprecated
    public boolean isLong(int row, int column) {
        return this.getType(row, column) == 1;
    }

    @Deprecated
    public boolean isFloat(int row, int column) {
        return this.getType(row, column) == 2;
    }

    @Deprecated
    public boolean isString(int row, int column) {
        int type = this.getType(row, column);
        return type == 3 || type == 0;
    }

    public int getType(int row, int column) {
        this.acquireReference();
        try {
            int n = CursorWindow.nativeGetType(this.mWindowPtr, row - this.mStartPos, column);
            return n;
        }
        finally {
            this.releaseReference();
        }
    }

    public byte[] getBlob(int row, int column) {
        this.acquireReference();
        try {
            byte[] byArray = CursorWindow.nativeGetBlob(this.mWindowPtr, row - this.mStartPos, column);
            return byArray;
        }
        finally {
            this.releaseReference();
        }
    }

    public String getString(int row, int column) {
        this.acquireReference();
        try {
            String string = CursorWindow.nativeGetString(this.mWindowPtr, row - this.mStartPos, column);
            return string;
        }
        finally {
            this.releaseReference();
        }
    }

    public void copyStringToBuffer(int row, int column, CharArrayBuffer buffer) {
        if (buffer == null) {
            throw new IllegalArgumentException("CharArrayBuffer should not be null");
        }
        this.acquireReference();
        try {
            CursorWindow.nativeCopyStringToBuffer(this.mWindowPtr, row - this.mStartPos, column, buffer);
        }
        finally {
            this.releaseReference();
        }
    }

    public long getLong(int row, int column) {
        this.acquireReference();
        try {
            long l = CursorWindow.nativeGetLong(this.mWindowPtr, row - this.mStartPos, column);
            return l;
        }
        finally {
            this.releaseReference();
        }
    }

    public double getDouble(int row, int column) {
        this.acquireReference();
        try {
            double d = CursorWindow.nativeGetDouble(this.mWindowPtr, row - this.mStartPos, column);
            return d;
        }
        finally {
            this.releaseReference();
        }
    }

    public short getShort(int row, int column) {
        return (short)this.getLong(row, column);
    }

    public int getInt(int row, int column) {
        return (int)this.getLong(row, column);
    }

    public float getFloat(int row, int column) {
        return (float)this.getDouble(row, column);
    }

    public boolean putBlob(byte[] value, int row, int column) {
        this.acquireReference();
        try {
            boolean bl = CursorWindow.nativePutBlob(this.mWindowPtr, value, row - this.mStartPos, column);
            return bl;
        }
        finally {
            this.releaseReference();
        }
    }

    public boolean putString(String value, int row, int column) {
        this.acquireReference();
        try {
            boolean bl = CursorWindow.nativePutString(this.mWindowPtr, value, row - this.mStartPos, column);
            return bl;
        }
        finally {
            this.releaseReference();
        }
    }

    public boolean putLong(long value, int row, int column) {
        this.acquireReference();
        try {
            boolean bl = CursorWindow.nativePutLong(this.mWindowPtr, value, row - this.mStartPos, column);
            return bl;
        }
        finally {
            this.releaseReference();
        }
    }

    public boolean putDouble(double value, int row, int column) {
        this.acquireReference();
        try {
            boolean bl = CursorWindow.nativePutDouble(this.mWindowPtr, value, row - this.mStartPos, column);
            return bl;
        }
        finally {
            this.releaseReference();
        }
    }

    public boolean putNull(int row, int column) {
        this.acquireReference();
        try {
            boolean bl = CursorWindow.nativePutNull(this.mWindowPtr, row - this.mStartPos, column);
            return bl;
        }
        finally {
            this.releaseReference();
        }
    }

    public static CursorWindow newFromParcel(Parcel p) {
        return (CursorWindow)CREATOR.createFromParcel(p);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.mStartPos);
        CursorWindow.nativeWriteToParcel(this.mWindowPtr, dest);
        if ((flags & 1) != 0) {
            this.releaseReference();
        }
    }

    @Override
    protected void onAllReferencesReleased() {
        this.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recordNewWindow(int pid, int window) {
        SparseIntArray sparseIntArray = sWindowToPidMap;
        synchronized (sparseIntArray) {
            sWindowToPidMap.put(window, pid);
            if (Log.isLoggable((String)STATS_TAG, (int)2)) {
                Log.i((String)STATS_TAG, (String)("Created a new Cursor. " + this.printStats()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recordClosingOfWindow(int window) {
        SparseIntArray sparseIntArray = sWindowToPidMap;
        synchronized (sparseIntArray) {
            if (sWindowToPidMap.size() == 0) {
                return;
            }
            sWindowToPidMap.delete(window);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String printStats() {
        StringBuilder buff = new StringBuilder();
        int myPid = Process.myPid();
        int total = 0;
        SparseIntArray pidCounts = new SparseIntArray();
        SparseIntArray sparseIntArray = sWindowToPidMap;
        synchronized (sparseIntArray) {
            int size;
            block8: {
                size = sWindowToPidMap.size();
                if (size != 0) break block8;
                return "";
            }
            int indx = 0;
            while (indx < size) {
                int pid = sWindowToPidMap.valueAt(indx);
                int value = pidCounts.get(pid);
                pidCounts.put(pid, ++value);
                ++indx;
            }
        }
        int numPids = pidCounts.size();
        int i = 0;
        while (i < numPids) {
            buff.append(" (# cursors opened by ");
            int pid = pidCounts.keyAt(i);
            if (pid == myPid) {
                buff.append("this proc=");
            } else {
                buff.append("pid " + pid + "=");
            }
            int num = pidCounts.get(pid);
            buff.append(String.valueOf(num) + ")");
            total += num;
            ++i;
        }
        String s = buff.length() > 980 ? buff.substring(0, 980) : buff.toString();
        return "# Open Cursors=" + total + s;
    }

    public String toString() {
        return String.valueOf(this.getName()) + " {" + Integer.toHexString(this.mWindowPtr) + "}";
    }

    /* synthetic */ CursorWindow(Parcel parcel, CursorWindow cursorWindow) {
        this(parcel);
    }
}

