/*
 * Decompiled with CFR 0.152.
 */
package com.sqlcrypt.database;

import android.os.Bundle;
import android.os.IBinder;
import android.os.RemoteException;
import com.sqlcrypt.database.BulkCursorNative;
import com.sqlcrypt.database.ContentObserver;
import com.sqlcrypt.database.CrossProcessCursor;
import com.sqlcrypt.database.CrossProcessCursorWrapper;
import com.sqlcrypt.database.Cursor;
import com.sqlcrypt.database.CursorWindow;
import com.sqlcrypt.database.IContentObserver;
import com.sqlcrypt.database.StaleDataException;

public final class CursorToBulkCursorAdaptor
extends BulkCursorNative
implements IBinder.DeathRecipient {
    private static final String TAG = "Cursor";
    private final Object mLock = new Object();
    private final String mProviderName;
    private ContentObserverProxy mObserver;
    private CrossProcessCursor mCursor;
    private CursorWindow mFilledWindow;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CursorToBulkCursorAdaptor(Cursor cursor, IContentObserver observer, String providerName) {
        this.mCursor = cursor instanceof CrossProcessCursor ? (CrossProcessCursor)cursor : new CrossProcessCursorWrapper(cursor);
        this.mProviderName = providerName;
        Object object = this.mLock;
        synchronized (object) {
            this.createAndRegisterObserverProxyLocked(observer);
        }
    }

    private void closeFilledWindowLocked() {
        if (this.mFilledWindow != null) {
            this.mFilledWindow.close();
            this.mFilledWindow = null;
        }
    }

    private void disposeLocked() {
        if (this.mCursor != null) {
            this.unregisterObserverProxyLocked();
            this.mCursor.close();
            this.mCursor = null;
        }
        this.closeFilledWindowLocked();
    }

    private void throwIfCursorIsClosed() {
        if (this.mCursor == null) {
            throw new StaleDataException("Attempted to access a cursor after it has been closed.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void binderDied() {
        Object object = this.mLock;
        synchronized (object) {
            this.disposeLocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CursorWindow getWindow(int startPos) {
        Object object = this.mLock;
        synchronized (object) {
            block10: {
                this.throwIfCursorIsClosed();
                if (this.mCursor.moveToPosition(startPos)) break block10;
                this.closeFilledWindowLocked();
                return null;
            }
            CursorWindow window = this.mCursor.getWindow();
            if (window != null) {
                this.closeFilledWindowLocked();
            } else {
                window = this.mFilledWindow;
                if (window == null) {
                    window = this.mFilledWindow = new CursorWindow(this.mProviderName);
                    this.mCursor.fillWindow(startPos, window);
                } else if (startPos < window.getStartPosition() || startPos >= window.getStartPosition() + window.getNumRows()) {
                    window.clear();
                    this.mCursor.fillWindow(startPos, window);
                }
            }
            if (window != null) {
                window.acquireReference();
            }
            return window;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onMove(int position) {
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfCursorIsClosed();
            this.mCursor.onMove(this.mCursor.getPosition(), position);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int count() {
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfCursorIsClosed();
            return this.mCursor.getCount();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getColumnNames() {
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfCursorIsClosed();
            return this.mCursor.getColumnNames();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deactivate() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mCursor != null) {
                this.unregisterObserverProxyLocked();
                this.mCursor.deactivate();
            }
            this.closeFilledWindowLocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = this.mLock;
        synchronized (object) {
            this.disposeLocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int requery(IContentObserver observer) {
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfCursorIsClosed();
            this.closeFilledWindowLocked();
            try {
                if (!this.mCursor.requery()) {
                    return -1;
                }
            }
            catch (IllegalStateException e) {
                IllegalStateException leakProgram = new IllegalStateException(String.valueOf(this.mProviderName) + " Requery misuse db, mCursor isClosed:" + this.mCursor.isClosed(), e);
                throw leakProgram;
            }
            this.unregisterObserverProxyLocked();
            this.createAndRegisterObserverProxyLocked(observer);
            return this.mCursor.getCount();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean getWantsAllOnMoveCalls() {
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfCursorIsClosed();
            return this.mCursor.getWantsAllOnMoveCalls();
        }
    }

    private void createAndRegisterObserverProxyLocked(IContentObserver observer) {
        if (this.mObserver != null) {
            throw new IllegalStateException("an observer is already registered");
        }
        this.mObserver = new ContentObserverProxy(observer, this);
        this.mCursor.registerContentObserver(this.mObserver);
    }

    private void unregisterObserverProxyLocked() {
        if (this.mObserver != null) {
            this.mCursor.unregisterContentObserver(this.mObserver);
            this.mObserver.unlinkToDeath(this);
            this.mObserver = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Bundle getExtras() {
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfCursorIsClosed();
            return this.mCursor.getExtras();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Bundle respond(Bundle extras) {
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfCursorIsClosed();
            return this.mCursor.respond(extras);
        }
    }

    private static final class ContentObserverProxy
    extends ContentObserver {
        protected IContentObserver mRemote;

        public ContentObserverProxy(IContentObserver remoteObserver, IBinder.DeathRecipient recipient) {
            super(null);
            this.mRemote = remoteObserver;
            try {
                remoteObserver.asBinder().linkToDeath(recipient, 0);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }

        public boolean unlinkToDeath(IBinder.DeathRecipient recipient) {
            return this.mRemote.asBinder().unlinkToDeath(recipient, 0);
        }

        @Override
        public boolean deliverSelfNotifications() {
            return false;
        }

        @Override
        public void onChange(boolean selfChange) {
            try {
                this.mRemote.onChange(selfChange);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
    }
}

