/*
 * Decompiled with CFR 0.152.
 */
package com.sqlcrypt.database;

import android.os.Handler;
import com.sqlcrypt.database.IContentObserver;

public abstract class ContentObserver {
    private Transport mTransport;
    private Object lock = new Object();
    Handler mHandler;

    public ContentObserver(Handler handler) {
        this.mHandler = handler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IContentObserver getContentObserver() {
        Object object = this.lock;
        synchronized (object) {
            if (this.mTransport == null) {
                this.mTransport = new Transport(this);
            }
            return this.mTransport;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IContentObserver releaseContentObserver() {
        Object object = this.lock;
        synchronized (object) {
            Transport oldTransport = this.mTransport;
            if (oldTransport != null) {
                oldTransport.releaseContentObserver();
                this.mTransport = null;
            }
            return oldTransport;
        }
    }

    public boolean deliverSelfNotifications() {
        return false;
    }

    public void onChange(boolean selfChange) {
    }

    public final void dispatchChange(boolean selfChange) {
        if (this.mHandler == null) {
            this.onChange(selfChange);
        } else {
            this.mHandler.post((Runnable)new NotificationRunnable(selfChange));
        }
    }

    private final class NotificationRunnable
    implements Runnable {
        private boolean mSelf;

        public NotificationRunnable(boolean self) {
            this.mSelf = self;
        }

        @Override
        public void run() {
            ContentObserver.this.onChange(this.mSelf);
        }
    }

    private static final class Transport
    extends IContentObserver.Stub {
        ContentObserver mContentObserver;

        public Transport(ContentObserver contentObserver) {
            this.mContentObserver = contentObserver;
        }

        public boolean deliverSelfNotifications() {
            ContentObserver contentObserver = this.mContentObserver;
            if (contentObserver != null) {
                return contentObserver.deliverSelfNotifications();
            }
            return false;
        }

        @Override
        public void onChange(boolean selfChange) {
            ContentObserver contentObserver = this.mContentObserver;
            if (contentObserver != null) {
                contentObserver.dispatchChange(selfChange);
            }
        }

        public void releaseContentObserver() {
            this.mContentObserver = null;
        }
    }
}

