/*
 * Decompiled with CFR 0.152.
 */
package com.sqlcrypt.database;

import android.os.Bundle;
import android.os.RemoteException;
import android.util.Log;
import com.sqlcrypt.database.AbstractCursor;
import com.sqlcrypt.database.AbstractWindowedCursor;
import com.sqlcrypt.database.IBulkCursor;
import com.sqlcrypt.database.IContentObserver;
import com.sqlcrypt.database.StaleDataException;

public final class BulkCursorToCursorAdaptor
extends AbstractWindowedCursor {
    private static final String TAG = "BulkCursor";
    private AbstractCursor.SelfContentObserver mObserverBridge = new AbstractCursor.SelfContentObserver(this);
    private IBulkCursor mBulkCursor;
    private int mCount;
    private String[] mColumns;
    private boolean mWantsAllOnMoveCalls;

    public void initialize(IBulkCursor bulkCursor, int count, int idIndex, boolean wantsAllOnMoveCalls) {
        this.mBulkCursor = bulkCursor;
        this.mColumns = null;
        this.mCount = count;
        this.mRowIdColumnIndex = idIndex;
        this.mWantsAllOnMoveCalls = wantsAllOnMoveCalls;
    }

    public static int findRowIdColumnIndex(String[] columnNames) {
        int length = columnNames.length;
        int i = 0;
        while (i < length) {
            if (columnNames[i].equals("_id")) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public IContentObserver getObserver() {
        return this.mObserverBridge.getContentObserver();
    }

    private void throwIfCursorIsClosed() {
        if (this.mBulkCursor == null) {
            throw new StaleDataException("Attempted to access a cursor after it has been closed.");
        }
    }

    @Override
    public int getCount() {
        this.throwIfCursorIsClosed();
        return this.mCount;
    }

    @Override
    public boolean onMove(int oldPosition, int newPosition) {
        this.throwIfCursorIsClosed();
        try {
            if (this.mWindow == null || newPosition < this.mWindow.getStartPosition() || newPosition >= this.mWindow.getStartPosition() + this.mWindow.getNumRows()) {
                this.setWindow(this.mBulkCursor.getWindow(newPosition));
            } else if (this.mWantsAllOnMoveCalls) {
                this.mBulkCursor.onMove(newPosition);
            }
        }
        catch (RemoteException ex) {
            Log.e((String)TAG, (String)"Unable to get window because the remote process is dead");
            return false;
        }
        return this.mWindow != null;
    }

    @Override
    public void deactivate() {
        super.deactivate();
        if (this.mBulkCursor != null) {
            try {
                this.mBulkCursor.deactivate();
            }
            catch (RemoteException ex) {
                Log.w((String)TAG, (String)"Remote process exception when deactivating");
            }
        }
    }

    @Override
    public void close() {
        super.close();
        if (this.mBulkCursor != null) {
            try {
                try {
                    this.mBulkCursor.close();
                }
                catch (RemoteException ex) {
                    Log.w((String)TAG, (String)"Remote process exception when closing");
                    this.mBulkCursor = null;
                }
            }
            finally {
                this.mBulkCursor = null;
            }
        }
    }

    @Override
    public boolean requery() {
        block3: {
            this.throwIfCursorIsClosed();
            try {
                this.mCount = this.mBulkCursor.requery(this.getObserver());
                if (this.mCount == -1) break block3;
                this.mPos = -1;
                this.closeWindow();
                super.requery();
                return true;
            }
            catch (Exception ex) {
                Log.e((String)TAG, (String)("Unable to requery because the remote process exception " + ex.getMessage()));
                this.deactivate();
                return false;
            }
        }
        this.deactivate();
        return false;
    }

    @Override
    public String[] getColumnNames() {
        this.throwIfCursorIsClosed();
        if (this.mColumns == null) {
            try {
                this.mColumns = this.mBulkCursor.getColumnNames();
            }
            catch (RemoteException ex) {
                Log.e((String)TAG, (String)"Unable to fetch column names because the remote process is dead");
                return null;
            }
        }
        return this.mColumns;
    }

    @Override
    public Bundle getExtras() {
        this.throwIfCursorIsClosed();
        try {
            return this.mBulkCursor.getExtras();
        }
        catch (RemoteException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Bundle respond(Bundle extras) {
        this.throwIfCursorIsClosed();
        try {
            return this.mBulkCursor.respond(extras);
        }
        catch (RemoteException e) {
            Log.w((String)TAG, (String)"respond() threw RemoteException, returning an empty bundle.", (Throwable)e);
            return Bundle.EMPTY;
        }
    }
}

