/*
 * Decompiled with CFR 0.152.
 */
package com.sqlcrypt.database;

import android.os.Bundle;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import com.sqlcrypt.database.CursorWindow;
import com.sqlcrypt.database.DatabaseUtils;
import com.sqlcrypt.database.IBulkCursor;
import com.sqlcrypt.database.IContentObserver;

final class BulkCursorProxy
implements IBulkCursor {
    private IBinder mRemote;
    private Bundle mExtras;

    public BulkCursorProxy(IBinder remote) {
        this.mRemote = remote;
        this.mExtras = null;
    }

    public IBinder asBinder() {
        return this.mRemote;
    }

    @Override
    public CursorWindow getWindow(int startPos) throws RemoteException {
        Parcel data = Parcel.obtain();
        Parcel reply = Parcel.obtain();
        try {
            data.writeInterfaceToken("android.content.IBulkCursor");
            data.writeInt(startPos);
            this.mRemote.transact(1, data, reply, 0);
            DatabaseUtils.readExceptionFromParcel(reply);
            CursorWindow window = null;
            if (reply.readInt() == 1) {
                window = CursorWindow.newFromParcel(reply);
            }
            CursorWindow cursorWindow = window;
            return cursorWindow;
        }
        finally {
            data.recycle();
            reply.recycle();
        }
    }

    @Override
    public void onMove(int position) throws RemoteException {
        Parcel data = Parcel.obtain();
        Parcel reply = Parcel.obtain();
        try {
            data.writeInterfaceToken("android.content.IBulkCursor");
            data.writeInt(position);
            this.mRemote.transact(8, data, reply, 0);
            DatabaseUtils.readExceptionFromParcel(reply);
        }
        finally {
            data.recycle();
            reply.recycle();
        }
    }

    @Override
    public int count() throws RemoteException {
        Parcel data = Parcel.obtain();
        Parcel reply = Parcel.obtain();
        try {
            data.writeInterfaceToken("android.content.IBulkCursor");
            boolean result = this.mRemote.transact(2, data, reply, 0);
            DatabaseUtils.readExceptionFromParcel(reply);
            int count = !result ? -1 : reply.readInt();
            int n = count;
            return n;
        }
        finally {
            data.recycle();
            reply.recycle();
        }
    }

    @Override
    public String[] getColumnNames() throws RemoteException {
        Parcel data = Parcel.obtain();
        Parcel reply = Parcel.obtain();
        try {
            data.writeInterfaceToken("android.content.IBulkCursor");
            this.mRemote.transact(3, data, reply, 0);
            DatabaseUtils.readExceptionFromParcel(reply);
            String[] columnNames = null;
            int numColumns = reply.readInt();
            columnNames = new String[numColumns];
            int i = 0;
            while (i < numColumns) {
                columnNames[i] = reply.readString();
                ++i;
            }
            String[] stringArray = columnNames;
            return stringArray;
        }
        finally {
            data.recycle();
            reply.recycle();
        }
    }

    @Override
    public void deactivate() throws RemoteException {
        Parcel data = Parcel.obtain();
        Parcel reply = Parcel.obtain();
        try {
            data.writeInterfaceToken("android.content.IBulkCursor");
            this.mRemote.transact(6, data, reply, 0);
            DatabaseUtils.readExceptionFromParcel(reply);
        }
        finally {
            data.recycle();
            reply.recycle();
        }
    }

    @Override
    public void close() throws RemoteException {
        Parcel data = Parcel.obtain();
        Parcel reply = Parcel.obtain();
        try {
            data.writeInterfaceToken("android.content.IBulkCursor");
            this.mRemote.transact(12, data, reply, 0);
            DatabaseUtils.readExceptionFromParcel(reply);
        }
        finally {
            data.recycle();
            reply.recycle();
        }
    }

    @Override
    public int requery(IContentObserver observer) throws RemoteException {
        Parcel data = Parcel.obtain();
        Parcel reply = Parcel.obtain();
        try {
            int count;
            data.writeInterfaceToken("android.content.IBulkCursor");
            data.writeStrongInterface((IInterface)observer);
            boolean result = this.mRemote.transact(7, data, reply, 0);
            DatabaseUtils.readExceptionFromParcel(reply);
            if (!result) {
                count = -1;
            } else {
                count = reply.readInt();
                this.mExtras = reply.readBundle();
            }
            int n = count;
            return n;
        }
        finally {
            data.recycle();
            reply.recycle();
        }
    }

    @Override
    public boolean getWantsAllOnMoveCalls() throws RemoteException {
        Parcel data = Parcel.obtain();
        Parcel reply = Parcel.obtain();
        try {
            data.writeInterfaceToken("android.content.IBulkCursor");
            this.mRemote.transact(9, data, reply, 0);
            DatabaseUtils.readExceptionFromParcel(reply);
            int result = reply.readInt();
            boolean bl = result != 0;
            return bl;
        }
        finally {
            data.recycle();
            reply.recycle();
        }
    }

    @Override
    public Bundle getExtras() throws RemoteException {
        if (this.mExtras == null) {
            Parcel data = Parcel.obtain();
            Parcel reply = Parcel.obtain();
            try {
                data.writeInterfaceToken("android.content.IBulkCursor");
                this.mRemote.transact(10, data, reply, 0);
                DatabaseUtils.readExceptionFromParcel(reply);
                this.mExtras = reply.readBundle();
            }
            finally {
                data.recycle();
                reply.recycle();
            }
        }
        return this.mExtras;
    }

    @Override
    public Bundle respond(Bundle extras) throws RemoteException {
        Parcel data = Parcel.obtain();
        Parcel reply = Parcel.obtain();
        try {
            Bundle returnExtras;
            data.writeInterfaceToken("android.content.IBulkCursor");
            data.writeBundle(extras);
            this.mRemote.transact(11, data, reply, 0);
            DatabaseUtils.readExceptionFromParcel(reply);
            Bundle bundle = returnExtras = reply.readBundle();
            return bundle;
        }
        finally {
            data.recycle();
            reply.recycle();
        }
    }
}

