/*
 * Decompiled with CFR 0.152.
 */
package com.sqlcrypt.database;

import android.os.Binder;
import android.os.Bundle;
import android.os.IBinder;
import android.os.Parcel;
import android.os.RemoteException;
import com.sqlcrypt.database.BulkCursorProxy;
import com.sqlcrypt.database.CursorWindow;
import com.sqlcrypt.database.DatabaseUtils;
import com.sqlcrypt.database.IBulkCursor;
import com.sqlcrypt.database.IContentObserver;

public abstract class BulkCursorNative
extends Binder
implements IBulkCursor {
    public BulkCursorNative() {
        this.attachInterface(this, "android.content.IBulkCursor");
    }

    public static IBulkCursor asInterface(IBinder obj) {
        if (obj == null) {
            return null;
        }
        IBulkCursor in = (IBulkCursor)obj.queryLocalInterface("android.content.IBulkCursor");
        if (in != null) {
            return in;
        }
        return new BulkCursorProxy(obj);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
        try {
            switch (code) {
                case 1: {
                    data.enforceInterface("android.content.IBulkCursor");
                    int startPos = data.readInt();
                    CursorWindow window = this.getWindow(startPos);
                    reply.writeNoException();
                    if (window == null) {
                        reply.writeInt(0);
                        return true;
                    }
                    reply.writeInt(1);
                    window.writeToParcel(reply, 1);
                    return true;
                }
                case 2: {
                    data.enforceInterface("android.content.IBulkCursor");
                    int count = this.count();
                    reply.writeNoException();
                    reply.writeInt(count);
                    return true;
                }
                case 3: {
                    data.enforceInterface("android.content.IBulkCursor");
                    String[] columnNames = this.getColumnNames();
                    reply.writeNoException();
                    reply.writeInt(columnNames.length);
                    int length = columnNames.length;
                    int i = 0;
                    while (true) {
                        if (i >= length) {
                            return true;
                        }
                        reply.writeString(columnNames[i]);
                        ++i;
                    }
                }
                case 6: {
                    data.enforceInterface("android.content.IBulkCursor");
                    this.deactivate();
                    reply.writeNoException();
                    return true;
                }
                case 12: {
                    data.enforceInterface("android.content.IBulkCursor");
                    this.close();
                    reply.writeNoException();
                    return true;
                }
                case 7: {
                    data.enforceInterface("android.content.IBulkCursor");
                    IContentObserver observer = IContentObserver.Stub.asInterface(data.readStrongBinder());
                    int count = this.requery(observer);
                    reply.writeNoException();
                    reply.writeInt(count);
                    reply.writeBundle(this.getExtras());
                    return true;
                }
                case 8: {
                    data.enforceInterface("android.content.IBulkCursor");
                    int position = data.readInt();
                    this.onMove(position);
                    reply.writeNoException();
                    return true;
                }
                case 9: {
                    data.enforceInterface("android.content.IBulkCursor");
                    boolean result = this.getWantsAllOnMoveCalls();
                    reply.writeNoException();
                    reply.writeInt(result ? 1 : 0);
                    return true;
                }
                case 10: {
                    data.enforceInterface("android.content.IBulkCursor");
                    Bundle extras = this.getExtras();
                    reply.writeNoException();
                    reply.writeBundle(extras);
                    return true;
                }
                case 11: {
                    data.enforceInterface("android.content.IBulkCursor");
                    Bundle extras = data.readBundle();
                    Bundle returnExtras = this.respond(extras);
                    reply.writeNoException();
                    reply.writeBundle(returnExtras);
                    return true;
                }
            }
            return super.onTransact(code, data, reply, flags);
        }
        catch (Exception e) {
            DatabaseUtils.writeExceptionToParcel(reply, e);
            return true;
        }
    }

    public IBinder asBinder() {
        return this;
    }
}

