/*
 * Decompiled with CFR 0.152.
 */
package com.sqlcrypt.database;

import android.content.Context;
import android.content.SharedPreferences;
import android.content.res.AssetManager;
import android.util.Log;
import com.sqlcrypt.database.sqlite.SQLiteDatabase;
import com.sqlcrypt.database.sqlite.SQLiteDebug;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class AssetsDatabaseManager {
    private static final String TAG = "AssetsDatabase";
    private final String DATABASE_DIR = "data";
    private final String databasepath;
    private Map<String, SQLiteDatabase> databases = new HashMap<String, SQLiteDatabase>();
    private Context context = null;
    private static AssetsDatabaseManager mInstance = null;

    public static void initManager(Context context) {
        if (mInstance == null) {
            mInstance = new AssetsDatabaseManager(context);
        }
    }

    public static AssetsDatabaseManager getManager() {
        if (mInstance == null) {
            throw new NullPointerException("Please first setup initManager(Context)");
        }
        return mInstance;
    }

    private AssetsDatabaseManager(Context context) {
        this.context = context;
        File datafile = new File(context.getFilesDir(), "data");
        this.databasepath = datafile.getAbsolutePath();
    }

    public SQLiteDatabase getDatabase(String dbfile, String passwd) {
        SQLiteDatabase db = this.databases.get(dbfile);
        if (db != null && db.isOpen()) {
            if (SQLiteDebug.isDebug) {
                Log.i((String)TAG, (String)String.format("Return a database copy of %s", dbfile));
            }
            return this.databases.get(dbfile);
        }
        if (this.context == null) {
            return null;
        }
        if (SQLiteDebug.isDebug) {
            Log.i((String)TAG, (String)String.format("Create database %s", dbfile));
        }
        String spath = this.databasepath;
        String sfile = this.getDatabaseFile(dbfile);
        File file = new File(sfile);
        SharedPreferences dbs = this.context.getSharedPreferences(AssetsDatabaseManager.class.toString(), 0);
        boolean flag = dbs.getBoolean(dbfile, false);
        if (!flag || !file.exists()) {
            file = new File(spath);
            if (!file.exists() && !file.mkdirs()) {
                if (SQLiteDebug.isDebug) {
                    Log.i((String)TAG, (String)("Create \"" + spath + "\" fail!"));
                }
                return null;
            }
            if (!this.copyAssetsToFilesystem(dbfile, sfile)) {
                if (SQLiteDebug.isDebug) {
                    Log.i((String)TAG, (String)String.format("Copy %s to %s fail!", dbfile, sfile));
                }
                return null;
            }
            dbs.edit().putBoolean(dbfile, true).commit();
        }
        if ((db = SQLiteDatabase.openDatabase(sfile, passwd, null, 16)) != null) {
            this.databases.put(dbfile, db);
        }
        return db;
    }

    public SQLiteDatabase getDatabase(String dbfile) {
        SQLiteDatabase db = this.databases.get(dbfile);
        if (db != null && db.isOpen()) {
            if (SQLiteDebug.isDebug) {
                Log.i((String)TAG, (String)String.format("Return a database copy of %s", dbfile));
            }
            return this.databases.get(dbfile);
        }
        return null;
    }

    private String getDatabaseFile(String dbfile) {
        return String.valueOf(this.databasepath) + "/" + dbfile;
    }

    private boolean copyAssetsToFilesystem(String assetsSrc, String des) {
        if (SQLiteDebug.isDebug) {
            Log.i((String)TAG, (String)("Copy " + assetsSrc + " to " + des));
        }
        InputStream istream = null;
        OutputStream ostream = null;
        try {
            int length;
            AssetManager am = this.context.getAssets();
            istream = am.open(assetsSrc);
            ostream = new FileOutputStream(des);
            byte[] buffer = new byte[65536];
            while ((length = istream.read(buffer)) > 0) {
                ostream.write(buffer, 0, length);
            }
            istream.close();
            ostream.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            try {
                if (istream != null) {
                    istream.close();
                }
                if (ostream != null) {
                    ostream.close();
                }
            }
            catch (Exception ee) {
                ee.printStackTrace();
            }
            return false;
        }
        return true;
    }

    public boolean closeDatabase(String dbfile) {
        if (this.databases.get(dbfile) != null) {
            SQLiteDatabase db = this.databases.get(dbfile);
            db.close();
            this.databases.remove(dbfile);
            return true;
        }
        return false;
    }

    public static void closeAllDatabase() {
        if (SQLiteDebug.isDebug) {
            Log.i((String)TAG, (String)"closeAllDatabase");
        }
        if (mInstance != null) {
            Set<String> set = AssetsDatabaseManager.mInstance.databases.keySet();
            Iterator<String> iterator = set.iterator();
            while (iterator.hasNext()) {
                String key = iterator.next();
                SQLiteDatabase db = AssetsDatabaseManager.mInstance.databases.get(key);
                if (db.isOpen()) {
                    db.close();
                }
                iterator.remove();
            }
        }
    }
}

