/*
 * Decompiled with CFR 0.152.
 */
package com.sqlcrypt.database;

import android.content.ContentResolver;
import android.net.Uri;
import android.os.Bundle;
import android.util.Log;
import com.sqlcrypt.database.CharArrayBuffer;
import com.sqlcrypt.database.ContentObservable;
import com.sqlcrypt.database.ContentObserver;
import com.sqlcrypt.database.CrossProcessCursor;
import com.sqlcrypt.database.CursorIndexOutOfBoundsException;
import com.sqlcrypt.database.CursorWindow;
import com.sqlcrypt.database.DataSetObservable;
import com.sqlcrypt.database.DataSetObserver;
import com.sqlcrypt.database.DatabaseUtils;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;

public abstract class AbstractCursor
implements CrossProcessCursor {
    private static final String TAG = "Cursor";
    DataSetObservable mDataSetObservable = new DataSetObservable();
    ContentObservable mContentObservable = new ContentObservable();
    Bundle mExtras = Bundle.EMPTY;
    @Deprecated
    protected HashMap<Long, Map<String, Object>> mUpdatedRows;
    protected int mRowIdColumnIndex = -1;
    protected int mPos = -1;
    protected Long mCurrentRowID = null;
    protected ContentResolver mContentResolver;
    protected boolean mClosed = false;
    private Uri mNotifyUri;
    private ContentObserver mSelfObserver;
    private final Object mSelfObserverLock = new Object();
    private boolean mSelfObserverRegistered;

    @Override
    public abstract int getCount();

    @Override
    public abstract String[] getColumnNames();

    @Override
    public abstract String getString(int var1);

    @Override
    public abstract short getShort(int var1);

    @Override
    public abstract int getInt(int var1);

    @Override
    public abstract long getLong(int var1);

    @Override
    public abstract float getFloat(int var1);

    @Override
    public abstract double getDouble(int var1);

    @Override
    public abstract boolean isNull(int var1);

    @Override
    public int getType(int column) {
        return 3;
    }

    @Override
    public byte[] getBlob(int column) {
        throw new UnsupportedOperationException("getBlob is not supported");
    }

    @Override
    public CursorWindow getWindow() {
        return null;
    }

    @Override
    public int getColumnCount() {
        return this.getColumnNames().length;
    }

    @Override
    public void deactivate() {
        this.onDeactivateOrClose();
    }

    protected void onDeactivateOrClose() {
        if (this.mSelfObserver != null) {
            this.mSelfObserverRegistered = false;
        }
        this.mDataSetObservable.notifyInvalidated();
    }

    @Override
    public boolean requery() {
        if (this.mSelfObserver != null && !this.mSelfObserverRegistered) {
            this.mSelfObserverRegistered = true;
        }
        this.mDataSetObservable.notifyChanged();
        return true;
    }

    @Override
    public boolean isClosed() {
        return this.mClosed;
    }

    @Override
    public void close() {
        this.mClosed = true;
        this.mContentObservable.unregisterAll();
        this.onDeactivateOrClose();
    }

    @Override
    public boolean onMove(int oldPosition, int newPosition) {
        return true;
    }

    @Override
    public void copyStringToBuffer(int columnIndex, CharArrayBuffer buffer) {
        String result = this.getString(columnIndex);
        if (result != null) {
            char[] data = buffer.data;
            if (data == null || data.length < result.length()) {
                buffer.data = result.toCharArray();
            } else {
                result.getChars(0, result.length(), data, 0);
            }
            buffer.sizeCopied = result.length();
        } else {
            buffer.sizeCopied = 0;
        }
    }

    public AbstractCursor() {
        this.mUpdatedRows = new HashMap();
    }

    @Override
    public final int getPosition() {
        return this.mPos;
    }

    @Override
    public final boolean moveToPosition(int position) {
        int count = this.getCount();
        if (position >= count) {
            this.mPos = count;
            return false;
        }
        if (position < 0) {
            this.mPos = -1;
            return false;
        }
        if (position == this.mPos) {
            return true;
        }
        boolean result = this.onMove(this.mPos, position);
        if (!result) {
            this.mPos = -1;
        } else {
            this.mPos = position;
            if (this.mRowIdColumnIndex != -1) {
                this.mCurrentRowID = this.getLong(this.mRowIdColumnIndex);
            }
        }
        return result;
    }

    @Override
    public void fillWindow(int position, CursorWindow window) {
        DatabaseUtils.cursorFillWindow(this, position, window);
    }

    @Override
    public final boolean move(int offset) {
        return this.moveToPosition(this.mPos + offset);
    }

    @Override
    public final boolean moveToFirst() {
        return this.moveToPosition(0);
    }

    @Override
    public final boolean moveToLast() {
        return this.moveToPosition(this.getCount() - 1);
    }

    @Override
    public final boolean moveToNext() {
        return this.moveToPosition(this.mPos + 1);
    }

    @Override
    public final boolean moveToPrevious() {
        return this.moveToPosition(this.mPos - 1);
    }

    @Override
    public final boolean isFirst() {
        return this.mPos == 0 && this.getCount() != 0;
    }

    @Override
    public final boolean isLast() {
        int cnt = this.getCount();
        return this.mPos == cnt - 1 && cnt != 0;
    }

    @Override
    public final boolean isBeforeFirst() {
        if (this.getCount() == 0) {
            return true;
        }
        return this.mPos == -1;
    }

    @Override
    public final boolean isAfterLast() {
        if (this.getCount() == 0) {
            return true;
        }
        return this.mPos == this.getCount();
    }

    @Override
    public int getColumnIndex(String columnName) {
        int periodIndex = columnName.lastIndexOf(46);
        if (periodIndex != -1) {
            Exception e = new Exception();
            Log.e((String)TAG, (String)("requesting column name with table name -- " + columnName), (Throwable)e);
            columnName = columnName.substring(periodIndex + 1);
        }
        String[] columnNames = this.getColumnNames();
        int length = columnNames.length;
        int i = 0;
        while (i < length) {
            if (columnNames[i].equalsIgnoreCase(columnName)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    @Override
    public int getColumnIndexOrThrow(String columnName) {
        int index = this.getColumnIndex(columnName);
        if (index < 0) {
            throw new IllegalArgumentException("column '" + columnName + "' does not exist");
        }
        return index;
    }

    @Override
    public String getColumnName(int columnIndex) {
        return this.getColumnNames()[columnIndex];
    }

    @Override
    public void registerContentObserver(ContentObserver observer) {
        this.mContentObservable.registerObserver(observer);
    }

    @Override
    public void unregisterContentObserver(ContentObserver observer) {
        if (!this.mClosed) {
            this.mContentObservable.unregisterObserver(observer);
        }
    }

    protected void notifyDataSetChange() {
        this.mDataSetObservable.notifyChanged();
    }

    protected DataSetObservable getDataSetObservable() {
        return this.mDataSetObservable;
    }

    @Override
    public void registerDataSetObserver(DataSetObserver observer) {
        this.mDataSetObservable.registerObserver(observer);
    }

    @Override
    public void unregisterDataSetObserver(DataSetObserver observer) {
        this.mDataSetObservable.unregisterObserver(observer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onChange(boolean selfChange) {
        Object object = this.mSelfObserverLock;
        synchronized (object) {
            this.mContentObservable.dispatchChange(selfChange);
            if (this.mNotifyUri != null) {
                // empty if block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setNotificationUri(ContentResolver cr, Uri notifyUri) {
        Object object = this.mSelfObserverLock;
        synchronized (object) {
            this.mNotifyUri = notifyUri;
            this.mContentResolver = cr;
            this.mSelfObserver = new SelfContentObserver(this);
            this.mSelfObserverRegistered = true;
        }
    }

    public Uri getNotificationUri() {
        return this.mNotifyUri;
    }

    @Override
    public boolean getWantsAllOnMoveCalls() {
        return false;
    }

    public void setExtras(Bundle extras) {
        this.mExtras = extras == null ? Bundle.EMPTY : extras;
    }

    @Override
    public Bundle getExtras() {
        return this.mExtras;
    }

    @Override
    public Bundle respond(Bundle extras) {
        return Bundle.EMPTY;
    }

    @Deprecated
    protected boolean isFieldUpdated(int columnIndex) {
        return false;
    }

    @Deprecated
    protected Object getUpdatedField(int columnIndex) {
        return null;
    }

    protected void checkPosition() {
        if (-1 == this.mPos || this.getCount() == this.mPos) {
            throw new CursorIndexOutOfBoundsException(this.mPos, this.getCount());
        }
    }

    protected void finalize() {
        if (this.mSelfObserver != null) {
            // empty if block
        }
    }

    protected static class SelfContentObserver
    extends ContentObserver {
        WeakReference<AbstractCursor> mCursor;

        public SelfContentObserver(AbstractCursor cursor) {
            super(null);
            this.mCursor = new WeakReference<AbstractCursor>(cursor);
        }

        @Override
        public boolean deliverSelfNotifications() {
            return false;
        }

        @Override
        public void onChange(boolean selfChange) {
            AbstractCursor cursor = (AbstractCursor)this.mCursor.get();
            if (cursor != null) {
                cursor.onChange(false);
            }
        }
    }
}

