/*
 * Decompiled with CFR 0.152.
 */
package org.keplerproject.luajava;

import org.keplerproject.luajava.CPtr;
import org.keplerproject.luajava.JavaFunction;
import org.keplerproject.luajava.LuaException;
import org.keplerproject.luajava.LuaObject;
import org.keplerproject.luajava.LuaStateFactory;

public class LuaState {
    private static final String LUAJAVA_LIB = "luajava";
    public static final Integer LUA_GLOBALSINDEX = new Integer(-10002);
    public static final Integer LUA_REGISTRYINDEX = new Integer(-10000);
    public static final Integer LUA_TNONE = new Integer(-1);
    public static final Integer LUA_TNIL = new Integer(0);
    public static final Integer LUA_TBOOLEAN = new Integer(1);
    public static final Integer LUA_TLIGHTUSERDATA = new Integer(2);
    public static final Integer LUA_TNUMBER = new Integer(3);
    public static final Integer LUA_TSTRING = new Integer(4);
    public static final Integer LUA_TTABLE = new Integer(5);
    public static final Integer LUA_TFUNCTION = new Integer(6);
    public static final Integer LUA_TUSERDATA = new Integer(7);
    public static final Integer LUA_TTHREAD = new Integer(8);
    public static final Integer LUA_MULTRET = new Integer(-1);
    public static final Integer LUA_ERRRUN = new Integer(1);
    public static final Integer LUA_YIELD = new Integer(2);
    public static final Integer LUA_ERRSYNTAX = new Integer(3);
    public static final Integer LUA_ERRMEM = new Integer(4);
    public static final Integer LUA_ERRERR = new Integer(5);
    private CPtr luaState;
    private int stateId;
    public static final Integer LUA_GCSTOP;
    public static final Integer LUA_GCRESTART;
    public static final Integer LUA_GCCOLLECT;
    public static final Integer LUA_GCCOUNT;
    public static final Integer LUA_GCCOUNTB;
    public static final Integer LUA_GCSTEP;
    public static final Integer LUA_GCSETPAUSE;
    public static final Integer LUA_GCSETSTEPMUL;

    static {
        System.loadLibrary(LUAJAVA_LIB);
        LUA_GCSTOP = new Integer(0);
        LUA_GCRESTART = new Integer(1);
        LUA_GCCOLLECT = new Integer(2);
        LUA_GCCOUNT = new Integer(3);
        LUA_GCCOUNTB = new Integer(4);
        LUA_GCSTEP = new Integer(5);
        LUA_GCSETPAUSE = new Integer(6);
        LUA_GCSETSTEPMUL = new Integer(7);
    }

    protected LuaState(int stateId) {
        this.luaState = this._open();
        this.luajava_open(this.luaState, stateId);
        this.stateId = stateId;
    }

    protected LuaState(CPtr luaState) {
        this.luaState = luaState;
        this.stateId = LuaStateFactory.insertLuaState(this);
        this.luajava_open(luaState, this.stateId);
    }

    public synchronized void close() {
        LuaStateFactory.removeLuaState(this.stateId);
        this._close(this.luaState);
        this.luaState = null;
    }

    public synchronized boolean isClosed() {
        return this.luaState == null;
    }

    public long getCPtrPeer() {
        return this.luaState != null ? this.luaState.getPeer() : 0L;
    }

    private synchronized native CPtr _open();

    private synchronized native void _close(CPtr var1);

    private synchronized native CPtr _newthread(CPtr var1);

    private synchronized native int _getTop(CPtr var1);

    private synchronized native void _setTop(CPtr var1, int var2);

    private synchronized native void _pushValue(CPtr var1, int var2);

    private synchronized native void _remove(CPtr var1, int var2);

    private synchronized native void _insert(CPtr var1, int var2);

    private synchronized native void _replace(CPtr var1, int var2);

    private synchronized native int _checkStack(CPtr var1, int var2);

    private synchronized native void _xmove(CPtr var1, CPtr var2, int var3);

    private synchronized native int _isNumber(CPtr var1, int var2);

    private synchronized native int _isString(CPtr var1, int var2);

    private synchronized native int _isCFunction(CPtr var1, int var2);

    private synchronized native int _isUserdata(CPtr var1, int var2);

    private synchronized native int _type(CPtr var1, int var2);

    private synchronized native String _typeName(CPtr var1, int var2);

    private synchronized native int _equal(CPtr var1, int var2, int var3);

    private synchronized native int _rawequal(CPtr var1, int var2, int var3);

    private synchronized native int _lessthan(CPtr var1, int var2, int var3);

    private synchronized native double _toNumber(CPtr var1, int var2);

    private synchronized native int _toInteger(CPtr var1, int var2);

    private synchronized native int _toBoolean(CPtr var1, int var2);

    private synchronized native String _toString(CPtr var1, int var2);

    private synchronized native int _objlen(CPtr var1, int var2);

    private synchronized native CPtr _toThread(CPtr var1, int var2);

    private synchronized native void _pushNil(CPtr var1);

    private synchronized native void _pushNumber(CPtr var1, double var2);

    private synchronized native void _pushInteger(CPtr var1, int var2);

    private synchronized native void _pushString(CPtr var1, String var2);

    private synchronized native void _pushString(CPtr var1, byte[] var2, int var3);

    private synchronized native void _pushBoolean(CPtr var1, int var2);

    private synchronized native void _getTable(CPtr var1, int var2);

    private synchronized native void _getField(CPtr var1, int var2, String var3);

    private synchronized native void _rawGet(CPtr var1, int var2);

    private synchronized native void _rawGetI(CPtr var1, int var2, int var3);

    private synchronized native void _createTable(CPtr var1, int var2, int var3);

    private synchronized native int _getMetaTable(CPtr var1, int var2);

    private synchronized native void _getFEnv(CPtr var1, int var2);

    private synchronized native void _setTable(CPtr var1, int var2);

    private synchronized native void _setField(CPtr var1, int var2, String var3);

    private synchronized native void _rawSet(CPtr var1, int var2);

    private synchronized native void _rawSetI(CPtr var1, int var2, int var3);

    private synchronized native int _setMetaTable(CPtr var1, int var2);

    private synchronized native int _setFEnv(CPtr var1, int var2);

    private synchronized native void _call(CPtr var1, int var2, int var3);

    private synchronized native int _pcall(CPtr var1, int var2, int var3, int var4);

    private synchronized native int _yield(CPtr var1, int var2);

    private synchronized native int _resume(CPtr var1, int var2);

    private synchronized native int _status(CPtr var1);

    private synchronized native int _gc(CPtr var1, int var2, int var3);

    private synchronized native int _error(CPtr var1);

    private synchronized native int _next(CPtr var1, int var2);

    private synchronized native void _concat(CPtr var1, int var2);

    private synchronized native void _pop(CPtr var1, int var2);

    private synchronized native void _newTable(CPtr var1);

    private synchronized native int _strlen(CPtr var1, int var2);

    private synchronized native int _isFunction(CPtr var1, int var2);

    private synchronized native int _isTable(CPtr var1, int var2);

    private synchronized native int _isNil(CPtr var1, int var2);

    private synchronized native int _isBoolean(CPtr var1, int var2);

    private synchronized native int _isThread(CPtr var1, int var2);

    private synchronized native int _isNone(CPtr var1, int var2);

    private synchronized native int _isNoneOrNil(CPtr var1, int var2);

    private synchronized native void _setGlobal(CPtr var1, String var2);

    private synchronized native void _getGlobal(CPtr var1, String var2);

    private synchronized native int _getGcCount(CPtr var1);

    private synchronized native int _LdoFile(CPtr var1, String var2);

    private synchronized native int _LdoString(CPtr var1, String var2);

    private synchronized native int _LgetMetaField(CPtr var1, int var2, String var3);

    private synchronized native int _LcallMeta(CPtr var1, int var2, String var3);

    private synchronized native int _Ltyperror(CPtr var1, int var2, String var3);

    private synchronized native int _LargError(CPtr var1, int var2, String var3);

    private synchronized native String _LcheckString(CPtr var1, int var2);

    private synchronized native String _LoptString(CPtr var1, int var2, String var3);

    private synchronized native double _LcheckNumber(CPtr var1, int var2);

    private synchronized native double _LoptNumber(CPtr var1, int var2, double var3);

    private synchronized native int _LcheckInteger(CPtr var1, int var2);

    private synchronized native int _LoptInteger(CPtr var1, int var2, int var3);

    private synchronized native void _LcheckStack(CPtr var1, int var2, String var3);

    private synchronized native void _LcheckType(CPtr var1, int var2, int var3);

    private synchronized native void _LcheckAny(CPtr var1, int var2);

    private synchronized native int _LnewMetatable(CPtr var1, String var2);

    private synchronized native void _LgetMetatable(CPtr var1, String var2);

    private synchronized native void _Lwhere(CPtr var1, int var2);

    private synchronized native int _Lref(CPtr var1, int var2);

    private synchronized native void _LunRef(CPtr var1, int var2, int var3);

    private synchronized native int _LgetN(CPtr var1, int var2);

    private synchronized native void _LsetN(CPtr var1, int var2, int var3);

    private synchronized native int _LloadFile(CPtr var1, String var2);

    private synchronized native int _LloadBuffer(CPtr var1, byte[] var2, long var3, String var5);

    private synchronized native int _LloadString(CPtr var1, String var2);

    private synchronized native String _Lgsub(CPtr var1, String var2, String var3, String var4);

    private synchronized native String _LfindTable(CPtr var1, int var2, String var3, int var4);

    private synchronized native void _openBase(CPtr var1);

    private synchronized native void _openTable(CPtr var1);

    private synchronized native void _openIo(CPtr var1);

    private synchronized native void _openOs(CPtr var1);

    private synchronized native void _openString(CPtr var1);

    private synchronized native void _openMath(CPtr var1);

    private synchronized native void _openDebug(CPtr var1);

    private synchronized native void _openPackage(CPtr var1);

    private synchronized native void _openLibs(CPtr var1);

    public LuaState newThread() {
        LuaState l = new LuaState(this._newthread(this.luaState));
        LuaStateFactory.insertLuaState(l);
        return l;
    }

    public int getTop() {
        return this._getTop(this.luaState);
    }

    public void setTop(int idx) {
        this._setTop(this.luaState, idx);
    }

    public void pushValue(int idx) {
        this._pushValue(this.luaState, idx);
    }

    public void remove(int idx) {
        this._remove(this.luaState, idx);
    }

    public void insert(int idx) {
        this._insert(this.luaState, idx);
    }

    public void replace(int idx) {
        this._replace(this.luaState, idx);
    }

    public int checkStack(int sz) {
        return this._checkStack(this.luaState, sz);
    }

    public void xmove(LuaState to, int n) {
        this._xmove(this.luaState, to.luaState, n);
    }

    public boolean isNumber(int idx) {
        return this._isNumber(this.luaState, idx) != 0;
    }

    public boolean isString(int idx) {
        return this._isString(this.luaState, idx) != 0;
    }

    public boolean isFunction(int idx) {
        return this._isFunction(this.luaState, idx) != 0;
    }

    public boolean isCFunction(int idx) {
        return this._isCFunction(this.luaState, idx) != 0;
    }

    public boolean isUserdata(int idx) {
        return this._isUserdata(this.luaState, idx) != 0;
    }

    public boolean isTable(int idx) {
        return this._isTable(this.luaState, idx) != 0;
    }

    public boolean isBoolean(int idx) {
        return this._isBoolean(this.luaState, idx) != 0;
    }

    public boolean isNil(int idx) {
        return this._isNil(this.luaState, idx) != 0;
    }

    public boolean isThread(int idx) {
        return this._isThread(this.luaState, idx) != 0;
    }

    public boolean isNone(int idx) {
        return this._isNone(this.luaState, idx) != 0;
    }

    public boolean isNoneOrNil(int idx) {
        return this._isNoneOrNil(this.luaState, idx) != 0;
    }

    public int type(int idx) {
        return this._type(this.luaState, idx);
    }

    public String typeName(int tp) {
        return this._typeName(this.luaState, tp);
    }

    public int equal(int idx1, int idx2) {
        return this._equal(this.luaState, idx1, idx2);
    }

    public int rawequal(int idx1, int idx2) {
        return this._rawequal(this.luaState, idx1, idx2);
    }

    public int lessthan(int idx1, int idx2) {
        return this._lessthan(this.luaState, idx1, idx2);
    }

    public double toNumber(int idx) {
        return this._toNumber(this.luaState, idx);
    }

    public int toInteger(int idx) {
        return this._toInteger(this.luaState, idx);
    }

    public boolean toBoolean(int idx) {
        return this._toBoolean(this.luaState, idx) != 0;
    }

    public String toString(int idx) {
        return this._toString(this.luaState, idx);
    }

    public int strLen(int idx) {
        return this._strlen(this.luaState, idx);
    }

    public int objLen(int idx) {
        return this._objlen(this.luaState, idx);
    }

    public LuaState toThread(int idx) {
        return new LuaState(this._toThread(this.luaState, idx));
    }

    public void pushNil() {
        this._pushNil(this.luaState);
    }

    public void pushNumber(double db) {
        this._pushNumber(this.luaState, db);
    }

    public void pushInteger(int integer) {
        this._pushInteger(this.luaState, integer);
    }

    public void pushString(String str) {
        if (str == null) {
            this._pushNil(this.luaState);
        } else {
            this._pushString(this.luaState, str);
        }
    }

    public void pushString(byte[] bytes) {
        if (bytes == null) {
            this._pushNil(this.luaState);
        } else {
            this._pushString(this.luaState, bytes, bytes.length);
        }
    }

    public void pushBoolean(boolean bool) {
        this._pushBoolean(this.luaState, bool ? 1 : 0);
    }

    public void getTable(int idx) {
        this._getTable(this.luaState, idx);
    }

    public void getField(int idx, String k) {
        this._getField(this.luaState, idx, k);
    }

    public void rawGet(int idx) {
        this._rawGet(this.luaState, idx);
    }

    public void rawGetI(int idx, int n) {
        this._rawGetI(this.luaState, idx, n);
    }

    public void createTable(int narr, int nrec) {
        this._createTable(this.luaState, narr, nrec);
    }

    public void newTable() {
        this._newTable(this.luaState);
    }

    public int getMetaTable(int idx) {
        return this._getMetaTable(this.luaState, idx);
    }

    public void getFEnv(int idx) {
        this._getFEnv(this.luaState, idx);
    }

    public void setTable(int idx) {
        this._setTable(this.luaState, idx);
    }

    public void setField(int idx, String k) {
        this._setField(this.luaState, idx, k);
    }

    public void rawSet(int idx) {
        this._rawSet(this.luaState, idx);
    }

    public void rawSetI(int idx, int n) {
        this._rawSetI(this.luaState, idx, n);
    }

    public int setMetaTable(int idx) {
        return this._setMetaTable(this.luaState, idx);
    }

    public int setFEnv(int idx) {
        return this._setFEnv(this.luaState, idx);
    }

    public void call(int nArgs, int nResults) {
        this._call(this.luaState, nArgs, nResults);
    }

    public int pcall(int nArgs, int nResults, int errFunc) {
        return this._pcall(this.luaState, nArgs, nResults, errFunc);
    }

    public int yield(int nResults) {
        return this._yield(this.luaState, nResults);
    }

    public int resume(int nArgs) {
        return this._resume(this.luaState, nArgs);
    }

    public int status() {
        return this._status(this.luaState);
    }

    public int gc(int what, int data) {
        return this._gc(this.luaState, what, data);
    }

    public int getGcCount() {
        return this._getGcCount(this.luaState);
    }

    public int next(int idx) {
        return this._next(this.luaState, idx);
    }

    public int error() {
        return this._error(this.luaState);
    }

    public void concat(int n) {
        this._concat(this.luaState, n);
    }

    public int LdoFile(String fileName) {
        return this._LdoFile(this.luaState, fileName);
    }

    public int LdoString(String str) {
        return this._LdoString(this.luaState, str);
    }

    public int LgetMetaField(int obj, String e) {
        return this._LgetMetaField(this.luaState, obj, e);
    }

    public int LcallMeta(int obj, String e) {
        return this._LcallMeta(this.luaState, obj, e);
    }

    public int Ltyperror(int nArg, String tName) {
        return this._Ltyperror(this.luaState, nArg, tName);
    }

    public int LargError(int numArg, String extraMsg) {
        return this._LargError(this.luaState, numArg, extraMsg);
    }

    public String LcheckString(int numArg) {
        return this._LcheckString(this.luaState, numArg);
    }

    public String LoptString(int numArg, String def) {
        return this._LoptString(this.luaState, numArg, def);
    }

    public double LcheckNumber(int numArg) {
        return this._LcheckNumber(this.luaState, numArg);
    }

    public double LoptNumber(int numArg, double def) {
        return this._LoptNumber(this.luaState, numArg, def);
    }

    public int LcheckInteger(int numArg) {
        return this._LcheckInteger(this.luaState, numArg);
    }

    public int LoptInteger(int numArg, int def) {
        return this._LoptInteger(this.luaState, numArg, def);
    }

    public void LcheckStack(int sz, String msg) {
        this._LcheckStack(this.luaState, sz, msg);
    }

    public void LcheckType(int nArg, int t) {
        this._LcheckType(this.luaState, nArg, t);
    }

    public void LcheckAny(int nArg) {
        this._LcheckAny(this.luaState, nArg);
    }

    public int LnewMetatable(String tName) {
        return this._LnewMetatable(this.luaState, tName);
    }

    public void LgetMetatable(String tName) {
        this._LgetMetatable(this.luaState, tName);
    }

    public void Lwhere(int lvl) {
        this._Lwhere(this.luaState, lvl);
    }

    public int Lref(int t) {
        return this._Lref(this.luaState, t);
    }

    public void LunRef(int t, int ref) {
        this._LunRef(this.luaState, t, ref);
    }

    public int LgetN(int t) {
        return this._LgetN(this.luaState, t);
    }

    public void LsetN(int t, int n) {
        this._LsetN(this.luaState, t, n);
    }

    public int LloadFile(String fileName) {
        return this._LloadFile(this.luaState, fileName);
    }

    public int LloadString(String s) {
        return this._LloadString(this.luaState, s);
    }

    public int LloadBuffer(byte[] buff, String name) {
        return this._LloadBuffer(this.luaState, buff, buff.length, name);
    }

    public String Lgsub(String s, String p, String r) {
        return this._Lgsub(this.luaState, s, p, r);
    }

    public String LfindTable(int idx, String fname, int szhint) {
        return this._LfindTable(this.luaState, idx, fname, szhint);
    }

    public void pop(int n) {
        this._pop(this.luaState, n);
    }

    public synchronized void getGlobal(String global) {
        this._getGlobal(this.luaState, global);
    }

    public synchronized void setGlobal(String name) {
        this._setGlobal(this.luaState, name);
    }

    public void openBase() {
        this._openBase(this.luaState);
    }

    public void openTable() {
        this._openTable(this.luaState);
    }

    public void openIo() {
        this._openIo(this.luaState);
    }

    public void openOs() {
        this._openOs(this.luaState);
    }

    public void openString() {
        this._openString(this.luaState);
    }

    public void openMath() {
        this._openMath(this.luaState);
    }

    public void openDebug() {
        this._openDebug(this.luaState);
    }

    public void openPackage() {
        this._openPackage(this.luaState);
    }

    public void openLibs() {
        this._openLibs(this.luaState);
    }

    private synchronized native void luajava_open(CPtr var1, int var2);

    private synchronized native Object _getObjectFromUserdata(CPtr var1, int var2) throws LuaException;

    private synchronized native boolean _isObject(CPtr var1, int var2);

    private synchronized native void _pushJavaObject(CPtr var1, Object var2);

    private synchronized native void _pushJavaFunction(CPtr var1, JavaFunction var2) throws LuaException;

    private synchronized native boolean _isJavaFunction(CPtr var1, int var2);

    public Object getObjectFromUserdata(int idx) throws LuaException {
        return this._getObjectFromUserdata(this.luaState, idx);
    }

    public boolean isObject(int idx) {
        return this._isObject(this.luaState, idx);
    }

    public void pushJavaObject(Object obj) {
        this._pushJavaObject(this.luaState, obj);
    }

    public void pushJavaFunction(JavaFunction func) throws LuaException {
        this._pushJavaFunction(this.luaState, func);
    }

    public boolean isJavaFunction(int idx) {
        return this._isJavaFunction(this.luaState, idx);
    }

    public void pushObjectValue(Object obj) throws LuaException {
        if (obj == null) {
            this.pushNil();
        } else if (obj instanceof Boolean) {
            Boolean bool = (Boolean)obj;
            this.pushBoolean(bool);
        } else if (obj instanceof Number) {
            this.pushNumber(((Number)obj).doubleValue());
        } else if (obj instanceof String) {
            this.pushString((String)obj);
        } else if (obj instanceof JavaFunction) {
            JavaFunction func = (JavaFunction)obj;
            this.pushJavaFunction(func);
        } else if (obj instanceof LuaObject) {
            LuaObject ref = (LuaObject)obj;
            ref.push();
        } else if (obj instanceof byte[]) {
            this.pushString((byte[])obj);
        } else {
            this.pushJavaObject(obj);
        }
    }

    public synchronized Object toJavaObject(int idx) throws LuaException {
        Object obj = null;
        if (this.isBoolean(idx)) {
            obj = new Boolean(this.toBoolean(idx));
        } else if (this.type(idx) == LUA_TSTRING.intValue()) {
            obj = this.toString(idx);
        } else if (this.isFunction(idx)) {
            obj = this.getLuaObject(idx);
        } else if (this.isTable(idx)) {
            obj = this.getLuaObject(idx);
        } else if (this.type(idx) == LUA_TNUMBER.intValue()) {
            obj = new Double(this.toNumber(idx));
        } else if (this.isUserdata(idx)) {
            obj = this.isObject(idx) ? this.getObjectFromUserdata(idx) : this.getLuaObject(idx);
        } else if (this.isNil(idx)) {
            obj = null;
        }
        return obj;
    }

    public LuaObject getLuaObject(String globalName) {
        return new LuaObject(this, globalName);
    }

    public LuaObject getLuaObject(LuaObject parent, String name) throws LuaException {
        if (parent.L.getCPtrPeer() != this.luaState.getPeer()) {
            throw new LuaException("Object must have the same LuaState as the parent!");
        }
        return new LuaObject(parent, name);
    }

    public LuaObject getLuaObject(LuaObject parent, Number name) throws LuaException {
        if (parent.L.getCPtrPeer() != this.luaState.getPeer()) {
            throw new LuaException("Object must have the same LuaState as the parent!");
        }
        return new LuaObject(parent, name);
    }

    public LuaObject getLuaObject(LuaObject parent, LuaObject name) throws LuaException {
        if (parent.getLuaState().getCPtrPeer() != this.luaState.getPeer() || parent.getLuaState().getCPtrPeer() != name.getLuaState().getCPtrPeer()) {
            throw new LuaException("Object must have the same LuaState as the parent!");
        }
        return new LuaObject(parent, name);
    }

    public LuaObject getLuaObject(int index) {
        return new LuaObject(this, index);
    }

    public static Number convertLuaNumber(Double db, Class retType) {
        if (retType.isPrimitive()) {
            if (retType == Integer.TYPE) {
                return new Integer(db.intValue());
            }
            if (retType == Long.TYPE) {
                return new Long(db.longValue());
            }
            if (retType == Float.TYPE) {
                return new Float(db.floatValue());
            }
            if (retType == Double.TYPE) {
                return db;
            }
            if (retType == Byte.TYPE) {
                return new Byte(db.byteValue());
            }
            if (retType == Short.TYPE) {
                return new Short(db.shortValue());
            }
        } else if (retType.isAssignableFrom(Number.class)) {
            if (retType.isAssignableFrom(Integer.class)) {
                return new Integer(db.intValue());
            }
            if (retType.isAssignableFrom(Long.class)) {
                return new Long(db.longValue());
            }
            if (retType.isAssignableFrom(Float.class)) {
                return new Float(db.floatValue());
            }
            if (retType.isAssignableFrom(Double.class)) {
                return db;
            }
            if (retType.isAssignableFrom(Byte.class)) {
                return new Byte(db.byteValue());
            }
            if (retType.isAssignableFrom(Short.class)) {
                return new Short(db.shortValue());
            }
        }
        return null;
    }

    public String dumpStack() {
        int n = this.getTop();
        StringBuilder sb = new StringBuilder();
        int i = 1;
        while (i <= n) {
            int t = this.type(i);
            sb.append(i).append(": ").append(this.typeName(t));
            if (t == LUA_TNUMBER) {
                sb.append(" = ").append(this.toNumber(i));
            } else if (t == LUA_TSTRING) {
                sb.append(" = '").append(this.toString(i)).append("'");
            }
            sb.append("\n");
            ++i;
        }
        return sb.toString();
    }
}

