/*
 * Decompiled with CFR 0.152.
 */
package org.keplerproject.luajava;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.StringTokenizer;
import org.keplerproject.luajava.LuaException;
import org.keplerproject.luajava.LuaInvocationHandler;
import org.keplerproject.luajava.LuaState;

public class LuaObject {
    protected Integer ref;
    protected LuaState L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected LuaObject(LuaState L, String globalName) {
        LuaState luaState = L;
        synchronized (luaState) {
            this.L = L;
            L.getGlobal(globalName);
            this.registerValue(-1);
            L.pop(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected LuaObject(LuaObject parent, String name) throws LuaException {
        LuaState luaState = parent.getLuaState();
        synchronized (luaState) {
            this.L = parent.getLuaState();
            if (!parent.isTable() && !parent.isUserdata()) {
                throw new LuaException("Object parent should be a table or userdata .");
            }
            parent.push();
            this.L.pushString(name);
            this.L.getTable(-2);
            this.L.remove(-2);
            this.registerValue(-1);
            this.L.pop(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected LuaObject(LuaObject parent, Number name) throws LuaException {
        LuaState luaState = parent.getLuaState();
        synchronized (luaState) {
            this.L = parent.getLuaState();
            if (!parent.isTable() && !parent.isUserdata()) {
                throw new LuaException("Object parent should be a table or userdata .");
            }
            parent.push();
            this.L.pushNumber(name.doubleValue());
            this.L.getTable(-2);
            this.L.remove(-2);
            this.registerValue(-1);
            this.L.pop(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected LuaObject(LuaObject parent, LuaObject name) throws LuaException {
        if (parent.getLuaState() != name.getLuaState()) {
            throw new LuaException("LuaStates must be the same!");
        }
        LuaState luaState = parent.getLuaState();
        synchronized (luaState) {
            if (!parent.isTable() && !parent.isUserdata()) {
                throw new LuaException("Object parent should be a table or userdata .");
            }
            this.L = parent.getLuaState();
            parent.push();
            name.push();
            this.L.getTable(-2);
            this.L.remove(-2);
            this.registerValue(-1);
            this.L.pop(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected LuaObject(LuaState L, int index) {
        LuaState luaState = L;
        synchronized (luaState) {
            this.L = L;
            this.registerValue(index);
        }
    }

    public LuaState getLuaState() {
        return this.L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerValue(int index) {
        LuaState luaState = this.L;
        synchronized (luaState) {
            this.L.pushValue(index);
            int key = this.L.Lref(LuaState.LUA_REGISTRYINDEX);
            this.ref = new Integer(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() {
        try {
            LuaState luaState = this.L;
            synchronized (luaState) {
                if (this.L.getCPtrPeer() != 0L) {
                    this.L.LunRef(LuaState.LUA_REGISTRYINDEX, this.ref);
                }
            }
        }
        catch (Exception e) {
            System.err.println("Unable to release object " + this.ref);
        }
    }

    public void push() {
        this.L.rawGetI(LuaState.LUA_REGISTRYINDEX, this.ref);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isNil() {
        LuaState luaState = this.L;
        synchronized (luaState) {
            this.push();
            boolean bool = this.L.isNil(-1);
            this.L.pop(1);
            return bool;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isBoolean() {
        LuaState luaState = this.L;
        synchronized (luaState) {
            this.push();
            boolean bool = this.L.isBoolean(-1);
            this.L.pop(1);
            return bool;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isNumber() {
        LuaState luaState = this.L;
        synchronized (luaState) {
            this.push();
            boolean bool = this.L.isNumber(-1);
            this.L.pop(1);
            return bool;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isString() {
        LuaState luaState = this.L;
        synchronized (luaState) {
            this.push();
            boolean bool = this.L.isString(-1);
            this.L.pop(1);
            return bool;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isFunction() {
        LuaState luaState = this.L;
        synchronized (luaState) {
            this.push();
            boolean bool = this.L.isFunction(-1);
            this.L.pop(1);
            return bool;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isJavaObject() {
        LuaState luaState = this.L;
        synchronized (luaState) {
            this.push();
            boolean bool = this.L.isObject(-1);
            this.L.pop(1);
            return bool;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isJavaFunction() {
        LuaState luaState = this.L;
        synchronized (luaState) {
            this.push();
            boolean bool = this.L.isJavaFunction(-1);
            this.L.pop(1);
            return bool;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isTable() {
        LuaState luaState = this.L;
        synchronized (luaState) {
            this.push();
            boolean bool = this.L.isTable(-1);
            this.L.pop(1);
            return bool;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isUserdata() {
        LuaState luaState = this.L;
        synchronized (luaState) {
            this.push();
            boolean bool = this.L.isUserdata(-1);
            this.L.pop(1);
            return bool;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int type() {
        LuaState luaState = this.L;
        synchronized (luaState) {
            this.push();
            int type = this.L.type(-1);
            this.L.pop(1);
            return type;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getBoolean() {
        LuaState luaState = this.L;
        synchronized (luaState) {
            this.push();
            boolean bool = this.L.toBoolean(-1);
            this.L.pop(1);
            return bool;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getNumber() {
        LuaState luaState = this.L;
        synchronized (luaState) {
            this.push();
            double db = this.L.toNumber(-1);
            this.L.pop(1);
            return db;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getString() {
        LuaState luaState = this.L;
        synchronized (luaState) {
            this.push();
            String str = this.L.toString(-1);
            this.L.pop(1);
            return str;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getObject() throws LuaException {
        LuaState luaState = this.L;
        synchronized (luaState) {
            this.push();
            Object obj = this.L.getObjectFromUserdata(-1);
            this.L.pop(1);
            return obj;
        }
    }

    public LuaObject getField(String field) throws LuaException {
        return this.L.getLuaObject(this, field);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] call(Object[] args, int nres) throws LuaException {
        LuaState luaState = this.L;
        synchronized (luaState) {
            int nargs;
            if (!(this.isFunction() || this.isTable() || this.isUserdata())) {
                throw new LuaException("Invalid object. Not a function, table or userdata .");
            }
            int top = this.L.getTop();
            this.push();
            if (args != null) {
                nargs = args.length;
                int i = 0;
                while (i < nargs) {
                    Object obj = args[i];
                    this.L.pushObjectValue(obj);
                    ++i;
                }
            } else {
                nargs = 0;
            }
            int err = this.L.pcall(nargs, nres, 0);
            if (err != 0) {
                String str;
                if (this.L.isString(-1)) {
                    str = this.L.toString(-1);
                    this.L.pop(1);
                } else {
                    str = "";
                }
                str = err == LuaState.LUA_ERRRUN ? "Runtime error. " + str : (err == LuaState.LUA_ERRMEM ? "Memory allocation error. " + str : (err == LuaState.LUA_ERRERR ? "Error while running the error handler function. " + str : "Lua Error code " + err + ". " + str));
                throw new LuaException(str);
            }
            if (nres == LuaState.LUA_MULTRET) {
                nres = this.L.getTop() - top;
            }
            if (this.L.getTop() - top < nres) {
                throw new LuaException("Invalid Number of Results .");
            }
            Object[] res = new Object[nres];
            int i = nres;
            while (i > 0) {
                res[i - 1] = this.L.toJavaObject(-1);
                this.L.pop(1);
                --i;
            }
            return res;
        }
    }

    public Object call(Object[] args) throws LuaException {
        return this.call(args, 1)[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String toString() {
        LuaState luaState = this.L;
        synchronized (luaState) {
            try {
                if (this.isNil()) {
                    return "nil";
                }
                if (this.isBoolean()) {
                    return String.valueOf(this.getBoolean());
                }
                if (this.isNumber()) {
                    return String.valueOf(this.getNumber());
                }
                if (this.isString()) {
                    return this.getString();
                }
                if (this.isFunction()) {
                    return "Lua Function";
                }
                if (this.isJavaObject()) {
                    return this.getObject().toString();
                }
                if (this.isUserdata()) {
                    return "Userdata";
                }
                if (this.isTable()) {
                    return "Lua Table";
                }
                if (this.isJavaFunction()) {
                    return "Java Function";
                }
            }
            catch (LuaException e) {
                return null;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object createProxy(String implem) throws ClassNotFoundException, LuaException {
        LuaState luaState = this.L;
        synchronized (luaState) {
            if (!this.isTable()) {
                throw new LuaException("Invalid Object. Must be Table.");
            }
            StringTokenizer st = new StringTokenizer(implem, ",");
            Class[] interfaces = new Class[st.countTokens()];
            int i = 0;
            while (st.hasMoreTokens()) {
                interfaces[i] = Class.forName(st.nextToken());
                ++i;
            }
            LuaInvocationHandler handler = new LuaInvocationHandler(this);
            return Proxy.newProxyInstance(this.getClass().getClassLoader(), interfaces, (InvocationHandler)handler);
        }
    }
}

