/*
 * Decompiled with CFR 0.152.
 */
package org.keplerproject.luajava;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.keplerproject.luajava.LuaException;
import org.keplerproject.luajava.LuaObject;
import org.keplerproject.luajava.LuaState;
import org.keplerproject.luajava.LuaStateFactory;

public final class LuaJavaAPI {
    private LuaJavaAPI() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int objectIndex(int luaState, Object obj, String methodName) throws LuaException {
        LuaState L;
        LuaState luaState2 = L = LuaStateFactory.getExistingState(luaState);
        synchronized (luaState2) {
            Object ret;
            block14: {
                int top = L.getTop();
                Object[] objs = new Object[top - 1];
                Class<?> clazz = obj instanceof Class ? (Class<?>)obj : obj.getClass();
                Method[] methods = clazz.getMethods();
                Method method = null;
                int i = 0;
                while (i < methods.length) {
                    Class<?>[] parameters;
                    if (methods[i].getName().equals(methodName) && (parameters = methods[i].getParameterTypes()).length == top - 1) {
                        boolean okMethod = true;
                        int j = 0;
                        while (j < parameters.length) {
                            try {
                                objs[j] = LuaJavaAPI.compareTypes(L, parameters[j], j + 2);
                            }
                            catch (Exception e) {
                                okMethod = false;
                                break;
                            }
                            ++j;
                        }
                        if (okMethod) {
                            method = methods[i];
                            break;
                        }
                    }
                    ++i;
                }
                if (method == null) {
                    throw new LuaException("Invalid method call. No such method.");
                }
                try {
                    if (Modifier.isPublic(method.getModifiers())) {
                        method.setAccessible(true);
                    }
                    ret = obj instanceof Class ? method.invoke(null, objs) : method.invoke(obj, objs);
                }
                catch (Exception e) {
                    throw new LuaException(e);
                }
                if (ret != null) break block14;
                return 0;
            }
            L.pushObjectValue(ret);
            return 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int classIndex(int luaState, Class clazz, String searchName) throws LuaException {
        LuaState luaState2 = LuaStateFactory.getExistingState(luaState);
        synchronized (luaState2) {
            block6: {
                int res;
                block5: {
                    res = LuaJavaAPI.checkField(luaState, clazz, searchName);
                    if (res == 0) break block5;
                    return 1;
                }
                res = LuaJavaAPI.checkMethod(luaState, clazz, searchName);
                if (res == 0) break block6;
                return 2;
            }
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int javaNewInstance(int luaState, String className) throws LuaException {
        LuaState L;
        LuaState luaState2 = L = LuaStateFactory.getExistingState(luaState);
        synchronized (luaState2) {
            Class<?> clazz;
            try {
                clazz = Class.forName(className);
            }
            catch (ClassNotFoundException e) {
                throw new LuaException(e);
            }
            Object ret = LuaJavaAPI.getObjInstance(L, clazz);
            L.pushJavaObject(ret);
            return 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int javaNew(int luaState, Class clazz) throws LuaException {
        LuaState L;
        LuaState luaState2 = L = LuaStateFactory.getExistingState(luaState);
        synchronized (luaState2) {
            Object ret = LuaJavaAPI.getObjInstance(L, clazz);
            L.pushJavaObject(ret);
            return 1;
        }
    }

    public static int javaLoadLib(int luaState, String className, String methodName) throws LuaException {
        LuaState L;
        LuaState luaState2 = L = LuaStateFactory.getExistingState(luaState);
        synchronized (luaState2) {
            Class<?> clazz;
            try {
                clazz = Class.forName(className);
            }
            catch (ClassNotFoundException e) {
                throw new LuaException(e);
            }
            try {
                Method mt = clazz.getMethod(methodName, LuaState.class);
                Object obj = mt.invoke(null, L);
                if (obj != null && obj instanceof Integer) {
                    return (Integer)obj;
                }
                return 0;
            }
            catch (Exception e) {
                throw new LuaException("Error on calling method. Library could not be loaded. " + e.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object getObjInstance(LuaState L, Class clazz) throws LuaException {
        LuaState luaState = L;
        synchronized (luaState) {
            Object ret;
            int top = L.getTop();
            Object[] objs = new Object[top - 1];
            Constructor<?>[] constructors = clazz.getConstructors();
            Constructor<?> constructor = null;
            int i = 0;
            while (i < constructors.length) {
                Class<?>[] parameters = constructors[i].getParameterTypes();
                if (parameters.length == top - 1) {
                    boolean okConstruc = true;
                    int j = 0;
                    while (j < parameters.length) {
                        try {
                            objs[j] = LuaJavaAPI.compareTypes(L, parameters[j], j + 2);
                        }
                        catch (Exception e) {
                            okConstruc = false;
                            break;
                        }
                        ++j;
                    }
                    if (okConstruc) {
                        constructor = constructors[i];
                        break;
                    }
                }
                ++i;
            }
            if (constructor == null) {
                throw new LuaException("Invalid method call. No such method.");
            }
            try {
                ret = constructor.newInstance(objs);
            }
            catch (Exception e) {
                throw new LuaException(e);
            }
            if (ret == null) {
                throw new LuaException("Couldn't instantiate java Object");
            }
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int checkField(int luaState, Object obj, String fieldName) throws LuaException {
        LuaState L;
        LuaState luaState2 = L = LuaStateFactory.getExistingState(luaState);
        synchronized (luaState2) {
            Object ret;
            block12: {
                Field field;
                block11: {
                    field = null;
                    Class<?> objClass = obj instanceof Class ? (Class<?>)obj : obj.getClass();
                    try {
                        field = objClass.getField(fieldName);
                    }
                    catch (Exception e) {
                        return 0;
                    }
                    if (field != null) break block11;
                    return 0;
                }
                ret = null;
                try {
                    ret = field.get(obj);
                }
                catch (Exception e1) {
                    return 0;
                }
                if (obj != null) break block12;
                return 0;
            }
            L.pushObjectValue(ret);
            return 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int checkMethod(int luaState, Object obj, String methodName) {
        LuaState L;
        LuaState luaState2 = L = LuaStateFactory.getExistingState(luaState);
        synchronized (luaState2) {
            Class<?> clazz = obj instanceof Class ? (Class<?>)obj : obj.getClass();
            Method[] methods = clazz.getMethods();
            int i = 0;
            while (true) {
                if (i >= methods.length) {
                    return 0;
                }
                if (methods[i].getName().equals(methodName)) {
                    return 1;
                }
                ++i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int createProxyObject(int luaState, String implem) throws LuaException {
        LuaState L;
        LuaState luaState2 = L = LuaStateFactory.getExistingState(luaState);
        synchronized (luaState2) {
            try {
                if (!L.isTable(2)) {
                    throw new LuaException("Parameter is not a table. Can't create proxy.");
                }
                LuaObject luaObj = L.getLuaObject(2);
                Object proxy = luaObj.createProxy(implem);
                L.pushJavaObject(proxy);
            }
            catch (Exception e) {
                throw new LuaException(e);
            }
            return 1;
        }
    }

    private static Object compareTypes(LuaState L, Class parameter, int idx) throws LuaException {
        boolean okType = true;
        Object obj = null;
        if (L.isBoolean(idx)) {
            if (parameter.isPrimitive()) {
                if (parameter != Boolean.TYPE) {
                    okType = false;
                }
            } else if (!parameter.isAssignableFrom(Boolean.class)) {
                okType = false;
            }
            obj = new Boolean(L.toBoolean(idx));
        } else if (L.type(idx) == LuaState.LUA_TSTRING.intValue()) {
            if (!parameter.isAssignableFrom(String.class)) {
                okType = false;
            } else {
                obj = L.toString(idx);
            }
        } else if (L.isFunction(idx)) {
            if (!parameter.isAssignableFrom(LuaObject.class)) {
                okType = false;
            } else {
                obj = L.getLuaObject(idx);
            }
        } else if (L.isTable(idx)) {
            if (!parameter.isAssignableFrom(LuaObject.class)) {
                okType = false;
            } else {
                obj = L.getLuaObject(idx);
            }
        } else if (L.type(idx) == LuaState.LUA_TNUMBER.intValue()) {
            Double db = new Double(L.toNumber(idx));
            obj = LuaState.convertLuaNumber(db, parameter);
            if (obj == null) {
                okType = false;
            }
        } else if (L.isUserdata(idx)) {
            if (L.isObject(idx)) {
                Object userObj = L.getObjectFromUserdata(idx);
                if (!parameter.isAssignableFrom(userObj.getClass())) {
                    okType = false;
                } else {
                    obj = userObj;
                }
            } else if (!parameter.isAssignableFrom(LuaObject.class)) {
                okType = false;
            } else {
                obj = L.getLuaObject(idx);
            }
        } else if (L.isNil(idx)) {
            obj = null;
        } else {
            throw new LuaException("Invalid Parameters.");
        }
        if (!okType) {
            throw new LuaException("Invalid Parameter.");
        }
        return obj;
    }
}

