/*
 * Decompiled with CFR 0.152.
 */
package org.keplerproject.luajava;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import org.keplerproject.luajava.LuaException;
import org.keplerproject.luajava.LuaState;
import org.keplerproject.luajava.LuaStateFactory;

public class Console {
    public static void main(String[] args) {
        try {
            String line;
            LuaState L = LuaStateFactory.newLuaState();
            L.openLibs();
            if (args.length > 0) {
                int i = 0;
                while (i < args.length) {
                    int res = L.LloadFile(args[i]);
                    if (res == 0) {
                        res = L.pcall(0, 0, 0);
                    }
                    if (res != 0) {
                        throw new LuaException("Error on file: " + args[i] + ". " + L.toString(-1));
                    }
                    ++i;
                }
                return;
            }
            System.out.println("API Lua Java - console mode.");
            BufferedReader inp = new BufferedReader(new InputStreamReader(System.in));
            System.out.print("> ");
            while ((line = inp.readLine()) != null && !line.equals("exit")) {
                int ret = L.LloadBuffer(line.getBytes(), "from console");
                if (ret == 0) {
                    ret = L.pcall(0, 0, 0);
                }
                if (ret != 0) {
                    System.err.println("Error on line: " + line);
                    System.err.println(L.toString(-1));
                }
                System.out.print("> ");
            }
            L.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

