/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.output2;

import java.awt.Color;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.AsynchronousCloseException;
import java.nio.channels.ClosedByInterruptException;
import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.core.output2.AbstractLines;
import org.netbeans.core.output2.Controller;
import org.netbeans.core.output2.ErrWriter;
import org.netbeans.core.output2.FileMapStorage;
import org.netbeans.core.output2.HeapStorage;
import org.netbeans.core.output2.LineInfo;
import org.netbeans.core.output2.Lines;
import org.netbeans.core.output2.NbIO;
import org.netbeans.core.output2.Storage;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.windows.OutputEvent;
import org.openide.windows.OutputListener;

class OutWriter
extends PrintWriter {
    private boolean trouble = false;
    private NbIO owner;
    private boolean disposed = false;
    private boolean disposeOnClose = false;
    private static final boolean USE_HEAP_STORAGE = Boolean.getBoolean("nb.output.heap") || Utilities.getOperatingSystem() == 4 || Utilities.getOperatingSystem() == 2;
    static final String LINE_SEPARATOR = "\n";
    private Storage storage;
    private AbstractLines lines = new LinesImpl();
    static boolean lowDiskSpace = false;
    private int lineStart = -1;
    private int lineLength = 0;
    private int lineCharLengthWithTabs = 0;
    private int errorCount = 0;
    private boolean closed = false;
    private static final int WRITE_BUFF_SIZE = 16384;
    private Color ansiColor;
    private int ansiColorCode;
    private boolean ansiBright;
    private boolean ansiFaint;
    private static final Pattern ANSI_CSI_SGR = Pattern.compile("\u001b\\[(\\d+(;\\d+)*)?m");
    private static final Color[] COLORS = new Color[]{null, new Color(205, 0, 0), new Color(0, 205, 0), new Color(205, 205, 0), new Color(0, 0, 238), new Color(205, 0, 205), new Color(0, 205, 205), new Color(229, 229, 229), new Color(127, 127, 127), new Color(255, 0, 0), new Color(0, 255, 0), new Color(255, 255, 0), new Color(92, 92, 255), new Color(255, 0, 255), new Color(0, 255, 255), new Color(255, 255, 255)};

    OutWriter(NbIO nbIO) {
        this();
        this.owner = nbIO;
    }

    OutWriter() {
        super(new DummyWriter());
    }

    Storage getStorage() {
        if (this.disposed) {
            throw new IllegalStateException("Output file has been disposed!");
        }
        if (this.storage == null) {
            this.storage = USE_HEAP_STORAGE || lowDiskSpace ? new HeapStorage() : new FileMapStorage();
        }
        return this.storage;
    }

    boolean hasStorage() {
        return this.storage != null;
    }

    boolean isDisposed() {
        return this.disposed;
    }

    boolean isEmpty() {
        return this.storage == null ? true : this.storage.size() == 0;
    }

    public String toString() {
        return "OutWriter@" + System.identityHashCode(this) + " for " + this.owner + " closed ";
    }

    private void handleException(Exception exception) {
        this.setError();
        if (Controller.LOG) {
            StackTraceElement[] stackTraceElementArray = exception.getStackTrace();
            Controller.log("EXCEPTION: " + exception.getClass() + exception.getMessage());
            for (int i = 1; i < stackTraceElementArray.length; ++i) {
                Controller.log(stackTraceElementArray[i].toString());
            }
        }
        if (this.errorCount++ < 3) {
            Exceptions.printStackTrace((Throwable)exception);
        }
    }

    private synchronized void write(ByteBuffer byteBuffer, int n, boolean bl) {
        if (this.checkError()) {
            return;
        }
        this.closed = false;
        int n2 = -1;
        try {
            n2 = this.getStorage().write(byteBuffer);
        }
        catch (ClosedByInterruptException closedByInterruptException) {
            this.onWriteException();
        }
        catch (AsynchronousCloseException asynchronousCloseException) {
            Exceptions.printStackTrace((Throwable)asynchronousCloseException);
            this.onWriteException();
        }
        catch (IOException iOException) {
            if (iOException.getMessage().indexOf("There is not enough space on the disk") != -1) {
                lowDiskSpace = true;
                String string = NbBundle.getMessage(OutWriter.class, (String)"MSG_DiskSpace", (Object)this.storage);
                Exceptions.attachLocalizedMessage((Throwable)iOException, (String)string);
                Exceptions.printStackTrace((Throwable)iOException);
                this.setError();
                this.storage.dispose();
            }
            Exceptions.printStackTrace((Throwable)iOException);
            this.onWriteException();
        }
        if (this.checkError()) {
            return;
        }
        int n3 = byteBuffer.limit();
        this.lineLength += n3;
        this.lineCharLengthWithTabs += n;
        if (n2 >= 0 && this.lineStart == -1) {
            this.lineStart = n2;
        }
        this.lines.lineUpdated(this.lineStart, this.lineLength, this.lineCharLengthWithTabs, bl);
        if (bl) {
            this.lineStart = -1;
            this.lineLength = 0;
            this.lineCharLengthWithTabs = 0;
        }
        if (this.owner != null && this.owner.isStreamClosed()) {
            this.owner.setStreamClosed(false);
            this.lines.fire();
        }
    }

    void onWriteException() {
        ErrWriter errWriter;
        this.trouble = true;
        if (Controller.LOG) {
            Controller.log(this + " Close due to termination");
        }
        if ((errWriter = this.owner.writer().err()) != null) {
            errWriter.closed = true;
        }
        this.owner.setStreamClosed(true);
        this.close();
    }

    public synchronized void dispose() {
        if (this.disposed) {
            return;
        }
        if (Controller.LOG) {
            Controller.log(this + ": OutWriter.dispose - owner is " + (this.owner == null ? "null" : this.owner.getName()));
        }
        this.clearListeners();
        if (this.storage != null) {
            this.lines.onDispose(this.storage.size());
            this.storage.dispose();
            this.storage = null;
        }
        if (Controller.LOG) {
            Controller.log(this + ": Setting owner to null, trouble to true, dirty to false.  This OutWriter is officially dead.");
        }
        this.owner = null;
        this.disposed = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearListeners() {
        if (Controller.LOG) {
            Controller.log(this + ": Sending outputLineCleared to all listeners");
        }
        if (this.owner == null) {
            return;
        }
        OutWriter outWriter = this;
        synchronized (outWriter) {
            if (this.lines.hasListeners()) {
                int[] nArray = this.lines.getLinesWithListeners();
                Controller.ControllerOutputEvent controllerOutputEvent = new Controller.ControllerOutputEvent(this.owner, 0);
                for (int i = 0; i < nArray.length; ++i) {
                    Collection<OutputListener> collection = this.lines.getListenersForLine(nArray[i]);
                    controllerOutputEvent.setLine(nArray[i]);
                    for (OutputListener outputListener : collection) {
                        outputListener.outputLineCleared((OutputEvent)controllerOutputEvent);
                    }
                }
            } else if (Controller.LOG) {
                Controller.log(this + ": No listeners to clear");
            }
        }
    }

    public synchronized boolean isClosed() {
        if (this.checkError() || this.storage == null || this.storage.isClosed()) {
            return true;
        }
        return this.closed;
    }

    public Lines getLines() {
        return this.lines;
    }

    @Override
    public synchronized void close() {
        this.closed = true;
        try {
            if (this.storage != null) {
                this.storage.close();
            }
            this.lines.fire();
            if (this.isDisposeOnClose() && !this.isDisposed()) {
                this.dispose();
            }
        }
        catch (IOException iOException) {
            this.onWriteException();
        }
    }

    boolean isDisposeOnClose() {
        return this.disposeOnClose;
    }

    void setDisposeOnClose(boolean bl) {
        this.disposeOnClose = bl;
    }

    @Override
    public synchronized void println(String string) {
        this.doWrite(string, 0, string.length());
        this.println();
    }

    @Override
    public synchronized void flush() {
        if (this.checkError()) {
            return;
        }
        try {
            this.getStorage().flush();
            this.lines.fire();
        }
        catch (IOException iOException) {
            this.onWriteException();
        }
    }

    @Override
    public boolean checkError() {
        return this.disposed || this.trouble;
    }

    @Override
    public synchronized void write(int n) {
        this.doWrite(new String(new char[]{(char)n}), 0, 1);
    }

    @Override
    public synchronized void write(char[] cArray, int n, int n2) {
        this.doWrite(new CharArrayWrapper(cArray), n, n2);
    }

    private synchronized void doWrite(CharSequence charSequence, int n, int n2) {
        if (this.checkError() || n2 == 0) {
            return;
        }
        if (this.printANSI(charSequence.subSequence(n, n + n2), false, false, false)) {
            return;
        }
        int n3 = 0;
        try {
            boolean bl = false;
            char c = '\u0000';
            ByteBuffer byteBuffer = this.getStorage().getWriteBuffer(32768);
            CharBuffer charBuffer = byteBuffer.asCharBuffer();
            int n4 = AbstractLines.toCharIndex(this.getStorage().size());
            for (int i = n; i < n + n2; ++i) {
                int n5;
                char c2;
                if (charBuffer.position() + 1 >= 16384) {
                    this.write((ByteBuffer)byteBuffer.position(charBuffer.position() * 2), n3, false);
                    bl = true;
                }
                if (bl) {
                    byteBuffer = this.getStorage().getWriteBuffer(32768);
                    charBuffer = byteBuffer.asCharBuffer();
                    n3 = 0;
                    bl = false;
                }
                if ((c2 = charSequence.charAt(i)) == '\t') {
                    charBuffer.put(c2);
                    n5 = 8 - (this.lineCharLengthWithTabs + n3) % 8;
                    this.lines.addTabAt(n4 + (i - n), n5);
                    n3 += n5;
                } else if (c2 == '\b') {
                    this.handleBackspace(charBuffer);
                } else if (c2 == '\r' || c2 == '\n' && c != '\r') {
                    charBuffer.put('\n');
                    n5 = charBuffer.position() * 2;
                    ByteBuffer byteBuffer2 = (ByteBuffer)byteBuffer.position(n5);
                    this.write(byteBuffer2, n3, true);
                    bl = true;
                } else if (c2 == '\n') {
                    assert (c == '\r');
                } else {
                    charBuffer.put(c2);
                    ++n3;
                }
                c = c2;
            }
            if (!bl) {
                this.write((ByteBuffer)byteBuffer.position(charBuffer.position() * 2), n3, false);
            }
        }
        catch (IOException iOException) {
            this.onWriteException();
        }
        this.lines.delayedFire();
    }

    private void handleBackspace(CharBuffer charBuffer) {
        if (charBuffer.position() > 0) {
            charBuffer.position(charBuffer.position() - 1);
        }
    }

    @Override
    public synchronized void write(char[] cArray) {
        this.doWrite(new CharArrayWrapper(cArray), 0, cArray.length);
    }

    @Override
    public synchronized void println() {
        this.doWrite(LINE_SEPARATOR, 0, 1);
    }

    @Override
    public synchronized void write(String string, int n, int n2) {
        this.doWrite(string, n, n2);
    }

    @Override
    public synchronized void write(String string) {
        this.doWrite(string, 0, string.length());
    }

    public synchronized void println(String string, OutputListener outputListener) {
        this.println(string, outputListener, false);
    }

    public synchronized void println(String string, OutputListener outputListener, boolean bl) {
        this.print(string, outputListener, bl, null, false, true);
    }

    synchronized void print(CharSequence charSequence, OutputListener outputListener, boolean bl, Color color, boolean bl2, boolean bl3) {
        if (color == null) {
            if (outputListener == null && this.printANSI(charSequence, bl, bl2, bl3)) {
                return;
            }
            color = this.ansiColor;
        }
        int n = this.lines.getLineCount() - 1;
        int n2 = this.lines.getCharCount();
        this.doWrite(charSequence, 0, charSequence.length());
        if (bl3) {
            this.println();
        }
        this.lines.updateLinesInfo(charSequence, n, n2, outputListener, bl, bl2, color);
    }

    private boolean printANSI(CharSequence charSequence, boolean bl, boolean bl2, boolean bl3) {
        int n = charSequence.length();
        boolean bl4 = false;
        for (int i = 0; i < n - 1; ++i) {
            if (charSequence.charAt(i) != '\u001b' || charSequence.charAt(i + 1) != '[') continue;
            bl4 = true;
            break;
        }
        if (!bl4) {
            return false;
        }
        Matcher matcher = ANSI_CSI_SGR.matcher(charSequence);
        int n2 = 0;
        while (matcher.find()) {
            int n3 = matcher.start();
            if (n3 > n2) {
                this.print(charSequence.subSequence(n2, n3), null, bl, this.ansiColor, bl2, false);
            }
            n2 = matcher.end();
            String string = matcher.group(1);
            if (Controller.VERBOSE) {
                Controller.log("ANSI CSI+SGR: " + string);
            }
            if (string == null) {
                this.ansiColorCode = 0;
                this.ansiBright = false;
                this.ansiFaint = false;
            } else {
                for (String string2 : string.split(";")) {
                    int n4 = Integer.parseInt(string2);
                    if (n4 == 0) {
                        this.ansiColorCode = 0;
                        this.ansiBright = false;
                        this.ansiFaint = false;
                        continue;
                    }
                    if (n4 == 1) {
                        this.ansiBright = true;
                        this.ansiFaint = false;
                        continue;
                    }
                    if (n4 == 2) {
                        this.ansiBright = false;
                        this.ansiFaint = true;
                        continue;
                    }
                    if (n4 == 21) {
                        this.ansiBright = false;
                        continue;
                    }
                    if (n4 == 22) {
                        this.ansiBright = false;
                        this.ansiFaint = false;
                        continue;
                    }
                    if (n4 >= 30 && n4 <= 37) {
                        this.ansiColorCode = n4 - 30;
                        continue;
                    }
                    if (n4 != 39) continue;
                    this.ansiColorCode = 0;
                }
            }
            assert (this.ansiColorCode >= 0 && this.ansiColorCode <= 7);
            assert (!this.ansiBright || !this.ansiFaint);
            this.ansiColor = COLORS[this.ansiColorCode + (this.ansiBright ? 8 : 0)];
            if (!this.ansiFaint || this.ansiColor == null) continue;
            this.ansiColor = this.ansiColor.darker();
        }
        if (n2 == 0) {
            return false;
        }
        if (n2 < n) {
            this.print(charSequence.subSequence(n2, n), null, bl, this.ansiColor, bl2, bl3);
        } else if (bl3) {
            this.println();
        }
        return true;
    }

    synchronized void print(CharSequence charSequence, LineInfo lineInfo, boolean bl) {
        int n = this.lines.getLineCount() - 1;
        this.doWrite(charSequence, 0, charSequence.length());
        if (lineInfo != null) {
            this.lines.addLineInfo(n, lineInfo, bl);
        }
    }

    private class LinesImpl
    extends AbstractLines {
        LinesImpl() {
        }

        @Override
        protected Storage getStorage() {
            return OutWriter.this.getStorage();
        }

        @Override
        protected boolean isDisposed() {
            return OutWriter.this.disposed;
        }

        @Override
        public Object readLock() {
            return OutWriter.this;
        }

        @Override
        public boolean isGrowing() {
            return !OutWriter.this.isClosed();
        }

        @Override
        protected void handleException(Exception exception) {
            OutWriter.this.handleException(exception);
        }
    }

    static class DummyWriter
    extends Writer {
        DummyWriter() {
            super(new Object());
        }

        @Override
        public void close() throws IOException {
        }

        @Override
        public void flush() throws IOException {
        }

        @Override
        public void write(char[] cArray, int n, int n2) throws IOException {
        }
    }

    static class CharArrayWrapper
    implements CharSequence {
        private char[] arr;
        private int off;
        private int len;

        public CharArrayWrapper(char[] cArray) {
            this(cArray, 0, cArray.length);
        }

        public CharArrayWrapper(char[] cArray, int n, int n2) {
            this.arr = cArray;
            this.off = n;
            this.len = n2;
        }

        @Override
        public char charAt(int n) {
            return this.arr[this.off + n];
        }

        @Override
        public int length() {
            return this.len;
        }

        @Override
        public CharSequence subSequence(int n, int n2) {
            return new CharArrayWrapper(this.arr, this.off + n, n2 - n);
        }

        @Override
        public String toString() {
            return new String(this.arr, this.off, this.len);
        }
    }
}

