/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.output2;

import java.awt.Container;
import java.awt.Font;
import java.io.CharConversionException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.text.Document;
import org.netbeans.core.output2.IOEvent;
import org.netbeans.core.output2.Lines;
import org.netbeans.core.output2.NbIO;
import org.netbeans.core.output2.OutWriter;
import org.netbeans.core.output2.OutputDocument;
import org.netbeans.core.output2.OutputTab;
import org.openide.util.Exceptions;
import org.openide.util.NbPreferences;
import org.openide.windows.IOColors;
import org.openide.windows.IOContainer;
import org.openide.windows.IOSelect;
import org.openide.windows.InputOutput;
import org.openide.windows.OutputEvent;
import org.openide.xml.XMLUtil;

public class Controller {
    static Controller controller;
    private Map<NbIO, OutputTab> ioToTab = new HashMap<NbIO, OutputTab>();
    private static final String KEY_FONTSIZE = "fontsize";
    private static final String KEY_FONTNAME = "fontname";
    private static final String KEY_FONTSTYLE = "fontstyle";
    private static final String KEY_FONTSIZE_MONOSPACED = "fontsize_monospaced";
    private static final int MIN_FONT_SIZE = 3;
    private static Font defaultFont;
    private Font currentFontMS;
    private Font currentFont = this.currentFont();
    private boolean allMonospaced;
    private static final boolean DONT_USE_HTML;
    private CoalescedNameUpdater nameUpdater = null;
    public static final boolean LOG;
    public static final boolean VERBOSE;
    static final boolean logStdOut;
    private static OutputStream logStream;

    public static Controller getDefault() {
        if (controller == null) {
            controller = new Controller();
        }
        return controller;
    }

    Controller() {
    }

    void eventDispatched(IOEvent iOEvent) {
        if (LOG) {
            Controller.log("Event received: " + iOEvent);
        }
        NbIO nbIO = iOEvent.getIO();
        int n = iOEvent.getCommand();
        boolean bl = iOEvent.getValue();
        Object object = iOEvent.getData();
        OutputTab outputTab = this.ioToTab.get(nbIO);
        if (LOG) {
            Controller.log("Passing command to controller " + iOEvent);
        }
        this.performCommand(outputTab, nbIO, n, bl, object);
        iOEvent.consume();
    }

    private OutputTab createOutputTab(NbIO nbIO) {
        if (LOG) {
            Controller.log("Create component for nbio " + nbIO);
        }
        OutputTab outputTab = new OutputTab(nbIO);
        outputTab.setName(nbIO.getName() + " ");
        Action[] actionArray = nbIO.getToolbarActions();
        if (actionArray != null) {
            outputTab.setToolbarActions(actionArray);
        }
        if (LOG) {
            Controller.log("Adding new tab " + outputTab);
        }
        this.ioToTab.put(nbIO, outputTab);
        IOContainer iOContainer = nbIO.getIOContainer();
        iOContainer.add((JComponent)outputTab, (IOContainer.CallBacks)outputTab);
        iOContainer.setToolbarActions((JComponent)outputTab, actionArray);
        if (nbIO.getIcon() != null) {
            iOContainer.setIcon((JComponent)outputTab, nbIO.getIcon());
        }
        if (nbIO.getToolTipText() != null) {
            iOContainer.setToolTipText((JComponent)outputTab, nbIO.getToolTipText());
        }
        nbIO.setClosed(false);
        for (OutputTab outputTab2 : this.ioToTab.values()) {
            this.updateName(outputTab2);
        }
        return outputTab;
    }

    void removeTab(NbIO nbIO) {
        OutputTab outputTab = this.ioToTab.remove(nbIO);
        this.removeFromUpdater(outputTab);
    }

    void changeFontSizeBy(int n, boolean bl) {
        Font font;
        int n2 = (bl ? this.currentFontMS.getSize() : this.currentFont.getSize()) + n;
        if (n2 < 3) {
            n2 = 3;
        } else if (n2 > 72) {
            n2 = 72;
        }
        String string = bl || this.allMonospaced ? KEY_FONTSIZE_MONOSPACED : KEY_FONTSIZE;
        NbPreferences.forModule(Controller.class).putInt(string, n2);
        if (bl || this.allMonospaced) {
            font = this.currentFontMS = this.getCurrentFontMS().deriveFont((float)n2);
            if (this.allMonospaced) {
                this.currentFont = this.currentFontMS;
            }
        } else {
            font = this.currentFont = this.currentFont.deriveFont((float)n2);
        }
        for (OutputTab outputTab : this.ioToTab.values()) {
            if (!this.allMonospaced && outputTab.getOutputPane().isWrapped() != bl) continue;
            outputTab.getOutputPane().setViewFont(font);
        }
    }

    void changeFont(Font font) {
        this.currentFont = font == null ? Controller.getDefaultFont() : font;
        this.allMonospaced = this.isDefaultFontType(this.currentFont);
        if (this.allMonospaced) {
            this.currentFontMS = this.currentFont;
            NbPreferences.forModule(Controller.class).putInt(KEY_FONTSIZE_MONOSPACED, this.currentFont.getSize());
        }
        NbPreferences.forModule(Controller.class).putInt(KEY_FONTSIZE, this.currentFont.getSize());
        NbPreferences.forModule(Controller.class).putInt(KEY_FONTSTYLE, this.currentFont.getStyle());
        NbPreferences.forModule(Controller.class).put(KEY_FONTNAME, this.currentFont.getName());
        for (OutputTab outputTab : this.ioToTab.values()) {
            if (!this.allMonospaced && outputTab.getOutputPane().isWrapped()) continue;
            outputTab.getOutputPane().setViewFont(this.currentFont);
        }
    }

    private static Font getDefaultFont() {
        if (defaultFont == null) {
            Font font;
            int n = UIManager.getInt("uiFontSize");
            if (n < 3) {
                n = UIManager.getInt("customFontSize");
            }
            if (n < 3 && (font = (Font)UIManager.get("controlFont")) != null) {
                n = font.getSize();
            }
            if (n < 3) {
                n = 11;
            }
            defaultFont = new Font("Monospaced", 0, n);
        }
        return defaultFont;
    }

    public Font getCurrentFont() {
        return this.currentFont;
    }

    private Font currentFont() {
        Font font;
        String string = NbPreferences.forModule(Controller.class).get(KEY_FONTNAME, "Monospaced");
        int n = NbPreferences.forModule(Controller.class).getInt(string.equals("Monospaced") ? KEY_FONTSIZE_MONOSPACED : KEY_FONTSIZE, -1);
        int n2 = NbPreferences.forModule(Controller.class).getInt(KEY_FONTSTYLE, -1);
        if (n == -1 || n2 == -1) {
            font = Controller.getDefaultFont();
            if (n != -1) {
                font = font.deriveFont((float)n);
            }
            this.allMonospaced = true;
        } else {
            font = new Font(string, n2, n);
            this.allMonospaced = this.isDefaultFontType(font);
        }
        return font;
    }

    private boolean isDefaultFontType(Font font) {
        Font font2 = Controller.getDefaultFont();
        return font2.getName().equals(font.getName()) && font2.getStyle() == font.getStyle();
    }

    public Font getCurrentFontMS() {
        if (this.currentFontMS == null) {
            this.currentFontMS = Controller.getDefaultFont();
            int n = NbPreferences.forModule(Controller.class).getInt(KEY_FONTSIZE_MONOSPACED, -1);
            if (n != -1) {
                this.currentFontMS = this.currentFontMS.deriveFont((float)n);
            }
        }
        return this.currentFontMS;
    }

    void removeFromUpdater(OutputTab outputTab) {
        if (this.nameUpdater != null) {
            this.nameUpdater.remove(outputTab);
        }
    }

    void updateName(OutputTab outputTab) {
        if (this.nameUpdater == null) {
            if (LOG) {
                Controller.log("Update name for " + outputTab.getIO() + " dispatching a name updater");
            }
            this.nameUpdater = new CoalescedNameUpdater();
            SwingUtilities.invokeLater(this.nameUpdater);
        }
        this.nameUpdater.add(outputTab);
    }

    private static boolean htmlTabsBroken() {
        String string = System.getProperty("java.version");
        for (int i = 14; i < 18; ++i) {
            if (!string.startsWith("1.6.0_" + i)) continue;
            return true;
        }
        return string.startsWith("1.6.0") && "Aqua".equals(UIManager.getLookAndFeel().getID());
    }

    private static boolean isInSlidingMode(OutputTab outputTab) {
        for (Container container = outputTab; container != null; container = container.getParent()) {
            JComponent jComponent;
            Object object;
            if (!(container instanceof JComponent) || (object = (jComponent = (JComponent)container).getClientProperty("isSliding")) == null) continue;
            return object.equals(Boolean.TRUE);
        }
        return false;
    }

    void performCommand(OutputTab outputTab, NbIO nbIO, int n, boolean bl, Object object) {
        if (LOG) {
            Controller.log("PERFORMING: " + IOEvent.cmdToString(n) + " value=" + bl + " on " + nbIO + " tob " + outputTab);
        }
        IOContainer iOContainer = nbIO.getIOContainer();
        switch (n) {
            case 0: {
                this.createOutputTab(nbIO);
                break;
            }
            case 2: {
                if (bl && outputTab == null) {
                    outputTab = this.createOutputTab(nbIO);
                }
                if (outputTab == null) break;
                outputTab.setInputVisible(bl);
                break;
            }
            case 6: {
                if (outputTab == null) {
                    outputTab = this.createOutputTab(nbIO);
                }
                if (nbIO.isFocusTaken() || Controller.isInSlidingMode(outputTab)) {
                    iOContainer.requestActive();
                }
                iOContainer.open();
                iOContainer.requestVisible();
                iOContainer.select((JComponent)outputTab);
                break;
            }
            case 15: {
                if (outputTab == null) {
                    outputTab = this.createOutputTab(nbIO);
                }
                assert (object == null || object instanceof Set);
                Set set = (Set)object;
                if (set != null) {
                    if (nbIO.isFocusTaken() && set.contains(IOSelect.AdditionalOperation.REQUEST_ACTIVE)) {
                        iOContainer.requestActive();
                    }
                    if (set.contains(IOSelect.AdditionalOperation.OPEN)) {
                        iOContainer.open();
                    }
                    if (set.contains(IOSelect.AdditionalOperation.REQUEST_VISIBLE)) {
                        iOContainer.requestVisible();
                    }
                }
                iOContainer.select((JComponent)outputTab);
                break;
            }
            case 10: {
                if (outputTab == null) break;
                Action[] actionArray = (Action[])object;
                outputTab.setToolbarActions(actionArray);
                outputTab.getIO().getIOContainer().setToolbarActions((JComponent)outputTab, actionArray);
                break;
            }
            case 7: {
                if (outputTab != null) {
                    iOContainer.remove((JComponent)outputTab);
                }
                nbIO.dispose();
                break;
            }
            case 8: {
                if (bl) {
                    if (outputTab == null) {
                        if (nbIO.out() == null) break;
                        nbIO.out().dispose();
                        break;
                    }
                    this.updateName(outputTab);
                    if (outputTab.getIO().out() != null && outputTab.getIO().out().getLines().firstListenerLine() == -1) {
                        outputTab.getOutputPane().ensureCaretPosition();
                    }
                    if (outputTab != iOContainer.getSelected()) break;
                    outputTab.updateActions();
                    break;
                }
                if (outputTab == null || outputTab.getParent() == null) break;
                this.updateName(outputTab);
                break;
            }
            case 9: {
                if (outputTab == null) {
                    if (LOG) {
                        Controller.log("Got a reset on an io with no tab.  Creating a tab.");
                    }
                    this.createOutputTab(nbIO);
                    iOContainer.requestVisible();
                    return;
                }
                if (LOG) {
                    Controller.log("Setting io " + nbIO + " on tab " + outputTab);
                }
                outputTab.reset();
                this.updateName(outputTab);
                if (!LOG) break;
                Controller.log("Reset on " + outputTab + " tab displayable " + outputTab.isDisplayable() + " io " + nbIO + " io.out " + nbIO.out());
                break;
            }
            case 11: {
                if (outputTab == null) break;
                outputTab.getIO().getIOContainer().setIcon((JComponent)outputTab, (Icon)object);
                break;
            }
            case 12: {
                if (outputTab == null) break;
                outputTab.getIO().getIOContainer().setToolTipText((JComponent)outputTab, (String)object);
                break;
            }
            case 13: {
                if (outputTab == null) break;
                outputTab.getOutputPane().scrollTo((Integer)object);
                break;
            }
            case 14: {
                Lines lines;
                Document document;
                if (outputTab == null || (document = outputTab.getOutputPane().getDocument()) == null || !(document instanceof OutputDocument) || (lines = ((OutputDocument)document).getLines()) == null) break;
                IOColors.OutputType outputType = (IOColors.OutputType)object;
                lines.setDefColor(outputType, nbIO.getColor(outputType));
                outputTab.getOutputPane().repaint();
            }
        }
    }

    public static void log(String string) {
        string = Long.toString(System.currentTimeMillis()) + ":" + string + "(" + Thread.currentThread() + ")  ";
        if (logStdOut) {
            System.out.println(string);
            return;
        }
        OutputStream outputStream = Controller.getLogStream();
        byte[] byArray = new byte[string.length() + 1];
        char[] cArray = string.toCharArray();
        for (int i = 0; i < cArray.length; ++i) {
            byArray[i] = (byte)cArray[i];
        }
        byArray[byArray.length - 1] = 10;
        try {
            outputStream.write(byArray);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.err.println(string);
        }
        try {
            outputStream.flush();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void logStack() {
        if (logStdOut) {
            new Exception().printStackTrace();
            return;
        }
        Exception exception = new Exception();
        exception.fillInStackTrace();
        StackTraceElement[] stackTraceElementArray = exception.getStackTrace();
        for (int i = 1; i < Math.min(22, stackTraceElementArray.length); ++i) {
            Controller.log("   *   " + stackTraceElementArray[i]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static OutputStream getLogStream() {
        if (logStream != null) return logStream;
        String string = System.getProperty("java.io.tmpdir") + File.separator + "outlog.txt";
        Class<Controller> clazz = Controller.class;
        synchronized (Controller.class) {
            try {
                File file = new File(string);
                if (file.exists()) {
                    file.delete();
                }
                file.createNewFile();
                logStream = new FileOutputStream(file);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                logStream = System.err;
            }
            return logStream;
        }
    }

    static {
        DONT_USE_HTML = Controller.htmlTabsBroken();
        LOG = Boolean.getBoolean("nb.output.log") || Boolean.getBoolean("nb.output.log.verbose");
        VERBOSE = Boolean.getBoolean("nb.output.log.verbose");
        logStdOut = Boolean.getBoolean("nb.output.log.stdout");
        logStream = null;
    }

    static class ControllerOutputEvent
    extends OutputEvent {
        private int line;
        private OutWriter out;

        ControllerOutputEvent(NbIO nbIO, int n) {
            super((InputOutput)nbIO);
            this.out = nbIO.out();
            this.line = n;
        }

        ControllerOutputEvent(NbIO nbIO, OutWriter outWriter, int n) {
            this(nbIO, n);
            this.out = outWriter;
        }

        void setLine(int n) {
            this.line = n;
        }

        public String getLine() {
            NbIO nbIO = (NbIO)this.getSource();
            OutWriter outWriter = nbIO.out();
            try {
                if (outWriter != null) {
                    String string = outWriter.getLines().getLine(this.line);
                    if (string.endsWith("\n")) {
                        string = string.substring(0, string.length() - 1);
                    }
                    if (string.endsWith("\r")) {
                        string = string.substring(0, string.length() - 1);
                    }
                    return string;
                }
            }
            catch (IOException iOException) {
                IOException iOException2 = new IOException("Could not fetch line " + this.line + " on " + nbIO.getName());
                iOException2.initCause(iOException);
                Exceptions.printStackTrace((Throwable)iOException);
            }
            return null;
        }
    }

    private class CoalescedNameUpdater
    implements Runnable {
        private Set<OutputTab> components = new HashSet<OutputTab>();

        CoalescedNameUpdater() {
        }

        public void add(OutputTab outputTab) {
            this.components.add(outputTab);
        }

        public void remove(OutputTab outputTab) {
            this.components.remove(outputTab);
        }

        @Override
        public void run() {
            for (OutputTab outputTab : this.components) {
                String string;
                String string2;
                NbIO nbIO = outputTab.getIO();
                if (!Controller.this.ioToTab.containsKey(nbIO)) continue;
                if (LOG) {
                    Controller.log("Update name for " + nbIO.getName() + " stream " + "closed is " + nbIO.isStreamClosed());
                }
                try {
                    string2 = XMLUtil.toAttributeValue((String)nbIO.getName());
                }
                catch (CharConversionException charConversionException) {
                    string2 = nbIO.getName();
                }
                String string3 = nbIO.isStreamClosed() ? nbIO.getName() + " " : (string = DONT_USE_HTML ? nbIO.getName() + " * " : "<html><b>" + string2 + " </b>&nbsp;</html>");
                if (LOG) {
                    Controller.log("  set name to " + string);
                }
                nbIO.getIOContainer().setTitle((JComponent)outputTab, string.replace("&apos;", "'"));
            }
            Controller.this.nameUpdater = null;
        }
    }
}

