/*
 * Decompiled with CFR 0.152.
 */
package com.android.draw9patch.ui;

import com.android.draw9patch.ui.CorruptPatch;
import com.android.draw9patch.ui.Pair;
import com.android.draw9patch.ui.PatchInfo;
import java.awt.AWTEvent;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.TexturePaint;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.geom.Area;
import java.awt.geom.Line2D;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;

public class ImageViewer
extends JComponent {
    private final Color CORRUPTED_COLOR = new Color(1.0f, 0.0f, 0.0f, 0.7f);
    private final Color LOCK_COLOR = new Color(0.0f, 0.0f, 0.0f, 0.7f);
    private final Color STRIPES_COLOR = new Color(1.0f, 0.0f, 0.0f, 0.5f);
    private final Color BACK_COLOR = UIManager.getColor("Panel.background").darker();
    private final Color HELP_COLOR = new Color(0xFFFFE1);
    private final Color PATCH_COLOR = new Color(1.0f, 0.37f, 0.99f, 0.5f);
    private final Color PATCH_ONEWAY_COLOR = new Color(0.37f, 1.0f, 0.37f, 0.5f);
    private final Color HIGHLIGHT_REGION_COLOR = new Color(0.5f, 0.5f, 0.5f, 0.5f);
    private static final float STRIPES_WIDTH = 4.0f;
    private static final double STRIPES_SPACING = 6.0;
    private static final int STRIPES_ANGLE = 45;
    private static final float IDEAL_IMAGE_FRACTION_OF_WINDOW = 0.7f;
    public static final int DEFAULT_ZOOM = 8;
    public static final int MIN_ZOOM = 1;
    public static final int MAX_ZOOM = 16;
    private final AWTEventListener mAwtKeyEventListener;
    private int zoom = 8;
    private boolean showPatches;
    private boolean showLock = false;
    private final TexturePaint texture;
    private final Container container;
    private final StatusBar statusBar;
    private final Dimension size;
    private boolean locked;
    private int lastPositionX;
    private int lastPositionY;
    private boolean showCursor;
    private JLabel helpLabel;
    private boolean eraseMode;
    private JButton checkButton;
    private List<Rectangle> corruptedPatches;
    private boolean showBadPatches;
    private JPanel helpPanel;
    private boolean drawingLine;
    private int lineFromX;
    private int lineFromY;
    private int lineToX;
    private int lineToY;
    private boolean showDrawingLine;
    private final List<Rectangle> hoverHighlightRegions = new ArrayList<Rectangle>();
    private String toolTipText;
    private boolean isEditMode;
    private UpdateRegion editRegion;
    private final Pair<Integer> editSegment = new Pair<Integer>(0, 0);
    private final List<Rectangle> editHighlightRegions = new ArrayList<Rectangle>();
    private Rectangle editPatchRegion = new Rectangle();
    private BufferedImage image;
    private PatchInfo patchInfo;
    private DrawMode currentMode = DrawMode.PATCH;
    private static final int EDGE_DELTA = 1;
    private final Set<PatchUpdateListener> listeners = new HashSet<PatchUpdateListener>();

    ImageViewer(Container container, TexturePaint texture, BufferedImage image, StatusBar statusBar) {
        this.container = container;
        this.texture = texture;
        this.image = image;
        this.statusBar = statusBar;
        this.setLayout(new GridBagLayout());
        this.helpPanel = new JPanel(new BorderLayout());
        this.helpPanel.setBorder(new EmptyBorder(0, 6, 0, 6));
        this.helpPanel.setBackground(this.HELP_COLOR);
        this.helpLabel = new JLabel("\u6309\u4e0bShift\u952e\u6e05\u9664\u50cf\u7d20\u70b9\uff0c\u6309\u4e0bCtrl\u952e\u7ed8\u5236\u5e03\u5c40\u8fb9\u754c  Android\u4e2d\u6587\u7f16\u7a0b\u9886\u5bfc\u8005\u201cE4A\u201d\u6c49\u5316  \u7fa4\u6210\u5458\uff1a\u9633\u5149\u751c\u6a59");
        this.helpLabel.putClientProperty("JComponent.sizeVariant", "small");
        this.helpPanel.add((Component)this.helpLabel, "West");
        this.checkButton = new JButton("\u663e\u793a\u635f\u574f\u533a\u5757\u7ebf");
        this.checkButton.putClientProperty("JComponent.sizeVariant", "small");
        this.checkButton.putClientProperty("JButton.buttonType", "roundRect");
        this.helpPanel.add((Component)this.checkButton, "East");
        this.add((Component)this.helpPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 23, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.setOpaque(true);
        this.size = new Dimension(0, 0);
        this.addAncestorListener(new AncestorListener(){

            @Override
            public void ancestorRemoved(AncestorEvent event) {
            }

            @Override
            public void ancestorMoved(AncestorEvent event) {
                ImageViewer.this.removeAncestorListener(this);
                ImageViewer.this.setDefaultZoom();
            }

            @Override
            public void ancestorAdded(AncestorEvent event) {
            }
        });
        this.updatePatchInfo();
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent event) {
                ImageViewer.this.updateDrawMode(event);
                int x = ImageViewer.this.imageXCoordinate(event.getX());
                int y = ImageViewer.this.imageYCoordinate(event.getY());
                ImageViewer.this.startDrawingLine(x, y);
                if (ImageViewer.this.currentMode == DrawMode.PATCH) {
                    ImageViewer.this.startEditingRegion(x, y);
                } else {
                    ImageViewer.this.hoverHighlightRegions.clear();
                    ImageViewer.this.setCursor(Cursor.getDefaultCursor());
                    ImageViewer.this.repaint();
                }
            }

            @Override
            public void mouseReleased(MouseEvent event) {
                int x = ImageViewer.this.imageXCoordinate(event.getX());
                int y = ImageViewer.this.imageYCoordinate(event.getY());
                ImageViewer.this.endDrawingLine();
                ImageViewer.this.endEditingRegion(x, y);
                ImageViewer.this.resetDrawMode();
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent event) {
                int y;
                int x = ImageViewer.this.imageXCoordinate(event.getX());
                if (!ImageViewer.this.checkLockedRegion(x, y = ImageViewer.this.imageYCoordinate(event.getY()))) {
                    ImageViewer.this.moveLine(x, y);
                }
                ImageViewer.this.updateEditRegion(x, y);
            }

            @Override
            public void mouseMoved(MouseEvent event) {
                int x = ImageViewer.this.imageXCoordinate(event.getX());
                int y = ImageViewer.this.imageYCoordinate(event.getY());
                ImageViewer.this.checkLockedRegion(x, y);
                ImageViewer.this.updateHoverRegion(x, y);
                ImageViewer.this.repaint();
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                ImageViewer.this.hoverHighlightRegions.clear();
                ImageViewer.this.updateSize();
                ImageViewer.this.repaint();
            }
        });
        this.mAwtKeyEventListener = new AWTEventListener(){

            @Override
            public void eventDispatched(AWTEvent event) {
                ImageViewer.this.enableEraseMode((KeyEvent)event);
            }
        };
        Toolkit.getDefaultToolkit().addAWTEventListener(this.mAwtKeyEventListener, 8L);
        this.checkButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                if (!ImageViewer.this.showBadPatches) {
                    ImageViewer.this.corruptedPatches = CorruptPatch.findBadPatches(ImageViewer.this.image, ImageViewer.this.patchInfo);
                    ImageViewer.this.checkButton.setText("\u9690\u85cf\u635f\u574f\u533a\u5757\u7ebf");
                } else {
                    ImageViewer.this.checkButton.setText("\u663e\u793a\u635f\u574f\u533a\u5757\u7ebf");
                    ImageViewer.this.corruptedPatches = null;
                }
                ImageViewer.this.repaint();
                ImageViewer.this.showBadPatches = !ImageViewer.this.showBadPatches;
            }
        });
    }

    private void updateDrawMode(MouseEvent event) {
        this.currentMode = event.isShiftDown() ? DrawMode.ERASE : (event.isControlDown() ? DrawMode.LAYOUT_BOUND : DrawMode.PATCH);
    }

    private void resetDrawMode() {
        this.currentMode = DrawMode.PATCH;
    }

    private UpdateRegionInfo findVerticalPatch(int x, int y) {
        UpdateRegion region;
        List<Pair<Integer>> markers;
        if (x < this.image.getWidth() / 2) {
            markers = this.patchInfo.verticalPatchMarkers;
            region = UpdateRegion.LEFT_PATCH;
        } else {
            markers = this.patchInfo.verticalPaddingMarkers;
            region = UpdateRegion.RIGHT_PADDING;
        }
        return this.getContainingPatch(markers, y, region);
    }

    private UpdateRegionInfo findHorizontalPatch(int x, int y) {
        UpdateRegion region;
        List<Pair<Integer>> markers;
        if (y < this.image.getHeight() / 2) {
            markers = this.patchInfo.horizontalPatchMarkers;
            region = UpdateRegion.TOP_PATCH;
        } else {
            markers = this.patchInfo.horizontalPaddingMarkers;
            region = UpdateRegion.BOTTOM_PADDING;
        }
        return this.getContainingPatch(markers, x, region);
    }

    private UpdateRegionInfo getContainingPatch(List<Pair<Integer>> patches, int a, UpdateRegion region) {
        for (Pair<Integer> p : patches) {
            if ((Integer)p.first <= a && (Integer)p.second > a) {
                return new UpdateRegionInfo(region, p);
            }
            if ((Integer)p.first <= a) continue;
            break;
        }
        return new UpdateRegionInfo(region, null);
    }

    private void updateHoverRegion(int x, int y) {
        UpdateRegionInfo vertical = this.findVerticalPatch(x, y);
        UpdateRegionInfo horizontal = this.findHorizontalPatch(x, y);
        this.computeHoverHighlightRegions(vertical, horizontal);
        this.computeHoverRegionTooltip(vertical, horizontal);
        UpdateRegionInfo updateRegion = this.pickUpdateRegion(x, y, vertical, horizontal);
        this.setCursorForRegion(x, y, updateRegion);
    }

    private void startEditingRegion(int x, int y) {
        this.hoverHighlightRegions.clear();
        this.isEditMode = false;
        this.editRegion = null;
        UpdateRegionInfo vertical = this.findVerticalPatch(x, y);
        UpdateRegionInfo horizontal = this.findHorizontalPatch(x, y);
        UpdateRegionInfo updateRegion = this.pickUpdateRegion(x, y, vertical, horizontal);
        this.setCursorForRegion(x, y, updateRegion);
        if (updateRegion != null) {
            this.editRegion = updateRegion.region;
            this.isEditMode = true;
            Edge e = null;
            switch (this.editRegion) {
                case LEFT_PATCH: 
                case RIGHT_PADDING: {
                    e = this.getClosestEdge(y, updateRegion.segment);
                    break;
                }
                case TOP_PATCH: 
                case BOTTOM_PADDING: {
                    e = this.getClosestEdge(x, updateRegion.segment);
                    break;
                }
                default: {
                    assert (false) : this.editRegion;
                    break;
                }
            }
            int first = (Integer)updateRegion.segment.first;
            int second = (Integer)updateRegion.segment.second;
            boolean start = e == Edge.START;
            this.editSegment.first = start ? second : first;
            this.editSegment.second = start ? first : second;
            this.flushEditPatchData(0);
        } else {
            this.editRegion = this.findNewPatchRegion(x, y);
            if (this.editRegion != null) {
                this.isEditMode = true;
                boolean verticalPatch = this.editRegion == UpdateRegion.LEFT_PATCH || this.editRegion == UpdateRegion.RIGHT_PADDING;
                x = this.clamp(x, 1, this.image.getWidth() - 1);
                y = this.clamp(y, 1, this.image.getHeight() - 1);
                this.editSegment.second = verticalPatch ? y : x;
                this.editSegment.first = this.editSegment.second;
            }
        }
        if (this.isEditMode) {
            this.computeEditHighlightRegions();
        }
        this.repaint();
    }

    private void endEditingRegion(int x, int y) {
        if (!this.isEditMode) {
            return;
        }
        x = this.clamp(x, 1, this.image.getWidth() - 1);
        y = this.clamp(y, 1, this.image.getHeight() - 1);
        switch (this.editRegion) {
            case LEFT_PATCH: 
            case RIGHT_PADDING: {
                this.editSegment.second = y;
                break;
            }
            case TOP_PATCH: 
            case BOTTOM_PADDING: {
                this.editSegment.second = x;
                break;
            }
            default: {
                assert (false) : this.editRegion;
                break;
            }
        }
        this.flushEditPatchData(-16777216);
        this.hoverHighlightRegions.clear();
        this.setCursor(Cursor.getDefaultCursor());
        this.patchesChanged();
        this.repaint();
        this.isEditMode = false;
        this.editRegion = null;
    }

    private void updateEditRegion(int x, int y) {
        if (!this.isEditMode) {
            return;
        }
        x = this.clamp(x, 1, this.image.getWidth() - 1);
        y = this.clamp(y, 1, this.image.getHeight() - 1);
        switch (this.editRegion) {
            case LEFT_PATCH: 
            case RIGHT_PADDING: {
                this.editSegment.second = y;
                break;
            }
            case TOP_PATCH: 
            case BOTTOM_PADDING: {
                this.editSegment.second = x;
            }
        }
        this.computeEditHighlightRegions();
        this.repaint();
    }

    private int clamp(int i, int min, int max) {
        if (i < min) {
            return min;
        }
        if (i > max) {
            return max;
        }
        return i;
    }

    private UpdateRegion findNewPatchRegion(int x, int y) {
        boolean horizontalPatch;
        boolean verticalPatch = y >= 0 && y <= this.image.getHeight();
        boolean bl = horizontalPatch = x >= 0 && x <= this.image.getWidth();
        if (verticalPatch) {
            if (x < 0) {
                return UpdateRegion.LEFT_PATCH;
            }
            if (x > this.image.getWidth()) {
                return UpdateRegion.RIGHT_PADDING;
            }
        }
        if (horizontalPatch) {
            if (y < 0) {
                return UpdateRegion.TOP_PATCH;
            }
            if (y > this.image.getHeight()) {
                return UpdateRegion.BOTTOM_PADDING;
            }
        }
        return null;
    }

    private void computeHoverHighlightRegions(UpdateRegionInfo vertical, UpdateRegionInfo horizontal) {
        this.hoverHighlightRegions.clear();
        if (vertical != null && vertical.segment != null) {
            this.hoverHighlightRegions.addAll(this.getHorizontalHighlightRegions(0, (Integer)vertical.segment.first, this.image.getWidth(), (Integer)vertical.segment.second - (Integer)vertical.segment.first));
        }
        if (horizontal != null && horizontal.segment != null) {
            this.hoverHighlightRegions.addAll(this.getVerticalHighlightRegions((Integer)horizontal.segment.first, 0, (Integer)horizontal.segment.second - (Integer)horizontal.segment.first, this.image.getHeight()));
        }
    }

    private void computeHoverRegionTooltip(UpdateRegionInfo vertical, UpdateRegionInfo horizontal) {
        StringBuilder sb = new StringBuilder(50);
        if (vertical != null && vertical.segment != null) {
            if (vertical.region == UpdateRegion.LEFT_PATCH) {
                sb.append("\u7eb5\u5411\u533a\u5757: ");
            } else {
                sb.append("\u7eb5\u5411\u8fb9\u8ddd: ");
            }
            sb.append(String.format("%d - %d px", vertical.segment.first, vertical.segment.second));
        }
        if (horizontal != null && horizontal.segment != null) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            if (horizontal.region == UpdateRegion.TOP_PATCH) {
                sb.append("\u6a2a\u5411\u533a\u5757: ");
            } else {
                sb.append("\u6a2a\u5411\u8fb9\u8ddd: ");
            }
            sb.append(String.format("%d - %d px", horizontal.segment.first, horizontal.segment.second));
        }
        this.toolTipText = sb.length() > 0 ? sb.toString() : null;
    }

    private void computeEditHighlightRegions() {
        this.editHighlightRegions.clear();
        int f = (Integer)this.editSegment.first;
        int s = (Integer)this.editSegment.second;
        int min = Math.min(f, s);
        int diff = Math.abs(f - s);
        int imageWidth = this.image.getWidth();
        int imageHeight = this.image.getHeight();
        switch (this.editRegion) {
            case LEFT_PATCH: {
                this.editPatchRegion = this.displayCoordinates(new Rectangle(0, min, 1, diff));
                this.editHighlightRegions.addAll(this.getHorizontalHighlightRegions(0, min, imageWidth, diff));
                break;
            }
            case RIGHT_PADDING: {
                this.editPatchRegion = this.displayCoordinates(new Rectangle(imageWidth - 1, min, 1, diff));
                this.editHighlightRegions.addAll(this.getHorizontalHighlightRegions(0, min, imageWidth, diff));
                break;
            }
            case TOP_PATCH: {
                this.editPatchRegion = this.displayCoordinates(new Rectangle(min, 0, diff, 1));
                this.editHighlightRegions.addAll(this.getVerticalHighlightRegions(min, 0, diff, imageHeight));
                break;
            }
            case BOTTOM_PADDING: {
                this.editPatchRegion = this.displayCoordinates(new Rectangle(min, imageHeight - 1, diff, 1));
                this.editHighlightRegions.addAll(this.getVerticalHighlightRegions(min, 0, diff, imageHeight));
                break;
            }
            default: {
                assert (false) : this.editRegion;
                break;
            }
        }
    }

    private List<Rectangle> getHorizontalHighlightRegions(int x, int y, int w, int h) {
        ArrayList<Rectangle> l = new ArrayList<Rectangle>(3);
        Rectangle r = this.displayCoordinates(new Rectangle(x, y, w, h));
        l.add(r);
        l.add(new Rectangle(0, r.y, this.getWidth(), 1));
        l.add(new Rectangle(0, r.y + r.height, this.getWidth(), 1));
        return l;
    }

    private List<Rectangle> getVerticalHighlightRegions(int x, int y, int w, int h) {
        ArrayList<Rectangle> l = new ArrayList<Rectangle>(3);
        Rectangle r = this.displayCoordinates(new Rectangle(x, y, w, h));
        l.add(r);
        l.add(new Rectangle(r.x, 0, 1, this.getHeight()));
        l.add(new Rectangle(r.x + r.width, 0, 1, this.getHeight()));
        return l;
    }

    private void setCursorForRegion(int x, int y, UpdateRegionInfo region) {
        if (region != null) {
            Cursor c = this.getCursor(x, y, region);
            this.setCursor(c);
        } else {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    private Cursor getCursor(int x, int y, UpdateRegionInfo editRegion) {
        int cursor = 0;
        switch (editRegion.region) {
            case LEFT_PATCH: 
            case RIGHT_PADDING: {
                Edge e = this.getClosestEdge(y, editRegion.segment);
                cursor = e == Edge.START ? 8 : 9;
                break;
            }
            case TOP_PATCH: 
            case BOTTOM_PADDING: {
                Edge e = this.getClosestEdge(x, editRegion.segment);
                cursor = e == Edge.START ? 10 : 11;
                break;
            }
            default: {
                assert (false) : this.editRegion;
                break;
            }
        }
        return Cursor.getPredefinedCursor(cursor);
    }

    private UpdateRegionInfo pickUpdateRegion(int x, int y, UpdateRegionInfo vertical, UpdateRegionInfo horizontal) {
        Edge e;
        if (vertical != null && vertical.segment != null && (e = this.getClosestEdge(y, vertical.segment)) != Edge.NONE) {
            return vertical;
        }
        if (horizontal != null && horizontal.segment != null && (e = this.getClosestEdge(x, horizontal.segment)) != Edge.NONE) {
            return horizontal;
        }
        return null;
    }

    private Edge getClosestEdge(int x, Pair<Integer> range) {
        if (Math.abs(x - (Integer)range.first) <= 1) {
            return Edge.START;
        }
        if (Math.abs((Integer)range.second - x) <= 1) {
            return Edge.END;
        }
        return Edge.NONE;
    }

    private int imageYCoordinate(int y) {
        int top = this.helpPanel.getHeight() + (this.getHeight() - this.size.height) / 2;
        return (y - top) / this.zoom;
    }

    private int imageXCoordinate(int x) {
        int left = (this.getWidth() - this.size.width) / 2;
        return (x - left) / this.zoom;
    }

    private Point getImageOrigin() {
        int left = (this.getWidth() - this.size.width) / 2;
        int top = this.helpPanel.getHeight() + (this.getHeight() - this.size.height) / 2;
        return new Point(left, top);
    }

    private Rectangle displayCoordinates(Rectangle r) {
        Point imageOrigin = this.getImageOrigin();
        int x = r.x * this.zoom + imageOrigin.x;
        int y = r.y * this.zoom + imageOrigin.y;
        int w = r.width * this.zoom;
        int h = r.height * this.zoom;
        return new Rectangle(x, y, w, h);
    }

    private void updatePatchInfo() {
        this.patchInfo = new PatchInfo(this.image);
    }

    private void enableEraseMode(KeyEvent event) {
        boolean oldEraseMode = this.eraseMode;
        this.eraseMode = event.isShiftDown();
        if (this.eraseMode != oldEraseMode) {
            if (this.eraseMode) {
                this.helpLabel.setText("\u91ca\u653eShift\u952e\u7ed8\u5236\u50cf\u7d20\u70b9");
            } else {
                this.helpLabel.setText("\u6309\u4e0bShift\u952e\u6e05\u9664\u50cf\u7d20\u70b9\uff0c\u6309\u4e0bCtrl\u952e\u7ed8\u5236\u5e03\u5c40\u8fb9\u754c  Android\u4e2d\u6587\u7f16\u7a0b\u9886\u5bfc\u8005\u201cE4A\u201d\u6c49\u5316  \u7fa4\u6210\u5458\uff1a\u9633\u5149\u751c\u6a59");
            }
        }
    }

    private void startDrawingLine(int x, int y) {
        int width = this.image.getWidth();
        int height = this.image.getHeight();
        if ((x == 0 || x == width - 1) && y > 0 && y < height - 1 || x > 0 && x < width - 1 && (y == 0 || y == height - 1)) {
            this.drawingLine = true;
            this.lineFromX = x;
            this.lineFromY = y;
            this.lineToX = x;
            this.lineToY = y;
            this.showDrawingLine = true;
            this.showCursor = false;
            this.repaint();
        }
    }

    private void moveLine(int x, int y) {
        if (!this.drawingLine) {
            return;
        }
        int width = this.image.getWidth();
        int height = this.image.getHeight();
        this.showDrawingLine = false;
        if (x == this.lineFromX && y > 0 && y < height - 1 || x > 0 && x < width - 1 && y == this.lineFromY) {
            this.lineToX = x;
            this.lineToY = y;
            this.showDrawingLine = true;
        }
        this.repaint();
    }

    private void endDrawingLine() {
        int color;
        if (!this.drawingLine) {
            return;
        }
        this.drawingLine = false;
        if (!this.showDrawingLine) {
            return;
        }
        switch (this.currentMode) {
            case PATCH: {
                color = -16777216;
                break;
            }
            case LAYOUT_BOUND: {
                color = -65536;
                break;
            }
            case ERASE: {
                color = 0;
                break;
            }
            default: {
                return;
            }
        }
        this.setPatchData(color, this.lineFromX, this.lineFromY, this.lineToX, this.lineToY, true);
        this.patchesChanged();
        this.repaint();
    }

    private void setPatchData(int color, int x1, int y1, int x2, int y2, boolean inclusive) {
        int x = x1;
        int y = y1;
        int dx = 0;
        int dy = 0;
        if (x2 != x1) {
            dx = x2 > x1 ? 1 : -1;
        } else if (y2 != y1) {
            int n = dy = y2 > y1 ? 1 : -1;
        }
        while (x != x2 || y != y2) {
            this.image.setRGB(x, y, color);
            x += dx;
            y += dy;
        }
        if (inclusive) {
            this.image.setRGB(x, y, color);
        }
    }

    private void flushEditPatchData(int color) {
        int y2 = 0;
        int y1 = 0;
        int x2 = 0;
        int x1 = 0;
        int min = Math.min((Integer)this.editSegment.first, (Integer)this.editSegment.second);
        int max = Math.max((Integer)this.editSegment.first, (Integer)this.editSegment.second);
        switch (this.editRegion) {
            case LEFT_PATCH: {
                x2 = 0;
                x1 = 0;
                y1 = min;
                y2 = max;
                break;
            }
            case RIGHT_PADDING: {
                x1 = x2 = this.image.getWidth() - 1;
                y1 = min;
                y2 = max;
                break;
            }
            case TOP_PATCH: {
                x1 = min;
                x2 = max;
                y2 = 0;
                y1 = 0;
                break;
            }
            case BOTTOM_PADDING: {
                x1 = min;
                x2 = max;
                y1 = y2 = this.image.getHeight() - 1;
                break;
            }
            default: {
                assert (false) : this.editRegion;
                break;
            }
        }
        this.setPatchData(color, x1, y1, x2, y2, false);
    }

    private void patchesChanged() {
        this.updatePatchInfo();
        this.notifyPatchesUpdated();
        if (this.showBadPatches) {
            this.corruptedPatches = CorruptPatch.findBadPatches(this.image, this.patchInfo);
        }
    }

    private boolean checkLockedRegion(int x, int y) {
        int oldX = this.lastPositionX;
        int oldY = this.lastPositionY;
        this.lastPositionX = x;
        this.lastPositionY = y;
        int width = this.image.getWidth();
        int height = this.image.getHeight();
        this.statusBar.setPointerLocation(Math.max(0, Math.min(x, width - 1)), Math.max(0, Math.min(y, height - 1)));
        boolean previousLock = this.locked;
        this.locked = x > 0 && x < width - 1 && y > 0 && y < height - 1;
        boolean previousCursor = this.showCursor;
        boolean bl = this.showCursor = !this.drawingLine && ((x == 0 || x == width - 1) && y > 0 && y < height - 1 || x > 0 && x < width - 1 && (y == 0 || y == height - 1));
        if (this.locked != previousLock) {
            this.repaint();
        } else if (this.showCursor || this.showCursor != previousCursor) {
            Rectangle clip = new Rectangle(this.lastPositionX - 1 - this.zoom / 2, this.lastPositionY - 1 - this.zoom / 2, this.zoom + 2, this.zoom + 2);
            clip = clip.union(new Rectangle(oldX - 1 - this.zoom / 2, oldY - 1 - this.zoom / 2, this.zoom + 2, this.zoom + 2));
            this.repaint(clip);
        }
        return this.locked;
    }

    @Override
    protected void paintComponent(Graphics g) {
        int x = (this.getWidth() - this.size.width) / 2;
        int y = this.helpPanel.getHeight() + (this.getHeight() - this.size.height) / 2;
        Graphics2D g2 = (Graphics2D)g.create();
        g2.setColor(this.BACK_COLOR);
        g2.fillRect(0, 0, this.getWidth(), this.getHeight());
        g2.translate(x, y);
        g2.setPaint(this.texture);
        g2.fillRect(0, 0, this.size.width, this.size.height);
        g2.scale(this.zoom, this.zoom);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
        g2.drawImage((Image)this.image, 0, 0, null);
        if (this.showPatches) {
            g2.setColor(this.PATCH_COLOR);
            for (Rectangle patch : this.patchInfo.patches) {
                g2.fillRect(patch.x, patch.y, patch.width, patch.height);
            }
            g2.setColor(this.PATCH_ONEWAY_COLOR);
            for (Rectangle patch : this.patchInfo.horizontalPatches) {
                g2.fillRect(patch.x, patch.y, patch.width, patch.height);
            }
            for (Rectangle patch : this.patchInfo.verticalPatches) {
                g2.fillRect(patch.x, patch.y, patch.width, patch.height);
            }
        }
        if (this.corruptedPatches != null) {
            g2.setColor(this.CORRUPTED_COLOR);
            g2.setStroke(new BasicStroke(3.0f / (float)this.zoom));
            for (Rectangle patch : this.corruptedPatches) {
                g2.draw(new RoundRectangle2D.Float((float)patch.x - 2.0f / (float)this.zoom, (float)patch.y - 2.0f / (float)this.zoom, (float)patch.width + 2.0f / (float)this.zoom, (float)patch.height + 2.0f / (float)this.zoom, 6.0f / (float)this.zoom, 6.0f / (float)this.zoom));
            }
        }
        if (this.showLock && this.locked) {
            int width = this.image.getWidth();
            int height = this.image.getHeight();
            g2.setColor(this.LOCK_COLOR);
            g2.fillRect(1, 1, width - 2, height - 2);
            g2.setColor(this.STRIPES_COLOR);
            g2.translate(1, 1);
            this.paintStripes(g2, width - 2, height - 2);
            g2.translate(-1, -1);
        }
        g2.dispose();
        if (this.drawingLine && this.showDrawingLine) {
            Graphics cursor = g.create();
            cursor.setXORMode(Color.WHITE);
            cursor.setColor(Color.BLACK);
            x = Math.min(this.lineFromX, this.lineToX);
            y = Math.min(this.lineFromY, this.lineToY);
            int w = Math.abs(this.lineFromX - this.lineToX) + 1;
            int h = Math.abs(this.lineFromY - this.lineToY) + 1;
            x *= this.zoom;
            y *= this.zoom;
            int left = (this.getWidth() - this.size.width) / 2;
            int top = this.helpPanel.getHeight() + (this.getHeight() - this.size.height) / 2;
            cursor.drawRect(x += left, y += top, w *= this.zoom, h *= this.zoom);
            cursor.dispose();
        }
        if (this.showCursor) {
            Graphics cursor = g.create();
            cursor.setXORMode(Color.WHITE);
            cursor.setColor(Color.BLACK);
            cursor.drawRect(this.lastPositionX - this.zoom / 2, this.lastPositionY - this.zoom / 2, this.zoom, this.zoom);
            cursor.dispose();
        }
        g2 = (Graphics2D)g.create();
        g2.setColor(this.HIGHLIGHT_REGION_COLOR);
        for (Rectangle r : this.hoverHighlightRegions) {
            g2.fillRect(r.x, r.y, r.width, r.height);
        }
        if (!this.hoverHighlightRegions.isEmpty()) {
            this.setToolTipText(this.toolTipText);
        } else {
            this.setToolTipText(null);
        }
        if (this.isEditMode && this.editRegion != null) {
            g2.setColor(this.HIGHLIGHT_REGION_COLOR);
            for (Rectangle r : this.editHighlightRegions) {
                g2.fillRect(r.x, r.y, r.width, r.height);
            }
            g2.setColor(Color.BLACK);
            g2.fillRect(this.editPatchRegion.x, this.editPatchRegion.y, this.editPatchRegion.width, this.editPatchRegion.height);
        }
        g2.dispose();
    }

    private void paintStripes(Graphics2D g, int width, int height) {
        Shape oldClip = g.getClip();
        Area area = new Area(new Rectangle(0, 0, width, height));
        if (oldClip != null) {
            area = new Area(oldClip);
        }
        area.intersect(new Area(new Rectangle(0, 0, width, height)));
        g.setClip(area);
        g.setStroke(new BasicStroke(4.0f));
        double hypLength = Math.sqrt(width * width + height * height);
        double radians = Math.toRadians(45.0);
        g.rotate(radians);
        double spacing = 6.0;
        int numLines = (int)(hypLength / (spacing += 4.0));
        for (int i = 0; i < numLines; ++i) {
            double x = (double)i * spacing;
            Line2D.Double line = new Line2D.Double(x, -hypLength, x, hypLength);
            g.draw(line);
        }
        g.setClip(oldClip);
    }

    @Override
    public Dimension getPreferredSize() {
        return this.size;
    }

    private void setDefaultZoom() {
        int frameWidth = this.getWidth();
        int frameHeight = this.getHeight();
        int z = 8;
        if (frameWidth > 0 && frameHeight > 0) {
            float w = (float)this.image.getWidth() / (float)frameWidth;
            float h = (float)this.image.getHeight() / (float)frameHeight;
            float current = Math.max(w, h);
            float ideal = 0.7f;
            z = this.clamp(Math.round(ideal / current), 1, 16);
        }
        this.setZoom(z);
    }

    void setZoom(int value) {
        this.zoom = value;
        this.updateSize();
        if (!this.size.equals(this.getSize())) {
            this.setSize(this.size);
            this.container.validate();
            this.repaint();
        }
    }

    int getZoom() {
        return this.zoom;
    }

    private void updateSize() {
        int width = this.image.getWidth();
        int height = this.image.getHeight();
        if (this.size.height == 0 || this.getHeight() - this.size.height == 0) {
            this.size.setSize(width * this.zoom, height * this.zoom + this.helpPanel.getHeight());
        } else {
            this.size.setSize(width * this.zoom, height * this.zoom);
        }
    }

    void setPatchesVisible(boolean visible) {
        this.showPatches = visible;
        this.updatePatchInfo();
        this.repaint();
    }

    void setLockVisible(boolean visible) {
        this.showLock = visible;
        this.repaint();
    }

    public void setImage(BufferedImage image) {
        this.image = image;
    }

    public BufferedImage getImage() {
        return this.image;
    }

    public PatchInfo getPatchInfo() {
        return this.patchInfo;
    }

    public void addPatchUpdateListener(PatchUpdateListener p) {
        this.listeners.add(p);
    }

    public void removePatchUpdateListener(PatchUpdateListener p) {
        this.listeners.remove(p);
    }

    private void notifyPatchesUpdated() {
        for (PatchUpdateListener p : this.listeners) {
            p.patchesUpdated();
        }
    }

    public void dispose() {
        Toolkit.getDefaultToolkit().removeAWTEventListener(this.mAwtKeyEventListener);
    }

    public static interface PatchUpdateListener {
        public void patchesUpdated();
    }

    public static interface StatusBar {
        public void setPointerLocation(int var1, int var2);
    }

    private static enum Edge {
        START,
        END,
        NONE;

    }

    private static class UpdateRegionInfo {
        public final UpdateRegion region;
        public final Pair<Integer> segment;

        private UpdateRegionInfo(UpdateRegion region, Pair<Integer> segment) {
            this.region = region;
            this.segment = segment;
        }
    }

    private static enum UpdateRegion {
        LEFT_PATCH,
        TOP_PATCH,
        RIGHT_PADDING,
        BOTTOM_PADDING;

    }

    private static enum DrawMode {
        PATCH,
        LAYOUT_BOUND,
        ERASE;

    }
}

