/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.stat.event;

import android.content.Context;
import android.util.Log;
import com.tencent.stat.StatConfig;
import com.tencent.stat.StatStore;
import com.tencent.stat.common.StatCommonHelper;
import com.tencent.stat.common.User;
import com.tencent.stat.event.EventType;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class Event {
    protected String appkey;
    protected long timestamp;
    protected int sessionId;
    protected User user = null;
    protected Context ctx;

    public long getTimestamp() {
        return this.timestamp;
    }

    Event(Context context, int n) {
        this.ctx = context;
        this.appkey = StatConfig.getAppKey(context);
        this.timestamp = System.currentTimeMillis() / 1000L;
        this.sessionId = n;
        this.user = StatStore.getInstance(context).getUser(context);
    }

    public Context getContext() {
        return this.ctx;
    }

    public abstract EventType getType();

    public abstract boolean onEncode(JSONObject var1) throws JSONException;

    public boolean encode(JSONObject jSONObject) {
        try {
            StatCommonHelper.jsonPut(jSONObject, "ky", this.appkey);
            jSONObject.put("et", this.getType().GetIntValue());
            jSONObject.put("ui", (Object)this.user.getUid());
            String string = this.user.getMac();
            StatCommonHelper.jsonPut(jSONObject, "mc", string);
            jSONObject.put("si", this.sessionId);
            jSONObject.put("ts", this.timestamp);
            return this.onEncode(jSONObject);
        }
        catch (JSONException jSONException) {
            Log.e((String)"Event", (String)"Failed to encode", (Throwable)jSONException);
            return false;
        }
    }

    public String toJsonString() {
        JSONObject jSONObject = new JSONObject();
        this.encode(jSONObject);
        return jSONObject.toString();
    }
}

