/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.stat.event;

import android.content.Context;
import com.tencent.stat.event.Event;
import com.tencent.stat.event.EventType;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import org.json.JSONException;
import org.json.JSONObject;

public class ErrorEvent
extends Event {
    private String error;
    private int errorAttr;
    private int maxErrorLength = 100;

    public ErrorEvent(Context context, int n, int n2, Throwable throwable) {
        super(context, n);
        StackTraceElement[] stackTraceElementArray;
        StackTraceElement[] stackTraceElementArray2 = throwable.getStackTrace();
        if (stackTraceElementArray2 != null && stackTraceElementArray2.length > this.maxErrorLength) {
            stackTraceElementArray = new StackTraceElement[this.maxErrorLength];
            for (int i = 0; i < this.maxErrorLength; ++i) {
                stackTraceElementArray[i] = stackTraceElementArray2[i];
            }
            throwable.setStackTrace(stackTraceElementArray);
        }
        stackTraceElementArray = new StringWriter();
        PrintWriter printWriter = new PrintWriter((Writer)stackTraceElementArray);
        throwable.printStackTrace(printWriter);
        this.error = stackTraceElementArray.toString();
        this.errorAttr = n2;
        printWriter.close();
    }

    public ErrorEvent(Context context, int n, String string) {
        super(context, n);
        this.error = string;
        this.errorAttr = 0;
    }

    @Override
    public EventType getType() {
        return EventType.ERROR;
    }

    @Override
    public boolean onEncode(JSONObject jSONObject) throws JSONException {
        jSONObject.put("er", (Object)this.error);
        jSONObject.put("ea", this.errorAttr);
        return true;
    }
}

