/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.stat.common;

import android.content.Context;
import android.os.Build;
import android.util.DisplayMetrics;
import com.tencent.stat.StatConfig;
import com.tencent.stat.common.StatCommonHelper;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import org.json.JSONException;
import org.json.JSONObject;

public class Env {
    static BasicEnv basicEnv;
    Integer tel_network = null;
    String conn = null;
    private static JSONObject attr_json;

    public static void appendEnvAttr(Context context, Map<String, String> map) throws JSONException {
        if (map == null) {
            return;
        }
        if (null == attr_json) {
            attr_json = new JSONObject();
        }
        for (Map.Entry<String, String> entry : map.entrySet()) {
            attr_json.put(entry.getKey(), (Object)entry.getValue());
        }
    }

    static BasicEnv getBasicEnv(Context context) {
        if (null == basicEnv) {
            basicEnv = new BasicEnv(context.getApplicationContext());
        }
        return basicEnv;
    }

    public Env(Context context) {
        Env.getBasicEnv(context);
        this.tel_network = StatCommonHelper.getTelephonyNetworkType(context.getApplicationContext());
        this.conn = StatCommonHelper.getLinkedWay(context);
    }

    public void encode(JSONObject jSONObject) throws JSONException {
        JSONObject jSONObject2 = new JSONObject();
        if (null != basicEnv) {
            basicEnv.encode(jSONObject2);
        }
        StatCommonHelper.jsonPut(jSONObject2, "cn", this.conn);
        if (this.tel_network != null) {
            jSONObject2.put("tn", (Object)this.tel_network);
        }
        jSONObject.put("ev", (Object)jSONObject2);
        if (attr_json != null && attr_json.length() > 0) {
            jSONObject.put("eva", (Object)attr_json);
        }
    }

    static {
        attr_json = null;
    }

    static class BasicEnv {
        String appVersion;
        String sdkVersion = "1.0.0";
        DisplayMetrics display;
        int osVersion = Build.VERSION.SDK_INT;
        String model = Build.MODEL;
        String manufacture = Build.MANUFACTURER;
        String language = Locale.getDefault().getLanguage();
        String channel;
        String operator;
        String timezone;
        String sd;
        int jb = 0;

        private BasicEnv(Context context) {
            this.display = StatCommonHelper.getDisplayMetrics(context);
            this.appVersion = StatCommonHelper.getCurAppVersion(context);
            this.channel = StatConfig.getInstallChannel(context);
            this.operator = StatCommonHelper.getSimOperator(context);
            this.timezone = TimeZone.getDefault().getID();
            this.jb = StatCommonHelper.hasRootAccess(context);
            this.sd = StatCommonHelper.getExternalStorageInfo(context);
        }

        void encode(JSONObject jSONObject) throws JSONException {
            jSONObject.put("sr", (Object)(this.display.widthPixels + "*" + this.display.heightPixels));
            StatCommonHelper.jsonPut(jSONObject, "av", this.appVersion);
            StatCommonHelper.jsonPut(jSONObject, "ch", this.channel);
            StatCommonHelper.jsonPut(jSONObject, "mf", this.manufacture);
            StatCommonHelper.jsonPut(jSONObject, "sv", this.sdkVersion);
            StatCommonHelper.jsonPut(jSONObject, "ov", Integer.toString(this.osVersion));
            jSONObject.put("os", 1);
            StatCommonHelper.jsonPut(jSONObject, "op", this.operator);
            StatCommonHelper.jsonPut(jSONObject, "lg", this.language);
            StatCommonHelper.jsonPut(jSONObject, "md", this.model);
            StatCommonHelper.jsonPut(jSONObject, "tz", this.timezone);
            if (this.jb != 0) {
                jSONObject.put("jb", this.jb);
            }
            StatCommonHelper.jsonPut(jSONObject, "sd", this.sd);
        }
    }
}

