/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.stat;

import android.content.Context;
import android.os.Handler;
import android.os.HandlerThread;
import com.tencent.stat.MtaSDkException;
import com.tencent.stat.StatAppMonitor;
import com.tencent.stat.StatConfig;
import com.tencent.stat.StatDispatchCallback;
import com.tencent.stat.StatDispatcher;
import com.tencent.stat.StatReportStrategy;
import com.tencent.stat.StatStore;
import com.tencent.stat.common.Env;
import com.tencent.stat.common.SdkProtection;
import com.tencent.stat.common.StatCommonHelper;
import com.tencent.stat.common.StatLogger;
import com.tencent.stat.common.StatPreferences;
import com.tencent.stat.event.AdditionEvent;
import com.tencent.stat.event.CustomEvent;
import com.tencent.stat.event.ErrorEvent;
import com.tencent.stat.event.Event;
import com.tencent.stat.event.EventType;
import com.tencent.stat.event.MonitorStatEvent;
import com.tencent.stat.event.PageView;
import com.tencent.stat.event.SessionEnv;
import java.util.Map;
import java.util.Properties;
import java.util.WeakHashMap;
import org.json.JSONException;
import org.json.JSONObject;

public class StatService {
    private static Handler handler;
    private static Map<CustomEvent.Key, Long> timedEventMap;
    private static volatile long lastActivityTimestamp;
    private static volatile long nextDayStartTimestamp;
    private static volatile int sessionId;
    private static volatile String last_pageId;
    private static volatile String lastReferPageId;
    private static Map<String, Long> timedPageEventMap;
    private static StatLogger logger;
    private static Thread.UncaughtExceptionHandler originalExceptionHandler;
    private static boolean firstSession;

    static void init(Context context) {
        if (context == null) {
            return;
        }
        if (null == handler) {
            if (!StatService.isServiceStatActive(context)) {
                return;
            }
            if (!SdkProtection.beginCheck(context)) {
                logger.error("ooh, Compatibility problem was found in this device!");
                logger.error("If you are on debug mode, please delete apk and try again.");
                StatConfig.setEnableStatService(false);
                return;
            }
            StatStore.getInstance(context);
            HandlerThread handlerThread = new HandlerThread("StatService");
            handlerThread.start();
            StatDispatcher.setApplicationContext(context);
            handler = new Handler(handlerThread.getLooper());
            originalExceptionHandler = Thread.getDefaultUncaughtExceptionHandler();
            if (StatConfig.isAutoExceptionCaught()) {
                final Context context2 = context.getApplicationContext();
                Thread.setDefaultUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

                    @Override
                    public void uncaughtException(Thread thread, Throwable throwable) {
                        if (!StatConfig.isEnableStatService()) {
                            return;
                        }
                        StatStore.getInstance(context2).storeEvent(new ErrorEvent(context2, StatService.getSessionID(context2, false), 2, throwable), null);
                        logger.debug("MTA has caught the following uncaught exception:");
                        logger.error(throwable);
                        if (originalExceptionHandler != null) {
                            logger.debug("Call the original uncaught exception handler.");
                            originalExceptionHandler.uncaughtException(thread, throwable);
                        } else {
                            logger.debug("Original uncaught exception handler not set.");
                        }
                    }
                });
            } else {
                logger.warn("MTA SDK AutoExceptionCaught is disable");
            }
            if (StatConfig.getStatSendStrategy() == StatReportStrategy.APP_LAUNCH && StatCommonHelper.isNetworkAvailable(context)) {
                StatStore.getInstance(context).loadEvents(-1);
            }
            logger.d("Init MTA StatService success.");
        }
    }

    static boolean isServiceStatActive(Context context) {
        long l = StatPreferences.getLong(context, StatConfig.HIBERNATE, 0L);
        long l2 = StatCommonHelper.getSDKLongVersion("1.0.0");
        if (l2 <= l) {
            StatConfig.setEnableStatService(false);
            return false;
        }
        return true;
    }

    static boolean isEmpty(String string) {
        return string == null || string.length() == 0;
    }

    private static Handler getHandler(Context context) {
        StatService.init(context);
        return handler;
    }

    static JSONObject getEncodeConfig() {
        JSONObject jSONObject = new JSONObject();
        try {
            JSONObject jSONObject2 = new JSONObject();
            if (StatConfig.sdkCfg.version != 0) {
                jSONObject2.put("v", StatConfig.sdkCfg.version);
            }
            jSONObject.put(Integer.toString(StatConfig.sdkCfg.type), (Object)jSONObject2);
            jSONObject2 = new JSONObject();
            if (StatConfig.userCfg.version != 0) {
                jSONObject2.put("v", StatConfig.userCfg.version);
            }
            jSONObject.put(Integer.toString(StatConfig.userCfg.type), (Object)jSONObject2);
        }
        catch (JSONException jSONException) {
            logger.e((Exception)((Object)jSONException));
        }
        return jSONObject;
    }

    static void sendNewSessionEnv(Context context) {
        if (StatService.getHandler(context) != null) {
            logger.d("start new session.");
            sessionId = StatCommonHelper.getNextSessionID();
            StatConfig.setCurSessionStatReportCount(0);
            StatConfig.incCurrentDaySessionNumbers();
            StatService.getHandler(context).post((Runnable)new StatTask(new SessionEnv(context, sessionId, StatService.getEncodeConfig())));
        }
    }

    static int getSessionID(Context context, boolean bl) {
        long l = System.currentTimeMillis();
        boolean bl2 = false;
        if (bl && l - lastActivityTimestamp >= (long)StatConfig.getSessionTimoutMillis()) {
            bl2 = true;
        }
        lastActivityTimestamp = l;
        if (nextDayStartTimestamp == 0L) {
            nextDayStartTimestamp = StatCommonHelper.getTomorrowStartMilliseconds();
        }
        if (l >= nextDayStartTimestamp) {
            nextDayStartTimestamp = StatCommonHelper.getTomorrowStartMilliseconds();
            if (StatStore.getInstance(context).getUser(context).getType() != 1) {
                StatStore.getInstance(context).getUser(context).setType(1);
            }
            StatConfig.setCurrentDaySessionNumbers(0);
            bl2 = true;
        }
        if (firstSession) {
            bl2 = true;
        }
        if (bl2) {
            if (StatConfig.getCurrentDaySessionNumbers() < StatConfig.getMaxDaySessionNumbers()) {
                StatService.sendNewSessionEnv(context);
            } else {
                logger.e("Exceed StatConfig.getMaxDaySessionNumbers().");
            }
        }
        if (firstSession) {
            SdkProtection.endCheck(context);
            firstSession = false;
        }
        return sessionId;
    }

    public static void startNewSession(Context context) {
        if (!StatConfig.isEnableStatService()) {
            return;
        }
        if (context == null) {
            logger.error("The Context of StatService.startNewSession() can not be null!");
            return;
        }
        try {
            StatService.stopSession();
            StatService.getSessionID(context, true);
        }
        catch (Throwable throwable) {
            StatService.reportSdkSelfException(context, throwable);
        }
    }

    public static void stopSession() {
        lastActivityTimestamp = 0L;
    }

    public static void onResume(Context context) {
        if (!StatConfig.isEnableStatService()) {
            return;
        }
        if (context == null) {
            logger.error("The Context of StatService.onResume() can not be null!");
            return;
        }
        try {
            if (timedPageEventMap.size() >= StatConfig.getMaxParallelTimmingEvents()) {
                logger.error("The number of page events exceeds the maximum value " + Integer.toString(StatConfig.getMaxParallelTimmingEvents()));
                return;
            }
            last_pageId = StatCommonHelper.getActivityName(context);
            if (last_pageId == null) {
                return;
            }
            if (timedPageEventMap.containsKey(last_pageId)) {
                logger.e("Duplicate PageID : " + last_pageId + ", onResume() repeated?");
                return;
            }
            timedPageEventMap.put(last_pageId, System.currentTimeMillis());
            StatService.getSessionID(context, true);
        }
        catch (Throwable throwable) {
            StatService.reportSdkSelfException(context, throwable);
        }
    }

    public static void setEnvAttributes(Context context, Map<String, String> map) {
        if (map == null || map.size() > 512) {
            logger.error("The map in setEnvAttributes can't be null or its size can't exceed 512.");
            return;
        }
        try {
            Env.appendEnvAttr(context, map);
        }
        catch (JSONException jSONException) {
            logger.e((Exception)((Object)jSONException));
        }
    }

    public static void reportQQ(Context context, String string) {
        if (string == null) {
            string = "";
        }
        if (!StatConfig.qq.equals(string)) {
            StatConfig.qq = string;
            StatService.sendAdditionEvent(context, null);
        }
    }

    public static boolean startStatService(Context context, String string, String string2) throws MtaSDkException {
        if (!StatConfig.isEnableStatService()) {
            logger.error("MTA StatService is disable.");
            return false;
        }
        String string3 = "1.0.0";
        logger.d("MTA SDK version, current: " + string3 + " ,required: " + string2);
        String string4 = "";
        if (context == null || string2 == null) {
            string4 = "Context or mtaSdkVersion in StatService.startStatService() is null, please check it!";
            logger.error(string4);
            StatConfig.setEnableStatService(false);
            throw new MtaSDkException(string4);
        }
        if (StatCommonHelper.getSDKLongVersion(string3) < StatCommonHelper.getSDKLongVersion(string2)) {
            string4 = "MTA SDK version conflicted, current: " + string3 + ",required: " + string2;
            string4 = string4 + ". please delete the current SDK and download the latest one. official website: http://mta.qq.com/ or http://mta.oa.com/";
            logger.error(string4);
            StatConfig.setEnableStatService(false);
            throw new MtaSDkException(string4);
        }
        try {
            String string5 = StatConfig.getInstallChannel(context);
            if (string5 == null || string5.length() == 0) {
                StatConfig.setInstallChannel("-");
            }
            StatConfig.setAppKey(context, string);
            StatService.getHandler(context);
        }
        catch (Throwable throwable) {
            logger.e(throwable);
            return false;
        }
        return true;
    }

    public static void onPause(Context context) {
        if (!StatConfig.isEnableStatService()) {
            return;
        }
        if (context == null) {
            logger.error("The Context of StatService.onPause() can not be null!");
            return;
        }
        try {
            String string = StatCommonHelper.getActivityName(context);
            Long l = timedPageEventMap.remove(string);
            if (l != null) {
                PageView pageView;
                Long l2 = (System.currentTimeMillis() - l) / 1000L;
                if (l2 == 0L) {
                    l2 = 1L;
                }
                if (lastReferPageId.equals(string)) {
                    lastReferPageId = "-";
                }
                if (!(pageView = new PageView(context, lastReferPageId, StatService.getSessionID(context, false), l2)).getPageId().equals(last_pageId)) {
                    logger.warn("Invalid invocation since previous onResume on diff page.");
                }
                if (StatService.getHandler(context) != null) {
                    StatService.getHandler(context).post((Runnable)new StatTask(pageView));
                }
            } else {
                logger.e("Starttime for PageID:" + string + " not found, lost onResume()?");
                return;
            }
            lastReferPageId = string;
        }
        catch (Throwable throwable) {
            StatService.reportSdkSelfException(context, throwable);
        }
    }

    public static void reportError(Context context, String string) {
        if (!StatConfig.isEnableStatService()) {
            return;
        }
        if (context == null) {
            logger.error("The Context of StatService.reportError() can not be null!");
            return;
        }
        if (StatService.isEmpty(string)) {
            logger.error("Error message in StatService.reportError() is empty.");
            return;
        }
        try {
            ErrorEvent errorEvent = new ErrorEvent(context, StatService.getSessionID(context, false), string);
            if (StatService.getHandler(context) != null) {
                StatService.getHandler(context).post((Runnable)new StatTask(errorEvent));
            }
        }
        catch (Throwable throwable) {
            StatService.reportSdkSelfException(context, throwable);
        }
    }

    static void reportSdkSelfException(Context context, Throwable throwable) {
        try {
            if (!StatConfig.isEnableStatService()) {
                return;
            }
            if (context == null) {
                logger.error("The Context of StatService.reportSdkSelfException() can not be null!");
                return;
            }
            ErrorEvent errorEvent = new ErrorEvent(context, StatService.getSessionID(context, false), 99, throwable);
            if (StatService.getHandler(context) != null) {
                StatService.getHandler(context).post((Runnable)new StatTask(errorEvent));
            }
        }
        catch (Throwable throwable2) {
            logger.e("reportSdkSelfException error: " + throwable2);
        }
    }

    static void sendAdditionEvent(Context context, Map<String, ?> map) {
        if (!StatConfig.isEnableStatService()) {
            return;
        }
        if (context == null) {
            logger.error("The Context of StatService.sendAdditionEvent() can not be null!");
            return;
        }
        try {
            AdditionEvent additionEvent = new AdditionEvent(context, StatService.getSessionID(context, false), map);
            if (StatService.getHandler(context) != null) {
                StatService.getHandler(context).post((Runnable)new StatTask(additionEvent));
            }
        }
        catch (Throwable throwable) {
            StatService.reportSdkSelfException(context, throwable);
        }
    }

    public static void reportException(Context context, Throwable throwable) {
        if (!StatConfig.isEnableStatService()) {
            return;
        }
        if (context == null) {
            logger.error("The Context of StatService.reportException() can not be null!");
            return;
        }
        if (throwable == null) {
            logger.error("The Throwable error message of StatService.reportException() can not be null!");
            return;
        }
        ErrorEvent errorEvent = new ErrorEvent(context, StatService.getSessionID(context, false), 1, throwable);
        if (StatService.getHandler(context) != null) {
            StatService.getHandler(context).post((Runnable)new StatTask(errorEvent));
        }
    }

    public static void trackCustomEvent(Context context, String string, String ... stringArray) {
        if (!StatConfig.isEnableStatService()) {
            return;
        }
        if (context == null) {
            logger.error("The Context of StatService.trackCustomEvent() can not be null!");
            return;
        }
        if (StatService.isEmpty(string)) {
            logger.error("The event_id of StatService.trackCustomEvent() can not be null or empty.");
            return;
        }
        try {
            CustomEvent customEvent = new CustomEvent(context, StatService.getSessionID(context, false), string);
            customEvent.setArgs(stringArray);
            if (StatService.getHandler(context) != null) {
                StatService.getHandler(context).post((Runnable)new StatTask(customEvent));
            }
        }
        catch (Throwable throwable) {
            StatService.reportSdkSelfException(context, throwable);
        }
    }

    public static void trackCustomKVEvent(Context context, String string, Properties properties) {
        if (!StatConfig.isEnableStatService()) {
            return;
        }
        if (context == null) {
            logger.error("The Context of StatService.trackCustomEvent() can not be null!");
            return;
        }
        if (StatService.isEmpty(string)) {
            logger.error("The event_id of StatService.trackCustomEvent() can not be null or empty.");
            return;
        }
        try {
            CustomEvent customEvent = new CustomEvent(context, StatService.getSessionID(context, false), string);
            customEvent.setProperties(properties);
            if (StatService.getHandler(context) != null) {
                StatService.getHandler(context).post((Runnable)new StatTask(customEvent));
            }
        }
        catch (Throwable throwable) {
            StatService.reportSdkSelfException(context, throwable);
        }
    }

    public static void trackCustomBeginEvent(Context context, String string, String ... stringArray) {
        if (!StatConfig.isEnableStatService()) {
            return;
        }
        if (context == null) {
            logger.error("The Context of StatService.trackCustomBeginEvent() can not be null!");
            return;
        }
        if (StatService.isEmpty(string)) {
            logger.error("The event_id of StatService.trackCustomBeginEvent() can not be null or empty.");
            return;
        }
        try {
            CustomEvent customEvent = new CustomEvent(context, StatService.getSessionID(context, false), string);
            customEvent.setArgs(stringArray);
            CustomEvent.Key key = customEvent.getKey();
            if (timedEventMap.containsKey(key)) {
                logger.error("Duplicate CustomEvent key: " + key.toString() + ", trackCustomBeginEvent() repeated?");
                return;
            }
            if (timedEventMap.size() <= StatConfig.getMaxParallelTimmingEvents()) {
                timedEventMap.put(key, System.currentTimeMillis());
            } else {
                logger.error("The number of timedEvent exceeds the maximum value " + Integer.toString(StatConfig.getMaxParallelTimmingEvents()));
            }
        }
        catch (Throwable throwable) {
            StatService.reportSdkSelfException(context, throwable);
        }
    }

    public static void trackCustomEndEvent(Context context, String string, String ... stringArray) {
        if (!StatConfig.isEnableStatService()) {
            return;
        }
        if (context == null) {
            logger.error("The Context of StatService.trackCustomEndEvent() can not be null!");
            return;
        }
        if (StatService.isEmpty(string)) {
            logger.error("The event_id of StatService.trackCustomEndEvent() can not be null or empty.");
            return;
        }
        try {
            CustomEvent customEvent = new CustomEvent(context, StatService.getSessionID(context, false), string);
            customEvent.setArgs(stringArray);
            Long l = timedEventMap.remove(customEvent.getKey());
            if (null != l) {
                Long l2 = (System.currentTimeMillis() - l) / 1000L;
                l2 = l2 == 0L ? 1L : l2;
                customEvent.setDuration(l2);
                if (StatService.getHandler(context) != null) {
                    StatService.getHandler(context).post((Runnable)new StatTask(customEvent));
                }
            } else {
                logger.error("No start time found for custom event: " + customEvent.getKey().toString() + ", lost trackCustomBeginEvent()?");
            }
        }
        catch (Throwable throwable) {
            StatService.reportSdkSelfException(context, throwable);
        }
    }

    public static void trackCustomBeginKVEvent(Context context, String string, Properties properties) {
        if (!StatConfig.isEnableStatService()) {
            return;
        }
        if (context == null) {
            logger.error("The Context of StatService.trackCustomBeginEvent() can not be null!");
            return;
        }
        if (StatService.isEmpty(string)) {
            logger.error("The event_id of StatService.trackCustomBeginEvent() can not be null or empty.");
            return;
        }
        try {
            CustomEvent customEvent = new CustomEvent(context, StatService.getSessionID(context, false), string);
            customEvent.setProperties(properties);
            CustomEvent.Key key = customEvent.getKey();
            if (timedEventMap.containsKey(key)) {
                logger.error("Duplicate CustomEvent key: " + key.toString() + ", trackCustomBeginKVEvent() repeated?");
                return;
            }
            if (timedEventMap.size() <= StatConfig.getMaxParallelTimmingEvents()) {
                timedEventMap.put(key, System.currentTimeMillis());
            } else {
                logger.error("The number of timedEvent exceeds the maximum value " + Integer.toString(StatConfig.getMaxParallelTimmingEvents()));
            }
        }
        catch (Throwable throwable) {
            StatService.reportSdkSelfException(context, throwable);
        }
    }

    public static void trackCustomEndKVEvent(Context context, String string, Properties properties) {
        if (!StatConfig.isEnableStatService()) {
            return;
        }
        if (context == null) {
            logger.error("The Context of StatService.trackCustomEndEvent() can not be null!");
            return;
        }
        if (StatService.isEmpty(string)) {
            logger.error("The event_id of StatService.trackCustomEndEvent() can not be null or empty.");
            return;
        }
        try {
            CustomEvent customEvent = new CustomEvent(context, StatService.getSessionID(context, false), string);
            customEvent.setProperties(properties);
            Long l = timedEventMap.remove(customEvent.getKey());
            if (null != l) {
                Long l2 = (System.currentTimeMillis() - l) / 1000L;
                l2 = l2 == 0L ? 1L : l2;
                customEvent.setDuration(l2);
                if (StatService.getHandler(context) != null) {
                    StatService.getHandler(context).post((Runnable)new StatTask(customEvent));
                }
            } else {
                logger.error("No start time found for custom event: " + customEvent.getKey().toString() + ", lost trackCustomBeginKVEvent()?");
            }
        }
        catch (Throwable throwable) {
            StatService.reportSdkSelfException(context, throwable);
        }
    }

    public static void reportAppMonitorStat(Context context, StatAppMonitor statAppMonitor) {
        if (!StatConfig.isEnableStatService()) {
            return;
        }
        if (context == null) {
            logger.error("The Context of StatService.reportAppMonitorStat() can not be null!");
            return;
        }
        if (statAppMonitor == null) {
            logger.error("The StatAppMonitor of StatService.reportAppMonitorStat() can not be null!");
            return;
        }
        if (statAppMonitor.getInterfaceName() == null) {
            logger.error("The interfaceName of StatAppMonitor on StatService.reportAppMonitorStat() can not be null!");
            return;
        }
        try {
            MonitorStatEvent monitorStatEvent = new MonitorStatEvent(context, StatService.getSessionID(context, false), statAppMonitor);
            if (StatService.getHandler(context) != null) {
                StatService.getHandler(context).post((Runnable)new StatTask(monitorStatEvent));
            }
        }
        catch (Throwable throwable) {
            StatService.reportSdkSelfException(context, throwable);
        }
    }

    public static void commitEvents(Context context, int n) {
        if (!StatConfig.isEnableStatService()) {
            return;
        }
        if (context == null) {
            logger.error("The Context of StatService.commitEvents() can not be null!");
            return;
        }
        if (n < -1 || n == 0) {
            logger.error("The maxNumber of StatService.commitEvents() should be -1 or bigger than 0.");
            return;
        }
        try {
            StatStore.getInstance(context).loadEvents(n);
        }
        catch (Throwable throwable) {
            StatService.reportSdkSelfException(context, throwable);
        }
    }

    static {
        timedEventMap = new WeakHashMap<CustomEvent.Key, Long>();
        lastActivityTimestamp = 0L;
        nextDayStartTimestamp = 0L;
        sessionId = 0;
        last_pageId = "";
        lastReferPageId = "";
        timedPageEventMap = new WeakHashMap<String, Long>();
        logger = StatCommonHelper.getLogger();
        originalExceptionHandler = null;
        firstSession = true;
    }

    static class StatTask
    implements Runnable {
        private Event ev;
        private StatReportStrategy strategy = null;

        public StatTask(Event event) {
            this.ev = event;
            this.strategy = StatConfig.getStatSendStrategy();
        }

        private void sendEvents() {
            if (StatStore.getInstance().getNumStoredEvents() > 0) {
                StatStore.getInstance().storeEvent(this.ev, null);
                StatStore.getInstance().loadEvents(-1);
            } else {
                this.sendEventsNow(true);
            }
        }

        private void sendEventsNow(boolean bl) {
            StatDispatchCallback statDispatchCallback = null;
            if (bl) {
                statDispatchCallback = new StatDispatchCallback(){

                    @Override
                    public void onDispatchSuccess() {
                        StatStore.getInstance().loadEvents(-1);
                    }

                    @Override
                    public void onDispatchFailure() {
                        StatStore.getInstance().storeEvent(StatTask.this.ev, null);
                    }
                };
            }
            StatDispatcher.getInstance().send(this.ev, statDispatchCallback);
        }

        @Override
        public void run() {
            if (!StatConfig.isEnableStatService()) {
                return;
            }
            if (this.ev.getType() != EventType.ERROR && this.ev.toJsonString().length() > StatConfig.getMaxReportEventLength()) {
                logger.e("Event length exceed StatConfig.getMaxReportEventLength(): " + StatConfig.getMaxReportEventLength());
                return;
            }
            if (StatConfig.getMaxSessionStatReportCount() > 0) {
                if (StatConfig.getCurSessionStatReportCount() >= StatConfig.getMaxSessionStatReportCount()) {
                    logger.e("Times for reporting events has reached the limit of StatConfig.getMaxSessionStatReportCount() in current session.");
                    return;
                }
                StatConfig.incCurSessionStatReportCount();
            }
            logger.i("Lauch stat task in thread:" + Thread.currentThread().getName());
            Context context = this.ev.getContext();
            if (!StatCommonHelper.isNetworkAvailable(context)) {
                StatStore.getInstance(context).storeEvent(this.ev, null);
                return;
            }
            if (StatConfig.isEnableSmartReporting() && this.strategy != StatReportStrategy.ONLY_WIFI_NO_CACHE && StatCommonHelper.isWifiNet(context)) {
                this.strategy = StatReportStrategy.INSTANT;
            }
            switch (this.strategy) {
                case INSTANT: {
                    this.sendEvents();
                    break;
                }
                case ONLY_WIFI: {
                    if (StatCommonHelper.isWiFiActive(context)) {
                        this.sendEvents();
                        break;
                    }
                    StatStore.getInstance(context).storeEvent(this.ev, null);
                    break;
                }
                case APP_LAUNCH: 
                case DEVELOPER: {
                    StatStore.getInstance(context).storeEvent(this.ev, null);
                    break;
                }
                case BATCH: {
                    if (StatStore.getInstance(this.ev.getContext()) == null) {
                        return;
                    }
                    StatStore.getInstance(context).storeEvent(this.ev, new StatDispatchCallback(){

                        @Override
                        public void onDispatchSuccess() {
                            if (StatStore.getInstance().getNumStoredEvents() >= StatConfig.getMaxBatchReportCount()) {
                                StatStore.getInstance().loadEvents(StatConfig.getMaxBatchReportCount());
                            }
                        }

                        @Override
                        public void onDispatchFailure() {
                        }
                    });
                    break;
                }
                case PERIOD: {
                    try {
                        StatStore.getInstance(context).storeEvent(this.ev, null);
                        String string = "last_period_ts";
                        Long l = StatPreferences.getLong(context, string, 0L);
                        Long l2 = System.currentTimeMillis();
                        Long l3 = l2 - l;
                        l3 = l3 / 60000L;
                        if (l3 <= (long)StatConfig.getSendPeriodMinutes()) break;
                        StatStore.getInstance(context).loadEvents(-1);
                        StatPreferences.putLong(context, string, l2);
                    }
                    catch (Exception exception) {
                        logger.e(exception);
                    }
                    break;
                }
                case ONLY_WIFI_NO_CACHE: {
                    if (!StatCommonHelper.isWiFiActive(context)) break;
                    this.sendEventsNow(false);
                    break;
                }
                default: {
                    logger.error("Invalid stat strategy:" + (Object)((Object)StatConfig.getStatSendStrategy()));
                }
            }
        }
    }
}

