/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.stat;

import android.content.Context;
import com.tencent.stat.StatDispatcher;
import com.tencent.stat.StatReportStrategy;
import com.tencent.stat.StatService;
import com.tencent.stat.StatStore;
import com.tencent.stat.common.StatCommonHelper;
import com.tencent.stat.common.StatLogger;
import com.tencent.stat.common.StatPreferences;
import java.util.Iterator;
import org.apache.http.HttpHost;
import org.json.JSONException;
import org.json.JSONObject;

public class StatConfig {
    private static StatLogger logger = StatCommonHelper.getLogger();
    static OnlineConfig userCfg = new OnlineConfig(2);
    static OnlineConfig sdkCfg = new OnlineConfig(1);
    private static StatReportStrategy statSendStrategy = StatReportStrategy.APP_LAUNCH;
    private static boolean enableStatService = true;
    private static int sessionTimoutMillis = 30000;
    private static int maxStoreEventCount = 1024;
    private static int maxLoadEventCount = 30;
    private static int maxSendRetryCount = 3;
    private static int maxBatchReportCount = 30;
    static String HIBERNATE = "__HIBERNATE__";
    private static String ta_http_proxy = null;
    private static String appkey;
    private static String installChannel;
    static String qq;
    private static int sendPeriodMinutes;
    private static int maxParallelTimmingEvents;
    private static boolean enableSmartReporting;
    private static long lastReportStrategyCheckTime;
    private static long maxReportStrategyCheckTime;
    public static boolean isAutoExceptionCaught;
    private static String statReportUrl;
    private static int maxSessionStatReportCount;
    private static volatile int curSessionStatReportCount;
    private static int maxDaySessionNumbers;
    private static int currentDaySessionNumbers;
    private static boolean reportTrafficStat;
    private static int maxReportEventLength;

    static boolean isBetween(int n, int n2, int n3) {
        return n >= n2 && n <= n3;
    }

    public static StatReportStrategy getStatSendStrategy() {
        return statSendStrategy;
    }

    public static void setStatSendStrategy(StatReportStrategy statReportStrategy) {
        statSendStrategy = statReportStrategy;
        logger.d("Change to statSendStrategy: " + (Object)((Object)statReportStrategy));
    }

    public static boolean isDebugEnable() {
        return StatCommonHelper.getLogger().isDebugEnable();
    }

    public static void setDebugEnable(boolean bl) {
        StatCommonHelper.getLogger().setDebugEnable(bl);
    }

    public static boolean isEnableStatService() {
        return enableStatService;
    }

    public static void setEnableStatService(boolean bl) {
        enableStatService = bl;
        if (!bl) {
            logger.warn("!!!!!!MTA StatService has been disabled!!!!!!");
        }
    }

    public static int getSessionTimoutMillis() {
        return sessionTimoutMillis;
    }

    public static void setSessionTimoutMillis(int n) {
        if (!StatConfig.isBetween(n, 1000, 86400000)) {
            logger.error("setSessionTimoutMillis can not exceed the range of [1000, 24 * 60 * 60 * 1000].");
            return;
        }
        sessionTimoutMillis = n;
    }

    public static int getMaxBatchReportCount() {
        return maxBatchReportCount;
    }

    public static void setMaxBatchReportCount(int n) {
        if (!StatConfig.isBetween(n, 2, 1000)) {
            logger.error("setMaxBatchReportCount can not exceed the range of [2,1000].");
            return;
        }
        maxBatchReportCount = n;
    }

    public static void setMaxSendRetryCount(int n) {
        if (!StatConfig.isBetween(n, 1, 10)) {
            logger.error("setMaxSendRetryCount can not exceed the range of [1,10].");
            return;
        }
        maxSendRetryCount = n;
    }

    public static int getMaxSendRetryCount() {
        return maxSendRetryCount;
    }

    static int getMaxLoadEventCount() {
        return maxLoadEventCount;
    }

    public static int getMaxStoreEventCount() {
        return maxStoreEventCount;
    }

    public static void setMaxStoreEventCount(int n) {
        if (!StatConfig.isBetween(n, 0, 500000)) {
            logger.error("setMaxStoreEventCount can not exceed the range of [0, 500000].");
            return;
        }
        maxStoreEventCount = n;
    }

    public static String getCustomProperty(String string) {
        try {
            return StatConfig.userCfg.props.getString(string);
        }
        catch (JSONException jSONException) {
            return null;
        }
    }

    public static String getCustomProperty(String string, String string2) {
        try {
            String string3 = StatConfig.userCfg.props.getString(string);
            if (string3 != null) {
                return string3;
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return string2;
    }

    static void updateOnlineConfig(JSONObject jSONObject) {
        try {
            JSONObject jSONObject2 = null;
            Iterator iterator = jSONObject.keys();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                if (string.equalsIgnoreCase(Integer.toString(StatConfig.sdkCfg.type))) {
                    jSONObject2 = jSONObject.getJSONObject(string);
                    StatConfig.updateCfg(sdkCfg, jSONObject2);
                    continue;
                }
                if (string.equalsIgnoreCase(Integer.toString(StatConfig.userCfg.type))) {
                    jSONObject2 = jSONObject.getJSONObject(string);
                    StatConfig.updateCfg(userCfg, jSONObject2);
                    continue;
                }
                if (string.equalsIgnoreCase("rs")) {
                    int n = jSONObject.getInt(string);
                    StatReportStrategy statReportStrategy = StatReportStrategy.getStatReportStrategy(n);
                    if (statReportStrategy == null) continue;
                    statSendStrategy = statReportStrategy;
                    logger.d("Change to ReportStrategy:" + statReportStrategy.name());
                    continue;
                }
                return;
            }
        }
        catch (JSONException jSONException) {
            logger.e((Exception)((Object)jSONException));
        }
    }

    static void updateCfg(OnlineConfig onlineConfig, JSONObject jSONObject) {
        try {
            Object object;
            Iterator iterator = jSONObject.keys();
            while (iterator.hasNext()) {
                object = (String)iterator.next();
                if (((String)object).equalsIgnoreCase("v")) {
                    onlineConfig.version = jSONObject.getInt((String)object);
                    continue;
                }
                if (((String)object).equalsIgnoreCase("c")) {
                    JSONObject jSONObject2;
                    String string = jSONObject.getString("c");
                    if (string.length() <= 0) continue;
                    onlineConfig.props = jSONObject2 = new JSONObject(string);
                    continue;
                }
                if (!((String)object).equalsIgnoreCase("m")) continue;
                onlineConfig.md5sum = jSONObject.getString("m");
            }
            object = StatStore.getInstance(StatDispatcher.getApplicationContext());
            if (null != object) {
                ((StatStore)object).storeCfg(onlineConfig);
            }
            if (onlineConfig.type == StatConfig.sdkCfg.type) {
                StatConfig.updateReportStrategy(onlineConfig.props);
                StatConfig.checkHibernate(onlineConfig.props);
            }
        }
        catch (JSONException jSONException) {
            logger.e((Exception)((Object)jSONException));
        }
        catch (Throwable throwable) {
            logger.e(throwable);
        }
    }

    static void updateReportStrategy(JSONObject jSONObject) {
        try {
            int n = jSONObject.getInt("rs");
            StatReportStrategy statReportStrategy = StatReportStrategy.getStatReportStrategy(n);
            if (statReportStrategy != null) {
                StatConfig.setStatSendStrategy(statReportStrategy);
                logger.debug("Change to ReportStrategy: " + statReportStrategy.name());
            }
        }
        catch (JSONException jSONException) {
            logger.d("rs not found.");
        }
    }

    static void setConfig(OnlineConfig onlineConfig) throws JSONException {
        if (onlineConfig.type == StatConfig.sdkCfg.type) {
            sdkCfg = onlineConfig;
            StatConfig.updateReportStrategy(StatConfig.sdkCfg.props);
        } else if (onlineConfig.type == StatConfig.userCfg.type) {
            userCfg = onlineConfig;
        } else {
            return;
        }
    }

    static void checkHibernate(JSONObject jSONObject) {
        try {
            String string = jSONObject.getString(HIBERNATE);
            logger.d("hibernateVer:" + string + ", current version:" + "1.0.0");
            long l = StatCommonHelper.getSDKLongVersion(string);
            long l2 = StatCommonHelper.getSDKLongVersion("1.0.0");
            if (l2 <= l) {
                StatPreferences.putLong(StatDispatcher.getApplicationContext(), HIBERNATE, l);
                StatConfig.setEnableStatService(false);
                logger.warn("MTA has disable for SDK version of " + string + " or lower.");
            }
        }
        catch (JSONException jSONException) {
            logger.d("__HIBERNATE__ not found.");
        }
    }

    static HttpHost getStatHttpProxy() {
        if (null != ta_http_proxy && ta_http_proxy.length() > 0) {
            String string = ta_http_proxy;
            String[] stringArray = string.split(":");
            String string2 = string;
            int n = 80;
            if (stringArray.length == 2) {
                string2 = stringArray[0];
                n = Integer.parseInt(stringArray[1]);
            }
            HttpHost httpHost = new HttpHost(string2, n);
            return httpHost;
        }
        return null;
    }

    static void storeAppkeys(Context context, String string) {
        if (string != null) {
            String string2 = StatCommonHelper.encode(string);
            StatPreferences.putString(context, "_mta_ky_tag_", string2);
        }
    }

    static String getStoredAppkeys(Context context) {
        String string = StatPreferences.getString(context, "_mta_ky_tag_", null);
        return StatCommonHelper.decode(string);
    }

    public static String getAppKey(Context context) {
        if (null != appkey) {
            return appkey;
        }
        if (context != null && appkey == null) {
            appkey = StatCommonHelper.getAppKey(context);
        }
        if (appkey == null || appkey.trim().length() == 0) {
            logger.error("AppKey can not be null or empty, please read Developer's Guide first!");
        }
        return appkey;
    }

    private static boolean updateAppkeys(String string) {
        if (string == null) {
            return false;
        }
        if (appkey == null) {
            appkey = string;
            return true;
        }
        if (!appkey.contains(string)) {
            appkey = appkey + "|" + string;
            return true;
        }
        return false;
    }

    public static void setAppKey(Context context, String string) {
        if (context == null) {
            logger.error("ctx in StatConfig.setAppKey() is null");
            return;
        }
        if (string == null || string.length() > 256) {
            logger.error("appkey in StatConfig.setAppKey() is null or exceed 256 bytes");
            return;
        }
        if (appkey == null) {
            appkey = StatConfig.getStoredAppkeys(context);
        }
        boolean bl = StatConfig.updateAppkeys(string);
        if (bl |= StatConfig.updateAppkeys(StatCommonHelper.getAppKey(context))) {
            StatConfig.storeAppkeys(context, appkey);
        }
    }

    @Deprecated
    public static void setAppKey(String string) {
        if (string == null) {
            logger.error("appkey in StatConfig.setAppKey() is null");
            return;
        }
        if (string.length() > 256) {
            logger.error("The length of appkey cann't exceed 256 bytes.");
            return;
        }
        appkey = string;
    }

    public static String getInstallChannel(Context context) {
        if (null != installChannel) {
            return installChannel;
        }
        installChannel = StatCommonHelper.getInstallChannel(context);
        if (installChannel == null || installChannel.trim().length() == 0) {
            logger.e("installChannel can not be null or empty, please read Developer's Guide first!");
        }
        return installChannel;
    }

    public static void setInstallChannel(String string) {
        if (string.length() > 128) {
            logger.error("the length of installChannel can not exceed the range of 128 bytes.");
            return;
        }
        installChannel = string;
    }

    public static String getQQ() {
        return qq;
    }

    public static void setQQ(Context context, String string) {
        StatService.reportQQ(context, string);
    }

    public static void setSendPeriodMinutes(int n) {
        if (!StatConfig.isBetween(n, 1, 10080)) {
            logger.error("setSendPeriodMinutes can not exceed the range of [1, 7*24*60] minutes.");
            return;
        }
        sendPeriodMinutes = n;
    }

    public static int getSendPeriodMinutes() {
        return sendPeriodMinutes;
    }

    public static int getMaxParallelTimmingEvents() {
        return maxParallelTimmingEvents;
    }

    public static void setMaxParallelTimmingEvents(int n) {
        if (!StatConfig.isBetween(n, 1, 4096)) {
            logger.error("setMaxParallelTimmingEvents can not exceed the range of [1, 4096].");
            return;
        }
        maxParallelTimmingEvents = n;
    }

    public static boolean isEnableSmartReporting() {
        return enableSmartReporting;
    }

    public static void setEnableSmartReporting(boolean bl) {
        enableSmartReporting = bl;
    }

    public static boolean isAutoExceptionCaught() {
        return isAutoExceptionCaught;
    }

    public static void setAutoExceptionCaught(boolean bl) {
        isAutoExceptionCaught = bl;
    }

    public static String getStatReportUrl() {
        return statReportUrl;
    }

    public static void setStatReportUrl(String string) {
        if (string == null || string.length() == 0) {
            logger.error("statReportUrl cannot be null or empty.");
            return;
        }
        statReportUrl = string;
    }

    public static int getMaxSessionStatReportCount() {
        return maxSessionStatReportCount;
    }

    public static void setMaxSessionStatReportCount(int n) {
        if (n < 0) {
            logger.error("maxSessionStatReportCount cannot be less than 0.");
            return;
        }
        maxSessionStatReportCount = n;
    }

    public static int getCurSessionStatReportCount() {
        return curSessionStatReportCount;
    }

    static synchronized void setCurSessionStatReportCount(int n) {
        curSessionStatReportCount = n;
    }

    static synchronized void incCurSessionStatReportCount() {
        ++curSessionStatReportCount;
    }

    public static int getMaxDaySessionNumbers() {
        return maxDaySessionNumbers;
    }

    public static void setMaxDaySessionNumbers(int n) {
        if (n <= 0) {
            logger.e("maxDaySessionNumbers must be greater than 0.");
            return;
        }
        maxDaySessionNumbers = n;
    }

    static void incCurrentDaySessionNumbers() {
        ++currentDaySessionNumbers;
    }

    static void setCurrentDaySessionNumbers(int n) {
        if (n < 0) {
            return;
        }
        currentDaySessionNumbers = n;
    }

    static int getCurrentDaySessionNumbers() {
        return currentDaySessionNumbers;
    }

    public static int getMaxReportEventLength() {
        return maxReportEventLength;
    }

    public static void setMaxReportEventLength(int n) {
        if (n <= 0) {
            logger.error("maxReportEventLength on setMaxReportEventLength() must greater than 0.");
            return;
        }
        maxReportEventLength = n;
    }

    static {
        qq = "";
        sendPeriodMinutes = 1440;
        maxParallelTimmingEvents = 1024;
        enableSmartReporting = true;
        lastReportStrategyCheckTime = 0L;
        maxReportStrategyCheckTime = 300000L;
        isAutoExceptionCaught = true;
        statReportUrl = "http://pingma.qq.com:80/mstat/report";
        maxSessionStatReportCount = 0;
        curSessionStatReportCount = 0;
        maxDaySessionNumbers = 20;
        currentDaySessionNumbers = 0;
        reportTrafficStat = false;
        maxReportEventLength = 4096;
    }

    static class OnlineConfig {
        int type;
        JSONObject props = new JSONObject();
        String md5sum = "";
        int version = 0;

        public OnlineConfig(int n) {
            this.type = n;
        }

        String toJsonString() {
            return this.props.toString();
        }
    }
}

