/*
 * Decompiled with CFR 0.152.
 */
package com.ta.utdid2.device;

import android.content.ContentResolver;
import android.content.Context;
import android.provider.Settings;
import com.ta.utdid2.android.utils.Base64;
import com.ta.utdid2.android.utils.IntUtils;
import com.ta.utdid2.android.utils.PhoneInfoUtils;
import com.ta.utdid2.android.utils.StringUtils;
import com.ta.utdid2.core.persistent.PersistentConfiguration;
import com.ta.utdid2.device.Device;
import com.ta.utdid2.device.UTUtdidHelper;
import com.ta.utdid2.device.UTUtdidHelper2;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.Adler32;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class UTUtdid {
    private static final String HMAC_KEY = "d6fc3a4a06adbde89223bvefedc24fecde188aaa9161";
    private Context mContext = null;
    private static final Object CREATE_LOCK = new Object();
    private static UTUtdid s_umutdid = null;
    private String mUtdid = null;
    private UTUtdidHelper mUtdidHelper = null;
    private String mCBKey = "xx_utdid_key";
    private String mCBDomain = "xx_utdid_domain";
    static final String UM_SETTINGS_STORAGE = "dxCRMxhQkdGePGnp";
    static final String UM_SETTINGS_STORAGE_NEW = "mqBRboGZkQPcAkyk";
    private PersistentConfiguration mPC = null;
    private static final String S_LOCAL_STORAGE_NAME = ".DataStorage";
    private static final String S_LOCAL_STORAGE_KEY = "ContextData";
    private PersistentConfiguration mTaoPC = null;
    private static final String S_GLOBAL_PERSISTENT_CONFIG_DIR = ".UTSystemConfig" + File.separator + "Global";
    private static final String S_GLOBAL_PERSISTENT_CONFIG_KEY = "Alvin2";
    private Pattern mPattern = Pattern.compile("[^0-9a-zA-Z=/+]+");

    public UTUtdid(Context context) {
        this.mContext = context;
        this.mTaoPC = new PersistentConfiguration(context, S_GLOBAL_PERSISTENT_CONFIG_DIR, S_GLOBAL_PERSISTENT_CONFIG_KEY, false, true);
        this.mPC = new PersistentConfiguration(context, S_LOCAL_STORAGE_NAME, S_LOCAL_STORAGE_KEY, false, true);
        this.mUtdidHelper = new UTUtdidHelper();
        this.mCBKey = String.format("K_%d", StringUtils.hashCode(this.mCBKey));
        this.mCBDomain = String.format("D_%d", StringUtils.hashCode(this.mCBDomain));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static UTUtdid instance(Context context) {
        if (context != null && s_umutdid == null) {
            Object object = CREATE_LOCK;
            synchronized (object) {
                if (s_umutdid == null) {
                    s_umutdid = new UTUtdid(context);
                }
            }
        }
        return s_umutdid;
    }

    static long getMetadataCheckSum(Device device) {
        String checkSumContent;
        if (device != null && !StringUtils.isEmpty(checkSumContent = String.format("%s%s%s%s%s", device.getUtdid(), device.getDeviceId(), device.getCreateTimestamp(), device.getImsi(), device.getImei()))) {
            Adler32 adler32 = new Adler32();
            adler32.reset();
            adler32.update(checkSumContent.getBytes());
            long checkSum = adler32.getValue();
            return checkSum;
        }
        return 0L;
    }

    private void saveUtdidToTaoPPC(String pUtdid) {
        if (this.isValidUTDID(pUtdid)) {
            if (pUtdid.endsWith("\n")) {
                pUtdid = pUtdid.substring(0, pUtdid.length() - 1);
            }
            if (pUtdid.length() == 24 && this.mTaoPC != null) {
                String lDID;
                String lIMSI;
                String lUTDID = this.mTaoPC.getString("UTDID");
                String lIMEI = this.mTaoPC.getString("EI");
                if (StringUtils.isEmpty(lIMEI)) {
                    lIMEI = PhoneInfoUtils.getImei(this.mContext);
                }
                if (StringUtils.isEmpty(lIMSI = this.mTaoPC.getString("SI"))) {
                    lIMSI = PhoneInfoUtils.getImsi(this.mContext);
                }
                if (StringUtils.isEmpty(lDID = this.mTaoPC.getString("DID"))) {
                    lDID = lIMEI;
                }
                if (null == lUTDID || !lUTDID.equals(pUtdid)) {
                    Device lD = new Device();
                    lD.setImei(lIMEI);
                    lD.setImsi(lIMSI);
                    lD.setUtdid(pUtdid);
                    lD.setDeviceId(lDID);
                    lD.setCreateTimestamp(System.currentTimeMillis());
                    this.mTaoPC.putString("UTDID", pUtdid);
                    this.mTaoPC.putString("EI", lD.getImei());
                    this.mTaoPC.putString("SI", lD.getImsi());
                    this.mTaoPC.putString("DID", lD.getDeviceId());
                    this.mTaoPC.putLong("timestamp", lD.getCreateTimestamp());
                    this.mTaoPC.putLong("S", UTUtdid.getMetadataCheckSum(lD));
                    this.mTaoPC.commit();
                }
            }
        }
    }

    private void saveUtdidToLocalStorage(String pPackedUtdid) {
        String lPackedUtdid;
        if (null != pPackedUtdid && null != this.mPC && !pPackedUtdid.equals(lPackedUtdid = this.mPC.getString(this.mCBKey))) {
            this.mPC.putString(this.mCBKey, pPackedUtdid);
            this.mPC.commit();
        }
    }

    private void saveUtdidToNewSettings(String lUtdid) {
        int lPermission = this.mContext.checkCallingOrSelfPermission("android.permission.WRITE_SETTINGS");
        if (0 == lPermission && this.isValidUTDID(lUtdid)) {
            String data;
            if (lUtdid.endsWith("\n")) {
                lUtdid = lUtdid.substring(0, lUtdid.length() - 1);
            }
            if (24 == lUtdid.length() && !this.isValidUTDID(data = Settings.System.getString((ContentResolver)this.mContext.getContentResolver(), (String)UM_SETTINGS_STORAGE_NEW))) {
                Settings.System.putString((ContentResolver)this.mContext.getContentResolver(), (String)UM_SETTINGS_STORAGE_NEW, (String)lUtdid);
            }
        }
    }

    private void syncUTDIDToSettings(String pPackedUtdid) {
        String data = Settings.System.getString((ContentResolver)this.mContext.getContentResolver(), (String)UM_SETTINGS_STORAGE);
        if (!pPackedUtdid.equals(data)) {
            Settings.System.putString((ContentResolver)this.mContext.getContentResolver(), (String)UM_SETTINGS_STORAGE, (String)pPackedUtdid);
        }
    }

    private void saveUtdidToSettings(String lPackedUtdid) {
        int lPermission = this.mContext.checkCallingOrSelfPermission("android.permission.WRITE_SETTINGS");
        if (0 == lPermission && null != lPackedUtdid) {
            this.syncUTDIDToSettings(lPackedUtdid);
        }
    }

    private String getUtdidFromTaoPPC() {
        String lPackedUtdid;
        String lUTDID;
        if (null != this.mTaoPC && !StringUtils.isEmpty(lUTDID = this.mTaoPC.getString("UTDID")) && null != (lPackedUtdid = this.mUtdidHelper.packUtdidStr(lUTDID))) {
            return lUTDID;
        }
        return null;
    }

    private boolean isValidUTDID(String pUTDID) {
        if (null != pUTDID) {
            Matcher lMatcher;
            if (pUTDID.endsWith("\n")) {
                pUTDID = pUTDID.substring(0, pUTDID.length() - 1);
            }
            if (24 == pUTDID.length() && !(lMatcher = this.mPattern.matcher(pUTDID)).find()) {
                return true;
            }
        }
        return false;
    }

    public synchronized String getValue() {
        Object lUtdid;
        String lSUtdid;
        if (null != this.mUtdid) {
            return this.mUtdid;
        }
        String lNewSettingsUtdid = Settings.System.getString((ContentResolver)this.mContext.getContentResolver(), (String)UM_SETTINGS_STORAGE_NEW);
        if (this.isValidUTDID(lNewSettingsUtdid)) {
            return lNewSettingsUtdid;
        }
        UTUtdidHelper2 lHelper2 = new UTUtdidHelper2();
        boolean lNeedUpdateSettings = false;
        String data = Settings.System.getString((ContentResolver)this.mContext.getContentResolver(), (String)UM_SETTINGS_STORAGE);
        if (!StringUtils.isEmpty(data)) {
            String lDePackedUtdid;
            String lPTmpUtdid;
            String lTmpUtdidBase64 = lHelper2.dePackWithBase64(data);
            if (this.isValidUTDID(lTmpUtdidBase64)) {
                this.saveUtdidToNewSettings(lTmpUtdidBase64);
                return lTmpUtdidBase64;
            }
            String lTmpUtdid = lHelper2.dePack(data);
            if (this.isValidUTDID(lTmpUtdid) && !StringUtils.isEmpty(lPTmpUtdid = this.mUtdidHelper.packUtdidStr(lTmpUtdid))) {
                this.saveUtdidToSettings(lPTmpUtdid);
                data = Settings.System.getString((ContentResolver)this.mContext.getContentResolver(), (String)UM_SETTINGS_STORAGE);
            }
            if (this.isValidUTDID(lDePackedUtdid = this.mUtdidHelper.dePack(data))) {
                this.mUtdid = lDePackedUtdid;
                this.saveUtdidToTaoPPC(lDePackedUtdid);
                this.saveUtdidToLocalStorage(data);
                this.saveUtdidToNewSettings(this.mUtdid);
                return this.mUtdid;
            }
        } else {
            lNeedUpdateSettings = true;
        }
        if (this.isValidUTDID(lSUtdid = this.getUtdidFromTaoPPC())) {
            String lPackedUtdid = this.mUtdidHelper.packUtdidStr(lSUtdid);
            if (lNeedUpdateSettings) {
                this.saveUtdidToSettings(lPackedUtdid);
            }
            this.saveUtdidToNewSettings(lSUtdid);
            this.saveUtdidToLocalStorage(lPackedUtdid);
            this.mUtdid = lSUtdid;
            return lSUtdid;
        }
        String lContent = this.mPC.getString(this.mCBKey);
        if (!StringUtils.isEmpty(lContent)) {
            lUtdid = lHelper2.dePack(lContent);
            if (!this.isValidUTDID((String)lUtdid)) {
                lUtdid = this.mUtdidHelper.dePack(lContent);
            }
            if (this.isValidUTDID((String)lUtdid)) {
                String lBUtdid = this.mUtdidHelper.packUtdidStr((String)lUtdid);
                if (!StringUtils.isEmpty((String)lUtdid)) {
                    this.mUtdid = lUtdid;
                    if (lNeedUpdateSettings) {
                        this.saveUtdidToSettings(lBUtdid);
                    }
                    this.saveUtdidToTaoPPC(this.mUtdid);
                    return this.mUtdid;
                }
            }
        }
        try {
            lUtdid = this._generateUtdid();
            if (null != lUtdid) {
                this.mUtdid = Base64.encodeToString((byte[])lUtdid, 2);
                this.saveUtdidToTaoPPC(this.mUtdid);
                String lPackedUtdid = this.mUtdidHelper.pack((byte[])lUtdid);
                if (null != lPackedUtdid) {
                    if (lNeedUpdateSettings) {
                        this.saveUtdidToSettings(lPackedUtdid);
                    }
                    this.saveUtdidToLocalStorage(lPackedUtdid);
                }
                return this.mUtdid;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    private final byte[] _generateUtdid() throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        int timestamp = (int)(System.currentTimeMillis() / 1000L);
        int uniqueID = new Random().nextInt();
        int version = 3;
        int reserve = 0;
        byte[] bTimestamp = IntUtils.getBytes(timestamp);
        byte[] bUniqueID = IntUtils.getBytes(uniqueID);
        baos.write(bTimestamp, 0, 4);
        baos.write(bUniqueID, 0, 4);
        baos.write(version);
        baos.write(reserve);
        String imei = null;
        try {
            imei = PhoneInfoUtils.getImei(this.mContext);
        }
        catch (Exception e) {
            imei = "" + new Random().nextInt();
        }
        int hashCode = StringUtils.hashCode(imei);
        byte[] bHashCode = IntUtils.getBytes(hashCode);
        baos.write(bHashCode, 0, 4);
        String hmac = "";
        hmac = UTUtdid._calcHmac(baos.toByteArray());
        byte[] bCheckSum = IntUtils.getBytes(StringUtils.hashCode(hmac));
        baos.write(bCheckSum);
        return baos.toByteArray();
    }

    private static String _calcHmac(byte[] src) throws Exception {
        String key = HMAC_KEY;
        Mac mac = Mac.getInstance("HmacSHA1");
        SecretKeySpec sk = new SecretKeySpec(key.getBytes(), mac.getAlgorithm());
        mac.init(sk);
        byte[] result = mac.doFinal(src);
        return Base64.encodeToString(result, 2);
    }
}

