/*
 * Decompiled with CFR 0.152.
 */
package com.ta.utdid2.android.utils;

import android.content.Context;
import android.content.pm.PackageManager;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import com.ta.utdid2.android.utils.StringUtils;

public class NetworkUtils {
    public static final String WIFI = "Wi-Fi";
    public static final String DEFAULT_WIFI_ADDRESS = "00-00-00-00-00-00";

    public static boolean isConnectInternet(Context context) {
        ConnectivityManager conManager = (ConnectivityManager)context.getSystemService("connectivity");
        if (conManager != null) {
            try {
                NetworkInfo networkInfo = conManager.getActiveNetworkInfo();
                if (networkInfo != null) {
                    return networkInfo.isAvailable();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    public static String[] getNetworkState(Context paramContext) {
        String[] arrayOfString = new String[]{"Unknown", "Unknown"};
        try {
            PackageManager localPackageManager = paramContext.getPackageManager();
            if (localPackageManager.checkPermission("android.permission.ACCESS_NETWORK_STATE", paramContext.getPackageName()) != 0) {
                arrayOfString[0] = "Unknown";
                return arrayOfString;
            }
            ConnectivityManager localConnectivityManager = (ConnectivityManager)paramContext.getSystemService("connectivity");
            if (localConnectivityManager == null) {
                arrayOfString[0] = "Unknown";
                return arrayOfString;
            }
            NetworkInfo localNetworkInfo1 = localConnectivityManager.getNetworkInfo(1);
            if (localNetworkInfo1 != null && localNetworkInfo1.getState() == NetworkInfo.State.CONNECTED) {
                arrayOfString[0] = WIFI;
                return arrayOfString;
            }
            NetworkInfo localNetworkInfo2 = localConnectivityManager.getNetworkInfo(0);
            if (localNetworkInfo2 != null && localNetworkInfo2.getState() == NetworkInfo.State.CONNECTED) {
                arrayOfString[0] = "2G/3G";
                arrayOfString[1] = localNetworkInfo2.getSubtypeName();
                return arrayOfString;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return arrayOfString;
    }

    public static String getWifiAddress(Context context) {
        if (context != null) {
            WifiManager wifimanage = (WifiManager)context.getSystemService("wifi");
            WifiInfo wifiinfo = wifimanage.getConnectionInfo();
            if (wifiinfo != null) {
                String address = wifiinfo.getMacAddress();
                if (StringUtils.isEmpty(address)) {
                    address = DEFAULT_WIFI_ADDRESS;
                }
                return address;
            }
            return DEFAULT_WIFI_ADDRESS;
        }
        return DEFAULT_WIFI_ADDRESS;
    }

    private static String _convertIntToIp(int i) {
        return (i & 0xFF) + "." + (i >> 8 & 0xFF) + "." + (i >> 16 & 0xFF) + "." + (i >> 24 & 0xFF);
    }

    public static String getWifiIpAddress(Context context) {
        if (context != null) {
            try {
                WifiManager wifiManage = (WifiManager)context.getSystemService("wifi");
                WifiInfo wifiinfo = wifiManage.getConnectionInfo();
                if (wifiinfo != null) {
                    return NetworkUtils._convertIntToIp(wifiinfo.getIpAddress());
                }
                return null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static boolean isWifi(Context context) {
        if (context != null) {
            try {
                if (NetworkUtils.getNetworkState(context)[0].equals(WIFI)) {
                    return true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }
}

