/*
 * Decompiled with CFR 0.152.
 */
package com.e4a.runtime.components.impl.android.ok\u6c89\u6d78\u5de5\u5177\u7c7b\u5e93;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.view.Window;
import android.view.WindowManager;
import android.widget.FrameLayout;
import java.lang.reflect.Method;

public class SystemBarTintManager {
    public static final int DEFAULT_TINT_COLOR = -1728053248;
    private static String sNavBarOverride;
    private final SystemBarConfig mConfig;
    private boolean mStatusBarAvailable;
    private boolean mNavBarAvailable;
    private boolean mStatusBarTintEnabled;
    private boolean mNavBarTintEnabled;
    private View mStatusBarTintView;
    private View mNavBarTintView;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TargetApi(value=19)
    public SystemBarTintManager(Activity activity) {
        Window window = activity.getWindow();
        ViewGroup viewGroup = (ViewGroup)window.getDecorView();
        if (Build.VERSION.SDK_INT >= 19) {
            int[] nArray = new int[]{16843759, 16843760};
            TypedArray typedArray = activity.obtainStyledAttributes(nArray);
            try {
                this.mStatusBarAvailable = typedArray.getBoolean(0, false);
                this.mNavBarAvailable = typedArray.getBoolean(1, false);
            }
            finally {
                typedArray.recycle();
            }
            WindowManager.LayoutParams layoutParams = window.getAttributes();
            int n = 0x4000000;
            if ((layoutParams.flags & n) != 0) {
                this.mStatusBarAvailable = true;
            }
            if ((layoutParams.flags & (n = 0x8000000)) != 0) {
                this.mNavBarAvailable = true;
            }
        }
        this.mConfig = new SystemBarConfig(activity, this.mStatusBarAvailable, this.mNavBarAvailable);
        if (!this.mConfig.hasNavigtionBar()) {
            this.mNavBarAvailable = false;
        }
        if (this.mStatusBarAvailable) {
            this.setupStatusBarView((Context)activity, viewGroup);
        }
        if (this.mNavBarAvailable) {
            this.setupNavBarView((Context)activity, viewGroup);
        }
    }

    public void setStatusBarTintEnabled(boolean bl) {
        this.mStatusBarTintEnabled = bl;
        if (this.mStatusBarAvailable) {
            this.mStatusBarTintView.setVisibility(bl ? 0 : 8);
        }
    }

    public void setNavigationBarTintEnabled(boolean bl) {
        this.mNavBarTintEnabled = bl;
        if (this.mNavBarAvailable) {
            this.mNavBarTintView.setVisibility(bl ? 0 : 8);
        }
    }

    public void setTintColor(int n) {
        this.setStatusBarTintColor(n);
    }

    public void setTintColor2(int n) {
        this.setNavigationBarTintColor(n);
    }

    public void setTintResource(int n) {
        this.setStatusBarTintResource(n);
    }

    public void setTintResource2(int n) {
        this.setNavigationBarTintResource(n);
    }

    public void setTintDrawable(Drawable drawable) {
        this.setStatusBarTintDrawable(drawable);
        this.setNavigationBarTintDrawable(drawable);
    }

    public void setTintAlpha(float f) {
        this.setStatusBarAlpha(f);
        this.setNavigationBarAlpha(f);
    }

    public void setStatusBarTintColor(int n) {
        if (this.mStatusBarAvailable) {
            this.mStatusBarTintView.setBackgroundColor(n);
        }
    }

    public void setStatusBarTintResource(int n) {
        if (this.mStatusBarAvailable) {
            this.mStatusBarTintView.setBackgroundResource(n);
        }
    }

    public void setStatusBarTintDrawable(Drawable drawable) {
        if (this.mStatusBarAvailable) {
            this.mStatusBarTintView.setBackgroundDrawable(drawable);
        }
    }

    @TargetApi(value=11)
    public void setStatusBarAlpha(float f) {
        if (this.mStatusBarAvailable && Build.VERSION.SDK_INT >= 11) {
            this.mStatusBarTintView.setAlpha(f);
        }
    }

    public void setNavigationBarTintColor(int n) {
        if (this.mNavBarAvailable) {
            this.mNavBarTintView.setBackgroundColor(n);
        }
    }

    public void setNavigationBarTintResource(int n) {
        if (this.mNavBarAvailable) {
            this.mNavBarTintView.setBackgroundResource(n);
        }
    }

    public void setNavigationBarTintDrawable(Drawable drawable) {
        if (this.mNavBarAvailable) {
            this.mNavBarTintView.setBackgroundDrawable(drawable);
        }
    }

    @TargetApi(value=11)
    public void setNavigationBarAlpha(float f) {
        if (this.mNavBarAvailable && Build.VERSION.SDK_INT >= 11) {
            this.mNavBarTintView.setAlpha(f);
        }
    }

    public SystemBarConfig getConfig() {
        return this.mConfig;
    }

    public boolean isStatusBarTintEnabled() {
        return this.mStatusBarTintEnabled;
    }

    public boolean isNavBarTintEnabled() {
        return this.mNavBarTintEnabled;
    }

    private void setupStatusBarView(Context context, ViewGroup viewGroup) {
        this.mStatusBarTintView = new View(context);
        FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(-1, this.mConfig.getStatusBarHeight());
        layoutParams.gravity = 48;
        if (this.mNavBarAvailable && !this.mConfig.isNavigationAtBottom()) {
            layoutParams.rightMargin = this.mConfig.getNavigationBarWidth();
        }
        this.mStatusBarTintView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        this.mStatusBarTintView.setBackgroundColor(-1728053248);
        this.mStatusBarTintView.setVisibility(8);
        viewGroup.addView(this.mStatusBarTintView);
    }

    private void setupNavBarView(Context context, ViewGroup viewGroup) {
        FrameLayout.LayoutParams layoutParams;
        this.mNavBarTintView = new View(context);
        if (this.mConfig.isNavigationAtBottom()) {
            layoutParams = new FrameLayout.LayoutParams(-1, this.mConfig.getNavigationBarHeight());
            layoutParams.gravity = 80;
        } else {
            layoutParams = new FrameLayout.LayoutParams(this.mConfig.getNavigationBarWidth(), -1);
            layoutParams.gravity = 5;
        }
        this.mNavBarTintView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        this.mNavBarTintView.setBackgroundColor(-1728053248);
        this.mNavBarTintView.setVisibility(8);
        viewGroup.addView(this.mNavBarTintView);
    }

    static {
        if (Build.VERSION.SDK_INT >= 19) {
            try {
                Class<?> clazz = Class.forName("android.os.SystemProperties");
                Method method = clazz.getDeclaredMethod("get", String.class);
                method.setAccessible(true);
                sNavBarOverride = (String)method.invoke(null, "qemu.hw.mainkeys");
            }
            catch (Throwable throwable) {
                sNavBarOverride = null;
            }
        }
    }

    public static class SystemBarConfig {
        private static final String STATUS_BAR_HEIGHT_RES_NAME = "status_bar_height";
        private static final String NAV_BAR_HEIGHT_RES_NAME = "navigation_bar_height";
        private static final String NAV_BAR_HEIGHT_LANDSCAPE_RES_NAME = "navigation_bar_height_landscape";
        private static final String NAV_BAR_WIDTH_RES_NAME = "navigation_bar_width";
        private static final String SHOW_NAV_BAR_RES_NAME = "config_showNavigationBar";
        private final boolean mTranslucentStatusBar;
        private final boolean mTranslucentNavBar;
        private final int mStatusBarHeight;
        private final int mActionBarHeight;
        private final boolean mHasNavigationBar;
        private final int mNavigationBarHeight;
        private final int mNavigationBarWidth;
        private final boolean mInPortrait;
        private final float mSmallestWidthDp;

        private SystemBarConfig(Activity activity, boolean bl, boolean bl2) {
            Resources resources = activity.getResources();
            this.mInPortrait = resources.getConfiguration().orientation == 1;
            this.mSmallestWidthDp = this.getSmallestWidthDp(activity);
            this.mStatusBarHeight = this.getInternalDimensionSize(resources, STATUS_BAR_HEIGHT_RES_NAME);
            this.mActionBarHeight = this.getActionBarHeight((Context)activity);
            this.mNavigationBarHeight = this.getNavigationBarHeight((Context)activity);
            this.mNavigationBarWidth = this.getNavigationBarWidth((Context)activity);
            this.mHasNavigationBar = this.mNavigationBarHeight > 0;
            this.mTranslucentStatusBar = bl;
            this.mTranslucentNavBar = bl2;
        }

        @TargetApi(value=14)
        private int getActionBarHeight(Context context) {
            int n = 0;
            if (Build.VERSION.SDK_INT >= 14) {
                TypedValue typedValue = new TypedValue();
                context.getTheme().resolveAttribute(16843499, typedValue, true);
                n = TypedValue.complexToDimensionPixelSize((int)typedValue.data, (DisplayMetrics)context.getResources().getDisplayMetrics());
            }
            return n;
        }

        @TargetApi(value=14)
        private int getNavigationBarHeight(Context context) {
            Resources resources = context.getResources();
            int n = 0;
            if (Build.VERSION.SDK_INT >= 14 && this.hasNavBar(context)) {
                String string = this.mInPortrait ? NAV_BAR_HEIGHT_RES_NAME : NAV_BAR_HEIGHT_LANDSCAPE_RES_NAME;
                return this.getInternalDimensionSize(resources, string);
            }
            return n;
        }

        @TargetApi(value=14)
        private int getNavigationBarWidth(Context context) {
            Resources resources = context.getResources();
            int n = 0;
            if (Build.VERSION.SDK_INT >= 14 && this.hasNavBar(context)) {
                return this.getInternalDimensionSize(resources, NAV_BAR_WIDTH_RES_NAME);
            }
            return n;
        }

        @TargetApi(value=14)
        private boolean hasNavBar(Context context) {
            Resources resources = context.getResources();
            int n = resources.getIdentifier(SHOW_NAV_BAR_RES_NAME, "bool", "android");
            if (n != 0) {
                boolean bl = resources.getBoolean(n);
                if ("1".equals(sNavBarOverride)) {
                    bl = false;
                } else if ("0".equals(sNavBarOverride)) {
                    bl = true;
                }
                return bl;
            }
            return !ViewConfiguration.get((Context)context).hasPermanentMenuKey();
        }

        private int getInternalDimensionSize(Resources resources, String string) {
            int n = 0;
            int n2 = resources.getIdentifier(string, "dimen", "android");
            if (n2 > 0) {
                n = resources.getDimensionPixelSize(n2);
            }
            return n;
        }

        @SuppressLint(value={"NewApi"})
        private float getSmallestWidthDp(Activity activity) {
            DisplayMetrics displayMetrics = new DisplayMetrics();
            if (Build.VERSION.SDK_INT >= 16) {
                activity.getWindowManager().getDefaultDisplay().getRealMetrics(displayMetrics);
            } else {
                activity.getWindowManager().getDefaultDisplay().getMetrics(displayMetrics);
            }
            float f = (float)displayMetrics.widthPixels / displayMetrics.density;
            float f2 = (float)displayMetrics.heightPixels / displayMetrics.density;
            return Math.min(f, f2);
        }

        public boolean isNavigationAtBottom() {
            return this.mSmallestWidthDp >= 600.0f || this.mInPortrait;
        }

        public int getStatusBarHeight() {
            return this.mStatusBarHeight;
        }

        public int getActionBarHeight() {
            return this.mActionBarHeight;
        }

        public boolean hasNavigtionBar() {
            return this.mHasNavigationBar;
        }

        public int getNavigationBarHeight() {
            return this.mNavigationBarHeight;
        }

        public int getNavigationBarWidth() {
            return this.mNavigationBarWidth;
        }

        public int getPixelInsetTop(boolean bl) {
            return (this.mTranslucentStatusBar ? this.mStatusBarHeight : 0) + (bl ? this.mActionBarHeight : 0);
        }

        public int getPixelInsetBottom() {
            if (this.mTranslucentNavBar && this.isNavigationAtBottom()) {
                return this.mNavigationBarHeight;
            }
            return 0;
        }

        public int getPixelInsetRight() {
            if (this.mTranslucentNavBar && !this.isNavigationAtBottom()) {
                return this.mNavigationBarWidth;
            }
            return 0;
        }
    }
}

