/*
 * Decompiled with CFR 0.152.
 */
package com.amap.api.maps2d.overlay;

import android.content.Context;
import android.content.res.AssetManager;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Color;
import com.amap.api.a.x;
import com.amap.api.maps2d.AMap;
import com.amap.api.maps2d.CameraUpdateFactory;
import com.amap.api.maps2d.model.BitmapDescriptor;
import com.amap.api.maps2d.model.BitmapDescriptorFactory;
import com.amap.api.maps2d.model.LatLng;
import com.amap.api.maps2d.model.LatLngBounds;
import com.amap.api.maps2d.model.Marker;
import com.amap.api.maps2d.model.MarkerOptions;
import com.amap.api.maps2d.model.Polyline;
import com.amap.api.maps2d.overlay.a;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

public class RouteOverlay {
    protected List<Marker> stationMarkers = new ArrayList<Marker>();
    protected List<Polyline> allPolyLines = new ArrayList<Polyline>();
    protected Marker startMarker;
    protected Marker endMarker;
    protected LatLng startPoint;
    protected LatLng endPoint;
    protected AMap mAMap;
    private Context a;
    private Bitmap b;
    private Bitmap c;
    private Bitmap d;
    private Bitmap e;
    private Bitmap f;
    private AssetManager g;

    public RouteOverlay(Context context) {
        this.a = context;
        this.g = this.a.getResources().getAssets();
    }

    public void removeFromMap() {
        if (this.startMarker != null) {
            this.startMarker.remove();
        }
        if (this.endMarker != null) {
            this.endMarker.remove();
        }
        for (Marker object : this.stationMarkers) {
            object.remove();
        }
        for (Polyline polyline : this.allPolyLines) {
            polyline.remove();
        }
        this.a();
    }

    private void a() {
        if (this.b != null) {
            this.b.recycle();
            this.b = null;
        }
        if (this.c != null) {
            this.c.recycle();
            this.c = null;
        }
        if (this.d != null) {
            this.d.recycle();
            this.d = null;
        }
        if (this.e != null) {
            this.e.recycle();
            this.e = null;
        }
        if (this.f != null) {
            this.f.recycle();
            this.f = null;
        }
    }

    protected BitmapDescriptor getStartBitmapDescriptor() {
        return this.a(this.b, "amap_start.png");
    }

    protected BitmapDescriptor getEndBitmapDescriptor() {
        return this.a(this.c, "amap_end.png");
    }

    protected BitmapDescriptor getBusBitmapDescriptor() {
        return this.a(this.d, "amap_bus.png");
    }

    protected BitmapDescriptor getWalkBitmapDescriptor() {
        return this.a(this.e, "amap_man.png");
    }

    protected BitmapDescriptor getDriveBitmapDescriptor() {
        return this.a(this.f, "amap_car.png");
    }

    private BitmapDescriptor a(Bitmap bitmap, String string) {
        try {
            InputStream inputStream = this.g.open(string);
            bitmap = BitmapFactory.decodeStream((InputStream)inputStream);
            bitmap = com.amap.api.maps2d.overlay.a.a(bitmap, x.a);
            inputStream.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return BitmapDescriptorFactory.fromBitmap(bitmap);
    }

    protected void addStartAndEndMarker() {
        this.startMarker = this.mAMap.addMarker(new MarkerOptions().position(this.startPoint).icon(this.getStartBitmapDescriptor()).title("\u8d77\u70b9"));
        this.endMarker = this.mAMap.addMarker(new MarkerOptions().position(this.endPoint).icon(this.getEndBitmapDescriptor()).title("\u7ec8\u70b9"));
    }

    public void zoomToSpan() {
        if (this.startPoint != null && this.endPoint != null) {
            if (this.mAMap == null) {
                return;
            }
            LatLngBounds latLngBounds = this.getLatLngBounds();
            this.mAMap.moveCamera(CameraUpdateFactory.newLatLngBounds(latLngBounds, 50));
        }
    }

    protected LatLngBounds getLatLngBounds() {
        LatLngBounds.Builder builder = LatLngBounds.builder();
        builder.include(new LatLng(this.startPoint.latitude, this.startPoint.longitude));
        builder.include(new LatLng(this.endPoint.latitude, this.endPoint.longitude));
        return builder.build();
    }

    protected int getWalkColor() {
        return Color.parseColor((String)"#6db74d");
    }

    protected int getBusColor() {
        return Color.parseColor((String)"#537edc");
    }

    protected int getDriveColor() {
        return Color.parseColor((String)"#537edc");
    }
}

