/*
 * Decompiled with CFR 0.152.
 */
package com.amap.api.maps2d.model;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.view.View;
import android.widget.FrameLayout;
import com.amap.api.a.ao;
import com.amap.api.a.aw;
import com.amap.api.maps2d.model.BitmapDescriptor;
import java.io.FileInputStream;
import java.io.InputStream;

public final class BitmapDescriptorFactory {
    public static final float HUE_RED = 0.0f;
    public static final float HUE_ORANGE = 30.0f;
    public static final float HUE_YELLOW = 60.0f;
    public static final float HUE_GREEN = 120.0f;
    public static final float HUE_CYAN = 180.0f;
    public static final float HUE_AZURE = 210.0f;
    public static final float HUE_BLUE = 240.0f;
    public static final float HUE_VIOLET = 270.0f;
    public static final float HUE_MAGENTA = 300.0f;
    public static final float HUE_ROSE = 330.0f;

    public static BitmapDescriptor fromResource(int n2) {
        try {
            Context context = aw.a;
            if (context != null) {
                InputStream inputStream = context.getResources().openRawResource(n2);
                return BitmapDescriptorFactory.fromBitmap(BitmapFactory.decodeStream((InputStream)inputStream));
            }
            return null;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static BitmapDescriptor fromView(View view) {
        try {
            Context context = aw.a;
            if (context != null) {
                FrameLayout frameLayout = new FrameLayout(context);
                frameLayout.addView(view);
                frameLayout.destroyDrawingCache();
                return BitmapDescriptorFactory.fromBitmap(BitmapDescriptorFactory.a((View)frameLayout));
            }
            return null;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static Bitmap a(View view) {
        view.measure(View.MeasureSpec.makeMeasureSpec((int)0, (int)0), View.MeasureSpec.makeMeasureSpec((int)0, (int)0));
        view.layout(0, 0, view.getMeasuredWidth(), view.getMeasuredHeight());
        view.buildDrawingCache();
        Bitmap bitmap = view.getDrawingCache().copy(Bitmap.Config.ARGB_8888, false);
        return bitmap;
    }

    public static BitmapDescriptor fromPath(String string) {
        try {
            Bitmap bitmap = BitmapFactory.decodeFile((String)string);
            return BitmapDescriptorFactory.fromBitmap(bitmap);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static BitmapDescriptor fromAsset(String string) {
        try {
            InputStream inputStream = BitmapDescriptorFactory.class.getResourceAsStream("/assets/" + string);
            Bitmap bitmap = BitmapFactory.decodeStream((InputStream)inputStream);
            inputStream.close();
            return BitmapDescriptorFactory.fromBitmap(bitmap);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static BitmapDescriptor fromFile(String string) {
        try {
            Context context = aw.a;
            if (context != null) {
                FileInputStream fileInputStream = context.openFileInput(string);
                Bitmap bitmap = BitmapFactory.decodeStream((InputStream)fileInputStream);
                fileInputStream.close();
                return BitmapDescriptorFactory.fromBitmap(bitmap);
            }
            return null;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static BitmapDescriptor defaultMarker() {
        try {
            return BitmapDescriptorFactory.fromAsset(ao.a.b.name() + ".png");
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static BitmapDescriptor defaultMarker(float f2) {
        try {
            f2 = (int)(f2 + 15.0f) / 30 * 30;
            if (f2 > 330.0f) {
                f2 = 330.0f;
            } else if (f2 < 0.0f) {
                f2 = 0.0f;
            }
            String string = "";
            if (f2 == 0.0f) {
                string = "RED";
            } else if (f2 == 30.0f) {
                string = "ORANGE";
            } else if (f2 == 60.0f) {
                string = "YELLOW";
            } else if (f2 == 120.0f) {
                string = "GREEN";
            } else if (f2 == 180.0f) {
                string = "CYAN";
            } else if (f2 == 210.0f) {
                string = "AZURE";
            } else if (f2 == 240.0f) {
                string = "BLUE";
            } else if (f2 == 270.0f) {
                string = "VIOLET";
            } else if (f2 == 300.0f) {
                string = "MAGENTAV";
            } else if (f2 == 330.0f) {
                string = "ROSE";
            }
            return BitmapDescriptorFactory.fromAsset(string + ".png");
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static BitmapDescriptor fromBitmap(Bitmap bitmap) {
        if (bitmap == null) {
            return null;
        }
        BitmapDescriptor bitmapDescriptor = new BitmapDescriptor(bitmap);
        return bitmapDescriptor;
    }
}

