/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.startup;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URL;
import java.net.URLClassLoader;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.WeakHashMap;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.logging.StreamHandler;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.netbeans.TopSecurityManager;
import org.netbeans.core.startup.CLIOptions;
import org.netbeans.core.startup.StartLog;
import org.openide.filesystems.FileUtil;
import org.openide.modules.Places;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.xml.sax.SAXParseException;

public final class TopLogging {
    private static boolean disabledConsole;
    private static final PrintStream OLD_ERR;
    private static final PrintStream DEBUG;
    private static final Pattern unwantedMessages;
    private static File previousUser;
    private static NonClose streamHandler;
    private static NonClose defaultHandler;
    private static final Map<Throwable, Integer> catchIndex;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TopLogging() {
        AWTHandler.install();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        PrintStream printStream = new PrintStream(byteArrayOutputStream);
        LinkedList<Logger> linkedList = new LinkedList<Logger>();
        for (Map.Entry<Object, Object> handlerArray2 : System.getProperties().entrySet()) {
            String i = (String)handlerArray2.getKey();
            if ("sun.os.patch.level".equals(i)) continue;
            String string = (String)handlerArray2.getValue();
            if (!i.endsWith(".level")) continue;
            printStream.print(i);
            printStream.print('=');
            printStream.println(string);
            linkedList.add(Logger.getLogger(i.substring(0, i.length() - 6)));
        }
        printStream.close();
        try {
            StartLog.unregister();
            LogManager.getLogManager().readConfiguration(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        finally {
            StartLog.register();
        }
        Logger logger = Logger.getLogger("");
        Handler[] handlerArray = logger.getHandlers();
        for (int i = 0; i < handlerArray.length; ++i) {
            logger.removeHandler(handlerArray[i]);
        }
        logger.addHandler(TopLogging.defaultHandler());
        if (!disabledConsole) {
            logger.addHandler(TopLogging.streamHandler());
        }
        logger.addHandler(new LookupDel());
    }

    public static void initializeQuietly() {
        TopLogging.initialize(false);
    }

    static final void initialize() {
        TopLogging.initialize(true);
    }

    private static void initialize(boolean bl) {
        block11: {
            AWTHandler.install();
            if (previousUser == null || previousUser.equals(Places.getUserDirectory())) {
                streamHandler = null;
                defaultHandler = null;
            }
            if (System.getProperty("java.util.logging.config.file") != null) {
                return;
            }
            String string = System.getProperty("java.util.logging.config.class");
            String string2 = TopLogging.class.getName();
            if (string != null && !string.equals(string2)) {
                return;
            }
            new TopLogging();
            System.setProperty("java.util.logging.config.class", string2);
            if (bl) {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                PrintStream printStream = new PrintStream(byteArrayOutputStream);
                TopLogging.printSystemInfo(printStream);
                printStream.close();
                try {
                    Logger logger = Logger.getLogger(TopLogging.class.getName());
                    logger.log(Level.INFO, byteArrayOutputStream.toString("utf-8"));
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    if ($assertionsDisabled) break block11;
                    throw new AssertionError();
                }
            }
        }
        if (!Boolean.getBoolean("netbeans.logger.noSystem")) {
            if (!(System.err instanceof LgStream)) {
                System.setErr(new LgStream(Logger.getLogger("stderr")));
                if (DEBUG != null) {
                    DEBUG.println("initializing stderr");
                }
            }
            if (!(System.out instanceof LgStream)) {
                System.setOut(new LgStream(Logger.getLogger("stderr")));
                if (DEBUG != null) {
                    DEBUG.println("initializing stdout");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void printSystemInfo(PrintStream printStream) {
        Object object;
        Object object222;
        Object object322;
        Object object4;
        Object object5;
        DateFormat dateFormat = DateFormat.getDateTimeInstance(0, 0, Locale.US);
        Date date = new Date();
        printStream.println("-------------------------------------------------------------------------------");
        printStream.println(">Log Session: " + dateFormat.format(date));
        printStream.println(">System Info: ");
        ArrayList<Object> arrayList = new ArrayList<Object>();
        String string = System.getProperty("netbeans.dirs");
        if (string != null) {
            object5 = new StringTokenizer(string, File.pathSeparator);
            while (((StringTokenizer)object5).hasMoreTokens()) {
                object4 = FileUtil.normalizeFile((File)new File(((StringTokenizer)object5).nextToken()));
                if (!((File)object4).isDirectory()) continue;
                arrayList.add(object4);
            }
        }
        object5 = System.getProperty("netbeans.buildnumber");
        object4 = NbBundle.getMessage(TopLogging.class, (String)"currentVersion", (Object)object5);
        System.setProperty("netbeans.productversion", (String)object4);
        printStream.print("  Product Version         = " + (String)object4);
        block6: for (Object object322 : arrayList) {
            object222 = new File((File)object322, "build_info");
            if (!((File)object222).isFile()) continue;
            try {
                object = new FileReader((File)object222);
                try {
                    String string2;
                    URL[] uRLArray = new BufferedReader((Reader)object);
                    Pattern pattern = Pattern.compile("Hg ID:    ([0-9a-f]{12})");
                    while ((string2 = uRLArray.readLine()) != null) {
                        Matcher object6 = pattern.matcher(string2);
                        if (!object6.matches()) continue;
                        printStream.print(" (#" + object6.group(1) + ")");
                        break block6;
                    }
                }
                finally {
                    ((Reader)object).close();
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace(printStream);
            }
            break;
        }
        printStream.println();
        printStream.println("  Operating System        = " + System.getProperty("os.name", "unknown") + " version " + System.getProperty("os.version", "unknown") + " running on " + System.getProperty("os.arch", "unknown"));
        printStream.println("  Java; VM; Vendor        = " + System.getProperty("java.version", "unknown") + "; " + System.getProperty("java.vm.name", "unknown") + " " + System.getProperty("java.vm.version", "") + "; " + System.getProperty("java.vendor", "unknown"));
        printStream.println("  Runtime                 = " + System.getProperty("java.runtime.name", "unknown") + " " + System.getProperty("java.runtime.version", ""));
        printStream.println("  Java Home               = " + System.getProperty("java.home", "unknown"));
        printStream.print("  System Locale; Encoding = " + Locale.getDefault());
        String string3 = NbBundle.getBranding();
        if (string3 != null) {
            printStream.print(" (" + (String)string3 + ")");
        }
        printStream.println("; " + System.getProperty("file.encoding", "unknown"));
        printStream.println("  Home Directory          = " + System.getProperty("user.home", "unknown"));
        printStream.println("  Current Directory       = " + System.getProperty("user.dir", "unknown"));
        printStream.print("  User Directory          = ");
        printStream.println(CLIOptions.getUserDir());
        printStream.println("  Cache Directory         = " + Places.getCacheDirectory());
        printStream.print("  Installation            = ");
        for (Object object222 : arrayList) {
            printStream.print(object222 + "\n                            ");
        }
        printStream.println(CLIOptions.getHomeDir());
        printStream.println("  Boot & Ext. Classpath   = " + TopLogging.createBootClassPath());
        object222 = Lookup.class.getClassLoader();
        if (object222 == ClassLoader.getSystemClassLoader()) {
            object322 = System.getProperty("java.class.path", "unknown");
        } else {
            object = new StringBuilder("loaded by ");
            if (object222 instanceof URLClassLoader) {
                ((StringBuilder)object).append("URLClassLoader");
                for (URL uRL : ((URLClassLoader)object222).getURLs()) {
                    ((StringBuilder)object).append(' ').append(uRL);
                }
            } else {
                ((StringBuilder)object).append(object222);
            }
            object322 = ((StringBuilder)object).toString();
        }
        printStream.println("  Application Classpath   = " + (String)object322);
        printStream.println("  Startup Classpath       = " + System.getProperty("netbeans.dynamic.classpath", "unknown"));
        printStream.println("-------------------------------------------------------------------------------");
    }

    private static String createBootClassPath() {
        String string = System.getProperty("sun.boot.class.path");
        StringBuffer stringBuffer = string != null ? new StringBuffer(string) : new StringBuffer();
        TopLogging.findBootJars(System.getProperty("java.ext.dirs"), stringBuffer);
        TopLogging.findBootJars(System.getProperty("java.endorsed.dirs"), stringBuffer);
        return stringBuffer.toString();
    }

    private static void findBootJars(String string, StringBuffer stringBuffer) {
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, File.pathSeparator);
            while (stringTokenizer.hasMoreTokens()) {
                File file = new File(stringTokenizer.nextToken());
                File[] fileArray = file.listFiles();
                if (fileArray == null) continue;
                for (int i = 0; i < fileArray.length; ++i) {
                    String string2 = fileArray[i].getName().toLowerCase(Locale.US);
                    if (!string2.endsWith(".zip") && !string2.endsWith(".jar")) continue;
                    if (stringBuffer.length() > 0) {
                        stringBuffer.append(File.pathSeparatorChar);
                    }
                    stringBuffer.append(fileArray[i].getPath());
                }
            }
        }
    }

    static Handler createStreamHandler(PrintStream printStream) {
        StreamHandler streamHandler = new StreamHandler(printStream, NbFormatter.FORMATTER);
        return new NonClose(streamHandler, 50);
    }

    private static synchronized NonClose streamHandler() {
        if (streamHandler == null) {
            StreamHandler streamHandler = new StreamHandler(OLD_ERR, NbFormatter.FORMATTER);
            streamHandler.setLevel(Level.ALL);
            TopLogging.streamHandler = new NonClose(streamHandler, 500);
        }
        return streamHandler;
    }

    private static synchronized NonClose defaultHandler() {
        if (defaultHandler != null) {
            return defaultHandler;
        }
        File file = Places.getUserDirectory();
        if (file != null && !CLIOptions.noLogging) {
            try {
                File file2 = new File(new File(file, "var"), "log");
                file2.mkdirs();
                File file3 = new File(file2, "messages.log");
                File file4 = new File(file2, "messages.log.1");
                File file5 = new File(file2, "messages.log.2");
                if (file5.exists()) {
                    file5.delete();
                }
                if (file4.exists()) {
                    file4.renameTo(file5);
                }
                if (file3.exists()) {
                    file3.renameTo(file4);
                }
                FileOutputStream fileOutputStream = new FileOutputStream(file3, false);
                StreamHandler streamHandler = new StreamHandler(fileOutputStream, NbFormatter.FORMATTER);
                streamHandler.setLevel(Level.ALL);
                streamHandler.setFormatter(NbFormatter.FORMATTER);
                defaultHandler = new NonClose(streamHandler, 5000);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        if (defaultHandler == null) {
            defaultHandler = TopLogging.streamHandler();
            disabledConsole = true;
        }
        return defaultHandler;
    }

    static void flush(boolean bl) {
        NonClose nonClose;
        System.err.flush();
        NonClose nonClose2 = streamHandler;
        if (nonClose2 != null) {
            ((Handler)nonClose2).flush();
        }
        if ((nonClose = defaultHandler) != null) {
            ((Handler)nonClose).flush();
        }
        if (bl) {
            streamHandler = null;
            defaultHandler = null;
        }
    }

    static void close() {
        NonClose nonClose;
        NonClose nonClose2 = streamHandler;
        if (nonClose2 != null) {
            nonClose2.doClose();
        }
        if ((nonClose = defaultHandler) != null) {
            nonClose.doClose();
        }
    }

    static void exit(int n) {
        TopLogging.flush(false);
        TopSecurityManager.exit((int)n);
    }

    public static void printStackTrace(Throwable throwable, PrintWriter printWriter) {
        TopLogging.doPrintStackTrace(printWriter, throwable, null);
    }

    private static void doPrintStackTrace(PrintWriter printWriter, Throwable throwable, Throwable throwable2) {
        int n;
        int n2;
        Object object;
        Object object2;
        Throwable throwable3;
        block10: {
            try {
                if (throwable.getClass().getMethod("printStackTrace", PrintWriter.class).getDeclaringClass() != Throwable.class) {
                    throwable.printStackTrace(printWriter);
                    return;
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
                if ($assertionsDisabled) break block10;
                throw new AssertionError((Object)noSuchMethodException);
            }
        }
        if ((throwable3 = throwable.getCause()) != null) {
            TopLogging.doPrintStackTrace(printWriter, throwable3, throwable);
            printWriter.print("Caused: ");
        }
        String string = throwable.toString();
        if (throwable3 != null && string.endsWith((String)(object2 = ": " + throwable3))) {
            string = string.substring(0, string.length() - ((String)object2).length());
        }
        printWriter.println(string);
        object2 = throwable.getStackTrace();
        if (throwable2 != null) {
            object = throwable2.getStackTrace();
            for (n2 = ((StackTraceElement[])object2).length; n2 > 0 && (n = n2 + ((StackTraceElement[])object).length - ((Object)object2).length) > 0 && ((StackTraceElement)object[n - 1]).equals(object2[n2 - 1]); --n2) {
            }
        }
        object = catchIndex.get(throwable);
        for (n = 0; n < n2; ++n) {
            if (object != null && n == (Integer)object) {
                printWriter.print("[catch] at ");
            } else {
                printWriter.print("\tat ");
            }
            printWriter.println(object2[n]);
        }
    }

    static {
        Serializable serializable;
        disabledConsole = !Boolean.getBoolean("netbeans.logger.console");
        OLD_ERR = System.err;
        PrintStream printStream = null;
        String string = System.getProperty("TopLogging.unwantedMessages");
        if (string != null || Boolean.getBoolean("TopLogging.DEBUG")) {
            try {
                serializable = new File(System.getProperty("java.io.tmpdir"), "TopLogging.log");
                System.err.println("Logging sent to: " + serializable);
                printStream = new PrintStream(new FileOutputStream((File)serializable), true);
            }
            catch (FileNotFoundException fileNotFoundException) {
                fileNotFoundException.printStackTrace();
            }
        }
        DEBUG = printStream;
        serializable = null;
        if (string != null) {
            try {
                serializable = Pattern.compile(string);
                DEBUG.println("On the lookout for log messages matching: " + string);
            }
            catch (PatternSyntaxException patternSyntaxException) {
                patternSyntaxException.printStackTrace();
            }
        }
        unwantedMessages = serializable;
        catchIndex = Collections.synchronizedMap(new WeakHashMap());
    }

    private static final class AWTHandler
    implements Thread.UncaughtExceptionHandler {
        private final Thread.UncaughtExceptionHandler delegate;
        private final Logger g;

        private AWTHandler(Thread.UncaughtExceptionHandler uncaughtExceptionHandler) {
            this.delegate = uncaughtExceptionHandler;
            this.g = Logger.getLogger("global");
        }

        static void install() {
            if (Thread.getDefaultUncaughtExceptionHandler() instanceof AWTHandler) {
                return;
            }
            Thread.setDefaultUncaughtExceptionHandler(new AWTHandler(Thread.getDefaultUncaughtExceptionHandler()));
        }

        @Override
        public void uncaughtException(Thread thread, Throwable throwable) {
            if (this.delegate != null) {
                this.delegate.uncaughtException(thread, throwable);
            }
            if (throwable.getClass().getName().endsWith(".ExitSecurityException")) {
                return;
            }
            if (throwable instanceof ThreadDeath) {
                return;
            }
            this.g.log(Level.SEVERE, null, throwable);
        }
    }

    private static final class LookupDel
    extends Handler
    implements LookupListener {
        private Lookup.Result<Handler> handlers = Lookup.getDefault().lookupResult(Handler.class);
        private Collection<? extends Handler> instances = this.handlers.allInstances();

        public LookupDel() {
            this.handlers.addLookupListener((LookupListener)this);
        }

        @Override
        public void publish(LogRecord logRecord) {
            for (Handler handler : this.instances) {
                handler.publish(logRecord);
            }
        }

        @Override
        public void flush() {
            for (Handler handler : this.instances) {
                handler.flush();
            }
        }

        @Override
        public void close() throws SecurityException {
            for (Handler handler : this.instances) {
                handler.close();
            }
        }

        public void resultChanged(LookupEvent lookupEvent) {
            this.instances = this.handlers.allInstances();
        }
    }

    private static final class LgStream
    extends PrintStream
    implements Runnable {
        private Logger log;
        private final StringBuilder sb = new StringBuilder();
        private static RequestProcessor RP = new RequestProcessor("StdErr Flush");
        private RequestProcessor.Task flush = RP.create((Runnable)this, true);

        public LgStream(Logger logger) {
            super(new ByteArrayOutputStream());
            this.log = logger;
        }

        @Override
        public void write(byte[] byArray, int n, int n2) {
            if (RP.isRequestProcessorThread()) {
                return;
            }
            String string = new String(byArray, n, n2);
            this.print(string);
        }

        @Override
        public void write(byte[] byArray) throws IOException {
            this.write(byArray, 0, byArray.length);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void write(int n) {
            if (RP.isRequestProcessorThread()) {
                return;
            }
            StringBuilder stringBuilder = this.sb;
            synchronized (stringBuilder) {
                this.sb.append((char)n);
            }
            this.checkFlush();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void print(String string) {
            if (unwantedMessages != null && unwantedMessages.matcher(string).find()) {
                new Exception().printStackTrace(DEBUG);
            }
            StringBuilder stringBuilder = this.sb;
            synchronized (stringBuilder) {
                this.sb.append(string);
            }
            this.checkFlush();
        }

        @Override
        public void println(String string) {
            this.print(string);
            this.print(System.getProperty("line.separator"));
        }

        @Override
        public void println(Object object) {
            String string = String.valueOf(object);
            this.println(string);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void flush() {
            boolean bl;
            StringBuilder stringBuilder = this.sb;
            synchronized (stringBuilder) {
                bl = this.sb.length() == 0;
            }
            if (!bl) {
                try {
                    this.flush.schedule(0);
                    this.flush.waitFinished(500L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            super.flush();
        }

        private void checkFlush() {
            try {
                this.flush.schedule(100);
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block3: while (true) {
                String string;
                int n;
                StringBuilder stringBuilder = this.sb;
                synchronized (stringBuilder) {
                    if (this.sb.length() == 0) {
                        break;
                    }
                    n = -1;
                    for (int i = this.sb.length() - 1; i >= 0; --i) {
                        if (this.sb.charAt(i) != '\n') continue;
                        n = i;
                        break;
                    }
                    if (n == -1) {
                        break;
                    }
                    string = this.sb.substring(0, n + 1);
                    this.sb.delete(0, n + 1);
                }
                int n2 = 0;
                while (true) {
                    if (n2 >= string.length()) continue block3;
                    n = string.indexOf(10, n2);
                    this.log.log(Level.INFO, string.substring(n2, n + 1));
                    n2 = n + 1;
                }
                break;
            }
        }
    }

    private static final class NbFormatter
    extends Formatter {
        private static String lineSeparator = System.getProperty("line.separator");
        static Formatter FORMATTER = new NbFormatter();

        private NbFormatter() {
        }

        @Override
        public String format(LogRecord logRecord) {
            StringBuilder stringBuilder = new StringBuilder();
            this.print(stringBuilder, logRecord, new HashSet<Throwable>());
            String string = stringBuilder.toString();
            if (DEBUG != null) {
                DEBUG.print("received: " + string);
            }
            if (unwantedMessages != null && unwantedMessages.matcher(string).find()) {
                new Exception().printStackTrace(DEBUG);
            }
            return string;
        }

        private void print(StringBuilder stringBuilder, LogRecord logRecord, Set<Throwable> set) {
            String string = this.formatMessage(logRecord);
            if (string != null && string.indexOf(10) != -1 && logRecord.getThrown() == null) {
                stringBuilder.append(string);
                if (string.charAt(string.length() - 1) != '\n') {
                    stringBuilder.append(lineSeparator);
                }
                return;
            }
            if ("stderr".equals(logRecord.getLoggerName()) && logRecord.getLevel() == Level.INFO) {
                stringBuilder.append(string);
                return;
            }
            stringBuilder.append(logRecord.getLevel().getName());
            NbFormatter.addLoggerName(stringBuilder, logRecord);
            if (string != null) {
                stringBuilder.append(": ");
                stringBuilder.append(string);
            }
            stringBuilder.append(lineSeparator);
            if (logRecord.getThrown() != null && logRecord.getLevel().intValue() != 1973) {
                LogRecord[] logRecordArray;
                try {
                    logRecordArray = new StringWriter();
                    LogRecord[] logRecordArray2 = new PrintWriter((Writer)logRecordArray);
                    TopLogging.printStackTrace(logRecord.getThrown(), (PrintWriter)logRecordArray2);
                    logRecordArray2.close();
                    stringBuilder.append(logRecordArray.toString());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                logRecordArray = NbFormatter.extractDelegates(stringBuilder, logRecord.getThrown(), set);
                if (logRecordArray != null) {
                    for (LogRecord logRecord2 : logRecordArray) {
                        this.print(stringBuilder, logRecord2, set);
                    }
                }
                this.specialProcessing(stringBuilder, logRecord.getThrown(), set);
            }
        }

        private static void addLoggerName(StringBuilder stringBuilder, LogRecord logRecord) {
            String string = logRecord.getLoggerName();
            if (!"".equals(string)) {
                stringBuilder.append(" [");
                stringBuilder.append(string);
                stringBuilder.append(']');
            }
        }

        private static LogRecord[] extractDelegates(StringBuilder stringBuilder, Throwable throwable, Set<Throwable> set) {
            if (!set.add(throwable)) {
                stringBuilder.append("warning: cyclic dependency between annotated throwables");
                return null;
            }
            if (throwable instanceof Callable) {
                Object var3_3 = null;
                try {
                    var3_3 = ((Callable)((Object)throwable)).call();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                if (var3_3 instanceof LogRecord[]) {
                    return var3_3;
                }
            }
            if (throwable == null) {
                return null;
            }
            return NbFormatter.extractDelegates(stringBuilder, throwable.getCause(), set);
        }

        private void specialProcessing(StringBuilder stringBuilder, Throwable throwable, Set<Throwable> set) {
            Object object;
            String string;
            Exception exception;
            if (throwable instanceof MissingResourceException) {
                exception = (MissingResourceException)throwable;
                string = ((MissingResourceException)exception).getClassName();
                if (string != null) {
                    object = new LogRecord(Level.CONFIG, null);
                    ((LogRecord)object).setResourceBundle(NbBundle.getBundle(TopLogging.class));
                    ((LogRecord)object).setMessage("EXC_MissingResourceException_class_name");
                    ((LogRecord)object).setParameters(new Object[]{string});
                    this.print(stringBuilder, (LogRecord)object, set);
                }
                if ((object = ((MissingResourceException)exception).getKey()) != null) {
                    LogRecord logRecord = new LogRecord(Level.CONFIG, null);
                    logRecord.setResourceBundle(NbBundle.getBundle(TopLogging.class));
                    logRecord.setMessage("EXC_MissingResourceException_key");
                    logRecord.setParameters(new Object[]{object});
                    this.print(stringBuilder, logRecord, set);
                }
            }
            if (throwable instanceof SAXParseException) {
                exception = (SAXParseException)throwable;
                string = ((SAXParseException)exception).getPublicId();
                object = ((SAXParseException)exception).getSystemId();
                if (string != null || object != null) {
                    Object[] objectArray;
                    String string2;
                    int n = ((SAXParseException)exception).getColumnNumber();
                    int n2 = ((SAXParseException)exception).getLineNumber();
                    if (n != -1 || n2 != -1) {
                        string2 = "EXC_sax_parse_col_line";
                        objectArray = new Object[]{String.valueOf(string), String.valueOf(object), n, n2};
                    } else {
                        string2 = "EXC_sax_parse";
                        objectArray = new Object[]{String.valueOf(string), String.valueOf(object)};
                    }
                    LogRecord logRecord = new LogRecord(Level.CONFIG, null);
                    logRecord.setResourceBundle(NbBundle.getBundle(TopLogging.class));
                    logRecord.setMessage(string2);
                    logRecord.setParameters(objectArray);
                    this.print(stringBuilder, logRecord, set);
                }
            }
        }
    }

    private static final class NonClose
    extends Handler
    implements Runnable {
        private static RequestProcessor RP = new RequestProcessor("Logging Flush", 1, false, false);
        private static ThreadLocal<Boolean> FLUSHING = new ThreadLocal();
        private final Handler delegate;
        private final BlockingQueue<LogRecord> queue = new LinkedBlockingQueue<LogRecord>(1000);
        private RequestProcessor.Task flush;
        private int delay;

        public NonClose(Handler handler, int n) {
            this.delegate = handler;
            this.flush = RP.create((Runnable)this, true);
            this.flush.setPriority(1);
            this.delay = n;
        }

        @Override
        public void publish(LogRecord logRecord) {
            Throwable throwable;
            if (RP.isRequestProcessorThread()) {
                return;
            }
            if (!this.queue.offer(logRecord)) {
                while (true) {
                    try {
                        if (!this.schedule(0)) {
                            return;
                        }
                        this.queue.put(logRecord);
                        Thread.yield();
                    }
                    catch (InterruptedException interruptedException) {
                        continue;
                    }
                    break;
                }
            }
            if ((throwable = logRecord.getThrown()) != null) {
                StackTraceElement[] stackTraceElementArray = throwable.getStackTrace();
                StackTraceElement[] stackTraceElementArray2 = new Throwable().getStackTrace();
                for (int i = 1; i <= Math.min(stackTraceElementArray.length, stackTraceElementArray2.length); ++i) {
                    if (stackTraceElementArray[stackTraceElementArray.length - i].equals(stackTraceElementArray2[stackTraceElementArray2.length - i])) continue;
                    catchIndex.put(throwable, stackTraceElementArray.length - i);
                    break;
                }
            }
            this.schedule(this.delay);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean schedule(int n) {
            if (!Boolean.TRUE.equals(FLUSHING.get())) {
                try {
                    FLUSHING.set(true);
                    this.flush.schedule(n);
                }
                finally {
                    FLUSHING.set(false);
                }
                return true;
            }
            return false;
        }

        @Override
        public void flush() {
            this.flush.cancel();
            this.flush.waitFinished();
            this.run();
        }

        @Override
        public void close() throws SecurityException {
            this.flush();
            this.delegate.flush();
        }

        public void doClose() throws SecurityException {
            this.flush();
            this.delegate.close();
        }

        @Override
        public Formatter getFormatter() {
            return this.delegate.getFormatter();
        }

        static Handler getInternal(Handler handler) {
            if (handler instanceof NonClose) {
                return ((NonClose)handler).delegate;
            }
            return handler;
        }

        @Override
        public void run() {
            LogRecord logRecord;
            while ((logRecord = (LogRecord)this.queue.poll()) != null) {
                this.delegate.publish(logRecord);
            }
            this.delegate.flush();
        }
    }
}

