/*
 * Decompiled with CFR 0.152.
 */
package ipc.android.sdk.com;

import android.annotation.TargetApi;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import ipc.android.sdk.com.AbstractDataSerialBase;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;

public class NetSDK_Media_Video_Config
extends AbstractDataSerialBase
implements Cloneable {
    public Capture capture = new Capture();
    public Encode encode = new Encode();
    public JpegConfig jpeg = new JpegConfig();
    public Overlay overlay = new Overlay();
    public Mask mask = new Mask();

    public Object clone() {
        try {
            NetSDK_Media_Video_Config netSDK_Media_Video_Config = (NetSDK_Media_Video_Config)super.clone();
            netSDK_Media_Video_Config.capture = (Capture)this.capture.clone();
            netSDK_Media_Video_Config.encode = (Encode)this.encode.clone();
            netSDK_Media_Video_Config.jpeg = (JpegConfig)this.jpeg.clone();
            netSDK_Media_Video_Config.overlay = (Overlay)this.overlay.clone();
            netSDK_Media_Video_Config.mask = (Mask)this.mask.clone();
            return netSDK_Media_Video_Config;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            cloneNotSupportedException.printStackTrace();
            return null;
        }
    }

    @TargetApi(value=9)
    public Object fromXML(String string) {
        Object object = null;
        if (this.mXStream == null || string == null) {
            return object;
        }
        this.mXStream.registerConverter((Converter)new MediaVideoConfigConverter());
        this.mXStream.alias("Video", NetSDK_Media_Video_Config.class);
        object = this.mXStream.fromXML(string);
        return object;
    }

    @Override
    public String toXMLString() {
        String string = null;
        if (this.mXStream == null) {
            return null;
        }
        this.mXStream.registerConverter((Converter)new MediaVideoConfigConverter());
        this.mXStream.alias("Video", NetSDK_Media_Video_Config.class);
        string = this.mXStream.toXML((Object)this);
        if (string != null && this.mIsAddHead && !this.haveHead(string)) {
            string = this.mDefaultHead + string;
        }
        return string;
    }

    public String getEncodeXMLString() {
        String string = null;
        if (this.mXStream == null) {
            return null;
        }
        this.mXStream.registerConverter((Converter)new EncodeConverter());
        this.mXStream.alias("Encode", Encode.class);
        string = this.mXStream.toXML((Object)this.encode);
        if (string != null && this.mIsAddHead && !this.haveHead(string)) {
            string = this.mDefaultHead + string;
        }
        return string;
    }

    public String getCaptureXMLString() {
        String string = null;
        if (this.mXStream == null) {
            return null;
        }
        this.mXStream.registerConverter((Converter)new CaptureConverter());
        this.mXStream.alias("Capture", Capture.class);
        string = this.mXStream.toXML((Object)this.capture);
        if (string != null && this.mIsAddHead && !this.haveHead(string)) {
            string = this.mDefaultHead + string;
        }
        return string;
    }

    public String getOverlayXMLString() {
        String string = null;
        if (this.mXStream == null) {
            return null;
        }
        this.mXStream.registerConverter((Converter)new OverlayConverter());
        this.mXStream.alias("Overlay", Overlay.class);
        string = this.mXStream.toXML((Object)this.overlay);
        if (string != null && this.mIsAddHead && !this.haveHead(string)) {
            string = this.mDefaultHead + string;
        }
        return string;
    }

    private String encodeTitle(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        byte[] byArray = new byte[]{};
        try {
            byArray = string.getBytes("gbk");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
        }
        for (byte by : byArray) {
            stringBuilder.append(Integer.toHexString(by & 0xFF));
        }
        return stringBuilder.toString();
    }

    private String decodeTitle(String string) {
        byte[] byArray = new byte[string.length() / 2];
        for (int i = 0; i < byArray.length; ++i) {
            String string2 = string.substring(i * 2, i * 2 + 2);
            int n = Integer.parseInt(string2, 16);
            byArray[i] = (byte)n;
        }
        try {
            return new String(byArray, "gbk");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
            return "";
        }
    }

    class OverlayConverter
    implements Converter {
        OverlayConverter() {
        }

        public void marshal(Object object, HierarchicalStreamWriter hierarchicalStreamWriter, MarshallingContext marshallingContext) {
            Overlay overlay = (Overlay)object;
            hierarchicalStreamWriter.addAttribute("Enable", overlay.Enable);
            hierarchicalStreamWriter.addAttribute("Transparency", overlay.Transparency);
            hierarchicalStreamWriter.startNode("TimeOverlay");
            hierarchicalStreamWriter.addAttribute("PosX", overlay.timeOverlay.PosX);
            hierarchicalStreamWriter.addAttribute("PosY", overlay.timeOverlay.PosY);
            hierarchicalStreamWriter.addAttribute("Format", overlay.timeOverlay.Format);
            hierarchicalStreamWriter.endNode();
            hierarchicalStreamWriter.startNode("TitleOverlay");
            hierarchicalStreamWriter.addAttribute("PosX", overlay.titleOverlay.PosX);
            hierarchicalStreamWriter.addAttribute("PosY", overlay.titleOverlay.PosY);
            String string = NetSDK_Media_Video_Config.this.encodeTitle(overlay.titleOverlay.Title);
            hierarchicalStreamWriter.addAttribute("Title", string);
            hierarchicalStreamWriter.endNode();
        }

        public Object unmarshal(HierarchicalStreamReader hierarchicalStreamReader, UnmarshallingContext unmarshallingContext) {
            return null;
        }

        public boolean canConvert(Class clazz) {
            return clazz.equals(Overlay.class);
        }
    }

    class MediaVideoConfigConverter
    implements Converter {
        MediaVideoConfigConverter() {
        }

        public void marshal(Object object, HierarchicalStreamWriter hierarchicalStreamWriter, MarshallingContext marshallingContext) {
            NetSDK_Media_Video_Config netSDK_Media_Video_Config = (NetSDK_Media_Video_Config)object;
            hierarchicalStreamWriter.startNode("Capture");
            hierarchicalStreamWriter.addAttribute("Brightness", netSDK_Media_Video_Config.capture.Brightness);
            hierarchicalStreamWriter.addAttribute("Contrast", netSDK_Media_Video_Config.capture.Contrast);
            hierarchicalStreamWriter.addAttribute("Saturation", netSDK_Media_Video_Config.capture.Saturation);
            hierarchicalStreamWriter.addAttribute("Sharpness", netSDK_Media_Video_Config.capture.Sharpness);
            hierarchicalStreamWriter.addAttribute("DayNight", netSDK_Media_Video_Config.capture.DayNight);
            hierarchicalStreamWriter.addAttribute("WhiteBalance", netSDK_Media_Video_Config.capture.WhiteBalance);
            hierarchicalStreamWriter.addAttribute("BackLight", netSDK_Media_Video_Config.capture.BackLight);
            hierarchicalStreamWriter.addAttribute("Switch2A", netSDK_Media_Video_Config.capture.Switch2A);
            hierarchicalStreamWriter.addAttribute("BinningSkip", netSDK_Media_Video_Config.capture.BinningSkip);
            hierarchicalStreamWriter.addAttribute("TVSystem", netSDK_Media_Video_Config.capture.TVSystem);
            hierarchicalStreamWriter.addAttribute("HFlip", netSDK_Media_Video_Config.capture.HFlip);
            hierarchicalStreamWriter.addAttribute("VFlip", netSDK_Media_Video_Config.capture.VFlip);
            hierarchicalStreamWriter.addAttribute("TNF", netSDK_Media_Video_Config.capture.TNF);
            hierarchicalStreamWriter.addAttribute("SNF", netSDK_Media_Video_Config.capture.SNF);
            hierarchicalStreamWriter.addAttribute("VSTAB", netSDK_Media_Video_Config.capture.VSTAB);
            hierarchicalStreamWriter.addAttribute("LDC", netSDK_Media_Video_Config.capture.LDC);
            hierarchicalStreamWriter.addAttribute("FD", netSDK_Media_Video_Config.capture.FD);
            hierarchicalStreamWriter.addAttribute("IrcutMode", netSDK_Media_Video_Config.capture.IrcutMode);
            hierarchicalStreamWriter.addAttribute("IrcutSensitivity", netSDK_Media_Video_Config.capture.IrcutSensitivity);
            hierarchicalStreamWriter.addAttribute("IrcutNightStartTime", netSDK_Media_Video_Config.capture.IrcutNightStartTime);
            hierarchicalStreamWriter.addAttribute("IrcutNightEndTime", netSDK_Media_Video_Config.capture.IrcutNightEndTime);
            hierarchicalStreamWriter.endNode();
            hierarchicalStreamWriter.startNode("Encode");
            for (EncodeConfig encodeConfig : NetSDK_Media_Video_Config.this.encode.EncodeList) {
                hierarchicalStreamWriter.startNode("EncodeConfig");
                hierarchicalStreamWriter.addAttribute("Stream", encodeConfig.Stream);
                hierarchicalStreamWriter.addAttribute("Resolution", encodeConfig.Resolution);
                hierarchicalStreamWriter.addAttribute("EncodeFormat", encodeConfig.EncodeFormat);
                hierarchicalStreamWriter.addAttribute("BitRateControl", encodeConfig.BitRateControl);
                hierarchicalStreamWriter.addAttribute("Initquant", encodeConfig.Initquant);
                hierarchicalStreamWriter.addAttribute("BitRate", encodeConfig.BitRate);
                hierarchicalStreamWriter.addAttribute("FrameRate", encodeConfig.FrameRate);
                hierarchicalStreamWriter.endNode();
            }
            hierarchicalStreamWriter.startNode("AdvanceEncodeConfig");
            hierarchicalStreamWriter.addAttribute("EncodeProfile", NetSDK_Media_Video_Config.this.encode.advance.EncodeProfile);
            hierarchicalStreamWriter.addAttribute("WDRMode", NetSDK_Media_Video_Config.this.encode.advance.WDRMode);
            hierarchicalStreamWriter.addAttribute("WDRStartTime", NetSDK_Media_Video_Config.this.encode.advance.WDRStartTime);
            hierarchicalStreamWriter.addAttribute("WDREndTime", NetSDK_Media_Video_Config.this.encode.advance.WDREndTime);
            hierarchicalStreamWriter.addAttribute("DisablePrivateData", NetSDK_Media_Video_Config.this.encode.advance.DisablePrivateData);
            hierarchicalStreamWriter.endNode();
            hierarchicalStreamWriter.endNode();
            hierarchicalStreamWriter.startNode("JpegConfig");
            hierarchicalStreamWriter.addAttribute("Enable", NetSDK_Media_Video_Config.this.jpeg.Enable);
            hierarchicalStreamWriter.addAttribute("Stream", NetSDK_Media_Video_Config.this.jpeg.Stream);
            hierarchicalStreamWriter.addAttribute("Quality", NetSDK_Media_Video_Config.this.jpeg.Quality);
            hierarchicalStreamWriter.addAttribute("Framerate", NetSDK_Media_Video_Config.this.jpeg.Framerate);
            hierarchicalStreamWriter.endNode();
            hierarchicalStreamWriter.startNode("Overlay");
            hierarchicalStreamWriter.addAttribute("Enable", NetSDK_Media_Video_Config.this.overlay.Enable);
            hierarchicalStreamWriter.addAttribute("Transparency", NetSDK_Media_Video_Config.this.overlay.Transparency);
            hierarchicalStreamWriter.startNode("TimeOverlay");
            hierarchicalStreamWriter.addAttribute("PosX", NetSDK_Media_Video_Config.this.overlay.timeOverlay.PosX);
            hierarchicalStreamWriter.addAttribute("PosY", NetSDK_Media_Video_Config.this.overlay.timeOverlay.PosY);
            hierarchicalStreamWriter.addAttribute("Format", NetSDK_Media_Video_Config.this.overlay.timeOverlay.Format);
            hierarchicalStreamWriter.endNode();
            hierarchicalStreamWriter.startNode("TitleOverlay");
            hierarchicalStreamWriter.addAttribute("PosX", NetSDK_Media_Video_Config.this.overlay.titleOverlay.PosX);
            hierarchicalStreamWriter.addAttribute("PosY", NetSDK_Media_Video_Config.this.overlay.titleOverlay.PosY);
            hierarchicalStreamWriter.addAttribute("Format", NetSDK_Media_Video_Config.this.overlay.titleOverlay.Title);
            hierarchicalStreamWriter.endNode();
            hierarchicalStreamWriter.endNode();
        }

        public Object unmarshal(HierarchicalStreamReader hierarchicalStreamReader, UnmarshallingContext unmarshallingContext) {
            NetSDK_Media_Video_Config netSDK_Media_Video_Config = new NetSDK_Media_Video_Config();
            if (!hierarchicalStreamReader.getNodeName().equals("Video")) {
                return null;
            }
            while (hierarchicalStreamReader.hasMoreChildren()) {
                hierarchicalStreamReader.moveDown();
                if (hierarchicalStreamReader.getNodeName().equals("Capture")) {
                    netSDK_Media_Video_Config.capture.Brightness = hierarchicalStreamReader.getAttribute("Brightness");
                    netSDK_Media_Video_Config.capture.Contrast = hierarchicalStreamReader.getAttribute("Contrast");
                    netSDK_Media_Video_Config.capture.Saturation = hierarchicalStreamReader.getAttribute("Saturation");
                    netSDK_Media_Video_Config.capture.Sharpness = hierarchicalStreamReader.getAttribute("Sharpness");
                    netSDK_Media_Video_Config.capture.DayNight = hierarchicalStreamReader.getAttribute("DayNight");
                    netSDK_Media_Video_Config.capture.WhiteBalance = hierarchicalStreamReader.getAttribute("WhiteBalance");
                    netSDK_Media_Video_Config.capture.BackLight = hierarchicalStreamReader.getAttribute("BackLight");
                    netSDK_Media_Video_Config.capture.Switch2A = hierarchicalStreamReader.getAttribute("Switch2A");
                    netSDK_Media_Video_Config.capture.BinningSkip = hierarchicalStreamReader.getAttribute("BinningSkip");
                    netSDK_Media_Video_Config.capture.TVSystem = hierarchicalStreamReader.getAttribute("TVSystem");
                    netSDK_Media_Video_Config.capture.HFlip = hierarchicalStreamReader.getAttribute("HFlip");
                    netSDK_Media_Video_Config.capture.VFlip = hierarchicalStreamReader.getAttribute("VFlip");
                    netSDK_Media_Video_Config.capture.TNF = hierarchicalStreamReader.getAttribute("TNF");
                    netSDK_Media_Video_Config.capture.SNF = hierarchicalStreamReader.getAttribute("SNF");
                    netSDK_Media_Video_Config.capture.VSTAB = hierarchicalStreamReader.getAttribute("VSTAB");
                    netSDK_Media_Video_Config.capture.LDC = hierarchicalStreamReader.getAttribute("LDC");
                    netSDK_Media_Video_Config.capture.FD = hierarchicalStreamReader.getAttribute("FD");
                    netSDK_Media_Video_Config.capture.IrcutMode = hierarchicalStreamReader.getAttribute("IrcutMode");
                    netSDK_Media_Video_Config.capture.IrcutSensitivity = hierarchicalStreamReader.getAttribute("IrcutSensitivity");
                    netSDK_Media_Video_Config.capture.IrcutNightStartTime = hierarchicalStreamReader.getAttribute("IrcutNightStartTime");
                    netSDK_Media_Video_Config.capture.IrcutNightEndTime = hierarchicalStreamReader.getAttribute("IrcutNightEndTime");
                } else if (hierarchicalStreamReader.getNodeName().equals("Encode")) {
                    while (hierarchicalStreamReader.hasMoreChildren()) {
                        hierarchicalStreamReader.moveDown();
                        if ("EncodeConfig".equals(hierarchicalStreamReader.getNodeName())) {
                            EncodeConfig encodeConfig = new EncodeConfig();
                            encodeConfig.Stream = hierarchicalStreamReader.getAttribute("Stream");
                            encodeConfig.Resolution = hierarchicalStreamReader.getAttribute("Resolution");
                            encodeConfig.EncodeFormat = hierarchicalStreamReader.getAttribute("EncodeFormat");
                            encodeConfig.BitRateControl = hierarchicalStreamReader.getAttribute("BitRateControl");
                            encodeConfig.Initquant = hierarchicalStreamReader.getAttribute("Initquant");
                            encodeConfig.BitRate = hierarchicalStreamReader.getAttribute("BitRate");
                            encodeConfig.FrameRate = hierarchicalStreamReader.getAttribute("FrameRate");
                            netSDK_Media_Video_Config.encode.EncodeList.add(encodeConfig);
                        } else if ("AdvanceEncodeConfig".equals(hierarchicalStreamReader.getNodeName())) {
                            netSDK_Media_Video_Config.encode.advance.EncodeProfile = hierarchicalStreamReader.getAttribute("EncodeProfile");
                            netSDK_Media_Video_Config.encode.advance.WDRMode = hierarchicalStreamReader.getAttribute("WDRMode");
                            netSDK_Media_Video_Config.encode.advance.WDRStartTime = hierarchicalStreamReader.getAttribute("WDRStartTime");
                            netSDK_Media_Video_Config.encode.advance.WDREndTime = hierarchicalStreamReader.getAttribute("WDREndTime");
                            netSDK_Media_Video_Config.encode.advance.DisablePrivateData = hierarchicalStreamReader.getAttribute("DisablePrivateData");
                        }
                        hierarchicalStreamReader.moveUp();
                    }
                } else if (hierarchicalStreamReader.getNodeName().equals("JpegConfig")) {
                    netSDK_Media_Video_Config.jpeg.Enable = hierarchicalStreamReader.getAttribute("Enable");
                    netSDK_Media_Video_Config.jpeg.Stream = hierarchicalStreamReader.getAttribute("Stream");
                    netSDK_Media_Video_Config.jpeg.Quality = hierarchicalStreamReader.getAttribute("Quality");
                    netSDK_Media_Video_Config.jpeg.Framerate = hierarchicalStreamReader.getAttribute("Framerate");
                } else if (hierarchicalStreamReader.getNodeName().equals("Overlay")) {
                    netSDK_Media_Video_Config.overlay.Enable = hierarchicalStreamReader.getAttribute("Enable");
                    netSDK_Media_Video_Config.overlay.Transparency = hierarchicalStreamReader.getAttribute("Transparency");
                    while (hierarchicalStreamReader.hasMoreChildren()) {
                        hierarchicalStreamReader.moveDown();
                        if ("TimeOverlay".equals(hierarchicalStreamReader.getNodeName())) {
                            netSDK_Media_Video_Config.overlay.timeOverlay.PosX = hierarchicalStreamReader.getAttribute("PosX");
                            netSDK_Media_Video_Config.overlay.timeOverlay.PosY = hierarchicalStreamReader.getAttribute("PosY");
                            netSDK_Media_Video_Config.overlay.timeOverlay.Format = hierarchicalStreamReader.getAttribute("Format");
                        } else if ("TitleOverlay".equals(hierarchicalStreamReader.getNodeName())) {
                            netSDK_Media_Video_Config.overlay.titleOverlay.PosX = hierarchicalStreamReader.getAttribute("PosX");
                            netSDK_Media_Video_Config.overlay.titleOverlay.PosY = hierarchicalStreamReader.getAttribute("PosY");
                            netSDK_Media_Video_Config.overlay.titleOverlay.Title = NetSDK_Media_Video_Config.this.decodeTitle(hierarchicalStreamReader.getAttribute("Title"));
                        }
                        hierarchicalStreamReader.moveUp();
                    }
                } else if ("Mask".equals(hierarchicalStreamReader.getNodeName())) {
                    while (hierarchicalStreamReader.hasMoreChildren()) {
                        hierarchicalStreamReader.moveDown();
                        if ("MainStream".equals(hierarchicalStreamReader.getNodeName())) {
                            netSDK_Media_Video_Config.mask.mainStream.Area1PosX = hierarchicalStreamReader.getAttribute("Area1PosX");
                            netSDK_Media_Video_Config.mask.mainStream.Area1PosY = hierarchicalStreamReader.getAttribute("Area1PosY");
                            netSDK_Media_Video_Config.mask.mainStream.Area1Width = hierarchicalStreamReader.getAttribute("Area1Width");
                            netSDK_Media_Video_Config.mask.mainStream.Area1Height = hierarchicalStreamReader.getAttribute("Area1Height");
                            netSDK_Media_Video_Config.mask.mainStream.Area2PosX = hierarchicalStreamReader.getAttribute("Area2PosX");
                            netSDK_Media_Video_Config.mask.mainStream.Area2PosY = hierarchicalStreamReader.getAttribute("Area2PosY");
                            netSDK_Media_Video_Config.mask.mainStream.Area2Width = hierarchicalStreamReader.getAttribute("Area2Width");
                            netSDK_Media_Video_Config.mask.mainStream.Area2Height = hierarchicalStreamReader.getAttribute("Area2Height");
                            netSDK_Media_Video_Config.mask.mainStream.Area3PosX = hierarchicalStreamReader.getAttribute("Area3PosX");
                            netSDK_Media_Video_Config.mask.mainStream.Area3PosY = hierarchicalStreamReader.getAttribute("Area3PosY");
                            netSDK_Media_Video_Config.mask.mainStream.Area3Width = hierarchicalStreamReader.getAttribute("Area3Width");
                            netSDK_Media_Video_Config.mask.mainStream.Area3Height = hierarchicalStreamReader.getAttribute("Area3Height");
                            netSDK_Media_Video_Config.mask.mainStream.Area4PosX = hierarchicalStreamReader.getAttribute("Area4PosX");
                            netSDK_Media_Video_Config.mask.mainStream.Area4PosY = hierarchicalStreamReader.getAttribute("Area4PosY");
                            netSDK_Media_Video_Config.mask.mainStream.Area4Width = hierarchicalStreamReader.getAttribute("Area4Width");
                            netSDK_Media_Video_Config.mask.mainStream.Area4Height = hierarchicalStreamReader.getAttribute("Area4Height");
                        } else if ("SubStream".equals(hierarchicalStreamReader.getNodeName())) {
                            netSDK_Media_Video_Config.mask.subStream.Area1PosX = hierarchicalStreamReader.getAttribute("Area1PosX");
                            netSDK_Media_Video_Config.mask.subStream.Area1PosY = hierarchicalStreamReader.getAttribute("Area1PosY");
                            netSDK_Media_Video_Config.mask.subStream.Area1Width = hierarchicalStreamReader.getAttribute("Area1Width");
                            netSDK_Media_Video_Config.mask.subStream.Area1Height = hierarchicalStreamReader.getAttribute("Area1Height");
                            netSDK_Media_Video_Config.mask.subStream.Area2PosX = hierarchicalStreamReader.getAttribute("Area2PosX");
                            netSDK_Media_Video_Config.mask.subStream.Area2PosY = hierarchicalStreamReader.getAttribute("Area2PosY");
                            netSDK_Media_Video_Config.mask.subStream.Area2Width = hierarchicalStreamReader.getAttribute("Area2Width");
                            netSDK_Media_Video_Config.mask.subStream.Area2Height = hierarchicalStreamReader.getAttribute("Area2Height");
                            netSDK_Media_Video_Config.mask.subStream.Area3PosX = hierarchicalStreamReader.getAttribute("Area3PosX");
                            netSDK_Media_Video_Config.mask.subStream.Area3PosY = hierarchicalStreamReader.getAttribute("Area3PosY");
                            netSDK_Media_Video_Config.mask.subStream.Area3Width = hierarchicalStreamReader.getAttribute("Area3Width");
                            netSDK_Media_Video_Config.mask.subStream.Area3Height = hierarchicalStreamReader.getAttribute("Area3Height");
                            netSDK_Media_Video_Config.mask.subStream.Area4PosX = hierarchicalStreamReader.getAttribute("Area4PosX");
                            netSDK_Media_Video_Config.mask.subStream.Area4PosY = hierarchicalStreamReader.getAttribute("Area4PosY");
                            netSDK_Media_Video_Config.mask.subStream.Area4Width = hierarchicalStreamReader.getAttribute("Area4Width");
                            netSDK_Media_Video_Config.mask.subStream.Area4Height = hierarchicalStreamReader.getAttribute("Area4Height");
                        }
                        hierarchicalStreamReader.moveUp();
                    }
                }
                hierarchicalStreamReader.moveUp();
            }
            return netSDK_Media_Video_Config;
        }

        public boolean canConvert(Class clazz) {
            return clazz.equals(NetSDK_Media_Video_Config.class);
        }
    }

    class CaptureConverter
    implements Converter {
        CaptureConverter() {
        }

        public void marshal(Object object, HierarchicalStreamWriter hierarchicalStreamWriter, MarshallingContext marshallingContext) {
            Capture capture = (Capture)object;
            hierarchicalStreamWriter.addAttribute("Brightness", capture.Brightness);
            hierarchicalStreamWriter.addAttribute("Contrast", capture.Contrast);
            hierarchicalStreamWriter.addAttribute("Saturation", capture.Saturation);
            hierarchicalStreamWriter.addAttribute("Sharpness", capture.Sharpness);
            hierarchicalStreamWriter.addAttribute("DayNight", capture.DayNight);
            hierarchicalStreamWriter.addAttribute("WhiteBalance", capture.WhiteBalance);
            hierarchicalStreamWriter.addAttribute("BackLight", capture.BackLight);
            hierarchicalStreamWriter.addAttribute("Switch2A", capture.Switch2A);
            hierarchicalStreamWriter.addAttribute("BinningSkip", capture.BinningSkip);
            hierarchicalStreamWriter.addAttribute("TVSystem", capture.TVSystem);
            hierarchicalStreamWriter.addAttribute("HFlip", capture.HFlip);
            hierarchicalStreamWriter.addAttribute("VFlip", capture.VFlip);
            hierarchicalStreamWriter.addAttribute("TNF", capture.TNF);
            hierarchicalStreamWriter.addAttribute("SNF", capture.SNF);
            hierarchicalStreamWriter.addAttribute("VSTAB", capture.VSTAB);
            hierarchicalStreamWriter.addAttribute("LDC", capture.LDC);
            hierarchicalStreamWriter.addAttribute("FD", capture.FD);
            hierarchicalStreamWriter.addAttribute("IrcutMode", capture.IrcutMode);
            hierarchicalStreamWriter.addAttribute("IrcutSensitivity", capture.IrcutSensitivity);
            hierarchicalStreamWriter.addAttribute("IrcutNightStartTime", capture.IrcutNightStartTime);
            hierarchicalStreamWriter.addAttribute("IrcutNightEndTime", capture.IrcutNightEndTime);
        }

        public Object unmarshal(HierarchicalStreamReader hierarchicalStreamReader, UnmarshallingContext unmarshallingContext) {
            return null;
        }

        public boolean canConvert(Class clazz) {
            return clazz.equals(Capture.class);
        }
    }

    class EncodeConverter
    implements Converter {
        EncodeConverter() {
        }

        public void marshal(Object object, HierarchicalStreamWriter hierarchicalStreamWriter, MarshallingContext marshallingContext) {
            Encode encode = (Encode)object;
            for (EncodeConfig encodeConfig : encode.EncodeList) {
                hierarchicalStreamWriter.startNode("EncodeConfig");
                hierarchicalStreamWriter.addAttribute("Stream", encodeConfig.Stream);
                hierarchicalStreamWriter.addAttribute("Resolution", encodeConfig.Resolution);
                hierarchicalStreamWriter.addAttribute("EncodeFormat", encodeConfig.EncodeFormat);
                hierarchicalStreamWriter.addAttribute("BitRateControl", encodeConfig.BitRateControl);
                hierarchicalStreamWriter.addAttribute("Initquant", encodeConfig.Initquant);
                hierarchicalStreamWriter.addAttribute("BitRate", encodeConfig.BitRate);
                hierarchicalStreamWriter.addAttribute("FrameRate", encodeConfig.FrameRate);
                hierarchicalStreamWriter.endNode();
            }
            hierarchicalStreamWriter.startNode("AdvanceEncodeConfig");
            hierarchicalStreamWriter.addAttribute("EncodeProfile", encode.advance.EncodeProfile);
            hierarchicalStreamWriter.addAttribute("WDRMode", encode.advance.WDRMode);
            hierarchicalStreamWriter.addAttribute("WDRStartTime", encode.advance.WDRStartTime);
            hierarchicalStreamWriter.addAttribute("WDREndTime", encode.advance.WDREndTime);
            hierarchicalStreamWriter.addAttribute("DisablePrivateData", encode.advance.DisablePrivateData);
            hierarchicalStreamWriter.endNode();
        }

        public Object unmarshal(HierarchicalStreamReader hierarchicalStreamReader, UnmarshallingContext unmarshallingContext) {
            return null;
        }

        public boolean canConvert(Class clazz) {
            return clazz.equals(Encode.class);
        }
    }

    public class Mask
    implements Cloneable {
        MainStream mainStream;
        SubStream subStream;

        public Mask() {
            this.mainStream = new MainStream();
            this.subStream = new SubStream();
        }

        protected Object clone() throws CloneNotSupportedException {
            Mask mask = (Mask)super.clone();
            mask.mainStream = (MainStream)this.mainStream.clone();
            mask.subStream = (SubStream)this.subStream.clone();
            return mask;
        }
    }

    public class SubStream
    implements Cloneable {
        public String Area1PosX;
        public String Area1PosY;
        public String Area1Width;
        public String Area1Height;
        public String Area2PosX;
        public String Area2PosY;
        public String Area2Width;
        public String Area2Height;
        public String Area3PosX;
        public String Area3PosY;
        public String Area3Width;
        public String Area3Height;
        public String Area4PosX;
        public String Area4PosY;
        public String Area4Width;
        public String Area4Height;

        protected Object clone() throws CloneNotSupportedException {
            return super.clone();
        }
    }

    public class MainStream
    implements Cloneable {
        public String Area1PosX;
        public String Area1PosY;
        public String Area1Width;
        public String Area1Height;
        public String Area2PosX;
        public String Area2PosY;
        public String Area2Width;
        public String Area2Height;
        public String Area3PosX;
        public String Area3PosY;
        public String Area3Width;
        public String Area3Height;
        public String Area4PosX;
        public String Area4PosY;
        public String Area4Width;
        public String Area4Height;

        protected Object clone() throws CloneNotSupportedException {
            return super.clone();
        }
    }

    public class Overlay
    implements Cloneable {
        public String Enable;
        public String Transparency;
        public TimeOverlay timeOverlay;
        public TitleOverlay titleOverlay;

        public Overlay() {
            this.timeOverlay = new TimeOverlay();
            this.titleOverlay = new TitleOverlay();
        }

        protected Object clone() throws CloneNotSupportedException {
            Overlay overlay = (Overlay)super.clone();
            overlay.timeOverlay = (TimeOverlay)this.timeOverlay.clone();
            overlay.titleOverlay = (TitleOverlay)this.titleOverlay.clone();
            return overlay;
        }
    }

    public class TitleOverlay
    implements Cloneable {
        public String PosX;
        public String PosY;
        public String Title;

        protected Object clone() throws CloneNotSupportedException {
            return super.clone();
        }
    }

    public class TimeOverlay
    implements Cloneable {
        public String PosX;
        public String PosY;
        public String Format;

        protected Object clone() throws CloneNotSupportedException {
            return super.clone();
        }
    }

    public class JpegConfig
    implements Cloneable {
        public String Enable;
        public String Stream;
        public String Quality;
        public String Framerate;

        protected Object clone() throws CloneNotSupportedException {
            return super.clone();
        }
    }

    public class Encode
    implements Cloneable {
        public List<EncodeConfig> EncodeList = new ArrayList<EncodeConfig>();
        AdvanceEncodeConfig advance = new AdvanceEncodeConfig();

        protected Object clone() throws CloneNotSupportedException {
            Encode encode = (Encode)super.clone();
            encode.EncodeList = new ArrayList<EncodeConfig>();
            for (EncodeConfig encodeConfig : this.EncodeList) {
                encode.EncodeList.add((EncodeConfig)encodeConfig.clone());
            }
            encode.advance = (AdvanceEncodeConfig)this.advance.clone();
            return encode;
        }
    }

    public class AdvanceEncodeConfig
    implements Cloneable {
        public String EncodeProfile;
        public String WDRMode;
        public String WDRStartTime;
        public String WDREndTime;
        public String DisablePrivateData;

        protected Object clone() throws CloneNotSupportedException {
            return super.clone();
        }
    }

    public class EncodeConfig
    implements Cloneable {
        public String Stream;
        public String Resolution;
        public String EncodeFormat;
        public String BitRateControl;
        public String Initquant;
        public String BitRate;
        public String FrameRate;

        protected Object clone() throws CloneNotSupportedException {
            return super.clone();
        }
    }

    public class Capture
    implements Cloneable {
        public String Brightness;
        public String Contrast;
        public String Saturation;
        public String Sharpness;
        public String DayNight;
        public String WhiteBalance;
        public String BackLight;
        public String Switch2A;
        public String BinningSkip;
        public String TVSystem;
        public String HFlip;
        public String VFlip;
        public String TNF;
        public String SNF;
        public String VSTAB;
        public String LDC;
        public String FD;
        public String IrcutMode;
        public String IrcutSensitivity;
        public String IrcutNightStartTime;
        public String IrcutNightEndTime;

        protected Object clone() throws CloneNotSupportedException {
            return super.clone();
        }
    }
}

