/*
 * Decompiled with CFR 0.152.
 */
package ipc.android.sdk.com;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.DomDriver;
import ipc.android.sdk.com.Device;
import ipc.android.sdk.com.IDataSerialBase;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import java.util.List;

@XStreamAlias(value="AbstractDataSerialBase")
@TargetApi(value=9)
public abstract class AbstractDataSerialBase
implements IDataSerialBase {
    @XStreamOmitField
    protected String mDefaultEncodeName = "UTF-8";
    @XStreamOmitField
    protected Charset mDefaultCharset = Charset.forName(this.mDefaultEncodeName);
    @XStreamOmitField
    protected boolean mIsAddHead = true;
    @XStreamOmitField
    protected String mDefaultHead = "<?xml version=\"1.0\" encoding=\"" + this.mDefaultEncodeName + "\"?>\n";
    @XStreamOmitField
    protected XStream mXStream = new XStream((HierarchicalStreamDriver)new DomDriver(this.mDefaultEncodeName));

    public AbstractDataSerialBase() {
        this.mXStream.alias(this.getClass().getSimpleName(), this.getClass());
        this.mXStream.autodetectAnnotations(true);
    }

    protected boolean haveHead(String string) {
        int n = string == null ? -1 : string.indexOf(this.mDefaultHead);
        return n >= 0;
    }

    public void addHead(boolean bl) {
        this.mIsAddHead = bl;
    }

    public String toXMLString() {
        String string = null;
        if (this.mXStream == null) {
            return string;
        }
        string = this.mXStream.toXML((Object)this);
        if (string != null) {
            string = string.replaceAll("__", "_");
            System.out.println(string);
            if (this.mIsAddHead && !this.haveHead(string)) {
                string = this.mDefaultHead + string;
            }
        }
        return string;
    }

    public String toXMLString(List<AbstractDataSerialBase> list, String string) {
        String string2 = null;
        if (this.mXStream == null) {
            return null;
        }
        this.mXStream.alias(string, List.class);
        string2 = this.mXStream.toXML(list);
        if (string2 != null) {
            string2 = string2.replaceAll("__", "_");
            System.out.println(string2);
            if (this.mIsAddHead && !this.haveHead(string2)) {
                string2 = this.mDefaultHead + string2;
            }
        }
        return string2;
    }

    @Override
    public byte[] toXML() {
        String string = this.toXMLString();
        return string == null ? null : string.getBytes(this.mDefaultCharset);
    }

    @Override
    public byte[] toXML(List<AbstractDataSerialBase> list, String string) {
        String string2 = this.toXMLString(list, string);
        return string2 == null ? null : string2.getBytes(this.mDefaultCharset);
    }

    @Override
    public Object fromXML(byte[] byArray) {
        Object object = null;
        if (this.mXStream == null || byArray == null) {
            return object;
        }
        String string = new String(byArray, this.mDefaultCharset);
        string = string.replaceAll("__", "_");
        object = this.mXStream.fromXML(string);
        return object;
    }

    @Override
    @SuppressLint(value={"NewApi"})
    public Object fromXML(byte[] byArray, String string) {
        Object object = null;
        if (this.mXStream == null || byArray == null) {
            return object;
        }
        String string2 = new String(byArray, this.mDefaultCharset);
        string2 = string2.replaceAll("__", "_");
        this.mXStream.alias(string, List.class);
        this.mXStream.alias("Device", Device.class);
        object = this.mXStream.fromXML(string2);
        return object;
    }

    protected ByteBuffer getBufByLen(byte[] byArray, int n) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(n);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        byteBuffer.put(byArray);
        byteBuffer.rewind();
        return byteBuffer;
    }

    @Override
    public Object byteBufferToObject(ByteBuffer byteBuffer) {
        return null;
    }

    @Override
    public ByteBuffer objectToByteBuffer(ByteOrder byteOrder) {
        return null;
    }

    @Override
    public int sizeOf() {
        return 0;
    }
}

